//system_defines.h

#define Cyclone2p0 (1) // Set if working with 2p0 version of the device

//#define CURRENT_SHARING_ENABLE (1) //use this if current sharing is needed
#define FREQUENCY_MODIFICATION (1)
#define AUTOTUNE (1)


#define min(a,b)					(((a)>(b)) ? (b):(a))

#define ENABLE 	(1)
#define DISABLE (0)

#define MASK_CTRL_PIN 		(1 << 14)
#define MASK_PSON 			(1 << 8)
#define MASK_PGOOD 			(1 << 29)
#define MASK_FAILURE 		(1 << 11)
#define MASK_AC_FAIL_IN 	(1 << 9)
#define MASK_AC_FAIL_OUT 	(1 << 10)
#define MASK_OR_CTRL 		(1 << 18)
#define MASK_DPWM2A 		(1 << 2)
#define MASK_DPWM2B 		(1 << 3)
#define PSON  (MiscAnalogRegs.GLBIOREAD.all & (MASK_CTRL_PIN | MASK_PSON))
#define CONSTANT_POWER (5521824)   //2016 * 2739  28A starts to roll off

//==========================================================================================
// Memory allocation constants
//==========================================================================================
// ****VOYAGER#define MFBALR2_HALF0_DATA_FLASH_BASE_ADDRESS 0x8800
#define DATA_FLASH_START_ADDRESS 	(0x18800)
#define DATA_FLASH_END_ADDRESS 		(0x18fff)
#define DATA_FLASH_LENGTH			(DATA_FLASH_END_ADDRESS - DATA_FLASH_START_ADDRESS + 1)
#define	DATA_FLASH_SEGMENT_SIZE		(32)
#define	DATA_FLASH_NUM_SEGMENTS		(DATA_FLASH_LENGTH / DATA_FLASH_SEGMENT_SIZE) 

// This limitation check is required because the flash access routines in flash.c make the
// assumption that the size of the segments of the data flash are an integral power of two.
#if (DATA_FLASH_SEGMENT_SIZE & (DATA_FLASH_SEGMENT_SIZE - 1)) != 0
#error "DATA_FLASH_SEGMENT_SIZE must be defined as an integral power of two"
#endif

#define MFBALR2_HALF0_DATA_FLASH_BASE_ADDRESS (0x8800)
#define MFBALRX_BYTE0_BLOCK_SIZE_2K     	(0x20) 		
#define MFBALRX_BYTE0_RONLY					(0x02)		   //Read-only protection
#define MFBALRX_BYTE0_BLOCK_SIZE_32K    	(0x60)
#define UART_RX_SIZE (10) //total number of bytes for received data packet
#define UART_TX_SIZE (10) //total number of bytes for transmitted data packet
#define UART_TX_TIME (10000) //number of timer interrupts between transmissions on serial port


// Flash Error codes
#define FLASH_SUCCESS 				(0)
#define FLASH_INVALID_SEGMENT 		(1)
#define	FLASH_INVALID_ADDRESS		(2)
#define	FLASH_MISCOMPARE			(3)

#define NULL						(0)
#define ROM_PASSWORD_BYTES      (4)
#define NUMBER_OF_FAULTY_TRIALS (5) // Number of time wrog password may be entered

#define DCDC_PAGE_NUMS (1)

#define VOUT_MODE_EXP	 (9)	//fixed
#define VOUT_DAC_SCALER  (1034)	//(R1/(R1+R2)<<14)/1.6  high res
#define VOUT_COMP_SCALER (164)	//(R1/(R1+R2)<<12)/2.5, left shifted 5-bit more for accuracy
#define VOUT_AD12_SCALER (167)	//(R1/(R1+R2)<<12)/2.5
#define IOUT_DAC_SCALER  (350) //(384) //(351)	//(R1/(R1+R2)*((0.0549<<14)/1.6) high res
#define IOUT_COMP_SCALER (98) //	//(0.0592<<12)/2.5, left shifted 5-bit more for accuracy
#define IOUT_AD12_SCALER (90) //(95)	// (0.0592<<12)/2.5
#define TEMP_AD12_SCALER (10) //(16)	//(0.00625<<12)/2.5
#define TEMP_AD12_OFFSET (694) //(819)	//(0.5<<12)/2.5 (0.429 <<12)/2.5) 
#define IIN_COMP_SCALER  (6)
#define POUT_SCALER  (14850)  //(16500)
#define IOUT_OFFSET (50) 
#define SWITCHING_FREQUENCY (140) //140
//Status Word aliases
#define PMBUS_STATUS_WORD_HIGH_BYTE			(0x1)
#define PMBUS_STATUS_WORD_CML 				(0x2)
#define PMBUS_STATUS_WORD_TEMPERATURE 		(0x4)
#define PMBUS_STATUS_WORD_VIN_UV 			(0x8)
#define PMBUS_STATUS_WORD_IOUT_OC 			(0x10)
#define PMBUS_STATUS_WORD_VOUT_OV 			(0x20)
#define PMBUS_STATUS_WORD_OFF 				(0x40)
#define PMBUS_STATUS_WORD_BUSY 				(0x80)
#define PMBUS_STATUS_WORD_UNKNOWN 			(0x100)
#define PMBUS_STATUS_WORD_OTHER 			(0x200)
#define PMBUS_STATUS_WORD_FAN	 			(0x400)
#define PMBUS_STATUS_WORD_POWER_GOOD_NOT 	(0x800)
#define PMBUS_STATUS_WORD_MFR   			(0x1000)
#define PMBUS_STATUS_WORD_INPUT 			(0x2000)
#define PMBUS_STATUS_WORD_IOUT  			(0x4000)
#define PMBUS_STATUS_WORD_VOUT  			(0x8000)

#define ACOMPA_INT_STATUS_MASK 	(0x01)
#define ACOMPB_INT_STATUS_MASK 	(0x02)
#define ACOMPC_INT_STATUS_MASK 	(0x04)
#define ACOMPD_INT_STATUS_MASK 	(0x08)
#define ACOMPE_INT_STATUS_MASK 	(0x10)
#define ACOMPF_INT_STATUS_MASK 	(0x20)
#define ACOMPG_INT_STATUS_MASK 	(0x40)
#define COMP_INT_STATUS_MASK	(ACOMPB_INT_STATUS_MASK | ACOMPE_INT_STATUS_MASK)

#define DPWM_FAULT_AB_STATUS_MASK (0x2)

//Vout measurement defines
#define VOUT_FULL_RANGE (25) //full range of ADC for VOUT
#define VOUT_POWER_GOOD_ON ((int32)((11.5*4096)/VOUT_FULL_RANGE))//11.5V
#define VOUT_POWER_GOOD_OFF ((int32)((10*4096)/VOUT_FULL_RANGE))//11V
#define VIN_GOOD (2674)//ready to turn on, 335V x 8 = 2680
#define VIN_BAD (2630)//vin is low to turn off, 325V x 8 = 2600
//#define VIN_GOOD (0)//ready to turn on
//#define VIN_BAD (0)//vin is low to turn off
#define UVIN_NO_FAULT (adc_values.vin_mon > VIN_GOOD)
#define UVIN_FAULT (adc_values.vin_mon < VIN_BAD)

#define IOUT_OC (3900)
#define IOUT_NO_OC (3860)
#define IOUT_FAULT (adc_values.io_sense > IOUT_OC)
#define IOUT_NO_FAULT (adc_values.io_sense < IOUT_NO_OC)

#define VOUT_OV (0xFFF)
#define VOUT_NO_OV (0xFFF)
#define VOUT_FAULT (adc_values.vo_sense > VOUT_OV)
#define VOUT_NO_FAULT (adc_values.vo_sense < VOUT_NO_OV)

//=========================================================================================
// CIM module definitions
//=========================================================================================
// FIRQPR, INTREQ, REQMASK Registers
// interrupts listed highest priority to lowest priority:
#define CIMINT_ALL_SYS_SOFT		(0x80000000)	// 31	System Software Interrupt					
#define CIMINT_ALL_FAULT_PIN	(0x40000000)	// 30	Fault Pin Interrupt		
#define CIMINT_ALL_DPWM0		(0x20000000)	// 29	Every(1-16)DPWM0 switching cycles or CLF flag shutdown Interrupt		
#define CIMINT_ALL_DPWM1		(0x10000000)	// 28	Every(1-16)DPWM1 switching cycles or CLF flag shutdown Interrupt			 						
#define CIMINT_ALL_DPWM2		(0x08000000)	// 27	Every(1-16)DPWM2 switching cycles or CLF flag shutdown Interrupt			 						
#define CIMINT_ALL_DPWM3		(0x04000000)	// 26	Every(1-16)DPWM3 switching cycles or CLF flag shutdown Interrupt		 						
#define CIMINT_ALL_FAULT_MUX	(0x02000000)	// 25	Fault Mux Interrupt			 				
#define CIMINT_ALL_ADC_CONV		(0x01000000)	// 24	ADC-12 End of Conversion Interrupt			 						
#define CIMINT_ALL_CPCC			(0x00800000)	// 23	CPCC Interrupt, Mode switched in CPCC module Flag needs to be read for details			 			
#define CIMINT_ALL_TMR_COMP0	(0x00400000)	// 22	24-bit Timer Compare 0 interrupt			 			
#define CIMINT_ALL_TMR_CAPT0	(0x00200000)	// 21	24-bit Timer Capture 0 interrupt									
#define CIMINT_ALL_TMR_COMP1	(0x00100000)	// 20	24-bit Timer Compare 1 interrupt		
#define CIMINT_ALL_TMR_CAPT1	(0x00080000)	// 19	24-bit Timer Capture 1 interrupt	
#define CIMINT_ALL_TMR_OVFL		(0x00040000)	// 18	24-bit Timer counter overflow interrupt							
#define CIMINT_ALL_PWM0_COMP	(0x00020000)	// 17	16-bit Timer PWM0 counter overflow or Compare interrupt			 					
#define CIMINT_ALL_PWM1_COMP	(0x00010000)	// 16	16-bit Timer PWM1 counter overflow or Compare interrupt			 					
#define CIMINT_ALL_PWM2_COMP	(0x00008000)	// 15	16-bit Timer PWM2 counter overflow or Compare interrupt			 					
#define CIMINT_ALL_PWM3_COMP	(0x00004000)	// 14	16-bit Timer PWM3 counter overflow or Compare interrupt			 					
#define CIMINT_ALL_FRONT_END2	(0x00002000)	// 13	Front End 2 Interrupt			 					
#define CIMINT_ALL_FRONT_END1	(0x00001000)	// 12	Front End 1 Interrupt			 					
#define CIMINT_ALL_FRONT_END0	(0x00000800)	// 11	Front End 0 Interrupt				
#define CIMINT_ALL_DIGI_COMP 	(0x00000400)	// 10	Digital comparator interrupt		
#define CIMINT_ALL_PMBUS		(0x00000200)	// 9	PMBus related interrupt			 				
#define CIMINT_ALL_UART2_TX		(0x00000100)	// 8	UART2 TX buffer empty			 						
#define CIMINT_ALL_UART2_RX		(0x00000080)	// 7	UART2 RX buffer has a byte			 				
#define CIMINT_ALL_UART1_TX		(0x00000040)	// 6	UART1 TX buffer empty			 		
#define CIMINT_ALL_UART1_RX		(0x00000020)	// 5	UART1 RX buffer has a byte 		
#define CIMINT_ALL_UART_ERR		(0x00000010)	// 4	UART or SCI error Interrupt. Frame, parity or Overrun			 	
#define CIMINT_ALL_WTDG_WAKE	(0x00000008)	// 3	Wakeup interrupt when watchdog equals half of set watch time			 	
#define CIMINT_ALL_WTDG_RSET	(0x00000004)	// 2	Interrupt from watchdog exceeded (reset)			 	
#define CIMINT_ALL_EXT_INT	    (0x00000002)	// 1	Interrupt on one or all external input pins			 					
#define CIMINT_ALL_BRWN_OUT		(0x00000001)	// 0	Brown Out Interrupt			 					


//=========================================================================================
// Global I/O definitions
//=========================================================================================
//Bit positions:
#define FAULT3_GLBIO_BIT_POSITION                (29)
#define ADC_EXT_TRIG_GLBIO_BIT_POSITION          (28)
#define TCK_GLBIO_BIT_POSITION                   (27)
#define TDO_GLBIO_BIT_POSITION                   (26)
#define TMS_GLBIO_BIT_POSITION                   (25)
#define TDI_GLBIO_BIT_POSITION                   (24)
#define SCI_TX1_GLBIO_BIT_POSITION               (23)
#define SCI_TX0_GLBIO_BIT_POSITION               (22)
#define SCI_RX1_GLBIO_BIT_POSITION               (21)
#define SCI_RX0_GLBIO_BIT_POSITION               (20)
#define TMR_CAP_GLBIO_BIT_POSITION               (19)
#define TMR_PWM1_GLBIO_BIT_POSITION              (18)
#define TMR_PWM0_GLBIO_BIT_POSITION              (17)
#define PMBUS_CLK_GLBIO_BIT_POSITION             (16)
#define PMBUS_DATA_GLBIO_BIT_POSITION            (15)
#define CONTROL_GLBIO_BIT_POSITION               (14)
#define ALERT_GLBIO_BIT_POSITION                 (13)
#define EXT_INT_GLBIO_BIT_POSITION               (12)
#define FAULT2_GLBIO_BIT_POSITION                (11)
#define FAULT1_GLBIO_BIT_POSITION                (10)
#define FAULT0_GLBIO_BIT_POSITION                 (9)
#define SYNC_GLBIO_BIT_POSITION                   (8)
#define DPWM3B_GLBIO_BIT_POSITION                 (7)
#define DPWM3A_GLBIO_BIT_POSITION                 (6)
#define DPWM2B_GLBIO_BIT_POSITION                 (5)
#define DPWM2A_GLBIO_BIT_POSITION                 (4)
#define DPWM1B_GLBIO_BIT_POSITION                 (3)
#define DPWM1A_GLBIO_BIT_POSITION                 (2)
#define DPWM0B_GLBIO_BIT_POSITION                 (1)
#define DPWM0A_GLBIO_BIT_POSITION                 (0)

//Bit masks:
#define FAULT3_GLBIO_BIT_MASK                 (1 << FAULT3_GLBIO_BIT_POSITION) 
#define ADC_EXT_TRIG_GLBIO_BIT_MASK           (1 << ADC_EXT_TRIG_GLBIO_BIT_POSITION)          
#define TCK_GLBIO_BIT_MASK                    (1 << TCK_GLBIO_BIT_POSITION)                   
#define TDO_GLBIO_BIT_MASK                    (1 << TDO_GLBIO_BIT_POSITION)                   
#define TMS_GLBIO_BIT_MASK                    (1 << TMS_GLBIO_BIT_POSITION)                   
#define TDI_GLBIO_BIT_MASK                    (1 << TDI_GLBIO_BIT_POSITION)                   
#define SCI_TX1_GLBIO_BIT_MASK                (1 << SCI_TX1_GLBIO_BIT_POSITION)               
#define SCI_TX0_GLBIO_BIT_MASK                (1 << SCI_TX0_GLBIO_BIT_POSITION)              
#define SCI_RX1_GLBIO_BIT_MASK                (1 << SCI_RX1_GLBIO_BIT_POSITION)               
#define SCI_RX0_GLBIO_BIT_MASK                (1 << SCI_RX0_GLBIO_BIT_POSITION)               
#define TMR_CAP_GLBIO_BIT_MASK                (1 << TMR_CAP_GLBIO_BIT_POSITION)               
#define TMR_PWM1_GLBIO_BIT_MASK               (1 << TMR_PWM1_GLBIO_BIT_POSITION)              
#define TMR_PWM0_GLBIO_BIT_MASK               (1 << TMR_PWM0_GLBIO_BIT_POSITION)              
#define PMBUS_CLK_GLBIO_BIT_MASK              (1 << PMBUS_CLK_GLBIO_BIT_POSITION)             
#define PMBUS_DATA_GLBIO_BIT_MASK             (1 << PMBUS_DATA_GLBIO_BIT_POSITION)            
#define CONTROL_GLBIO_BIT_MASK                (1 << CONTROL_GLBIO_BIT_POSITION)               
#define ALERT_GLBIO_BIT_MASK                  (1 << ALERT_GLBIO_BIT_POSITION)                 
#define EXT_INT_GLBIO_BIT_MASK                (1 << EXT_INT_GLBIO_BIT_POSITION)               
#define FAULT2_GLBIO_BIT_MASK                 (1 << FAULT2_GLBIO_BIT_POSITION)                
#define FAULT1_GLBIO_BIT_MASK                 (1 << FAULT1_GLBIO_BIT_POSITION)                
#define FAULT0_GLBIO_BIT_MASK                 (1 << FAULT0_GLBIO_BIT_POSITION)                
#define SYNC_GLBIO_BIT_MASK                   (1 << SYNC_GLBIO_BIT_POSITION)                   
#define DPWM3B_GLBIO_BIT_MASK                 (1 << DPWM3B_GLBIO_BIT_POSITION)                 
#define DPWM3A_GLBIO_BIT_MASK                 (1 << DPWM3A_GLBIO_BIT_POSITION)                 
#define DPWM2B_GLBIO_BIT_MASK                 (1 << DPWM2B_GLBIO_BIT_POSITION)                 
#define DPWM2A_GLBIO_BIT_MASK                 (1 << DPWM2A_GLBIO_BIT_POSITION)                 
#define DPWM1B_GLBIO_BIT_MASK                 (1 << DPWM1B_GLBIO_BIT_POSITION)                 
#define DPWM1A_GLBIO_BIT_MASK                 (1 << DPWM1A_GLBIO_BIT_POSITION)                 
#define DPWM0B_GLBIO_BIT_MASK                 (1 << DPWM0B_GLBIO_BIT_POSITION)                 
#define DPWM0A_GLBIO_BIT_MASK                 (1 << DPWM0A_GLBIO_BIT_POSITION)   

#define CS_INT_EXP (10)

#define LIGHT_LOAD_ENABLE (1)

//DPWM Constant

#define DAC_STEP_VALUE 1.5625
#define PCM_BLANK   (30) //30
#define DEADTIME_ADJ_LAG (16 * 4)  //16ns

#define DUTY_SHIFT (0) //reduces maximum duty by this number of nanoseconds
#define DUTY_SHIFT_HI_RES (DUTY_SHIFT * 4)

// Deadtimes
#define BRIDGE_DELAY (180) //180ns deadtime //240ns
#define BRIDGE_DELAY_ST (240) //240ns

#define SR_FALLING_BRIDGE_DELAY (-10) //deadtime of SR  //10 before
#define SR_RISING_BRIDGE_DELAY (30)                     //20 before
#define HALF_PERIOD  ((int)((1000000/SWITCHING_FREQUENCY)/8))//half period in 4 ns steps.
#define	PERIOD  (HALF_PERIOD * 2) //calculate HALF PERIOD first so period is sure to be twice the half period.

#define CURRENT_SHARING_THRESHOLD (30)

#define MIN_SWITCH_FREQ (80) //KHz.
#define MAX_SWITCH_FREQ (200) //KHz.
#define SWITCH_FREQ_NUMERATOR (250000) //numerator to divide by KHz to get period.








