#ifdef MAIN 					// If it is the main routine
	#define EXTERN	 			// If it isn't extern, so define it as nothing
#else 							// If it isn't the main routine
	#define EXTERN extern 		// If it is extern
#endif

typedef void (*FUNC_PTR)(); 	//used for zeroing instruction word.

typedef struct  
{
	Uint32 vin_mon; 		//Value from adc for Vin 
	Uint32 ishare; 			//Value from adc for Ishare
	Uint32 vo_sense; 		//Value from adc for Vout
	Uint32 ips; 			//Value from adc for primary current sense
	Uint32 vo_ovp; 			//Value from adc for Vin  
	Uint32 temp;			//Value from adc for SR MOSFET temperature
	Uint32 io_sense; 		//Value from adc for Iout
	Uint32 device_temp;		//Value from adc for internal device temperature
}ADC_VALUES_STRUCT;

struct PFC_OUT_STRUCT
{
	unsigned char pfc_status0;
    unsigned char pfc_status1;
    unsigned int  pfc_vac;
    unsigned int  pfc_iac;
    unsigned int  pfc_pin;
	unsigned int  pfc_pout;
    unsigned int  pfc_vdc_bus;
    unsigned int  pfc_sw_frequency;
    unsigned char pfc_temperature;
};

typedef enum
{
	STATE_IDLE,			
	STATE_RAMP_UP,
	STATE_REGULATED,
	STATE_FAULT
}SUPPLY_STATE;

typedef enum
{
	OVER_VOLTAGE,			
	OVER_CURRENT,
	OVER_TEMPERATURE,
	UNDER_VOLTAGE
}FAULT_TYPE;



typedef enum
{
	START_UP,			
	START_OVER
}RESTART_STATE;


EXTERN ADC_VALUES_STRUCT adc_values; 	//ADC Readings
EXTERN ADC_VALUES_STRUCT adc_values_avg;//ADC Readings Averaged
EXTERN SUPPLY_STATE supply_state; 		//Supply state enum for state machine
EXTERN FAULT_TYPE fault_type;
EXTERN RESTART_STATE start_state;

EXTERN Uint8 uart_text_rx_buf[UART_RX_SIZE*2 + 2]; 	//UART receive buffer in text mode
EXTERN Uint8 uart_text_tx_buf[UART_TX_SIZE*2 + 2]; 	//UART transmit buffer in text mode
EXTERN Uint8 uart_rx_buf[UART_RX_SIZE]; 			//UART receive buffer
EXTERN Uint8 uart_tx_buf[UART_TX_SIZE]; 			//UART transmit buffer
EXTERN Uint8 uart_rx_data_rdy; 						//flag, received a new data packet
EXTERN Uint8 uart_tx_data_rdy; 						//flag, a new data packet is ready for transmit
EXTERN Uint8 uart_rx_buf_ptr; 						//point to the buffer which will store the coming byte
EXTERN Uint8 uart_tx_buf_ptr; 						//point to buffer whose data is going to be sent out 
EXTERN Uint16 uart_rx_timeout; 						//count IRQ, UART receiver will start over when timeout
EXTERN Uint16 uart_tx_timeout; 						//count IRQ, UART needs to wait for a certain period before send the next data packet

EXTERN struct PFC_OUT_STRUCT pfc_out_struct;

EXTERN Uint8 light_load_enable;	//for APEC demo
EXTERN Uint8 pfc_command;		//for APEC demo
EXTERN Uint8 pfc_phase_2_enable;//for APEC demo
EXTERN Uint8 pfc_zvs_enable;	//for APEC demo
EXTERN Uint8 pfc_os_enable;		//for APEC demo

EXTERN Uint8 erase_segment_counter;	// Number of DFlash segment remaining to be erased
EXTERN Uint8 erase_segment_number;	// DFlash segment number being erased
EXTERN Uint8 flash_write_status;	// Global status while attempting to write to Data Flash.

EXTERN Uint32 interrupt_counter1;
EXTERN Uint32 hiccup_counter;
EXTERN Uint32 hiccup_counter_ov;

struct qnote
{
  int16 mantissa;
  int16 exponent;
};

EXTERN int32 current_share_int_state; 
EXTERN int32 current_share_control_effort;
EXTERN int16 current_share_kp;
EXTERN int16 current_share_ki;
EXTERN int32 error_zero;
EXTERN int32 local_error;
EXTERN int32 ishare_center_threshold;
EXTERN int32 ishare_threshold;
EXTERN int32 ishare_threshold_ms;
EXTERN int32 ishare_center_threshold_ms;
EXTERN int32 ishare_threshold_master_enable;
EXTERN int32 ishare_threshold_slave_enable;
EXTERN int32 eadc_dac_target;
EXTERN int32 eadc_dac_max;
EXTERN int32 eadc_dac_min;
EXTERN int32 master_state;
EXTERN int32 master_time_count;
EXTERN int32 master_time_limit;
EXTERN int8  enable_turn_on;
EXTERN int8  fault_flag;
EXTERN int8 vv_flag;
EXTERN int8 cc_flag;
EXTERN int8 cp_flag;
EXTERN int8 cv_trans_flag;
EXTERN int32 vloop_filter;
EXTERN int32 iloop_filter;
EXTERN Uint32 pout;


EXTERN Uint16 dpwm_ot_turn_on;

EXTERN Uint32 bridge_delay;
EXTERN Uint32 sr_falling_bridge_delay;
EXTERN Uint32 sr_rising_bridge_delay;
EXTERN Uint32 half_period;
EXTERN Uint32 period;
EXTERN Uint32 deadtime_bridge_adj;
EXTERN int32 deadtime_srrise_adj;
EXTERN int32 deadtime_srfall_adj;
EXTERN Uint32 isharing_error;

//EXTERN Uint32 switching_frequency;
EXTERN Uint32 period_new;






