#include "system_defines.h"
#include "Cyclone_Device.h"
#include "pmbus_commands.h"
#include "pmbus.h"
#include "variables.h"
#include "function_definitions.h"
#include "software_interrupts.h"


int pcm_blank;

int deadtime_adi_lag;

int pwm0_ev1;
int pwm0_ev2;
int pwm0_ev3;
int pwm0_ev4;
int pwm0_ev5;
int pwm0_ev6;

int pwm1_ev1;
int pwm1_ev2;
int pwm1_ev3 ;
int pwm1_ev4;
int pwm1_ev5 ;
int pwm1_ev6;


int pwm2_ev1;
int pwm2_ev2 ;
int pwm2_ev3 ;
int pwm2_ev4;
int pwm2_ev5;
int pwm2_ev6;



int pwm3_ev1;
int pwm3_ev2 ;
int pwm3_ev3 ;
int pwm3_ev4;
int pwm3_ev5;
int pwm3_ev6;


void deadtime_adjust(void)
{

Uint32 pwm_slavesync;
Uint32  pwm_period;


 deadtime_adi_lag = DEADTIME_ADJ_LAG;
#ifdef AUTOTUNE
 bridge_delay = deadtime_bridge_adj; //BRIDGE_DELAY;
 sr_falling_bridge_delay =deadtime_srfall_adj; //SR_FALLING_BRIDGE_DELAY;
 sr_rising_bridge_delay = deadtime_srrise_adj; //SR_RISING_BRIDGE_DELAY;
#else
 bridge_delay = BRIDGE_DELAY;
 sr_falling_bridge_delay = SR_FALLING_BRIDGE_DELAY;
 sr_rising_bridge_delay = SR_RISING_BRIDGE_DELAY;
#endif




#ifdef FREQUENCY_MODIFICATION

 period_new = (SWITCH_FREQ_NUMERATOR/pmbus_dcdc_config[0].switching_frequency); //in 4 ns
 if(period_new > period)
 {
	period = period + 1;

 }

 else if(period_new < period)
 {
	period = period - 1;

 }
	half_period = period >>1;

#else
 half_period = HALF_PERIOD;
 period = half_period *2;
#endif

 pwm_slavesync = half_period *16;   //scale to 250ps/bit in registers
 pwm_period = period *16;


 pwm0_ev1 = bridge_delay * 4;   // scale to 250ps/bit (bridge_delay/4 *16)
 pwm0_ev2 = half_period * 16;   //scale to 250ps/bit (*16)
 pwm0_ev3 = half_period * 16 + (bridge_delay - 30 + sr_rising_bridge_delay) * 4;
 pwm0_ev4 = (bridge_delay + sr_falling_bridge_delay) * 4;

 pwm0_ev5 = bridge_delay * 4; //scale to 250ps/bit (bridge_delay/4 *16)
 pwm0_ev6 = half_period * 16;




 pwm1_ev1 = bridge_delay * 4;
 pwm1_ev2 = half_period * 16;
 pwm1_ev3 = half_period * 16 + (bridge_delay - 30 + sr_rising_bridge_delay) * 4;
 pwm1_ev4 = (bridge_delay + sr_falling_bridge_delay) * 4;

 pwm1_ev5 = bridge_delay * 4;
 pwm1_ev6 = half_period * 16;



 pwm2_ev1 = bridge_delay * 4;
 pwm2_ev2 = half_period * 16;
 pwm2_ev3 = half_period * 16 + bridge_delay * 4;
 pwm2_ev4 = 0;

 pwm2_ev5 = bridge_delay * 4;
 pwm2_ev6 = half_period * 16;



 pwm3_ev1 = bridge_delay * 4;
 pwm3_ev2 = half_period * 16;
 pwm3_ev3 = half_period * 16 + bridge_delay * 4;
 pwm3_ev4 = 0;

 pwm3_ev5 = bridge_delay * 4;
 pwm3_ev6 = half_period * 16;

 pcm_blank = PCM_BLANK;


  Dpwm0Regs.DPWMEV1.all  = pwm0_ev1;       
  Dpwm0Regs.DPWMEV2.all  = pwm0_ev2;   // This has to match 3A EV2 for curr limit to match (readjust at end)    
  Dpwm0Regs.DPWMEV3.all  = pwm0_ev3;       
  Dpwm0Regs.DPWMEV4.all  = pwm0_ev4;       
 
  Dpwm0Regs.DPWMBLKABEG.all = 0; 
  Dpwm0Regs.DPWMBLKAEND.all = ( bridge_delay + pcm_blank) * 4;
   
  Dpwm0Regs.DPWMBLKBBEG.all =  pwm0_ev5 + deadtime_adi_lag ;
  Dpwm0Regs.DPWMBLKBEND.all =  pwm0_ev6;

  Dpwm0Regs.DPWMSAMPTRIG2.all = pwm_slavesync; 
  Dpwm0Regs.DPWMPHASETRIG.all =  pwm_slavesync;
  
  Dpwm0Regs.DPWMPRD.all  =  pwm_period;       

 
  // ----------------------------------------------------------------------
 
  Dpwm1Regs.DPWMEV1.all  = pwm1_ev1;       
  Dpwm1Regs.DPWMEV2.all  = pwm1_ev2;       
  Dpwm1Regs.DPWMEV3.all  = pwm1_ev3;       
  Dpwm1Regs.DPWMEV4.all  = pwm1_ev4; 

  Dpwm1Regs.DPWMBLKBBEG.all =  pwm1_ev5 + deadtime_adi_lag;
  Dpwm1Regs.DPWMBLKBEND.all =  pwm1_ev6;

  Dpwm1Regs.DPWMBLKABEG.all = 0; 
  Dpwm1Regs.DPWMBLKAEND.all = ( bridge_delay + pcm_blank) * 4; //; 
  Dpwm1Regs.DPWMPRD.all  =  pwm_period;       
  Dpwm1Regs.DPWMPHASETRIG.all =  pwm_slavesync;

  // ----------------------------------------------------------------------

  Dpwm2Regs.DPWMEV1.all  = pwm2_ev1;       
  Dpwm2Regs.DPWMEV2.all  = pwm2_ev2;       
  Dpwm2Regs.DPWMEV3.all  = pwm2_ev3;       
  Dpwm2Regs.DPWMEV4.all  = pwm2_ev4;
         
  Dpwm2Regs.DPWMBLKBBEG.all =  pwm2_ev5 + deadtime_adi_lag;
  Dpwm2Regs.DPWMBLKBEND.all =   pwm2_ev6;

  Dpwm2Regs.DPWMBLKABEG.all = 0; 
  Dpwm2Regs.DPWMBLKAEND.all = ( bridge_delay + pcm_blank) * 4; //16 * 30; 
  Dpwm2Regs.DPWMPRD.all  =  pwm_period;
  Dpwm2Regs.DPWMPHASETRIG.all =  pwm_slavesync;
  // ----------------------------------------------------------------------

  Dpwm3Regs.DPWMEV1.all  = pwm3_ev1;       
  Dpwm3Regs.DPWMEV2.all  = pwm3_ev2;       
  Dpwm3Regs.DPWMEV3.all  = pwm3_ev3;       
  Dpwm3Regs.DPWMEV4.all  = pwm3_ev4;
         
  Dpwm3Regs.DPWMBLKABEG.all = 0; 	
  Dpwm3Regs.DPWMBLKAEND.all = ( bridge_delay + pcm_blank) * 4;
   
  Dpwm3Regs.DPWMBLKBBEG.all =  pwm3_ev5 + deadtime_adi_lag;
  Dpwm3Regs.DPWMBLKBEND.all =  pwm3_ev6;
  Dpwm3Regs.DPWMPRD.all  =  pwm_period;


 Dpwm0Regs.DPWMSAMPTRIG1.all =  pwm_period >> 2;
 Dpwm1Regs.DPWMSAMPTRIG1.all =  pwm_period >> 2;

} 



