#include "pmbus_coefficients.h"

void char_out(char data);

void init_Filter0(void);
void init_Filter1(void);
void init_front_end0(void);
void init_front_end1(void);
void init_uart0(void);
void init_uart1(void);
void zero_out_integrity_word(void);
int  pmbus_write_rom_mode(void);
void watchdog_reset(void);
void init_timer_interrupt(void);
void init_gpio(void);
void init_filter0(void);
void init_filter1(void);
void init_adc12(void);
inline void poll_adc(void);
void clear_faults(void);
void uart_transmit_data(void);
void translate_raw_to_text(void);
void uart_process_rx_data(void);
char translate_nybble_out(char byte,char * pchar2 );
char translate_nybble_in(char nyb);
void translate_text_to_raw(void);
inline void uart_receive_data(void);
int pmbus_write_light_load_enable(void);
Uint8 pmbus_read_light_load_enable(void);

int pmbus_write_pfc_zvs_enable(void);
Uint8 pmbus_read_pfc_zvs_enable(void);
int pmbus_write_pfc_os_enable(void);
Uint8 pmbus_read_pfc_os_enable(void);
void cpcc_init(void);
void cpcc_enable(void);
void cpcc_disable(void);
void filter1_jam(void);
void send_string(const Uint8 string_to_send[], Uint8 num_bytes);
int pmbus_mfr_model_handler(void);
int pmbus_mfr_revision_handler(void);
int pmbus_mfr_id_handler(void);
int32 pmbus_read_two_byte_handler(Uint16 value);
int32 pmbus_read_one_byte_handler(Uint8 value);
Uint8 start_erase_task(const void* dest_ptr, Uint16 byte_count);
Uint32 calculate_dflash_checksum(Uint8 *start_addr, Uint8 *end_addr);
inline Uint8 calc_flash_segments(const void* dest_ptr, Uint16 byte_count, Uint8* first_segment);
void clear_program_flash(void);
Uint8 pmbus_write_store_default_all(void);
Uint8 pmbus_write_restore_default_all(void);
void init_pmbus_variables(void);
void translate_data_from_literal_to_translated( Uint16 *raw_data, Uint16 *translated_data, Uint8 shift_exponent, Uint16 numerator_factor, Uint16 denominator_factor);
void write_program_flash_word(int * address, int data);
void look_for_interrupted_dflash_erase(void);
Uint8 update_data_flash(void* dest_ptr, const void* src_ptr, Uint16 byte_count);
void erase_task(void);
void erase_one_section(int first_segment, int byte_count);
Uint8 pmbus_write_dflash_test(void);
void copy_coefficients_to_filter(volatile struct FILTER_REGS *dest, const FILTER_PMBUS_REGS *source);
void copy_coefficients_to_ram(volatile FILTER_PMBUS_REGS *dest, volatile struct FILTER_REGS *source);
Uint8 pmbus_write_vout_transition_rate(void);
Uint8 pmbus_read_vout_transition_rate(void);
Uint8 pmbus_write_vout_cmd(void);
Uint8 pmbus_read_vout_cmd(void);
Uint8 pmbus_write_ton_rise(void);
Uint8 pmbus_read_ton_rise(void);
void configure_ton_rise(void);
int8 unpack_literal_11(Uint16 *raw_data, Uint16 *mantissa, Uint8 *shift_exponent);
unsigned short unsigned_short_q_multiply(unsigned short multiplier,unsigned short multiplicand);
int handle_running_faults(void);
void transition_to_idle_state(void);
void control_sr_on_off(void);
void cccp_dac_adjust(void);
int pmbus_mfr_date_handler(void);
int pmbus_mfr_location_handler(void);
int pmbus_mfr_serial_handler(void);
Uint8 pmbus_read_vout_ov_fault_limit(void);

Uint8 pmbus_read_iout_oc_fault_limit(void);

Uint8 pmbus_read_temp_ot_fault_limit(void);

Uint8 pmbus_read_iin_oc_fault_limit(void);

Uint8 pmbus_write_vout_ov_fault_limit(void);

Uint8 pmbus_write_iout_oc_fault_limit(void);

Uint8 pmbus_write_temp_ot_fault_limit(void);

Uint8 pmbus_write_iin_oc_fault_limit(void);

Uint8 pmbus_read_vout(void);
int32 pmbus_read_vout_handler(Uint32 vout);
Uint8 pmbus_read_vin(void);
Uint8 pmbus_read_iout(void);
Uint8 pmbus_read_temperature1(void); 
Uint8 pmbus_write_clear_faults(void);
Uint8 above_vin_on_limit(void);
Uint8 below_vin_off_limit(void);

struct qnote qnote_multiply_int32 (struct qnote x, struct qnote y);
struct qnote qnote_multiply (struct qnote x, struct qnote y);
struct qnote qnote_scale_int32 (struct qnote x, int32 y);
struct qnote qnote_scale (struct qnote x, int16 y);
struct qnote linear11_to_qnote (int16 linear11);
struct qnote linear11_to_qnote (int16 linear11);
int16 qnote_fit(struct qnote x, int16 bits_limit, int8 *err_flag);
int16 qnote_multiply_fit(struct qnote x, struct qnote y, int16 bits_limit, int8 *err_flag);
int16 qnote_multiply_fit7(struct qnote x, struct qnote y, int8 *err_flag);
int16 qnote_multiply_fit14(struct qnote x, struct qnote y, int8 *err_flag);
int16 linear11_multiply_fit(int16 x, int16 y, int16 bits_limit, int8 *err_flag);
int16 linear11_multiply_fit7(int16 x, int16 y, int8 *err_flag);
int16 linear11_multiply_fit14(int16 x, int16 y, int8 *err_flag);
int16 linear11_multiply(int16 x, int16 y);
void initialize_dpwm_timing(void);

struct qnote qnote_subtract(struct qnote x, struct qnote y);
int16 qnote_to_linear11 (struct qnote x);
Uint16 qnote_linear16_multiply_fit14(struct qnote x, Uint16 linear16_mantissa, int8 vout_mode);

Uint8 pmbus_read_debug_buffer(void);
Uint8 pmbus_read_user_ram_00(void);
Uint8 pmbus_write_user_ram_00(void);

Uint8 pmbus_read_parm_value(void);
Uint8 pmbus_write_parm_value(void);
Uint8 pmbus_read_parm_info(void);
Uint8 pmbus_write_parm_info(void);

int pmbus_mfr_ic_device_handler(void);
int pmbus_mfr_ic_device_rev_handler(void);

float linear11_to_float (int16 linear11);
int16 float_to_linear11 (float x);
void float_out(float x);
void float_word_out(Uint32 x);
void linear_11_out(Uint16 x);
Uint16 float_to_linear16 (float x,int8 vout_mode);
float linear16_to_float(Uint16 x, int8 vout_mode);
float signed_linear16_to_float(int16 x, int8 vout_mode);

void jeff_init(void);

Uint8 pmbus_write_vout_scale_loop(void);
Uint8 pmbus_read_vout_scale_loop(void);

Uint8 pmbus_write_vout_cal_offset(void);
Uint8 pmbus_read_vout_cal_offset(void);

int16 dac_target_calculate(void);

void restore_default_all(void);
void pmbus_data_translation(void);
void configure_mode_switching(void);
void configure_cpcc(void);
void configure_burst_mode(void);
void disable_current_sharing(void);
void init_syncfet_soft_onoff(void);
void init_flux_balancing(void);
void preset_filter0(signed int preset_value);
void preset_filter1(signed int preset_value);
void deadtime_adjust(void);
Uint8 pmbus_write_deadband_config(void);
Uint8 pmbus_read_deadband_config(void);







