#include "include.h"

//use configuration in data flash
void init_filter1(void)
{
	copy_coefficients_to_filter(&Filter1Regs, &filter1_pmbus_regs);

	Filter0Regs.FILTERCTRL.bit.OUTPUT_MULT_SEL = 0; //use KCOMP for scaling.

	Filter1Regs.FILTERCTRL.bit.FILTER_EN = 1;
}

void connect_filter_1_to_front_end2_DAC(void)
{
	LoopMuxRegs.SAMPTRIGCTRL.bit.FE1_TRIG_DPWM1_EN = 1; //use DPWM0 for filter0 sample trigger	
	LoopMuxRegs.FILTERKCOMPA.bit.KCOMP0 = 0x3fff; //0x3FFF is full scale

//	LoopMuxRegs.EXTDACCTRL.bit.DAC2_SEL = 5; // 3 for CPCC. 4 for filter 0;  5 for current loop
	Filter1Regs.FILTERCTRL.bit.OUTPUT_SCALE =6; //gained by 4
	LoopMuxRegs.EXTDACCTRL.bit.EXT_DAC2_EN = 0;
}



void init_front_end1(void)
{
	// Initialize Front End Gain to start gain used in SAR Mode
	FeCtrl1Regs.EADCCTRL.bit.AFE_GAIN = filter1_pmbus_regs.FILTER_MISC.bit.AFE_GAIN;

	// Use 8MHz sampling frequency for Error EADC in SAR mode
	FeCtrl1Regs.EADCCTRL.bit.SCFE_CLK_DIV_2 = 0;

	// Initialize EADC counter to synchronize with SAR mode and MCLK
	//  FeCtrl1Regs.EADCCTRL.bit.SCFE_CNT_INIT  = 0xD;

	// Set Front End in Non-Continuous Mode
	FeCtrl1Regs.EADCCTRL.bit.EADC_MODE = 0;

	// Set Processor DAC to MAX_CURRENT value for Error calculation
//	FeCtrl1Regs.EADCDAC.bit.DAC_VALUE  = pmbus_dcdc_config_translated[0].cpcc_imax;



	// Enable Front End Control 1 Module to allow Switched cap/EADC to settle before 
	// starting SAR algorithm
	//LoopMuxRegs.GLBEN.all = 0x100;
}
void init_cpcc(void)
{
	LoopMuxRegs.EXTDACCTRL.bit.DAC0_SEL 	= 3; //Use Constant Power Module for Voltage DAC source
	LoopMuxRegs.EXTDACCTRL.bit.EXT_DAC0_EN 	= 0; ///disable control to Constant Power Module for now.

	LoopMuxRegs.DPWMMUX.bit.DPWM0_FILTER_SEL = 3; //constant power module output for all DPWMs
	LoopMuxRegs.DPWMMUX.bit.DPWM1_FILTER_SEL = 3;
	LoopMuxRegs.DPWMMUX.bit.DPWM2_FILTER_SEL = 3;
	LoopMuxRegs.DPWMMUX.bit.DPWM3_FILTER_SEL = 3;

	LoopMuxRegs.SAMPTRIGCTRL.bit.FE0_TRIG_DPWM0_EN = 1; //use DPWM0 for filter0 sample trigger	
	LoopMuxRegs.SAMPTRIGCTRL.bit.FE1_TRIG_DPWM1_EN = 1; //use DPWM1 for filter1 sample trigger

	//	i. Setup connection for each filter in use to KCOMP
	LoopMuxRegs.FILTERMUX.bit.FILTER0_KCOMP_SEL = 0;
	LoopMuxRegs.FILTERMUX.bit.FILTER1_KCOMP_SEL = 0;//use COMP0

	//	ii. Setup DPWM switching period input for each filter
	LoopMuxRegs.FILTERMUX.bit.FILTER0_PER_SEL = 0;//use dpwm0 period
	LoopMuxRegs.FILTERMUX.bit.FILTER1_PER_SEL = 0;//use dpwm0 period

	//	iii. Setup which Front End drives the filter
	LoopMuxRegs.FILTERMUX.bit.FILTER0_FE_SEL = 0;//use FE0 to drive CLA0
	LoopMuxRegs.FILTERMUX.bit.FILTER1_FE_SEL = 1;//use FE1 to drive CLA1

	LoopMuxRegs.CPCTRL.bit.CLOOP_SEL		= 1;  //select filter01 for current loop switching
	LoopMuxRegs.CPCTRL.bit.VLOOP_SEL  		= 0; // select filter 00 for voltage loop switching
	LoopMuxRegs.CPCTRL.bit.CPCC_CONFIG 		= 1;  //Use CPM for selection of Vloop and Cloop
	LoopMuxRegs.CPCTRL.bit.DIVISOR_SEL 		= 1;  //select EAD01 for CP devisor
	LoopMuxRegs.CPCTRL.bit.CPCC_EN 			= pmbus_dcdc_config[0].cpcc_enable; // enable CPCC module
	LoopMuxRegs.CPCTRL.bit.FW_DIVISOR_EN 	= 0; //use SAR for divisor
	LoopMuxRegs.CPCTRL.bit.LOWER_COMP_EN 	= 1; // use lower duty for loop switching
	LoopMuxRegs.CPCTRL.bit.THRESH_SEL 		= 4; //select EADC01 SAR for constant power comparison
	LoopMuxRegs.CPCTRL.bit.VLOOP_FREEZE_EN 	= 1; // voltage loop integrator is not frozen

	LoopMuxRegs.CPNOM.bit.NOM_CURRENT_LOWER = pmbus_dcdc_config_translated[0].cpcc_pmax / (pmbus_dcdc_config_translated[0].vout_cmd >> 4);  //lower nominal current limit
	LoopMuxRegs.CPNOM.bit.NOM_CURRENT_UPPER = pmbus_dcdc_config_translated[0].cpcc_pmax / (pmbus_dcdc_config_translated[0].vout_cmd >> 4); //upper nominal current limit
	LoopMuxRegs.CPMAX.bit.MAX_CURRENT_LOWER = pmbus_dcdc_config_translated[0].cpcc_imax >> 4;//lower max current limit
	LoopMuxRegs.CPMAX.bit.MAX_CURRENT_UPPER = pmbus_dcdc_config_translated[0].cpcc_imax >> 4;//upper max current limit
	LoopMuxRegs.CPCONFIG.bit.MAX_CURRENT 	= pmbus_dcdc_config_translated[0].cpcc_imax >> 4;//

	LoopMuxRegs.CPCONFIG.bit.NOM_VOLTAGE 	= pmbus_dcdc_config_translated[0].vout_cmd >> 4;  //output voltage setting 
	LoopMuxRegs.CPMAXPWR.bit.MAX_POWER 		= pmbus_dcdc_config_translated[0].cpcc_pmax; //max power 
	//LoopMuxRegs.CPFWDIVISOR.bit.FW_DIVISOR = 800;   //10 bits firmware divisor from firmware programming
	//LoopMuxRegs.CPINTTHRESH.bit.INT_THRESH =0 ; // added value to current loop for freezing current loop

	LoopMuxRegs.CPCTRL.bit.DAC_COMP_EN = 0;
}

void init_current_loop(void)
{
	init_front_end1();
	init_filter1();
//	init_cpcc();
	connect_filter_1_to_front_end2_DAC();

}

