#include "system_defines.h"
#include "Cyclone_Device.h"
#include "pmbus_commands.h"
#include "pmbus.h"
#include "variables.h"
#include "function_definitions.h"
#include "software_interrupts.h"

#define DT01  (BRIDGE_DELAY/4) // Convert to 4ns resolution
#define DT45  (BRIDGE_DELAY/4) 
#define DT23  (BRIDGE_DELAY/4) 
#define DT67  (BRIDGE_DELAY/4) 

#define DT0A  ((BRIDGE_DELAY + SR_FALLING_BRIDGE_DELAY)/4) 
#define DT2B  ((BRIDGE_DELAY + SR_RISING_BRIDGE_DELAY)/4) 
#define DT4C  ((BRIDGE_DELAY + SR_FALLING_BRIDGE_DELAY)/4) 
#define DT6D  ((BRIDGE_DELAY + SR_RISING_BRIDGE_DELAY)/4) 


  // ----------------------
#define  PWM_PERIOD          ((PERIOD - 1) * 16)   //250ps/bit in register
#define  PWM_SLAVESYNC       (HALF_PERIOD * 16)  
  // ----------------------
#define  PWM1_EV5       (DT01 * 16) 
#define  PWM1_EV6       (HALF_PERIOD * 16)

#define  PWM1_EV1       (DT01 * 16)  // for spike blocking
#define  PWM1_EV2       ((HALF_PERIOD * 16) - DUTY_SHIFT_HI_RES)
#define  PWM1_EV3       (((HALF_PERIOD + DT2B) * 16) - DUTY_SHIFT_HI_RES)
#define  PWM1_EV4       ((DT0A) * 16) //(PWM_PERIOD - 16) // ((DT0A) * 16)
  // ---------------------- SLAVE SYNC
#define  PWM0_EV5       (DT45 * 16)
#define  PWM0_EV6       (HALF_PERIOD * 16)

#define  PWM0_EV1       (DT45 * 16)
#define  PWM0_EV2       ((HALF_PERIOD * 16) - DUTY_SHIFT_HI_RES)
#define  PWM0_EV3       (((HALF_PERIOD + DT6D) * 16) - DUTY_SHIFT_HI_RES)
#define  PWM0_EV4       (DT4C * 16) //(PWM_PERIOD - 16) //(DT4C * 16)
  // ----------------------
#define  PWM2_EV5       (DT01 * 16)
#define  PWM2_EV6       (HALF_PERIOD * 16)

#define  PWM2_EV1       (DT01 * 16)
#define  PWM2_EV2       ((HALF_PERIOD * 16) - DUTY_SHIFT_HI_RES)
#define  PWM2_EV3       (((HALF_PERIOD + DT23) * 16) - DUTY_SHIFT_HI_RES)  //DPWM2B rise edge
#define  PWM2_EV4       (0)
  // ---------------------- SLAVE SYNC 
#define  PWM3_EV5       (DT45 * 16)
#define  PWM3_EV6       (HALF_PERIOD * 16)
 
#define  PWM3_EV1       ((DT45) * 16) //for spike blocking
#define  PWM3_EV2       ((HALF_PERIOD * 16) - DUTY_SHIFT_HI_RES)
#define  PWM3_EV3       (((HALF_PERIOD + DT67) * 16) - DUTY_SHIFT_HI_RES)
#define  PWM3_EV4       (0)

void init_dpwm(void)
{


  // -----------------
  // Configure DPWM-0
  // -----------------

  // Control-0
  Dpwm0Regs.DPWMCTRL0.bit.PWM_EN     = 1;       // Enable, wait for Global En
  Dpwm0Regs.DPWMCTRL0.bit.CLA_EN     = 0;       // CLA Disabled, using curr limit to chop  
  Dpwm0Regs.DPWMCTRL0.bit.PWM_MODE   = 0;       // SEt mode: 0 - Normal 
  Dpwm0Regs.DPWMCTRL0.bit.MSYNC_SLAVE_EN   = 0;  // Master 
  Dpwm0Regs.DPWMCTRL0.bit.CBC_ADV_CNT_EN   = 1;  // Adv cnt limit enabled 
  Dpwm0Regs.DPWMCTRL0.bit.CBC_PWM_AB_EN    = 1;   // Current limit enabled for AB outputs 
  Dpwm0Regs.DPWMCTRL0.bit.PWM_A_INTRA_MUX  = 0;   // Send PWM-C out the A output 
  Dpwm0Regs.DPWMCTRL0.bit.BLANK_A_EN       = 1;    



  // Control-1 
  Dpwm0Regs.DPWMCTRL1.bit.HIRES_DIS         = 1;      
  Dpwm0Regs.DPWMCTRL1.bit.ALL_PHASE_CLK_ENA = 1;      
  Dpwm0Regs.DPWMCTRL1.bit.CHECK_OVERRIDE    = 1;       
  Dpwm0Regs.DPWMCTRL1.bit.EVENT_UP_SEL      = 1;   // UPdate end of period      
  
  Dpwm0Regs.DPWMSAMPTRIG2.all = PWM_SLAVESYNC; 
  Dpwm0Regs.DPWMPHASETRIG.all =  PWM_SLAVESYNC;
  

  Dpwm0Regs.DPWMEV1.all  = PWM0_EV1;       
  Dpwm0Regs.DPWMEV2.all  = PWM0_EV2;   // This has to match 3A EV2 for curr limit to match (readjust at end)    
  Dpwm0Regs.DPWMEV3.all  = PWM0_EV3;       
  Dpwm0Regs.DPWMEV4.all  = PWM0_EV4;       
  Dpwm0Regs.DPWMPRD.all  = PWM_PERIOD;       

   
  Dpwm0Regs.DPWMPRD.all  = PWM_PERIOD;   

  // ----------------------------------------------------------------------
  // Use blanking on PWM-0 and PWM3 Identical to ensure current limits align 
  // In this config, we need to wait for EV4 of PWM-0 to pass
  Dpwm0Regs.DPWMBLKABEG.all = 0; 
  Dpwm0Regs.DPWMBLKAEND.all = (BRIDGE_DELAY + PCM_BLANK) * 4; //Dpwm0Regs.DPWMEV4.all; 
  // ----------------------------------------------------------------------


  // Setup waveform for PWM-C (re-using blanking B regs)
  Dpwm0Regs.DPWMBLKBBEG.all =  PWM0_EV5 + DEADTIME_ADJ_LAG;
  Dpwm0Regs.DPWMBLKBEND.all =  PWM0_EV6;




  // -----------------
  // Configure DPWM-1 (master sync for rest of setup)
  // -----------------

  // Control-0
  Dpwm1Regs.DPWMCTRL0.bit.PWM_EN     = 1;         // Enable, wait for Global En
  Dpwm1Regs.DPWMCTRL0.bit.CLA_EN     = 0;         // CLA Disabled, using curr limit to chop  
  Dpwm1Regs.DPWMCTRL0.bit.PWM_MODE   = 0;         // SEt mode: 0 - Normal 
  Dpwm1Regs.DPWMCTRL0.bit.MSYNC_SLAVE_EN   = 1;  // DPWM-1 is master
  Dpwm1Regs.DPWMCTRL0.bit.CBC_ADV_CNT_EN   = 1;   // Adv cnt limit enabled 
  Dpwm1Regs.DPWMCTRL0.bit.CBC_PWM_AB_EN    = 1;   // Current limit enabled for AB outputs 
  Dpwm1Regs.DPWMCTRL0.bit.PWM_A_INTRA_MUX  = 0;   // PWM-A out to A output 
  Dpwm1Regs.DPWMCTRL0.bit.BLANK_A_EN       = 1;    











  // Control-1 
  Dpwm1Regs.DPWMCTRL1.bit.HIRES_DIS         = 1;      
  Dpwm1Regs.DPWMCTRL1.bit.ALL_PHASE_CLK_ENA = 1;      
  Dpwm1Regs.DPWMCTRL1.bit.CHECK_OVERRIDE    = 1;       
  Dpwm1Regs.DPWMCTRL1.bit.EVENT_UP_SEL      = 1;   // UPdate end of period      

 
  Dpwm1Regs.DPWMEV1.all  = PWM1_EV1;       
  Dpwm1Regs.DPWMEV2.all  = PWM1_EV2;       
  Dpwm1Regs.DPWMEV3.all  = PWM1_EV3;       
  Dpwm1Regs.DPWMEV4.all  = PWM1_EV4; 
  Dpwm1Regs.DPWMPRD.all  = PWM_PERIOD;       


  Dpwm1Regs.DPWMSAMPTRIG1.all  = 0x0200;       

  // Setup waveform for PWM-C (re-using blanking B regs)
 

  Dpwm1Regs.DPWMBLKBBEG.all =  PWM1_EV5 + DEADTIME_ADJ_LAG;
  Dpwm1Regs.DPWMBLKBEND.all =  PWM1_EV6;


  // ----------------------------------------------------------------------
  // Use blanking on PWM-1 adn PWM2 Identical to ensure current limits align 
  // In this config, we need to wait for EV4 of PWM-1 to pass
  Dpwm1Regs.DPWMBLKABEG.all = 0; 
  Dpwm1Regs.DPWMBLKAEND.all = (BRIDGE_DELAY + PCM_BLANK) *4; //Dpwm1Regs.DPWMEV4.all; 
  // ----------------------------------------------------------------------

  Dpwm1Regs.DPWMPHASETRIG.all =  PWM_SLAVESYNC;   //trigger DPWM2




  // -----------------
  // Configure DPWM-2 
  // -----------------

  // Control-0
  Dpwm2Regs.DPWMCTRL0.bit.PWM_EN     = 1;         // Enable, wait for Global En
  Dpwm2Regs.DPWMCTRL0.bit.CLA_EN     = 0;         // CLA Disabled, using curr limit to chop  
  Dpwm2Regs.DPWMCTRL0.bit.PWM_MODE   = 0;         // SEt mode: 0 - Normal 
//  Dpwm2Regs.DPWMCTRL0.bit.MSYNC_SLAVE_EN   = 0;   // master 
  Dpwm2Regs.DPWMCTRL0.bit.MSYNC_SLAVE_EN   = 1;  // DPWM-1 is master  

  Dpwm2Regs.DPWMCTRL0.bit.CBC_ADV_CNT_EN   = 1;   // Adv cnt limit enabled 
  Dpwm2Regs.DPWMCTRL0.bit.CBC_PWM_AB_EN    = 1;   // Current limit enabled for AB outputs 
  Dpwm2Regs.DPWMCTRL0.bit.PWM_A_INTRA_MUX  = 1;   // EDGEGEN-A out the A output 
  Dpwm2Regs.DPWMCTRL0.bit.PWM_B_INTRA_MUX  = 1;   // EDGEGEN-B out the B output 
  Dpwm2Regs.DPWMCTRL0.bit.BLANK_A_EN       = 1;    



  // Control-1 
  Dpwm2Regs.DPWMCTRL1.bit.HIRES_DIS         = 1;      
  Dpwm2Regs.DPWMCTRL1.bit.ALL_PHASE_CLK_ENA = 1;      
  Dpwm2Regs.DPWMCTRL1.bit.CHECK_OVERRIDE    = 1;       
  Dpwm2Regs.DPWMCTRL1.bit.EVENT_UP_SEL      = 1;   // UPdate end of period      
 
  Dpwm2Regs.DPWMPHASETRIG.all =  PWM_SLAVESYNC;
 

  Dpwm2Regs.DPWMEV1.all  = PWM2_EV1;       
  Dpwm2Regs.DPWMEV2.all  = PWM2_EV2;       
  Dpwm2Regs.DPWMEV3.all  = PWM2_EV3;       
  Dpwm2Regs.DPWMEV4.all  = PWM2_EV4;       
  Dpwm2Regs.DPWMPRD.all  = PWM_PERIOD;       



  // Setup waveform for PWM-C (re-using blanking B regs)
  Dpwm2Regs.DPWMBLKBBEG.all =  PWM2_EV5 + DEADTIME_ADJ_LAG;
  Dpwm2Regs.DPWMBLKBEND.all =  PWM2_EV6;

  // ----------------------------------------------------------------------
  // Use blanking on PWM-1 adn PWM2 Identical to ensure current limits align 
  // In this config, we need to wait for EV4 of PWM-1 to pass
  Dpwm2Regs.DPWMBLKABEG.all = 0; 
  Dpwm2Regs.DPWMBLKAEND.all = (BRIDGE_DELAY + PCM_BLANK) * 4; //16 * 30; 
  // ----------------------------------------------------------------------


  Dpwm2Regs.DPWMINT.bit.PRD_INT_SCALE =2;  //every 4 cycles



  // Edge-generation setup
  // -------------------------
  // a-on  - posedge 2B (intra)  2'h2 
  // a-off - negedge 3A (below)  2'h5
  // b-on  - risedge 3B (intra)  2'h6
  // b-off - negedge 2A (below)  2'h1
  // -------------------------

  Dpwm2Regs.DPWMEDGEGEN.bit.A_ON_EDGE  =  2;
  Dpwm2Regs.DPWMEDGEGEN.bit.A_OFF_EDGE =  5;
  Dpwm2Regs.DPWMEDGEGEN.bit.B_ON_EDGE  =  6;
  Dpwm2Regs.DPWMEDGEGEN.bit.B_OFF_EDGE =  1;

  // When using edgegen, may need to enable all other DPWMS 
  // to ensure same path delay, default is passthru on others (1234)

  Dpwm0Regs.DPWMEDGEGEN.bit.EDGE_EN    =  1;
  Dpwm1Regs.DPWMEDGEGEN.bit.EDGE_EN    =  1;
  Dpwm2Regs.DPWMEDGEGEN.bit.EDGE_EN    =  1;
  Dpwm3Regs.DPWMEDGEGEN.bit.EDGE_EN    =  1;

  // -----------------
  // Configure DPWM-3 
  // -----------------
  // Control-0
  Dpwm3Regs.DPWMCTRL0.bit.PWM_EN     = 1;         // Enable, wait for Global En
  Dpwm3Regs.DPWMCTRL0.bit.CLA_EN     = 0;         // CLA Disabled, using curr limit to chop  
  Dpwm3Regs.DPWMCTRL0.bit.PWM_MODE   = 0;         // Set mode: 0 - Normal 
  Dpwm3Regs.DPWMCTRL0.bit.MSYNC_SLAVE_EN   = 1;   // Slave to DPWM-2 
  Dpwm3Regs.DPWMCTRL0.bit.CBC_ADV_CNT_EN   = 1;   // Adv cnt limit enabled 
  Dpwm3Regs.DPWMCTRL0.bit.CBC_PWM_AB_EN    = 1;   // Current limit enabled for AB outputs 
  Dpwm3Regs.DPWMCTRL0.bit.PWM_A_INTRA_MUX  = 7;   // Send DPWM1C 
  Dpwm3Regs.DPWMCTRL0.bit.PWM_B_INTRA_MUX  = 8;   // Send DPWM2C 
  Dpwm3Regs.DPWMCTRL0.bit.BLANK_A_EN       = 1;    





  // Control-1 
  Dpwm3Regs.DPWMCTRL1.bit.HIRES_DIS         = 1;      
  Dpwm3Regs.DPWMCTRL1.bit.ALL_PHASE_CLK_ENA = 1;      
  Dpwm3Regs.DPWMCTRL1.bit.CHECK_OVERRIDE    = 1;       
  Dpwm3Regs.DPWMCTRL1.bit.EVENT_UP_SEL      = 1;   // UPdate end of period      



  Dpwm3Regs.DPWMEV1.all  = PWM3_EV1;       
  Dpwm3Regs.DPWMEV2.all  = PWM3_EV2;       
  Dpwm3Regs.DPWMEV3.all  = PWM3_EV3;       
  Dpwm3Regs.DPWMEV4.all  = PWM3_EV4;       
  Dpwm3Regs.DPWMPRD.all  = PWM_PERIOD;       

  

  // ----------------------------------------------------------------------
  // Use blanking on PWM-0 and PWM3 Identical to ensure current limits align 
  // In this config, we need to wait for EV4 of PWM-0 to pass
  Dpwm3Regs.DPWMBLKABEG.all = 0; 	
  Dpwm3Regs.DPWMBLKAEND.all = (BRIDGE_DELAY + PCM_BLANK) * 4; //
  // ----------------------------------------------------------------------

    // Make connections to DPWM
    // ---------------------------

    // Connect master sync from dpwm-0 to dpwm-1 and from DPWM2 to DPWM3
    LoopMuxRegs.DPWMMUX.bit.DPWM1_SYNC_SEL = 0;     // Connect to dpwm-0
	LoopMuxRegs.DPWMMUX.bit.DPWM2_SYNC_SEL = 1;     // Connect to dpwm-0
    LoopMuxRegs.DPWMMUX.bit.DPWM3_SYNC_SEL = 2;     // Connect to dpwm-2 





    // Setup currlimit input to DPWM on Fault-AB
    FaultMuxRegs.DPWM0CLIM.bit.ANALOG_PCM_EN   = 1; 
    FaultMuxRegs.DPWM1CLIM.bit.ANALOG_PCM_EN   = 1; 
    FaultMuxRegs.DPWM2CLIM.bit.ANALOG_PCM_EN   = 1; 
    FaultMuxRegs.DPWM3CLIM.bit.ANALOG_PCM_EN   = 1; 


//**********************


//with ramp enabled
  FeCtrl2Regs.RAMPCYCLE.bit.SWITCH_CYC_PER_STEP = 0;   //32ns/cycle
  FeCtrl2Regs.DACSTEP.bit.DAC_STEP              = 52100; //58000; // 500mV/half switching period //39321; //120000; //0x8000; //0x10000; //maximum step - should go all the way to zero in a half period.
  FeCtrl2Regs.RAMPCTRL.bit.PCM_START_SEL        = 1;    // 1 - Use DAC value from filter
  FeCtrl2Regs.RAMPDACEND.bit.RAMP_DAC_VALUE = 500; //may not be perfect, keep above 0 to avoid potential problems
  LoopMuxRegs.PCMCTRL.bit.PCM_FILTER_SEL =0; //select filter0


  // Set AFE Gain
  FeCtrl2Regs.EADCDAC.bit.DAC_VALUE  = 11000; //0x1fff; //max DAC value

  FeCtrl2Regs.EADCCTRL.bit.AFE_GAIN  = 3;
  FeCtrl2Regs.EADCCTRL.bit.EADC_MODE = 5;       // Peak current mode
  FeCtrl2Regs.RAMPCTRL.bit.RAMP_EN   = 1;       //use internal slope--1182012

  FeCtrl2Regs.EADCCTRL.bit.D2S_COMP_EN = 1; //vital to enable comparator - this enables APCM comparator.



  // Configure Loop Mux Module for Analog PCM
  LoopMuxRegs.FECTRL2MUX.bit.DPWM2_A_TRIG_EN = 1;   // Set the trigger for the Analog PCM  
  LoopMuxRegs.FECTRL2MUX.bit.DPWM3_A_TRIG_EN = 1;   // Set the trigger for the Analog PCM  

  LoopMuxRegs.FECTRL2MUX.bit.DPWM2_FRAME_SYNC_EN = 1; //also need a second trigger to make it work better.
  LoopMuxRegs.FECTRL2MUX.bit.DPWM3_FRAME_SYNC_EN = 1; //also need a second trigger to make it work better.
  LoopMuxRegs.FECTRL0MUX.bit.DPWM0_FRAME_SYNC_EN = 1;
  LoopMuxRegs.FECTRL1MUX.bit.DPWM1_FRAME_SYNC_EN = 1;


  LoopMuxRegs.APCMCTRL.bit.PCM_FE_SEL        = 2;   // use FE2 for PCM */
 
  LoopMuxRegs.APCMCTRL.bit.PCM_EN            = 1;   // Enable PCM


//**************************
//set up DPWM3A and 1A to generate signal blocking - move fixed signal to 3B
///**************************************************************


  // ---------------------------------- 
  // Assert Global DPWM Enables 
  // ---------------------------------- 

	Dpwm0Regs.DPWMSAMPTRIG1.all = PWM_PERIOD >> 2;
	Dpwm0Regs.DPWMCTRL2.bit.SAMPLE_TRIG_1_EN = 1; //enable 1 sample trigger
	Dpwm0Regs.DPWMCTRL2.bit.SAMPLE_TRIG1_OVERSAMPLE = filter0_pmbus_regs.FILTER_MISC.bit.SAMPLE_TRIG1_OVERSAMPLE;

	Dpwm1Regs.DPWMSAMPTRIG1.all = PWM_PERIOD >> 2;
	Dpwm1Regs.DPWMCTRL2.bit.SAMPLE_TRIG_1_EN = 1; //enable 1 sample trigger
	Dpwm1Regs.DPWMCTRL2.bit.SAMPLE_TRIG1_OVERSAMPLE = filter1_pmbus_regs.FILTER_MISC.bit.SAMPLE_TRIG1_OVERSAMPLE;



//	Dpwm1Regs.DPWMCTRL1.bit.GPIO_A_EN =1;
//	Dpwm0Regs.DPWMCTRL1.bit.GPIO_A_EN =1;  //the Jumper for DPWM0 are taken out for scope
//	Dpwm1Regs.DPWMCTRL1.bit.GPIO_A_VAL =1;
//	Dpwm0Regs.DPWMCTRL1.bit.GPIO_A_VAL =1;



} 




