
#include "include.h"

extern Uint32 PWM_PERIOD; 

void init_filter_0_cpu_sample(void)//for testing
{
//special set up for Open Loop - all coefficients are zeroed.

//output is set by using CPU_SAMPLE mode

	Filter0Regs.FILTERCTRL.bit.USE_CPU_SAMPLE = 1; //enable CPU Sample

	Filter0Regs.CPUXN.bit.CPU_SAMPLE = 0x80; //halfway up.

	Filter0Regs.FILTERKPCOEF0.bit.KP_COEF_0 = 0x7fff; //full pass through of XN value.

	Filter0Regs.FILTERKICOEF0.bit.KI_COEF_0 = 0;

	Filter0Regs.FILTERKDCOEF0.bit.KD_COEF_0 = 0;

	Filter0Regs.FILTERKDALPHA.bit.KD_ALPHA_0 = 0;

	Filter0Regs.FILTERKICLPHI.bit.KI_CLAMP_HIGH = 0x7FFFFF;
    Filter0Regs.FILTERKICLPLO.bit.KI_CLAMP_LOW = 0;

	Filter0Regs.FILTERYNCLPHI.bit.YN_CLAMP_HIGH = 0x0FFFFF; //0x7FFFFF;
	Filter0Regs.FILTERYNCLPLO.bit.YN_CLAMP_LOW = 0;

    Filter0Regs.FILTERCTRL.bit.FILTER_EN = 1;
     //enable OK here, because nothing will happen until DPWM and front end are globally enabled

	Filter0Regs.FILTERCTRL.bit.OUTPUT_MULT_SEL = 0; //use KCOMP for scaling.
}

void connect_filter_0_to_front_end2_DAC(void)
{
	LoopMuxRegs.SAMPTRIGCTRL.bit.FE0_TRIG_DPWM0_EN = 1; //use DPWM0 for filter0 sample trigger	
	LoopMuxRegs.FILTERKCOMPA.bit.KCOMP0 = 0x3fff; //0x3FFF is full scale

//	LoopMuxRegs.EXTDACCTRL.bit.DAC2_SEL = 4; // 3 for CPCC. 4 for filter 0; 
	LoopMuxRegs.EXTDACCTRL.bit.EXT_DAC2_EN = 0; //enable DAC 2 to take input from selected spot.1 is driven by filter
}


//if use configuration in data flash
void init_filter0(void)
{
	copy_coefficients_to_filter(&Filter0Regs, &filter0_pmbus_regs);

	Filter0Regs.FILTERCTRL.bit.OUTPUT_MULT_SEL = 0; //use KCOMP for scaling.

    Filter0Regs.FILTERCTRL.bit.FILTER_EN = 1;
     //enable OK here, because nothing will happen until DPWM and front end are globally enabled
	Filter0Regs.FILTERCTRL.bit.OUTPUT_SCALE =6;
}

void init_front_end0(void)
{
	FeCtrl0Regs.EADCCTRL.bit.AFE_GAIN = filter0_pmbus_regs.FILTER_MISC.bit.AFE_GAIN;
}

void init_voltage_loop(void)
{
	init_front_end0();
	init_filter0();
	connect_filter_0_to_front_end2_DAC();
}


