#define MAIN 1

#include "include.h"

void main()
{
	MiscAnalogRegs.GLBIOEN.bit.TDI_IO_EN=1;
                
	if(MiscAnalogRegs.GLBIOREAD.bit.TDI_IO_READ == 0)
    {
       clear_integrity_word(); // rom backdoor, pull down TDI on pwr030 if need backdoor 
    }
 	MiscAnalogRegs.GLBIOEN.bit.TDI_IO_EN=0;
	
	MiscAnalogRegs.IOMUX.all = 0; //enable JTAG
	start_state =5;
	//Check to see if the last DFLASH erase was interrupted
	look_for_interrupted_dflash_erase();

	restore_default_all();



	period = (SWITCH_FREQ_NUMERATOR / pmbus_dcdc_config[0].switching_frequency); // in 4 ns


	configure_cpcc();

//	init_uart0();
	init_uart1();

	init_gpio();

	init_pmbus();

	init_dpwm();

	init_adc12();
	
	init_protection();

	init_voltage_loop();

	init_current_loop();

	init_light_load_configuration();

	init_miscellaneous();

	init_timer_interrupt();

	for(;;)
	{
//		pmbus_handler();

//		uart_transmit_data();

//		pmbus_handler();

//		uart_process_rx_data();

//		pmbus_handler();

		if (erase_segment_counter > 0)
		{
			erase_task();	//  Handle the DFlash segment erases
        }
		
		decimal_out_5_digits(supply_state);
		char_out('\r');
		char_out('\n');
	}
}

#pragma INTERRUPT(c_int00,RESET)
void c_int00(void)
{
	main();
}
