//standard_interrupt.c
#include "include.h"

int is_it_there = 51;
//unsigned int pout;
unsigned int vout;
unsigned int iout;
unsigned int vref;
unsigned int vdac;
unsigned int vin;
unsigned int vdac_prebias;
unsigned int duty_prebias;
int timer_interrupt_temporary_1;
int timer_interrupt_temporary_2;
int timer_interrupt_temporary_3;
int current_share_control;
int local_temp;
int current_share_temp;
int current_share_control_1;
int io_sense;
int ishare;
int cc_counter;
int cc_shutdown;
int sr_counter;
int sr_on;

void preset_filter0(signed int preset_value)
{
     LoopMuxRegs.SAMPTRIGCTRL.bit.FE0_TRIG_DPWM0_EN = 0; // Stop triggering EADC2/Filter2
	 Filter0Regs.FILTERPRESET.all = (1 << 27) + (1 << 24) + preset_value;
	 LoopMuxRegs.SAMPTRIGCTRL.bit.FE0_TRIG_DPWM0_EN = 1; // Resume triggering EADC2/Filter2
} 

void preset_filter1(signed int preset_value)
{
     LoopMuxRegs.SAMPTRIGCTRL.bit.FE1_TRIG_DPWM1_EN = 0; // Stop triggering EADC2/Filter2
	 Filter1Regs.FILTERPRESET.all = (1 << 27) + (1 << 24) + preset_value;
	 LoopMuxRegs.SAMPTRIGCTRL.bit.FE1_TRIG_DPWM1_EN = 1; // Resume triggering EADC2/Filter2
} 


inline void poll_adc(void)
{
	if(AdcRegs.ADCSTAT.bit.ADC_INT == 1)//If the conversion is complete
	{
		adc_values.vo_sense 	= AdcRegs.ADCAVGRESULT[3].bit.RESULT;   //965 at 5.84V
		adc_values.io_sense 	= AdcRegs.ADCAVGRESULT[1].bit.RESULT;   //352 if offset by R104, 95.6/A
		adc_values.ishare 		= AdcRegs.ADCAVGRESULT[0].bit.RESULT;
		adc_values.vin_mon 		= AdcRegs.ADCAVGRESULT[4].bit.RESULT;
		adc_values.temp 		= AdcRegs.ADCAVGRESULT[5].bit.RESULT;    //1016 at 32C and 10mV/C, 0.5V at 20C
		adc_values.vo_ovp 		= AdcRegs.ADCAVGRESULT[6].bit.RESULT; //same as AD00
		adc_values.ips 			= AdcRegs.ADCRESULT[7].bit.RESULT;
		adc_values.device_temp 	= AdcRegs.ADCRESULT[8].bit.RESULT;

		io_sense 	= AdcRegs.ADCRESULT[1].bit.RESULT;   //352 if offset by R104, 95.6/A
		ishare 		= AdcRegs.ADCRESULT[0].bit.RESULT;


	}
	AdcRegs.ADCCTRL.bit.SW_START = 1;  //start a conversion
	AdcRegs.ADCCTRL.bit.SW_START = 0;  //clear trigger, so we don't restart
}

inline	void uart_receive_data(void)//for frimary and secdonary communication
{
	//count for how much time has passed since the last packet been sent out
	if(uart_tx_timeout <= UART_TX_TIME) //1000ms 
	{
		uart_tx_timeout++;
	}

	//receive data, one byte a time
	if(uart_rx_data_rdy == 0) 
	{
		if(Uart0Regs.UARTRXST.bit.RX_RDY == 1)
		{
			uart_text_rx_buf[uart_rx_buf_ptr] =  Uart0Regs.UARTRXBUF.bit.RXDAT; //read a byte and clear RX_RDY flag
			uart_rx_buf_ptr ++; //point to next byte
			uart_rx_timeout = 0; 
			if(uart_rx_buf_ptr == ((UART_RX_SIZE * 2) + 2)) //received all bytes
			{
				uart_rx_buf_ptr = 0; //reset the pointer
				uart_rx_data_rdy = 1; //set flag to let background process received data
			}
		}
		else
		{
			uart_rx_timeout ++;
			if(uart_rx_timeout > (UART_TX_TIME - 2000))//if we didn't receive data for more than 800ms, the data packet is invalid, start over
			{
				uart_rx_buf_ptr = 0;
			}
		}

	}
}

#ifdef CURRENT_SHARING_ENABLE
inline void enable_current_sharing(void)
{
    FeCtrl0Regs.EADCDAC.bit.DAC_DITHER_EN = 1;
	//3 for pass through
	//1 for DPWM current source control 2.5 uA into 100 kOhm at 100% duty cycle.
	MiscAnalogRegs.CSCTRL.bit.TEST_MODE = 3;  //active current with analog sign 
	//300 kHz
//	MiscAnalogRegs.CSCTRL.bit.DPWM_PERIOD = 108;
}

void disable_current_sharing(void)
{
    FeCtrl0Regs.EADCDAC.bit.DAC_DITHER_EN = 0;
	//3 for pass through, 1 for DPWM current source control 2.5 uA into 100 kOhm at 100% duty cycle.
	MiscAnalogRegs.CSCTRL.bit.TEST_MODE = 0;
}


inline void handle_current_sharing_average(void)
{


	eadc_dac_target = (timer_interrupt_temporary_2 <<3); //pmbus_dcdc_config_translated[0].vout_cmd;
	eadc_dac_min =  (eadc_dac_target * 7) >>3;
	eadc_dac_max =  (eadc_dac_target * 9) >> 3;
	local_error = ishare - io_sense; //raw data
	if(abs((int)local_error) > CURRENT_SHARING_THRESHOLD)//if current difference is bigger than threshold

	{
		is_it_there ++;
		current_share_temp = current_share_temp + current_share_ki * local_error;
		current_share_control = current_share_temp + current_share_kp * local_error;
		
		if (current_share_temp < - 226777200)
		{
			current_share_temp = -226777200 ;

		}

		else if (current_share_temp >  386777200)
		{
			current_share_temp =  386777200;

		}

		current_share_control_1= (int) (current_share_control >> 14); 


		local_temp = (timer_interrupt_temporary_2 << 3) + current_share_control_1;
		
		if( local_temp >  eadc_dac_max) //if result is over permissible maximum voltage
		{
			timer_interrupt_temporary_3 = eadc_dac_max; //pull it down to maximum
		}
		else if(local_temp < eadc_dac_min) //if result is under permissible minimim voltage
		{
			timer_interrupt_temporary_3 = eadc_dac_min; //pull it up to minimum
		}
		else
		{
			timer_interrupt_temporary_3 = local_temp; //otherwise go ahead and store new target voltage
		}
	}


	else //if within threshold area, edge it gently back toward center of voltage range
	{
		if((timer_interrupt_temporary_3 - eadc_dac_target) > 32) //if well above target 20 * 0.0975*10 = 20mV
		{
			timer_interrupt_temporary_3 = timer_interrupt_temporary_3 - 1; //pull it down
		}
		else if((timer_interrupt_temporary_3 - eadc_dac_target) < -32) //-20mv if well below target
		{
			timer_interrupt_temporary_3 = timer_interrupt_temporary_3 + 1; //pull it up
		}
		else
		{
			current_share_temp = current_share_temp -1;
			if(current_share_temp < 1)
			{
				current_share_temp =2;
			}

			is_it_there =10;
		}

		
		is_it_there =0;
	}
	FeCtrl0Regs.EADCDAC.bit.DAC_VALUE = (timer_interrupt_temporary_3 >>3);
 
} 

#endif
inline void deadtime_autotune(void)
{
	 		deadtime_bridge_adj = (BRIDGE_DELAY + (5 * (4096 - adc_values.io_sense) * BRIDGE_DELAY) >> 14);
			deadtime_srrise_adj = (SR_RISING_BRIDGE_DELAY + (20 * (4096 - (int)(1.2 * adc_values.io_sense)) * SR_RISING_BRIDGE_DELAY) >> 14);
			deadtime_srfall_adj = ((40 * (adc_values.io_sense) * SR_FALLING_BRIDGE_DELAY) >> 14);
	 		
	 		if(deadtime_bridge_adj < BRIDGE_DELAY)
			{
				deadtime_bridge_adj = BRIDGE_DELAY;
			}
	 		else if(deadtime_bridge_adj > 2 * BRIDGE_DELAY)
			{
				deadtime_bridge_adj = 2 * BRIDGE_DELAY;
			}		
			
			if(deadtime_srrise_adj < -20)
			{
				deadtime_srrise_adj = -20;
			}
	 		else if(deadtime_srrise_adj > 3 * SR_RISING_BRIDGE_DELAY)
			{
				deadtime_srrise_adj = 3 * SR_RISING_BRIDGE_DELAY;
			}		

			if(deadtime_srfall_adj < 1)
			{
				deadtime_srfall_adj = 0;
			}
	 		else if(deadtime_srfall_adj > 70)
			{
				deadtime_srfall_adj = 70;
			}		


			deadtime_adjust();


}


void go_to_idle_state(void)
{
	Dpwm2Regs.DPWMINT.bit.PRD_INT_EN =0;
	LoopMuxRegs.GLBEN.all = 0;					//gloable disable all PE and DPWM
	Dpwm2Regs.DPWMEDGEGEN.bit.EDGE_EN = 0; 		//edge enable necessary to guarantee turn off of edge enabled DPWM pins
	LoopMuxRegs.EXTDACCTRL.bit.EXT_DAC0_EN = 0; //disable CPCC
	LoopMuxRegs.LLCTRL.bit.LL_EN = 0;			//disable burst mode
	interrupt_counter1 = 0;
	hiccup_counter =0;


#ifdef CURRENT_SHARING_ENABLE
	disable_current_sharing();					//disable current sharing
#endif

	MiscAnalogRegs.GLBIOVAL.all &= ~MASK_PGOOD;	 //turn off PGOOD LED
	MiscAnalogRegs.GLBIOVAL.all &= ~MASK_FAILURE;//turn off fault LED

	supply_state = STATE_IDLE;
}

inline void constant_power(void)
{
					
				
					vout = adc_values.vo_sense;
					iout = adc_values.io_sense;

					if (iout < 20)
					{
						iout = 20;	
					}


					timer_interrupt_temporary_2 =  pmbus_dcdc_config_translated[0].vout_cmd;
					vref = (unsigned int) (pout/iout);
					vdac = vref * 6.26;    //vref *2.5 *1000/256/1.56 scaler fron adc to dac

					if(vdac > timer_interrupt_temporary_2)
					{
						vdac = timer_interrupt_temporary_2;
					}


							FeCtrl0Regs.EADCDAC.bit.DAC_VALUE = vdac; 
//							timer_interrupt_temporary_2 = vdac;
					
				
}

inline void idle_state_handler(void)
{
	volatile int32 temp;

	if(PSON)//if ON/OFF switch is on
	{
		if(interrupt_counter1 < 100)//wait for 10ms (deal with switch bouncing)
		{
			interrupt_counter1 ++;

			Filter0Regs.FILTERCTRL.bit.FORCE_START =0;
			Filter0Regs.FILTERCTRL.bit.FILTER_EN = 0;
            Filter0Regs.FILTERPRESET.bit.PRESET_REG_SEL = 1;    
			Filter0Regs.FILTERPRESET.bit.PRESET_VALUE = 0;
			Filter0Regs.FILTERPRESET.bit.PRESET_EN = 1;
			Filter0Regs.CPUXN.bit.CPU_SAMPLE = 0;
			Filter0Regs.FILTERCTRL.bit.USE_CPU_SAMPLE = 1;

			Filter0Regs.FILTERCTRL.bit.FILTER_EN = 1;
			Filter0Regs.FILTERCTRL.bit.FORCE_START = 1;
			Dpwm2Regs.DPWMINT.bit.PRD_INT_EN =0;
			LoopMuxRegs.GLBEN.all = 0;//gloable disable all PE and DPWM
		}
		else if (IOUT_NO_FAULT && VOUT_NO_FAULT && UVIN_NO_FAULT)//if Vin good

		{
			//set up for hardware ramp up
		

			adc_values.io_sense =0;
			Dpwm0Regs.DPWMCTRL1.bit.GPIO_B_EN =1;
			Dpwm1Regs.DPWMCTRL1.bit.GPIO_B_EN =1;
			FeCtrl0Regs.RAMPCYCLE.bit.SWITCH_CYC_PER_STEP = 1;// Number of switching cycles pre DAC step
			FeCtrl0Regs.RAMPCTRL.bit.RAMP_EN = 1; // Ramp by Hardware
			FeCtrl0Regs.EADCDAC.bit.DAC_VALUE = 0;//starting point
			FeCtrl0Regs.RAMPDACEND.bit.RAMP_DAC_VALUE = pmbus_dcdc_config_translated[0].vout_cmd;
			FeCtrl1Regs.EADCDAC.bit.DAC_VALUE  		= (pmbus_dcdc_config_translated[0].cpcc_imax + 350);

			FeCtrl0Regs.DACSTEP.bit.DAC_STEP = 8000;//  80ms ramp up time
			Filter0Regs.FILTERCTRL.bit.USE_CPU_SAMPLE = 0;
		
			Dpwm2Regs.DPWMEDGEGEN.bit.EDGE_EN = 1;

			LoopMuxRegs.GLBEN.all = 0x70F;//global enable all Front_ends and DPWMs

			LoopMuxRegs.EXTDACCTRL.bit.DAC2_SEL = 4;   //voltage loop
		   	LoopMuxRegs.PCMCTRL.bit.PCM_FILTER_SEL =0; //select filter0 for voltage loop slope source
 			Filter0Regs.FILTERCTRL.bit.KI_STALL =0;

		

			MiscAnalogRegs.GLBIOVAL.all |= MASK_OR_CTRL;//turn off the oring FET

			supply_state = STATE_RAMP_UP;
			preset_filter0(0x0); 
			preset_filter1(0x7FFFFF); 
			FeCtrl0Regs.RAMPCTRL.bit.FIRMWARE_START = 1; //Initiate soft start ramp 
			FeCtrl1Regs.RAMPCTRL.bit.FIRMWARE_START = 1; //Initiate soft start ramp 

			LoopMuxRegs.GLBEN.all = 0x70F;//global enable all Front_ends and DPWMs


			disable_fast_interrupt();
			temp = FaultMuxRegs.FAULTMUXINTSTAT.all; 		//read to clear the interrupt flag
			FaultMuxRegs.ACOMPCTRL0.bit.ACOMP_B_INT_EN = 1; //enable ACOMP-B interrupt
			FaultMuxRegs.ACOMPCTRL2.bit.ACOMP_E_INT_EN = 1;	//enable ACOMP-E interrupt
			Dpwm2Regs.DPWMINT.bit.PRD_INT_EN =1;
			temp = FaultMuxRegs.FAULTMUXINTSTAT.all; 
 			enable_fast_interrupt(); //make sure fast interrupt is enabled for shutdown

			fault_type = 0;
			fault_flag =0;
			cp_flag =1;
			cc_flag =0;	
			vv_flag =0;
			cv_trans_flag =0;
			timer_interrupt_temporary_1 =0;
			timer_interrupt_temporary_2 = 0;
			cc_counter =0;
			cc_shutdown =0;
			current_share_temp =100;
			sr_counter =0;
			sr_on =0;
		
		
		}
	}
	else
	{
		interrupt_counter1 = 0;
	}
}

inline void ramp_up_state_handler(void)
{
	if(PSON && IOUT_NO_FAULT && VOUT_NO_FAULT && UVIN_NO_FAULT)
	{
		
		
		if (adc_values.vo_sense > 1360)   //Vout is 10.5V
		{
			Dpwm0Regs.DPWMCTRL1.bit.GPIO_B_EN =0;
			Dpwm1Regs.DPWMCTRL1.bit.GPIO_B_EN =0;
//			MiscAnalogRegs.GLBIOVAL.all &= ~MASK_OR_CTRL;//turn on the oring FET

		}


		if(FeCtrl0Regs.RAMPSTAT.bit.RAMP_COMP_INT_STATUS == 1)//if ramp up complete
		{
			
			FeCtrl0Regs.EADCDAC.bit.DAC_VALUE = pmbus_dcdc_config_translated[0].vout_cmd;
			LoopMuxRegs.EXTDACCTRL.bit.EXT_DAC0_EN = 0; 
			LoopMuxRegs.LLCTRL.bit.LL_EN = pmbus_dcdc_config[0].ll_en;//enable burst mode
			timer_interrupt_temporary_1  = FeCtrl0Regs.EADCDAC.bit.DAC_VALUE;
			timer_interrupt_temporary_3 = FeCtrl0Regs.EADCDAC.bit.DAC_VALUE;

			#ifdef CURRENT_SHARING_ENABLE
				enable_current_sharing();//enable current sharing
			#endif

				supply_state = STATE_REGULATED;
			
		}
		if(fault_flag ==1)
		{
			supply_state = STATE_FAULT;
		}
	}
	else
	{
		go_to_idle_state();
	}
}


inline void regulate_state_handler(void)
{
	if(PSON)
	{
		if(adc_values.temp > pmbus_dcdc_config_translated[0].temp_ot_fault_limit)//if over temperature
		{
			Dpwm2Regs.DPWMINT.bit.PRD_INT_EN =0;
			LoopMuxRegs.GLBEN.all = 0;//gloable disable all PE and DPWM
			Dpwm2Regs.DPWMEDGEGEN.bit.EDGE_EN = 0; 		//edge enable necessary to guarantee turn off of edge enabled DPWM pins
			pmbus_status_word |= PMBUS_STATUS_WORD_TEMPERATURE;
			fault_type = OVER_TEMPERATURE;
			MiscAnalogRegs.GLBIOVAL.all &= ~MASK_PGOOD;//turn off PGOOD LED
			MiscAnalogRegs.GLBIOVAL.all |= MASK_FAILURE;//turn on fault LED
			fault_flag =1;
			supply_state = STATE_FAULT;
		}
		else if(UVIN_FAULT) //if under voltage
		{
			pmbus_status_word |= PMBUS_STATUS_WORD_INPUT;
			supply_state = STATE_FAULT;
			fault_type = UNDER_VOLTAGE;
			Dpwm2Regs.DPWMINT.bit.PRD_INT_EN =0;
			LoopMuxRegs.GLBEN.all = 0;//gloable disable all PE and DPWM
			Dpwm2Regs.DPWMEDGEGEN.bit.EDGE_EN = 0; 		//edge enable necessary to guarantee turn off of edge enabled DPWM pins
			MiscAnalogRegs.GLBIOVAL.all &= ~MASK_PGOOD;//turn off PGOOD LED
			MiscAnalogRegs.GLBIOVAL.all |= MASK_FAILURE;//turn on fault LED
			fault_flag =1;

		}

		else if(IOUT_FAULT || cc_shutdown)//if over current
		{
			pmbus_status_word |= PMBUS_STATUS_WORD_IOUT_OC | PMBUS_STATUS_WORD_OFF | 
								 PMBUS_STATUS_WORD_IOUT    | PMBUS_STATUS_WORD_HIGH_BYTE;
			
			fault_type = OVER_CURRENT;
			supply_state = STATE_FAULT;
			Dpwm2Regs.DPWMINT.bit.PRD_INT_EN =0;
			LoopMuxRegs.GLBEN.all = 0;//gloable disable all PE and DPWM
			Dpwm2Regs.DPWMEDGEGEN.bit.EDGE_EN = 0; 		//edge enable necessary to guarantee turn off of edge enabled DPWM pins
			MiscAnalogRegs.GLBIOVAL.all &= ~MASK_PGOOD;//turn off PGOOD LED
			MiscAnalogRegs.GLBIOVAL.all |= MASK_FAILURE;//turn on fault LED
			fault_flag =1;

		}
		else if(VOUT_FAULT)//if over voltage
		{
			pmbus_status_word |= PMBUS_STATUS_WORD_VOUT_OV | PMBUS_STATUS_WORD_OFF | 
								 PMBUS_STATUS_WORD_VOUT    | PMBUS_STATUS_WORD_HIGH_BYTE;
			fault_type = OVER_VOLTAGE;
			supply_state = STATE_FAULT;
			Dpwm2Regs.DPWMINT.bit.PRD_INT_EN =0;
			LoopMuxRegs.GLBEN.all = 0;//gloable disable all PE and DPWM
			Dpwm2Regs.DPWMEDGEGEN.bit.EDGE_EN = 0; 		//edge enable necessary to guarantee turn off of edge enabled DPWM pins
			MiscAnalogRegs.GLBIOVAL.all &= ~MASK_PGOOD;//turn off PGOOD LED
			MiscAnalogRegs.GLBIOVAL.all |= MASK_FAILURE;//turn on fault LED
			fault_flag =1;

		}
		else
		{


			if ((adc_values.io_sense > 360)&& (!sr_on))   //Iout >3A
			{
				Dpwm0Regs.DPWMCTRL1.bit.GPIO_B_EN =0;
				Dpwm1Regs.DPWMCTRL1.bit.GPIO_B_EN =0;
				sr_on = 1;
			}

			sr_counter ++;
			if((sr_counter >100) && (!sr_on))
			{
				Dpwm0Regs.DPWMCTRL1.bit.GPIO_B_EN =0;
				Dpwm1Regs.DPWMCTRL1.bit.GPIO_B_EN =0;
				sr_on = 1;
			}


			constant_power();


		
            #ifdef CURRENT_SHARING_ENABLE

			handle_current_sharing_average();
			#endif 

			deadtime_autotune();

			if(adc_values.vo_sense > VOUT_POWER_GOOD_ON)
			{
				MiscAnalogRegs.GLBIOVAL.all |= MASK_PGOOD;//turn on PGOOD LED
			}
			else if(adc_values.vo_sense < VOUT_POWER_GOOD_OFF)
			{
				MiscAnalogRegs.GLBIOVAL.all &= ~MASK_PGOOD;//turn off PGOOD LED
			
			}

//oring FETS enabled
			if (adc_values.io_sense > 360)   //Iout >2A
			{
				MiscAnalogRegs.GLBIOVAL.all &= ~MASK_OR_CTRL;
			}
			else if (adc_values.io_sense < 5)
			{

//				MiscAnalogRegs.GLBIOVAL.all |= MASK_OR_CTRL;
			}

			if((adc_values.vo_sense <200) && (!cc_flag))

			{
				fault_flag =1;				// comment the two lines if need pulses stay with low voltage
				fault_type = UNDER_VOLTAGE;	//
			}

			if (cc_flag ==1)
			{
				cc_counter ++;
				if (cc_counter > 50000)
				{
					cc_shutdown =1;
					cc_counter =50000;
					fault_type = OVER_CURRENT;
				}
			}
			else
			{
			cc_counter =0;
			}


			if(fault_flag ==1)
			{
				supply_state = STATE_FAULT;
			}


		}
	}
	else
	{
		go_to_idle_state();
	}
}

inline void fault_state_handler(void)
{
	if(PSON)
	{
		
		MiscAnalogRegs.GLBIOVAL.all &= ~MASK_PGOOD;//turn off PGOOD LED
		
		switch(fault_type)
		{
			case OVER_VOLTAGE:
			
				if(hiccup_counter_ov > 3)
				{
				//wait here until ON/OFF switch is toggled, then go to idle
					hiccup_counter_ov =0;
				
				}
				else
				{
					go_to_idle_state();
					hiccup_counter_ov ++;
					
				}
				break;

			case OVER_CURRENT:
				hiccup_counter ++;
				if(hiccup_counter > 10000)//wait for 1s, then turn on again
				{
					go_to_idle_state();
					hiccup_counter =0;
				}			
				break;

			case OVER_TEMPERATURE:
				if(adc_values.temp < (pmbus_dcdc_config_translated[0].temp_ot_fault_limit - 100))//if temperature drops, turn on again
				{
					go_to_idle_state();
				}
				break;
			case UNDER_VOLTAGE:
				
				hiccup_counter ++;
				if(hiccup_counter > 20000)//wait for 2s, then turn on again
				{
					go_to_idle_state();
					hiccup_counter =0;
				}			
			
				break;				 
		}
	}
	else
	{
		go_to_idle_state();
	}
}

#pragma INTERRUPT(standard_interrupt,IRQ)
void standard_interrupt(void)
{
	poll_adc();

	uart_receive_data();

	if(UVIN_NO_FAULT)
	{
		MiscAnalogRegs.GLBIOVAL.all |= MASK_AC_FAIL_OUT;//turn on AC_GOOD LED
	}
	else if (UVIN_FAULT)
	{
		MiscAnalogRegs.GLBIOVAL.all  &= ~ MASK_AC_FAIL_OUT;//turn off AC_GOOD LED
	}
	switch(supply_state) 
	{
		case STATE_IDLE :
			idle_state_handler();
			break;

		case STATE_RAMP_UP :
			ramp_up_state_handler();
			break;

		case STATE_REGULATED:
			regulate_state_handler();	
			break;

		case STATE_FAULT:
			fault_state_handler();
			break;

		default:
			break;
	}
	TimerRegs.T16PWM0CMPCTRL.all = 3; //clear interrupt bit by a read/write.
}                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           





























































































































































