#include "include.h"

/*
void init_uart0(void)
{
	volatile Uint32 rx_byte0; //volatile to make warning go away about set but not read

	Uart0Regs.UARTCTRL3.bit.SW_RESET = 0; //software reset while initializing UART

	Uart0Regs.UARTCTRL0.bit.DATA_SIZE = 7; //8 bits
	Uart0Regs.UARTCTRL0.bit.STOP = 1; //2 stop bits
	Uart0Regs.UARTCTRL0.bit.SYNC_MODE = 1; //asynchronous mode

	Uart0Regs.UARTHBAUD.all = 0;
	Uart0Regs.UARTMBAUD.all = 0;
	Uart0Regs.UARTLBAUD.all = 47;  //for 38400 //47 for control board, 44 for open loop

	Uart0Regs.UARTRXST.bit.RX_ENA = 1 ;//enable RX

	Uart0Regs.UARTTXST.bit.TX_ENA = 1;//enable TX

	Uart0Regs.UARTINTST.all = 0xff;  //these two statements are supposed to clear the status bits
	Uart0Regs.UARTINTST.all = 0;

	rx_byte0 = Uart0Regs.UARTRXBUF.all; //clear RXRDY flag

	Uart0Regs.UARTIOCTRLTX.bit.IO_FUNC = 1; //enable transmit pin
	Uart0Regs.UARTIOCTRLRX.bit.IO_FUNC = 1; //enable receive pin

	Uart0Regs.UARTCTRL3.bit.CLOCK = 1; //internal clock select;
	Uart0Regs.UARTCTRL3.bit.SW_RESET = 1; //software reset released UART init done?

	Uart0Regs.UARTIOCTRLSCLK.bit.IO_FUNC = 0; //disable external clock for UART.

	Uart0Regs.UARTTXBUF.all = '\n'; //put out a byte to get things started.
}
*/
void init_uart1(void)
{
	volatile Uint32 rx_byte1; //volatile to make warning go away about set but not read

	Uart1Regs.UARTCTRL3.bit.SW_RESET = 0; //software reset while initializing UART

	Uart1Regs.UARTCTRL0.bit.DATA_SIZE = 7; //8 bits
	Uart1Regs.UARTCTRL0.bit.STOP = 1; //2 stop bits
	Uart1Regs.UARTCTRL0.bit.SYNC_MODE = 1; //asynchronous mode

	Uart1Regs.UARTHBAUD.all = 0;
	Uart1Regs.UARTMBAUD.all = 0;
	Uart1Regs.UARTLBAUD.all = 48;  //for 38400 //47 for control board, 44 for open loop

	Uart1Regs.UARTRXST.bit.RX_ENA = 1 ;//enable RX

	Uart1Regs.UARTTXST.bit.TX_ENA = 1;//enable TX

	Uart1Regs.UARTINTST.all = 0xff;  //these two statements are supposed to clear the status bits
	Uart1Regs.UARTINTST.all = 0;

	rx_byte1 = Uart1Regs.UARTRXBUF.all; //clear RXRDY flag

	Uart1Regs.UARTIOCTRLTX.bit.IO_FUNC = 1; //enable transmit pin
	Uart1Regs.UARTIOCTRLRX.bit.IO_FUNC = 1; //enable receive pin

	Uart1Regs.UARTCTRL3.bit.CLOCK = 1; //internal clock select;
	Uart1Regs.UARTCTRL3.bit.SW_RESET = 1; //software reset released UART init done?

	Uart1Regs.UARTIOCTRLSCLK.bit.IO_FUNC = 0; //disable external clock for UART.

	Uart1Regs.UARTTXBUF.all = ' '; //put out a byte to get things started.
}

void char_out(char data)
{
	volatile int rx_byte;
	while(Uart1Regs.UARTTXST.bit.TX_RDY == 0)
	{
		//do nothing while waiting for data to transmit.
		pmbus_handler();
		if(Uart1Regs.UARTRXST.bit.RX_RDY == 1)
		{
	  		rx_byte = Uart1Regs.UARTRXBUF.bit.RXDAT; //clear RXRDY flag
			//handle_serial_in();
		}
	}
	Uart1Regs.UARTTXBUF.all = data; //put out a byte
}

char translate_nybble_out(char byte,char * pchar2 )
{
	char char1;
	char1 = (byte & 0xf0) >> 4;
	*pchar2 = (byte & 0x0f);
	if (char1 < 10)
	{
		char1 +='0';
	}else if ((char1 >= 0xa) && (char1 <= 0xf))
	{
		char1 = char1 + 'a' - 10;
	}
	if (*pchar2 < 10)
	{
		*pchar2 +='0';
	}else if ((*pchar2 >= 0xa) && (*pchar2 <= 0xf))
	{
		*pchar2 = *pchar2 + 'a' - 10;
	}
	return char1;
}

char translate_nybble_in(char nyb)
{
	if((nyb >= '0') && (nyb <= '9'))
	{
		return nyb - '0';
	}
	else if((nyb >= 'a') && (nyb <= 'f'))
	{
		return nyb - 'a' + 10;
	}
	else if((nyb >= 'A') && (nyb <= 'F'))
	{
		return nyb - 'A' + 10;
	}
	else
	{
		return 0;
	}
}
 
void translate_raw_to_text(void)
{
	Uint16 i;
	Uint8 char2;
	for(i = 0; i < UART_TX_SIZE ;i++)
	{ 
		uart_text_tx_buf[2 * i] =  translate_nybble_out(uart_tx_buf[i], &char2);
		uart_text_tx_buf[(2 * i)+1] = char2;
	}
}

void translate_text_to_raw(void)
{
	//translates text serial in buffer to raw one.
	int i; //loop counter, index into input array
	int j = 0;

	for(i = 0; i < (UART_RX_SIZE *2);i++)
	{
		uart_rx_buf[j] = translate_nybble_in(uart_text_rx_buf[i]) << 4; //high nybble
		i++;
		uart_rx_buf[j] = translate_nybble_in(uart_text_rx_buf[i]) + uart_rx_buf[j]; //add in low nybble
		j++;
	}
}

void uart_transmit_data(void)
{
	static Uint8 previous_pfc_command;

	if(uart_tx_data_rdy == 0) //if previous packet is already sent out, assembly the new data packet 
	{
		Uint8 i;

		pfc_command = 4 * pfc_phase_2_enable + 2 * pfc_zvs_enable + pfc_os_enable;

		if(pfc_command ^ previous_pfc_command)
		{	
			switch (pfc_command)
			{
			case 0:
				{
					uart_tx_buf[0] = 0x40; // Disable Phase B
					uart_tx_buf[1] = 0xBE; // DC bus volts: 390 - 200 = 190 = 0xBE
					uart_tx_buf[2] = 0x2D; // Switching frequency: 100 - 55 = 45 = 0x2D
					uart_tx_buf[3] = 0x00; // Disable ZVS
					uart_tx_buf[4] = 0x01; // Disable over sampling
					uart_tx_buf[5] = 0x00;
					uart_tx_buf[6] = 0x00;
					uart_tx_buf[7] = 0x00;
					uart_tx_buf[8] = 0x00;
					break;
				}
			case 1:
				{
					uart_tx_buf[0] = 0x40; // Disable Phase B
					uart_tx_buf[1] = 0xBE; // DC bus volts: 390 - 200 = 190 = 0xBE
					uart_tx_buf[2] = 0x2D; // Switching frequency: 100 - 55 = 45 = 0x2D
					uart_tx_buf[3] = 0x00; // Disable ZVS
					uart_tx_buf[4] = 0x00; // Enable over sampling
					uart_tx_buf[5] = 0x00;
					uart_tx_buf[6] = 0x00;
					uart_tx_buf[7] = 0x00;
					uart_tx_buf[8] = 0x00;
					break;
				}
			case 2:
				{
					uart_tx_buf[0] = 0x40; // Disable Phase B
					uart_tx_buf[1] = 0xBE; // DC bus volts: 390 - 200 = 190 = 0xBE
					uart_tx_buf[2] = 0x2D; // Switching frequency: 100 - 55 = 45 = 0x2D
					uart_tx_buf[3] = 0x01; // Enable ZVS
					uart_tx_buf[4] = 0x01; // Disable over sampling
					uart_tx_buf[5] = 0x00;
					uart_tx_buf[6] = 0x00;
					uart_tx_buf[7] = 0x00;
					uart_tx_buf[8] = 0x00;
					break;
				}
			case 3:
				{
					uart_tx_buf[0] = 0x40; // Disable Phase B
					uart_tx_buf[1] = 0xBE; // DC bus volts: 390 - 200 = 190 = 0xBE
					uart_tx_buf[2] = 0x2D; // Switching frequency: 100 - 55 = 45 = 0x2D
					uart_tx_buf[3] = 0x01; // Enable ZVS
					uart_tx_buf[4] = 0x00; // Enable over sampling
					uart_tx_buf[5] = 0x00;
					uart_tx_buf[6] = 0x00;
					uart_tx_buf[7] = 0x00;
					uart_tx_buf[8] = 0x00;
					break;
				}
			case 4:
				{
					uart_tx_buf[0] = 0x00; // Enable Phase B
					uart_tx_buf[1] = 0xBE; // DC bus volts: 390 - 200 = 190 = 0xBE
					uart_tx_buf[2] = 0x2D; // Switching frequency: 100 - 55 = 45 = 0x2D
					uart_tx_buf[3] = 0x00; // Disable ZVS
					uart_tx_buf[4] = 0x01; // Disable over sampling
					uart_tx_buf[5] = 0x00;
					uart_tx_buf[6] = 0x00;
					uart_tx_buf[7] = 0x00;
					uart_tx_buf[8] = 0x00;
					break;
				}
			case 5:
				{
					uart_tx_buf[0] = 0x00; // Enable Phase B
					uart_tx_buf[1] = 0xBE; // DC bus volts: 390 - 200 = 190 = 0xBE
					uart_tx_buf[2] = 0x2D; // Switching frequency: 100 - 55 = 45 = 0x2D
					uart_tx_buf[3] = 0x00; // Disable ZVS
					uart_tx_buf[4] = 0x00; // Enable over sampling
					uart_tx_buf[5] = 0x00;
					uart_tx_buf[6] = 0x00;
					uart_tx_buf[7] = 0x00;
					uart_tx_buf[8] = 0x00;
					break;
				}
			case 6:
				{
					uart_tx_buf[0] = 0x00; // Enable Phase B
					uart_tx_buf[1] = 0xBE; // DC bus volts: 390 - 200 = 190 = 0xBE
					uart_tx_buf[2] = 0x2D; // Switching frequency: 100 - 55 = 45 = 0x2D
					uart_tx_buf[3] = 0x01; // Enable ZVS
					uart_tx_buf[4] = 0x01; // Disable over sampling
					uart_tx_buf[5] = 0x00;
					uart_tx_buf[6] = 0x00;
					uart_tx_buf[7] = 0x00;
					uart_tx_buf[8] = 0x00;
					break;
				}
			case 7:
				{
					uart_tx_buf[0] = 0x00; // Enable Phase B
					uart_tx_buf[1] = 0xBE; // DC bus volts: 390 - 200 = 190 = 0xBE
					uart_tx_buf[2] = 0x2D; // Switching frequency: 100 - 55 = 45 = 0x2D
					uart_tx_buf[3] = 0x01; // Enable ZVS
					uart_tx_buf[4] = 0x00; // Enable over sampling
					uart_tx_buf[5] = 0x00;
					uart_tx_buf[6] = 0x00;
					uart_tx_buf[7] = 0x00;
					uart_tx_buf[8] = 0x00;
					break;
				}
			}		
			uart_tx_buf[UART_TX_SIZE-1] = 0; //uart_tx_buf[9] = 0xF4; // Checksum	
			for(i=0; i<(UART_TX_SIZE-1); i++) //calculate checksum 
			{
				uart_tx_buf[UART_TX_SIZE-1] += uart_tx_buf[i]; //put checksum into the last buffer
			}
			translate_raw_to_text(); // Translate raw content of "uart_tx_buf" into text in "uart_text_tx_buf"
			uart_text_tx_buf[2 * UART_TX_SIZE] = '\n';
			uart_text_tx_buf[(2 * UART_TX_SIZE) + 1] = '\r';

			uart_tx_data_rdy = 1; //set flag, new data packet is ready for transmitting
			previous_pfc_command = pfc_command;
		}
	}
	else //send the new data packet
	{
		if(uart_tx_timeout >= 1000) //if 100ms has passed since last transmit
		{
			if(Uart0Regs.UARTTXST.bit.TX_RDY == 1) 
			{
				//Uart1Regs.UARTTXBUF.all = uart_tx_buf[uart_tx_buf_ptr]; //send out a byte and clear TX_RDY flag
				Uart0Regs.UARTTXBUF.all = uart_text_tx_buf[uart_tx_buf_ptr]; //send out a byte and clear TX_RDY flag
				uart_tx_buf_ptr ++; //point to next byte
				//if(uart_tx_buf_ptr == UART_TX_SIZE) //all bytes are sent out
				if(uart_tx_buf_ptr == (UART_TX_SIZE*2) + 2) //all bytes are sent out
				{
					uart_tx_buf_ptr = 0;  //reset the pointer
					uart_tx_data_rdy = 0; //clear flag, so background can start to prepare the next data packet 
					uart_tx_timeout = 0;    //reset the timeout
				}
			}
		}
	}
}

//process received data from UART
void uart_process_rx_data(void)
{
	if(uart_rx_data_rdy == 1) //if received a new data packet
	{
		Uint8 checksum, i;

		translate_text_to_raw();//what we received is in text mode, translate them into raw value

		checksum = 0;
		for(i=0; i<(UART_RX_SIZE-1); i++)  //calculate checksum
		{
			checksum += uart_rx_buf[i];
		}

		if(checksum == uart_rx_buf[UART_RX_SIZE-1]) //process received data if checksum is correct
		{
			pfc_out_struct.pfc_status0 = uart_rx_buf[0];
			pfc_out_struct.pfc_status1 = uart_rx_buf[1];
			// 45V offset to extend the range (255 in UART buffer means 300V)
			pfc_out_struct.pfc_vac = uart_rx_buf[2] + 45;
			pfc_out_struct.pfc_iac = uart_rx_buf[3];
			if(pfc_out_struct.pfc_status1 & 0x02)// Status 1, bit 1: 0=Input Power/ 1=Output Power
			{
				pfc_out_struct.pfc_pout = ((((unsigned short)uart_rx_buf[4])) << 8) + ((unsigned short)uart_rx_buf[5] & 0x00ff);
			}
			else
			{
				pfc_out_struct.pfc_pin = ((((unsigned short)uart_rx_buf[4])) << 8) + ((unsigned short)uart_rx_buf[5] & 0x00ff);
			}
			// 200V offset to extend the range (255 in UART buffer means 455V)
			pfc_out_struct.pfc_vdc_bus = uart_rx_buf[6] + 200;
			pfc_out_struct.pfc_sw_frequency = uart_rx_buf[7];
			// 0-255 range -- 0 -> -50 degrees C , 255 -> 205 degrees C
			pfc_out_struct.pfc_temperature = uart_rx_buf[8] - 50;
		}

		uart_rx_data_rdy = 0; //clear flag, now it's ready to receive next data packet
	}
}

void nybble_out(char nybble)  //Cyclone OK
{
	if(nybble < 10)
	{
		char_out(nybble + 0x30);
	}
	else
	{
		char_out(nybble + ('a' - 10)); //make 10 into an A
	}
}

void decimal_out_cursor_digits(int32 data) //Cyclone OK
{
	int32 i,o;

	if((data > 80) || (data < 1))
	{
		//for invalid data, do nothing
	}
	else
	{
		for(i = 10; i > 0;i = i/10)
		{
			o = (data/i);
			nybble_out(o);
			data = data - (o*i);
		}
	}
}

void decimal_out_4_digits(int32 data) //Cyclone OK
{
int32 i,o;

	if((data > 9999) || (data < 0))
	{
		for(i = 0; i < 4;i++)
		{
			char_out('x');
		}
	}
	else
	{
		for(i = 1000; i > 0;i = i/10)
		{
			o = (data/i);
			nybble_out(o);
			data = data - (o*i);
		}
	}
	char_out(' ');
}

void decimal_out_5_digits(int32 data) //Cyclone OK
{
int32 i,o;

	if((data > 99999) || (data < -99999))
	{
		for(i = 0; i < 6;i++)
		{
			char_out('x');
		}
	}
	else
	{
		if(data < 0)
		{
			data = -data;
			char_out('-');
		}
		else
		{
			char_out(' ');
		}
		for(i = 10000; i > 0;i = i/10)
		{
			o = (data/i);
			nybble_out(o);
			data = data - (o*i);
		}
	}
	char_out(' ');
}

void decimal_out_8_digits(int32 data) //Cyclone OK
{
int32 i,o;

	if((data > 99999999) || (data < -99999999))
	{
		for(i = 0; i < 9;i++)
		{
			char_out('x');
		}
	}
	else
	{
		if(data < 0)
		{
			data = -data;
			char_out('-');
		}
		else
		{
			char_out(' ');
		}
		for(i = 10000000; i > 0;i = i/10)
		{
			o = (data/i);
			nybble_out(o);
			data = data - (o*i);
		}
	}
	char_out(' ');
}

void decimal_out_3_digits(int32 data) //Cyclone OK
{
int32 i,o;

	if((data > 999) || (data < -999))
	{
		for(i = 0; i < 4;i++)
		{
			char_out('x');
		}
	}
	else
	{
		if(data < 0)
		{
			data = -data;
			char_out('-');
		}
		else
		{
			char_out(' ');
		}
		for(i = 100; i > 0;i = i/10)
		{
			o = (data/i);
			nybble_out(o);
			data = data - (o*i);
		}
	}
	char_out(' ');
}

void string_out(char* string)
{
  char character, i=0;

  while(character = *(string + i))
  {
    char_out(character);
	i++;
  } 
}
/*
void string_out(char string[]) //Cyclone OK
{
	int i = 0;

	while(string[i] != 0)
	{
		char_out(string[i]);
		i++;
	}
}
*/

void byte_out(char data)
{
	nybble_out(data >> 4);
	nybble_out(data & 0xf);
}

void three_nybble_out(unsigned short data)
{
	nybble_out(data >> 8);
	byte_out(data & 0xff);
}

void short_out(unsigned short data)
{
	byte_out(data >> 8);
	byte_out(data & 0xff);
}

void word_out(unsigned int data)
{
	short_out(data >> 16);
	short_out(data & 0xffff);
}



