#ifndef _19XDRIVERS_H
#define _19XDRIVERS_H

//Parameter Settings
int bqSetVINDPM(int vdpm);			//REG00[6:3]
int bqSetIINDPM(int idpm);			//REG00[2:0]
int bqSetCHGCONFIG(int code);		//REG01[5:4]
int bqSetSYSMIN(int vlimit);		//REG01[3:1]
int bqSetOTGILIM(int code);			//REG01[0]
int bqSetFASTCHRG(int ichg);		//REG02[7:2]
int bqSetPRECHRG(int iprechg);		//REG03[7:4]
int bqSetTERMCHRG(int iterm);		//REG03[3:0]
int bqSetChgVoltage(int vreg);		//REG04[7:2]
int bqSetBATLOWV(int setting);		//REG04[1]
int bqSetRECHRG(int setting);		//REG04[0]
int bqSetWatchDog(int code);		//REG05[5:4]
int bqSetFastChgTimer(int code);	//REG05[2:1]
//int bqSetJEITAICHG();				//Not listed in the datasheet
//int bqSetJEITAVREG();				//Not listed in the datasheet
int bqSetBATCOMP(int resistor);		//REG06[7:5]
int bqSetVCLAMP(int vclamp);		//REG06[4:2]
int bqSetTREG(int code);			//REG06[1:0]

//Control Settings
int bqEnHIZ(int enable);			//REG00[7]
int bqRstREG();						//REG01[7]
int bqRstWatchDog();				//REG01[6]
int bqEnTERM(int enable);			//REG05[7]
int bqTERMSTAT(int enable);			//REG05[6]
int bqEnTIMER(int enable);			//REG05[3]
int bqEnDPDM(int enable);			//REG07[7]
int bqEnTMR2X(int enable);			//REG07[6]
int bqOffBATFET(int enable);		//REG07[5]

unsigned int Reg00Val;
unsigned int Reg01Val;
unsigned int Reg02Val;
unsigned int Reg03Val;
unsigned int Reg04Val;
unsigned int Reg05Val;
unsigned int Reg06Val;
unsigned int Reg07Val;
unsigned int Reg08Val;	//Read Only
unsigned int Reg09Val;	//Read Only
unsigned int Reg10Val;

#define Reg00Add	0x00
#define Reg01Add	0x01
#define Reg02Add	0x02
#define Reg03Add	0x03
#define Reg04Add	0x04
#define Reg05Add	0x05
#define Reg06Add	0x06
#define Reg07Add	0x07
#define Reg08Add	0x08
#define Reg09Add	0x09
#define Reg10Add	0x0A

#define DevID 0x6B //bq24190/192/192I
//#define DevID 0x6A //bq24191

#define DISABLE 0
#define ENABLE 1
#define RESET 1

// Variables used on bqSetVINDPM Function
	#define VINDPM_MIN 3880		//value in mV
	#define VINDPM_MAX 5080		//value in mV
	#define VINDPM_STEP 80		//value in mV
	#define VINDPM_OFFSET 3880	//value in mV
	#define VINDPM_LSHIFT 3
	#define VINDPM_MASK 0x87 //Bits Set to 1 on mask will remain unchanged

// Variables used on bqSetIINDPM Function
	#define IINLIM_100MA 0		//000
	#define IINLIM_150MA 1		//001
	#define IINLIM_500MA 2		//010
	#define IINLIM_900MA 3		//011
	#define IINLIM_1200MA 4		//100
	#define IINLIM_1500MA 5		//101
	#define IINLIM_2000MA 6		//110
	#define IINLIM_3000MA 7		//111
	#define IINDPM_LSHIFT 0	
	#define IINDPM_MASK 0xF8 //Bits Set to 1 on mask will remain unchanged

// Variables used on bqSetCHGCONFIG Function
	//#define DISABLE 0
	#define CHARGE_BATTERY 1
	#define OTG 2
	//#define OTG 3
	#define CHGCONFIG_LSHIFT 5
	#define CHGCONFIG_MASK 0xCF //Bits Set to 1 on mask will remain unchanged

// Variables used on bqSetSYSMIN Function
	#define SYSMIN_MIN 3000		//value in mV
	#define SYSMIN_MAX 3700		//value in mV
	#define SYSMIN_STEP 100		//value in mV
	#define SYSMIN_OFFSET 3000	//value in mV
	#define SYSMIN_LSHIFT 1
	#define SYSMIN_MASK 0xF1 //Bits Set to 1 on mask will remain unchanged

// Variables used on bqSetOTGILIM Function
	#define BOOSTLIM_500mA 0
	#define BOOSTLIM_1300mA 1
	#define BOOSTLIM_LSHIFT 0
	#define BOOSTLIM_MASK 0xFE //Bits Set to 1 on mask will remain unchanged

// Variables used on bqSetFASTCHRG Function
	#define ICHG_MIN 500		//value in mA
	#define ICHG_MAX 4532		//value in mA
	#define ICHG_STEP 64		//value in mA
	#define ICHG_LSHIFT 2
	#define ICHG_MASK 0x03 //Bits Set to 1 on mask will remain unchanged

// Variables used on bqSetPRECHRG Function
	#define PRECHG_MIN 128		//value in mA
	#define PRECHG_MAX 2048		//value in mA
	#define PRECHG_STEP 128		//value in mA
	#define PRECHG_LSHIFT 4
	#define PRECHG_MASK 0x0F //Bits Set to 1 on mask will remain unchanged

// Variables used on bqSetTERMCHRG Function
	#define ITERM_MIN 128		//value in mA
	#define ITERM_MAX 2048		//value in mA
	#define ITERM_STEP 128		//value in mA
	#define ITERM_LSHIFT 0
	#define ITERM_MASK 0xF0 //Bits Set to 1 on mask will remain unchanged

// Variables used on bqSetChgVoltage Function
	#define VREG_MIN 3504		//value in mV
	#define VREG_MAX 4512		//value in mV
	#define VREG_STEP 16		//value in mV
	#define VREG_LSHIFT 2
	#define VREG_MASK 0x03 //Bits Set to 1 on mask will remain unchanged

// Variables used on bqSetBATLOWV Function
	#define BATLOWV_2800mV 0
	#define BATLOWV_3000mV 1		//*default value
	#define BATLOWV_LSHIFT 1
	#define BATLOWV_MASK 0xFD //Bits Set to 1 on mask will remain unchanged

// Variables used on bqSetRECHRG Function
	#define VRECHG_100mV 0		//*default value
	#define VRECHG_300mV 1
	#define VRECHG_LSHIFT 0
	#define VRECHG_MASK 0xFE //Bits Set to 1 on mask will remain unchanged

// Variables used on bqSetWatchDog Function
	//#define DISABLE 0
	#define WatchDog_40s 1		//*default value
	#define WatchDog_80s 2
	#define WatchDog_160s 3
	#define WatchDog_LSHIFT 4
	#define WatchDog_MASK 0xCF //Bits Set to 1 on mask will remain unchanged

// Variables used on bqSetFastChgTimer Function
	#define CHGTIMER_5h  0
	#define CHGTIMER_8h  1		//*default value
	#define CHGTIMER_12h 2
	#define CHGTIMER_20h 3
	#define CHGTIMER_LSHIFT 1
	#define CHGTIMER_MASK 0xF9 //Bits Set to 1 on mask will remain unchanged

// Variables used on bqSetBATCOMP Function
	#define BATCOMP_MIN  0		//value in mOhm
	#define BATCOMP_MAX	 70		//value in mOhm
	#define BATCOMP_STEP 10		//value in mOhm
	#define BATCOMP_LSHIFT 5
	#define BATCOMP_MASK 0x1F //Bits Set to 1 on mask will remain unchanged

// Variables used on bqSetVCLAMP Function
	#define VCLAMP_MIN  0		//value in mV
	#define VCLAMP_MAX	112		//value in mV
	#define VCLAMP_STEP 16		//value in mV
	#define VCLAMP_LSHIFT 2
	#define VCLAMP_MASK 0xE3 //Bits Set to 1 on mask will remain unchanged

// Variables used on bqSetTREG Function
	#define TREG_60C 0
	#define TREG_80C 1
	#define TREG_100C 2
	#define TREG_120C 3		//*default value
	#define TREG_LSHIFT 0
	#define TREG_MASK 0xFC //Bits Set to 1 on mask will remain unchanged

// Variables used on bqEnHIZ Function
	#define ENHIZ_LSHIFT 7
	#define ENHIZ_MASK 0x7F //Bits Set to 1 on mask will remain unchanged

// Variables used on bqRstREG Function
	#define RESETREG_LSHIFT 7
	#define RESETREG_MASK 0x7F //Bits Set to 1 on mask will remain unchanged

// Variables used on bqRstWatchDog Function
	#define RESETWATCHDOG_LSHIFT 6
	#define RESETWATCHDOG_MASK 0xBF //Bits Set to 1 on mask will remain unchanged

// Variables used on bqEnTERM Function
	#define ENTERM_LSHIFT 7
	#define ENTERM_MASK 0x7F //Bits Set to 1 on mask will remain unchanged

// Variables used on bqTERMSTAT Function
	#define TERMSTAT_ITERM 0		//*default value
	#define TERMSTAT_EARLY 1
	#define TERMSTAT_LSHIFT 6
	#define TERMSTAT_MASK 0xBF //Bits Set to 1 on mask will remain unchanged

// Variables used on bqEnTIMER Function
	#define ENTIMER_LSHIFT 3
	#define ENTIMER_MASK 0xF7 //Bits Set to 1 on mask will remain unchanged

// Variables used on bqEnDPDM Function
	#define ENDPDM_LSHIFT 7
	#define ENDPDM_MASK 0x7F //Bits Set to 1 on mask will remain unchanged

// Variables used on bqEnTMR2X Function
	#define EN2XTIMER_LSHIFT 6
	#define EN2XTIMER_MASK 0xBF //Bits Set to 1 on mask will remain unchanged

// Variables used on bqOffBATFET Function
	#define OFFBATFET_LSHIFT 5
	#define OFFBATFET_MASK 0xDF //Bits Set to 1 on mask will remain unchanged

#endif