                                                          /******************************************************************************/

/* Legacy Header File                                                         */

/* Not recommended for use in new projects.                                   */

/* Please use the msp430.h file or the device specific header file            */

/******************************************************************************/


/********************************************************************

*

* Standard register and bit definitions for the Texas Instruments

* MSP430 microcontroller.

*

* This file supports assembler and C development for

* MSP430x14x devices.

*

* Texas Instruments, Version 2.4

*

* Rev. 1.2, Additional Timer B bit definitions.

*           Renamed XTOFF to XT2OFF.

* Rev. 1.3, Removed leading 0 to aviod interpretation as octal

*            values under C

* Rev. 1.4, Corrected LPMx_EXIT to reference new intrinsic _BIC_SR_IRQ

*           Changed TAIV and TBIV to be read-only

* Rev. 1.5, Enclose all #define statements with parentheses

* Rev. 1.6, Defined vectors for USART (in addition to UART)

* Rev. 1.7, Added USART special function labels (UxME, UxIE, UxIFG)

* Rev. 2.1, Alignment of defintions in Users Guide and of version numbers

* Rev. 2.2, Fixed type in ADC12 bit definitions (replaced ADC10 with ADC12)

* Rev. 2.3, Removed unused def of TASSEL2 / TBSSEL2

* Rev. 2.4, added definitions for Interrupt Vectors xxIV

*

********************************************************************/


#ifndef __msp430x14x

#define __msp430x14x


#ifdef  __IAR_SYSTEMS_ICC__

#ifndef _SYSTEM_BUILD

#pragma system_include

#endif

#endif


#if (((__TID__ >> 8) & 0x7F) != 0x2b)     /* 0x2b = 43 dec */

#error msp430x14x.h file for use with ICC430/A430 only

#endif




#ifdef __IAR_SYSTEMS_ICC__

#include "in430.h"

#pragma language=extended


#define DEFC(name, address) __no_init volatile unsigned char name @ address;

#define DEFW(name, address) __no_init volatile unsigned short name @ address;

#define DEFXC  volatile unsigned char

#define DEFXW  volatile unsigned short


#endif  /* __IAR_SYSTEMS_ICC__  */




#ifdef __IAR_SYSTEMS_ASM__

#define DEFC(name, address) sfrb name = address;

#define DEFW(name, address) sfrw name = address;


#endif /* __IAR_SYSTEMS_ASM__*/


#ifdef __cplusplus

#define READ_ONLY

#else

#define READ_ONLY const

#endif


/************************************************************

* STANDARD BITS

************************************************************/


#define BIT0                (0x0001u)

#define BIT1                (0x0002u)

#define BIT2                (0x0004u)

#define BIT3                (0x0008u)

#define BIT4                (0x0010u)

#define BIT5                (0x0020u)

#define BIT6                (0x0040u)

#define BIT7                (0x0080u)

#define BIT8                (0x0100u)

#define BIT9                (0x0200u)

#define BITA                (0x0400u)

#define BITB         