#include "main.h"

uint16_t ADC_Convert(uint8_t ch, uint8_t times)
{
	uint16_t adc_result = 0, tmp = 0;
	uint8_t i;

	ADC1->CSR = ch;
	for (i = 0; i < times; i++)
	{
		ADC1->CR1 |= 0x01;
		while ((ADC1->CSR & 0x80) == 0);
		ADC1->CSR &= 0x7f;
		adc_result = ADC1->DRL;
		adc_result |= (uint16_t)(ADC1->DRH << (uint8_t)8);
		tmp += adc_result;
		DelayMs(3);
	}
	return(tmp/times);
}