#include "main.h"

uint8_t val1 = 0, val2 = 0;

void BAT_Discharge(void)
{
    static uint8_t vol_cur_update_cnt = 0;		//صѹ
    static uint8_t max_dischg_cur = 0;			//ŵ
    static uint8_t min_dischg_cur = 0;			//Сŵ

    //ؽ
    if(!(LUSB_Status & LUSB_ENABLE) && !(LUSB_Status & LUSB_PRT_CLOSE))
    {
        I2C_BQ24195_ByteWrite(0x01, 0x2b);		//BQ24195ʹܷŵ
        //LUSB_Open();							//LUSB
        GPIO_OutHigh(GPIOC, 0xf0);
        DelayMs(500);
        GPIO_OutLow(GPIOC, 0x0f);
        AWU_Init(AWU_TIMEBASE_256MS);			//ʼAWU256ms
        LUSB_Status |= LUSB_ENABLE;
    }

    ADC1->CR1 |= 0x01;										//ADC
    if(!(vol_cur_update_cnt++ % 40))							//صѹж
    {
        uint8_t bat_vol_val = 0;
        LUSB_Close();											//رLUSB
        LUSB_Voltage = ADC_Convert(ADC_CH_LUSB_VOL, 8);			//صѹ
        bat_vol_val = 12902 / LUSB_Voltage;						//1.26V * 1024 * 10 = 12902ʵʵѹֵ*10
        max_dischg_cur = (uint8_t)(1177 / bat_vol_val);			//2.3A * 0.05R * 1024 = 117.76㵱ǰADCֵ
//        max_dischg_cur = (uint8_t)(40 / bat_vol_val);			//80mA * 0.05R = 4㵱ǰСADCֵ
        LUSB_Open();											//LUSB
        DelayMs(100);
    }
    LUSB_Current = ADC_Convert(ADC_CH_LUSB_CUR, 8);				//ŵ

    if(max_dischg_cur < LUSB_Current)			//ŵ󱣻
    {
        LED_Indication(IDI_LUSB_OVERTOP_C);		//LEDָʾ
        LUSB_Status |= LUSB_PRT_CLOSE;			//־λ
    }
    else if((uint8_t)0 == LUSB_Current)					//ŵͣŵ ?
    {
        LUSB_Status |= LUSB_PRT_CLOSE;
    }
    //صѹȼж
    else if (BAT_VOL_LOWEST < LUSB_Voltage)		//صѹͱ
    {
        LED_Indication(IDI_LUSB_TOOLOW_V);		//LEDָʾ;
        LUSB_Status |= LUSB_PRT_CLOSE;
    }
    else if (BAT_VOL_LOWEST >= LUSB_Voltage && BAT_VOL_LOW < LUSB_Voltage)
    {
        BAT_VolLevel = BAT_VOL_LEVEL_1;
    }
    else if (BAT_VOL_LOW >= LUSB_Voltage && BAT_VOL_MIDDLE < LUSB_Voltage)
    {
        BAT_VolLevel = BAT_VOL_LEVEL_2;
    }
    else if (BAT_VOL_MIDDLE >= LUSB_Voltage && BAT_VOL_HIGH < LUSB_Voltage)
    {
        BAT_VolLevel = BAT_VOL_LEVEL_3;
    }
    else
    {
        BAT_VolLevel = BAT_VOL_LEVEL_4;
    }
    //λرLUSB
    if(LUSB_Status & LUSB_PRT_CLOSE)
    {
        LUSB_Close();							//رLUSB
        I2C_BQ24195_ByteWrite(0x01, 0x0b);		//BQ24195رշŵ
        GPIO_OutLow(GPIOC, 0x0f);
        AWU_Stop();
        DelayMs(5);
        if(GPIO_Input(GPIOC) & PIN_USB_WAKE)
        {
            LUSB_Status |= LUSB_EXTRACT;
        }
    }
    else
    {
        LED_Indication(IDI_BAT_DISCHGING);
    }
    if (LUSB_Status & LUSB_EXTRACT)
    {
        LUSB_Status = 0x00;
    }
}

void BAT_Charge(void)
{
    static uint8_t bat_vol_update_cnt = 0;
    static uint8_t full_vol_retest_cnt = 0;

    //Դ룬BQ24195
    if (!(CUSB_Status & CUSB_CHGING))
    {
        uint8_t tmp = 0;
        while (1)
        {
            DelayMs(1000);
            I2C_BQ24195_ByteWrite(0x00, 0x36);		//óV/I: 4.36V/2A
            DelayMs(300);
            tmp = I2C_BQ24195_ByteRead(0x00);
            if ((0x36 == tmp)) break;
        }
        AWU_Init(AWU_TIMEBASE_256MS);
        CUSB_Status |= CUSB_CHGING;
    }
    while(1)
    {
        if(!(bat_vol_update_cnt++ % 100))				//25.6sһεصѹ
        {
            bat_vol_update_cnt = 1;
            I2C_BQ24195_ByteWrite(0x01, 0x0b);
            I2C_BQ24195_ByteWrite(0x01, 0x2b);		//رճ磬ѹ
            //صѹ
            ADC1->CR1 |= 0x01;										//ADC
            LUSB_Voltage = ADC_Convert(ADC_CH_LUSB_VOL, 8);
            I2C_BQ24195_ByteWrite(0x01, 0x1b);		//ʹܳ
            //}

            //صѹȼ
            if((BAT_VOL_LOW < LUSB_Voltage))
            {
                BAT_VolLevel = BAT_VOL_LEVEL_1;
            }
            else if((BAT_VOL_LOW >= LUSB_Voltage) && (BAT_VOL_MIDDLE < LUSB_Voltage))
            {
                BAT_VolLevel = BAT_VOL_LEVEL_2;
            }
            else if((BAT_VOL_MIDDLE >= LUSB_Voltage) && (BAT_VOL_HIGH < LUSB_Voltage))
            {
                BAT_VolLevel = BAT_VOL_LEVEL_3;
            }
            else if((BAT_VOL_HIGH >= LUSB_Voltage) && (BAT_VOL_HIGHEST < LUSB_Voltage))
            {
                BAT_VolLevel = BAT_VOL_LEVEL_4;
            }
            else
            {
                //͵ѹظ
                if(full_vol_retest_cnt < 3)
                {
                    BAT_VolLevel = BAT_VOL_LEVEL_4;
                    full_vol_retest_cnt++;
                }
                else
                {
                    BAT_VolLevel = BAT_VOL_LEVEL_5;
                }
            }
        }
        LED_Indication(IDI_BAT_CHGING);

        if (CUSB_Status & CUSB_EXTRACT)
        {
            CUSB_Status = 0x00;
            bat_vol_update_cnt = 0;
            full_vol_retest_cnt = 0;
            I2C_BQ24195_ByteWrite(0x01, 0x0b);				//رBQ24195
            GPIO_OutLow(GPIOC, 0x0f);						//رLED
            AWU_Stop();
            break;
        }
        DelayMs(256);
    }
}

