#include "main.h"

void CLK_Configuration(void)
{
	CLK_DeInit();

	CLK_HSIPrescalerConfig(CLK_PRESCALER_HSIDIV2);

	//رղʹõʱ
	CLK_PeripheralClockConfig(CLK_PERIPHERAL_SPI, DISABLE);
	CLK_PeripheralClockConfig(CLK_PERIPHERAL_UART1, DISABLE);

	CLK_PeripheralClockConfig(CLK_PERIPHERAL_TIMER4, DISABLE);
	//CLK_PeripheralClockConfig(CLK_PERIPHERAL_AWU, DISABLE);


	//򿪽Ҫʹõʱ
	CLK_PeripheralClockConfig(CLK_PERIPHERAL_I2C, ENABLE);
	CLK_PeripheralClockConfig(CLK_PERIPHERAL_ADC, ENABLE);
	CLK_PeripheralClockConfig(CLK_PERIPHERAL_TIMER2, ENABLE);
	CLK_LSICmd(ENABLE);
	CLK_PeripheralClockConfig(CLK_PERIPHERAL_AWU, ENABLE);

}

void GPIO_Configuration(void)
{
	GPIO_DeInit(GPIOA);
	GPIO_DeInit(GPIOB);
	GPIO_DeInit(GPIOC);
	GPIO_DeInit(GPIOD);

	//
	GPIO_Init(GPIOD, PIN_CHG_FULL, GPIO_MODE_IN_FL_IT);
	GPIO_Init(GPIOD, PIN_CHG_WAKE, GPIO_MODE_IN_FL_IT);
	//ŵ
	GPIO_Init(GPIOD, PIN_USB_WAKE, GPIO_MODE_IN_PU_IT);
	GPIO_Init(GPIOA, PIN_USB_DPDN, GPIO_MODE_OUT_PP_LOW_FAST);
	GPIO_Init(GPIOA, PIN_USB_EN, GPIO_MODE_OUT_PP_LOW_FAST);
	//
	GPIO_Init(GPIOA, PIN_BUTON, GPIO_MODE_IN_FL_IT);
	//ADC
	GPIO_Init(GPIOD, PIN_USB_I, GPIO_MODE_IN_FL_NO_IT);
	GPIO_Init(GPIOD, PIN_USB_U, GPIO_MODE_IN_FL_NO_IT);
	//LED
	GPIO_Init(GPIOC, PIN_LED_1, GPIO_MODE_OUT_PP_LOW_FAST);
	GPIO_Init(GPIOC, PIN_LED_2, GPIO_MODE_OUT_PP_LOW_FAST);
	GPIO_Init(GPIOC, PIN_LED_3, GPIO_MODE_OUT_PP_LOW_FAST);
	GPIO_Init(GPIOC, PIN_LED_4, GPIO_MODE_OUT_PP_LOW_FAST);
	GPIO_Init(GPIOC, PIN_LED_5, GPIO_MODE_OUT_PP_LOW_FAST);
	GPIO_Out(GPIOC, 0x00);
	//I2C
	GPIO_Init(GPIOB, PIN_I2C_SCL, GPIO_MODE_IN_FL_NO_IT);
	GPIO_Init(GPIOB, PIN_I2C_SDA, GPIO_MODE_IN_FL_NO_IT);

}

void TIM_Configuration(void)
{
	TIM2_DeInit();

	TIM2_TimeBaseInit(TIM2_PRESCALER_8, 1000);
	TIM2_ClearITPendingBit(TIM2_IT_UPDATE);
	TIM2_ITConfig(TIM2_IT_UPDATE, ENABLE);
	TIM2_Cmd(DISABLE);

}

void I2C_Configuration(void)
{
	uint16_t tmp = 0;

	//λI2CĴ
	I2C->CR1 = I2C_CR1_RESET_VALUE;
	I2C->CR2 = I2C_CR2_RESET_VALUE;
	I2C->FREQR = I2C_FREQR_RESET_VALUE;
	I2C->OARL = I2C_OARL_RESET_VALUE;
	I2C->OARH = I2C_OARH_RESET_VALUE;
	I2C->ITR = I2C_ITR_RESET_VALUE;
	I2C->CCRL = I2C_CCRL_RESET_VALUE;
	I2C->CCRH = I2C_CCRH_RESET_VALUE;
	I2C->TRISER = I2C_TRISER_RESET_VALUE;
	//I2C
	I2C_Close();							//رI2C
	I2C->FREQR = I2C_INPUT_FRE;				//ʱ
	I2C->OARH = I2C_7BIT_ADDR;				//7λַģʽ
	I2C->OARL = I2C_INTER_ADDR;				//I2Cӿڵַ
	tmp = (uint16_t)((I2C_INPUT_FRE*1000000)/(I2C_OUTPUT_FRE<<(uint8_t)1));	//ʱӼĴֵ
	I2C->CCRL = (uint8_t)tmp;				//ʱ
	I2C->CCRH = ((uint8_t)(tmp >> 8) & 0x0f) ;		//Ϊ׼ģʽ
	I2C->TRISER = 0x02;						//ʱ
	I2C_Open();								//I2C
}

void ADC_Configuration(void)
{
	//λADCĴ
	ADC1->CSR  = ADC1_CSR_RESET_VALUE;
	ADC1->CR1  = ADC1_CR1_RESET_VALUE;
	ADC1->CR2  = ADC1_CR2_RESET_VALUE;
	ADC1->CR3  = ADC1_CR3_RESET_VALUE;
	ADC1->TDRH = ADC1_TDRH_RESET_VALUE;
	ADC1->TDRL = ADC1_TDRL_RESET_VALUE;
	ADC1->HTRH = ADC1_HTRH_RESET_VALUE;
	ADC1->HTRL = ADC1_HTRL_RESET_VALUE;
	ADC1->LTRH = ADC1_LTRH_RESET_VALUE;
	ADC1->LTRL = ADC1_LTRL_RESET_VALUE;
	ADC1->AWCRH = ADC1_AWCRH_RESET_VALUE;
	ADC1->AWCRL = ADC1_AWCRL_RESET_VALUE;
	//ADC
	ADC1->CR1 = 0x70;						//ADCʱ: Fmaster/2
	ADC1->CR2 = 0x08;						//Ҷ뷽ʽ
	ADC1->TDRH = 0x00;						//ʩشֹI/O̬
	ADC1->TDRL = 0x00;
	//ADC1->CSR = 0x03;						//ѡתͨ3
	//ADC1->CR1 |= 0x01;						//ADC
}

void UART_Configuration(void)
{
	UART1->BRR2 = 0x03; //9600bps @16M
	UART1->BRR1 = 0x68; //9600bps @16M
	UART1->CR3 = 0x00;  //1λֹͣλͬģʽ

	UART1->CR2 = 0x08;  // ʹܷͺͽչܣж
	UART1->CR1 = 0x00;  //8λݣʹżЧ飬ʹUART1
}

void EXTI_Configuration(void)
{
	//λĴ
	EXTI->CR1 = EXTI_CR1_RESET_VALUE;
	EXTI->CR2 = EXTI_CR2_RESET_VALUE;
	//жϴ
	EXTI->CR1 |= 0xc0;						//GPIODأ½شж

	//ITC->ISPR2 &= 0xcf;						//GPIODжȼΪ1
	//ITC->ISPR4 &= 0xf3;						//TIM2жȼΪ2
	_asm("rim");							//ж
}

void AWU_Configuration(void)
{
	//AWU_LSICalibrationConfig(LSI_Measurment());
	AWU_Init(AWU_TIMEBASE_1S);
	AWU_Stop();
}











