#include "main.h"

void LED_Blink(uint8_t times, uint16_t delay)
{
	while (times--)
	{
		GPIO_OutHigh(GPIOC, PIN_LED_1|PIN_LED_2|PIN_LED_3|PIN_LED_4);
		DelayMs(delay);
		GPIO_OutLow(GPIOC, ~(PIN_LED_1|PIN_LED_2|PIN_LED_3|PIN_LED_4));
		DelayMs(delay);
	}

}
void LED_Indication(uint8_t type)
{
	uint8_t i, tmp;

	switch (type)
	{
	case IDI_LUSB_OVERTOP_C:
		LED_Blink(8, 400);
		break;
	case IDI_LUSB_TOOLOW_C:
		LED_Blink(3, 1000);
		break;
	case IDI_LUSB_TOOLOW_V:
		for (i = 0; i < 20; i++)
		{
			GPIO_OutHigh(GPIOC, PIN_LED_1>>(i%4));
			DelayMs(800);
			if (!(i%4))
			{
				GPIO_OutLow(GPIOC, ~(PIN_LED_1|PIN_LED_2|PIN_LED_3|PIN_LED_4));
				DelayMs(500);
			}
		}
		break;
	case IDI_BAT_CHGING:
		if (BAT_VolLevel != BAT_VOL_LEVEL_5)
		{
			for (i = 0; i < (4-BAT_VolLevel); i++)
			{
				if (CUSB_Status & CUSB_EXTRACT)
				{
					GPIO_OutLow(GPIOC, 0x0f);
					return;
				}
				tmp = (uint8_t)((uint16_t)(0xff80) >> (BAT_VolLevel+i));
				GPIO_OutHigh(GPIOC, tmp);
				DelayMs(300);
			}
			tmp = (uint8_t)((uint16_t)(0xff00) >> BAT_VolLevel);
			GPIO_OutLow(GPIOC, tmp | 0x0f);
		}
		else
		{
			GPIO_OutHigh(GPIOC, 0xf0);
		}
		break;
	case IDI_BAT_DISCHGING:
		tmp = GPIO_Input(GPIOC);
		switch (BAT_VolLevel)
		{
		case BAT_VOL_LEVEL_1:
			(tmp & 0x80)?GPIO_OutLow(GPIOC, tmp & 0x7f):GPIO_OutHigh(GPIOC, tmp | 0x80);
			break;
		case BAT_VOL_LEVEL_2:
			(tmp & 0x40)?GPIO_OutLow(GPIOC, tmp & 0xbf):GPIO_OutHigh(GPIOC, tmp | 0xc0);
			break;
		case BAT_VOL_LEVEL_3:
			(tmp & 0x20)?GPIO_OutLow(GPIOC, tmp & 0xdf):GPIO_OutHigh(GPIOC, tmp | 0xe0);
			break;
		case BAT_VOL_LEVEL_4:
			(tmp & 0x10)?GPIO_OutLow(GPIOC, tmp & 0xef):GPIO_OutHigh(GPIOC, tmp | 0xf0);
			break;
		default:
			GPIO_OutLow(GPIOC, 0x0f);
			break;
		}
		break;
	}
}