#include "main.h"

uint16_t volatile LUSB_Voltage = 0, LUSB_Current = 0;		//ŵUSBѹUSB
uint8_t volatile LUSB_Status = 0, CUSB_Status = 0;			//USBӱ־
uint8_t volatile BAT_VolLevel = 0;
uint16_t volatile DelayVal = 0;
uint8_t volatile DelayFlag = NORMAL_DELAY;

void MainLoop(void);

void main(void)
{
	CLK_Configuration();								//ϵͳʱ
	GPIO_Configuration();								//ͨI/O
	TIM_Configuration();								//ʱ
	I2C_Configuration();								//I2Cͨ
	ADC_Configuration();								//ģת
	EXTI_Configuration();								//ⲿж
	BQ24195_Init();										//BA24195ʼ
	LED_Blink(1, 500);									//LED˸ָʾ
	MainLoop();													//ѭ
}

void MainLoop(void)
{
	ADC1->CR1 |= 0x01;									//ADC
	LUSB_Voltage = ADC_Convert(ADC_CH_LUSB_VOL, 8);
	while (1)
	{
		if (LUSB_Status & LUSB_INSERT)			//USB
		{
			BAT_Discharge();
		}
		if (CUSB_Status & CUSB_INSERT)
		{
			BAT_Charge();
		}
		_asm("halt");
	}
}

void DelayMs(uint16_t t)
{
	DelayVal = t;
	TIM2->CNTRH = (uint8_t)0x00;
	TIM2->CNTRL = (uint8_t)0x00;
	TIM2_Cmd(ENABLE);
	while (DelayVal);
	TIM2_Cmd(DISABLE);
}

void DelaySoft(uint16_t t)
{
	uint16_t i;

	while (t--)
	{
		for (i = 0; i < 500; i++);
	}
}

#ifdef USE_FULL_ASSERT

/**
  * @brief  Reports the name of the source file and the source line number
  *   where the assert_param error has occurred.
  * @param file: pointer to the source file name
  * @param line: assert_param error line source number
  * @retval : None
  */
void assert_failed(u8* file, u32 line)
{
	/* User can add his own implementation to report the file name and line number,
	   ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while (1)
	{
	}
}
#endif
