#ifndef		__CONFIG_H
#define		__CONFIG_H


/********************ͷļ********************/
#include "stm8s.h"
#include "stm8s_clk.h"
#include "stm8s_gpio.h"
#include "stm8s_exti.h"
#include "stm8s_tim2.h"
#include "stm8s_i2c.h"
#include "stm8s_adc1.h"
#include "stm8s_awu.h"


/********************궨********************/
//GPIOD
#define	PIN_CHG_FULL	GPIO_PIN_4
#define PIN_CHG_WAKE	GPIO_PIN_5
#define PIN_USB_WAKE 	GPIO_PIN_6
#define PIN_USB_I			GPIO_PIN_3
#define PIN_USB_U			GPIO_PIN_2
//GPIOA
#define PIN_USB_DPDN	GPIO_PIN_1
#define PIN_USB_EN		GPIO_PIN_2
#define PIN_BUTON			GPIO_PIN_3
//GPIOB
#define PIN_I2C_SCL		GPIO_PIN_4
#define PIN_I2C_SDA		GPIO_PIN_5
//GPIOC
#define PIN_LED_1			GPIO_PIN_7
#define PIN_LED_2			GPIO_PIN_6
#define PIN_LED_3			GPIO_PIN_5
#define PIN_LED_4			GPIO_PIN_4
#define PIN_LED_5			GPIO_PIN_3
#define GPIO_Out(GPIOx, Pin)	((GPIOx)->ODR = (Pin))
#define GPIO_OutHigh(GPIOx, Pin)	((GPIOx)->ODR |= (Pin))
#define GPIO_OutLow(GPIOx, Pin)		((GPIOx)->ODR &= (Pin))
#define GPIO_Input(GPIOx)		((GPIOx)->IDR)
//I2C
#define	I2C_OUTPUT_FRE		100000
#define I2C_INPUT_FRE		4
#define I2C_INTER_ADDR		0xa0
#define I2C_BQ24195_ADDR	0xd6
#define	I2C_7BIT_ADDR		0x40
#define I2C_Open()				(I2C->CR1 |= 0x01)
#define I2C_Close()				(I2C->CR1 &= 0xfe)
#define I2C_Start()				(I2C->CR2 |= 0x01)
#define I2C_Stop()				(I2C->CR2 |= 0x02)
#define I2C_EnableAck()			(I2C->CR2 |= 0x04)
#define I2C_DisableAck()		(I2C->CR2 &= 0xfb)
#define I2C_RecvByte()			(I2C->DR)
#define I2C_SendByte(data)		(I2C->DR = (data))
#define I2C_IsBusy()			(I2C->SR3 & 0x02)
#define I2C_IsStartFinished() 	(I2C->SR1 & 0x01)
#define I2C_IsAddrFinished()	(I2C->SR1 & 0x02)
#define I2C_IsSendFinished()	(I2C->SR1 & 0x04)
#define I2C_IsSendEmpty()		(I2C->SR1 & 0x80)
#define I2C_IsRecvNotEmpty()	(I2C->SR1 & 0x40)
#define I2C_ClearAddrFlag(tmp)	{(tmp)=I2C->SR1;(tmp)=I2C->SR3;}
#define I2C_ClearBTFFlag(tmp)	((tmp)=I2C->SR1)
//UART
#define UART_ByteSend(data)		(UART1->DR = (uint8_t)(data))					//UART
//AWU
#define	AWU_Start()							(AWU->CSR |= AWU_CSR_AWUEN)			//AWU
#define AWU_Stop()							(AWU->CSR &= ~AWU_CSR_AWUEN)		//AWUر
//ADC
#define ADC_CH_LUSB_VOL			4		//ADCѹͨ
#define ADC_CH_LUSB_CUR			3		//ADCͨ
//־
#define LUSB_INSERT				0x01	//USB
#define LUSB_ENABLE				0x02	//USB
#define LUSB_EXTRACT 			0x04	//USBγ
#define LUSB_PRT_CLOSE			0x80	//USBر

#define LUSB_Open()				(GPIOA->ODR |= PIN_USB_EN) 		//LUSB
#define LUSB_Close()			(GPIOA->ODR &= ~PIN_USB_EN)		//LUSBر

#define IDI_LUSB_OVERTOP_C		0		//LUSBָʾ
#define IDI_LUSB_TOOLOW_C		1		//LUSBָʾ
#define IDI_LUSB_TOOLOW_V		2		//LUSBѹָʾ
#define IDI_BAT_CHGING			3		//سָʾ
#define IDI_BAT_DISCHGING		4		//طŵָʾ

#define CUSB_INSERT				0x01	//USB
#define CUSB_CHGING				0x02	//ڳ
#define CUSB_EXTRACT			0x04	//USBγ
#define CUSB_TERMINA			0x30	//ֹ

#define BAT_VOL_LOWEST			(uint16_t)401	//3.2	401.28
#define BAT_VOL_LOW				(uint16_t)373	//3.45	372.5
#define BAT_VOL_MIDDLE			(uint16_t)347	//3.7	347.3
#define BAT_VOL_HIGH			(uint16_t)325	//3.95	325.3
#define BAT_VOL_HIGHEST			(uint16_t)301	//4.27  //4.2	305.9

#define BAT_VOL_LEVEL_1			0		//صѹȼ1
#define BAT_VOL_LEVEL_2			1		//صѹȼ2
#define BAT_VOL_LEVEL_3			2		//صѹȼ3
#define BAT_VOL_LEVEL_4			3		//صѹȼ4
#define BAT_VOL_LEVEL_5			4		//صѹȼ5

#define NORMAL_DELAY			0		//ʱ2ʱ
#define TMNAT_DELAY				1		//ʱ2ʱ


/********************ȫֱ********************/
extern volatile uint16_t LUSB_Voltage, LUSB_Current;		//صѹŵ
extern volatile uint8_t LUSB_Status, CUSB_Status;			//USBUSB״̬
extern uint8_t volatile BAT_VolLevel;						//صѹȼ
extern uint16_t volatile DelayVal;							//ʱʱֵ
extern uint8_t volatile DelayFlag;							//ʱֹʱ־


/********************ⲿ********************/

//BQ24195
extern void I2C_BQ24195_ByteWrite(uint8_t addr, uint8_t data);
extern uint8_t I2C_BQ24195_ByteRead(uint8_t addr);
extern uint8_t BQ24195_Init(void);

//ADC
extern uint16_t ADC_Convert(uint8_t ch, uint8_t times);

//LED
extern void LED_Blink(uint8_t times, uint16_t delay);
extern void LED_Indication(uint8_t type);
//BATTERY
extern void BAT_Discharge(void);
extern void BAT_Charge(void);

//MCU
extern void CLK_Configuration(void);
extern void GPIO_Configuration(void);
extern void TIM_Configuration(void);
extern void I2C_Configuration(void);
extern void ADC_Configuration(void);
extern void UART_Configuration(void);
extern void AWU_Configuration(void);
extern void EXTI_Configuration(void);

//ʱ
extern void DelayMs(uint16_t t);			//ʱʱ1ms
extern void DelaySoft(uint16_t t);			//ʱ


#endif
