/*	BASIC INTERRUPT VECTOR TABLE FOR STM8 devices
 *	Copyright (c) 2007 STMicroelectronics
 */

#include "main.h"

typedef void @far (*interrupt_handler_t)(void);

struct interrupt_vector {
	unsigned char interrupt_instruction;
	interrupt_handler_t interrupt_handler;
};

@far @interrupt void NonHandledInterrupt (void)
{
	/* in order to detect unexpected events during development, 
	   it is recommended to set a breakpoint on the following instruction
	*/

	return;
}

@far @interrupt void AWU_IRQHandler(void)
{
	if(AWU->CSR & AWU_CSR_AWUF)
	{
		/*if((GPIO_Input(GPIOC) & PIN_LED_4) == 0)
		{
			GPIO_OutHigh(GPIOC, PIN_LED_4);
		}
		else
		{
			GPIO_OutLow(GPIOC, ~PIN_LED_4);
		}*/
	}
}


@far @interrupt void EXTI_PortD_IRQHandler(void)
{
	uint8_t tmp = 0;

	tmp = GPIO_Input(GPIOD);
	if((tmp & PIN_CHG_WAKE) && !(CUSB_Status & CUSB_INSERT))				//CUSB
	{
		CUSB_Status |= CUSB_INSERT;
	}
    else if(!(tmp & PIN_CHG_WAKE) && (CUSB_Status & CUSB_INSERT))			//CUSBγ
	{
        DelayFlag = TMNAT_DELAY;
		CUSB_Status |= CUSB_EXTRACT;
	}
	else if(!(tmp & PIN_USB_WAKE) && !(LUSB_Status & LUSB_INSERT))			//LUSB
	{
		LUSB_Status |= LUSB_INSERT;
	}
    else if((tmp & PIN_USB_WAKE) && (LUSB_Status & LUSB_PRT_CLOSE))			//LUSBγֻLUSBرʱ
	{
		LUSB_Status |= LUSB_EXTRACT;
	}
}

@far @interrupt void TIM2_Update_IRQHandler(void)
{
	if(TIM2_GetITStatus(TIM2_IT_UPDATE) != RESET)
	{
        if(DelayFlag == TMNAT_DELAY)
		{
			DelayVal = 0;
            DelayFlag = NORMAL_DELAY;
		}
		else DelayVal--;
	}
	TIM2_ClearITPendingBit(TIM2_IT_UPDATE);
}


extern void _stext();     /* startup routine */
//extern void EXTI_PortC_IRQHandler(void);

struct interrupt_vector const _vectab[] = {
	{0x82, (interrupt_handler_t)_stext}, /* reset */
	{0x82, NonHandledInterrupt}, /* trap  */
	{0x82, NonHandledInterrupt}, /* irq0  */
	{0x82, AWU_IRQHandler}, /* irq1  */
	{0x82, NonHandledInterrupt}, /* irq2  */
	{0x82, NonHandledInterrupt}, /* irq3  */
	{0x82, NonHandledInterrupt}, /* irq4  */
	{0x82, NonHandledInterrupt}, /* irq5  */
	{0x82, EXTI_PortD_IRQHandler}, /* irq6  */
	{0x82, NonHandledInterrupt}, /* irq7  */
	{0x82, NonHandledInterrupt}, /* irq8  */
	{0x82, NonHandledInterrupt}, /* irq9  */
	{0x82, NonHandledInterrupt}, /* irq10 */
	{0x82, NonHandledInterrupt}, /* irq11 */
	{0x82, NonHandledInterrupt}, /* irq12 */
	{0x82, TIM2_Update_IRQHandler}, /* irq13 */
	{0x82, NonHandledInterrupt}, /* irq14 */
	{0x82, NonHandledInterrupt}, /* irq15 */
	{0x82, NonHandledInterrupt}, /* irq16 */
	{0x82, NonHandledInterrupt}, /* irq17 */
	{0x82, NonHandledInterrupt}, /* irq18 */
	{0x82, NonHandledInterrupt}, /* irq19 */
	{0x82, NonHandledInterrupt}, /* irq20 */
	{0x82, NonHandledInterrupt}, /* irq21 */
	{0x82, NonHandledInterrupt}, /* irq22 */
	{0x82, NonHandledInterrupt}, /* irq23 */
	{0x82, NonHandledInterrupt}, /* irq24 */
	{0x82, NonHandledInterrupt}, /* irq25 */
	{0x82, NonHandledInterrupt}, /* irq26 */
	{0x82, NonHandledInterrupt}, /* irq27 */
	{0x82, NonHandledInterrupt}, /* irq28 */
	{0x82, NonHandledInterrupt}, /* irq29 */
};
