//CONTROL LOCATIONS
typedef struct {
            u8 control_page;           //coefficient page location
            u8 control_base;           //coefficient base address within page
            u8 control_mute_flag;      //non-zero means muting required
            u8 control_string_index;   //string table index
} control; 


static control MUX_controls[] = {
};

static string MUX_control_names[] = {
};

static control VOLUME_controls[] = {
};

static string VOLUME_control_names[] = {
};

//INSTRUCTIONS & COEFFICIENTS
typedef struct {
    u8 reg_off;
    u8 reg_val;
} reg_value;

static string REG_Section_names[] = {
    "miniDSP_A_reg_values",
    "miniDSP_D_reg_values",
};

reg_value REG_Section_program[] = {
    {  0,0x00},
//			# reg[  0][  1] = 0x01	; Initialize the device through software reset
    {  1,0x01},
    {254,0x0A},
    {  0,0x01},
//			# reg[  1][  1] = 0x08	; Power up AVDD LDO; Disable weak AVDD to DVDD connection; Enable Master Analog Power Control, AVDD LDO Powered; Disable weak AVDD to DVDD connection
    {  1,0x08},
//			# reg[  1][  2] = 0x00	; Enable Master Analog Power Control
    {  2,0x00},
//			# reg[  1][ 71] = 0x32	; Set the input power-up time to 3.1ms
    { 71,0x32},
//			# reg[  1][123] = 0x01	; Set REF charging time to 40ms (automatic)
    {123,0x01},
    {255,0x00},
    {255,0x01},
    {  0,0x00},
//			# reg[  0][ 60] = 0x00    ; DAC prog Mode: miniDSP_A and miniDSP_D NOT powered up together, miniDSP_A used for signal processing
    { 60,0x00},
//			# reg[  0][ 61] = 0x00	; Use miniDSP_A for signal processing
    { 61,0x00},
//			# reg[  0][ 17] = 0x08	; 8x Interpolation
    { 17,0x08},
//			# reg[  0][ 23] = 0x04	; 4x Decimation
    { 23,0x04},
//			
    { 15,0x03},
//			
    { 16,0x88},
//			
    { 21,0x03},
//			
    { 22,0x88},
    {  0,0x08},
//			# reg[  8][  1] = 0x04	; adaptive mode for ADC
    {  1,0x04},
    {  0,0x2C},
//			# reg[ 44][  1] = 0x04	; adaptive mode for DAC
    {  1,0x04},
    {  0,0x00},
//			# reg[  0][  5] = 0x91	; P=1, R=1, J=8
    {  5,0x91},
//			# reg[  0][  6] = 0x08	; P=1, R=1, J=8
    {  6,0x08},
//			# reg[  0][  7] = 0x00	; D=0000 (MSB)
    {  7,0x00},
//			# reg[  0][  8] = 0x00	; D=0000 (LSB)
    {  8,0x00},
//			# reg[  0][  4] = 0x03	; PLL_clkin = MCLK, codec_clkin = PLL_CLK, PLL on
    {  4,0x03},
//			# reg[  0][ 12] = 0x88	; MDAC = 8, divider powered on
    { 12,0x88},
//			# reg[  0][ 13] = 0x00	; DOSR = 128 (MSB)
    { 13,0x00},
//			# reg[  0][ 14] = 0x80	; DOSR = 128 (LSB)
    { 14,0x80},
//			# reg[  0][ 18] = 0x02	; NADC = 2, divider powered off
    { 18,0x02},
//			# reg[  0][ 19] = 0x88	; MADC = 8, divider powered on
    { 19,0x88},
//			# reg[  0][ 20] = 0x80	; AOSR = 128
    { 20,0x80},
//			# reg[  0][ 11] = 0x82	; NDAC = 2, divider powered on
    { 11,0x82},
    {  0,0x01},
//			# reg[  1][ 51] = 0x40	; Mic Bias enabled, Source = Avdd, 1.25V
    { 51,0x40},
//			# reg[  1][ 52] = 0x40	; Route IN2L to LEFT_P with 10K input impedance; Route CM1L to LEFT_M with 10K input impedance; Route IN2R to RIGHT_P with 10K input impedance; Route IN1L to LEFT_P with 10K input impedance
    { 52,0x40},
//			# reg[  1][ 54] = 0x40	; Route CM1L to LEFT_M with 10K input impedance
    { 54,0x40},
//			# reg[  1][ 55] = 0x40	; Route IN1R to RIGHT_P with 10K input impedance
    { 55,0x40},
//			# reg[  1][ 57] = 0x40	; Route CM1R to RIGHT_M with 10K input impedance
    { 57,0x40},
//			# reg[  1][ 59] = 0x00	; Enable MicPGA_L Gain Control, 0dB
    { 59,0x00},
//			# reg[  1][ 60] = 0x00	; Enable MicPGA_R Gain Control, 0dB
    { 60,0x00},
    {  0,0x00},
//			# reg[  0][ 81] = 0xc0	; Power up LADC/RADC
    { 81,0xC0},
//			# reg[  0][ 82] = 0x00	; Unmute LADC/RADC
    { 82,0x00},
    {  0,0x01},
//			# reg[  1][ 20] = 0x25	; De-pop: 5 time constants, 6k resistance
    { 20,0x25},
//			# reg[  1][ 12] = 0x08	; Route LDAC to HPL
    { 12,0x08},
//			# reg[  1][ 13] = 0x08	; Route RDAC to HPR
    { 13,0x08},
//			# reg[  1][ 14] = 0x08	; Route LDAC to LOL
    { 14,0x08},
//			# reg[  1][ 15] = 0x08	; Route LDAC to LOR
    { 15,0x08},
    {  0,0x00},
//			# reg[  0][ 63] = 0xd4	; Power up LDAC/RDAC w/ soft stepping
    { 63,0xD4},
    {  0,0x01},
//			# reg[  1][ 16] = 0x00	; Unmute HPL driver, 0dB Gain
    { 16,0x00},
//			# reg[  1][ 17] = 0x00	; Unmute HPR driver, 0dB Gain
    { 17,0x00},
//			# reg[  1][ 18] = 0x00	; Unmute LOL driver, 0dB Gain
    { 18,0x00},
//			# reg[  1][ 19] = 0x00	; Unmute LOR driver, 0dB Gain
    { 19,0x00},
//			# reg[  1][  9] = 0x3c	; Power up HPL/HPR and LOL/LOR drivers
    {  9,0x3C},
    {  0,0x00},
//			# reg[  0][ 64] = 0x00	; Unmute LDAC/RDAC
    { 64,0x00},
//			# reg[0][82] = 0
    { 82,0x00},
//			# reg[0][83] = 0
    { 83,0x00},
//			# reg[0][86] = 32
    { 86,0x20},
//			# reg[0][87] = 254
    { 87,0xFE},
//			# reg[0][88] = 0
    { 88,0x00},
//			# reg[0][89] = 104
    { 89,0x68},
//			# reg[0][90] = 168
    { 90,0xA8},
//			# reg[0][91] = 6
    { 91,0x06},
//			# reg[0][92] = 0
    { 92,0x00},
//			# reg[0][84] = 0
    { 84,0x00},
//			# reg[0][94] = 32
    { 94,0x20},
//			# reg[0][95] = 254
    { 95,0xFE},
//			# reg[0][96] = 0
    { 96,0x00},
//			# reg[0][97] = 104
    { 97,0x68},
//			# reg[0][98] = 168
    { 98,0xA8},
//			# reg[0][99] = 6
    { 99,0x06},
//			# reg[0][100] = 0
    {100,0x00},
};

reg_value miniDSP_A_reg_values[] = {
    {  0,0x08},
    {  8,0x00},
    {  9,0xB7},
    { 10,0x98},
    { 11,0x00},
    { 12,0x7E},
    { 13,0x90},
    { 14,0xD0},
    { 15,0x00},
    { 16,0x7F},
    { 17,0xFF},
    { 18,0xFF},
    { 19,0x00},
    { 20,0x00},
    { 21,0x00},
    { 22,0x00},
    { 23,0x00},
    { 24,0x00},
    { 25,0x00},
    { 26,0x00},
    { 27,0x00},
    { 28,0xFF},
    { 29,0xFF},
    { 30,0xFF},
    { 31,0x00},
    { 32,0x80},
    { 33,0x00},
    { 34,0x00},
    { 35,0x00},
    { 36,0x7F},
    { 37,0xFF},
    { 38,0xFF},
    { 39,0x00},
    { 40,0x40},
    { 41,0x00},
    { 42,0x00},
    { 43,0x00},
    { 44,0x00},
    { 45,0x00},
    { 46,0x00},
    { 47,0x00},
    { 48,0xFF},
    { 49,0x9E},
    { 50,0x00},
    { 51,0x00},
    { 52,0xF7},
    { 53,0x10},
    { 54,0x00},
    { 55,0x00},
    { 56,0x26},
    { 57,0xF0},
    { 58,0x00},
    { 59,0x00},
    { 60,0x02},
    { 61,0x61},
    { 62,0x00},
    { 63,0x00},
    { 64,0x40},
    { 65,0x02},
    { 66,0x00},
    { 67,0x00},
    { 68,0xFF},
    { 69,0xFC},
    { 70,0x00},
    { 71,0x00},
    { 72,0xFF},
    { 73,0xFD},
    { 74,0x00},
    { 75,0x00},
    { 76,0xFF},
    { 77,0xE5},
    { 78,0x00},
    { 79,0x00},
    { 80,0xFF},
    { 81,0xA7},
    { 82,0x00},
    { 83,0x00},
    { 84,0xFF},
    { 85,0xC7},
    { 86,0x00},
    { 87,0x00},
    { 88,0xFF},
    { 89,0xCE},
    { 90,0x00},
    { 91,0x00},
    { 92,0xFF},
    { 93,0xFE},
    { 94,0x00},
    { 95,0x00},
    { 96,0xFE},
    { 97,0xF7},
    { 98,0x00},
    { 99,0x00},
    {100,0xFF},
    {101,0x46},
    {102,0x00},
    {103,0x00},
    {104,0xFF},
    {105,0x22},
    {106,0x00},
    {107,0x00},
    {108,0xFF},
    {109,0x0F},
    {110,0x00},
    {111,0x00},
    {112,0xFA},
    {113,0x8C},
    {114,0x00},
    {115,0x00},
    {116,0xF5},
    {117,0x08},
    {118,0x00},
    {119,0x00},
    {120,0xFD},
    {121,0x92},
    {122,0x00},
    {123,0x00},
    {124,0xF3},
    {125,0xA3},
    {126,0x00},
    {127,0x00},
    {  0,0x09},
    {  8,0x03},
    {  9,0xB3},
    { 10,0x00},
    { 11,0x00},
    { 12,0x00},
    { 13,0x33},
    { 14,0x00},
    { 15,0x00},
    { 16,0x00},
    { 17,0x71},
    { 18,0x00},
    { 19,0x00},
    { 20,0x40},
    { 21,0x60},
    { 22,0x00},
    { 23,0x00},
    { 24,0x00},
    { 25,0xE2},
    { 26,0x00},
    { 27,0x00},
    { 28,0x00},
    { 29,0xC6},
    { 30,0x00},
    { 31,0x00},
    { 32,0x00},
    { 33,0x87},
    { 34,0x00},
    { 35,0x00},
    { 36,0x00},
    { 37,0x0F},
    { 38,0x00},
    { 39,0x00},
    { 40,0x00},
    { 41,0x0A},
    { 42,0x00},
    { 43,0x00},
    { 44,0x00},
    { 45,0x02},
    { 46,0x00},
    { 47,0x00},
    { 48,0x01},
    { 49,0x81},
    { 50,0x00},
    { 51,0x00},
    { 52,0x18},
    { 53,0x89},
    { 54,0x00},
    { 55,0x00},
    { 56,0x07},
    { 57,0xFB},
    { 58,0x00},
    { 59,0x00},
    { 60,0x03},
    { 61,0xBE},
    { 62,0x00},
    { 63,0x00},
    { 64,0x00},
    { 65,0x49},
    { 66,0x00},
    { 67,0x00},
    { 68,0xFF},
    { 69,0xF2},
    { 70,0x00},
    { 71,0x00},
    { 72,0xF9},
    { 73,0xBA},
    { 74,0x00},
    { 75,0x00},
    { 76,0xF9},
    { 77,0x00},
    { 78,0x00},
    { 79,0x00},
    { 80,0xFF},
    { 81,0x68},
    { 82,0x00},
    { 83,0x00},
    { 84,0xFE},
    { 85,0x2C},
    { 86,0x00},
    { 87,0x00},
    { 88,0xEB},
    { 89,0x8D},
    { 90,0x00},
    { 91,0x00},
    { 92,0x03},
    { 93,0x83},
    { 94,0x00},
    { 95,0x00},
    { 96,0x01},
    { 97,0xC3},
    { 98,0x00},
    { 99,0x00},
    {100,0x00},
    {101,0xD3},
    {102,0x00},
    {103,0x00},
    {104,0x00},
    {105,0x33},
    {106,0x00},
    {107,0x00},
    {108,0x00},
    {109,0x02},
    {110,0x00},
    {111,0x00},
    {112,0x32},
    {113,0x08},
    {114,0x00},
    {115,0x00},
    {116,0x0A},
    {117,0xFA},
    {118,0x00},
    {119,0x00},
    {120,0x54},
    {121,0x7B},
    {122,0x00},
    {123,0x00},
    {124,0xFF},
    {125,0x6B},
    {126,0x00},
    {127,0x00},
    {  0,0x0A},
    {  8,0xFF},
    {  9,0x03},
    { 10,0x00},
    { 11,0x00},
    { 12,0xFC},
    { 13,0xC6},
    { 14,0x00},
    { 15,0x00},
    { 16,0xF5},
    { 17,0x54},
    { 18,0x00},
    { 19,0x00},
    { 20,0xF9},
    { 21,0x64},
    { 22,0x00},
    { 23,0x00},
    { 24,0x39},
    { 25,0x80},
    { 26,0x00},
    { 27,0x00},
    { 28,0x03},
    { 29,0x1C},
    { 30,0x00},
    { 31,0x00},
    { 32,0x03},
    { 33,0x2F},
    { 34,0x00},
    { 35,0x00},
    { 36,0x00},
    { 37,0x67},
    { 38,0x00},
    { 39,0x00},
    { 40,0x0F},
    { 41,0x73},
    { 42,0x00},
    { 43,0x00},
    { 44,0x2C},
    { 45,0x2B},
    { 46,0x00},
    { 47,0x00},
    { 48,0x00},
    { 49,0x00},
    { 50,0x51},
    { 51,0x00},
    { 52,0x00},
    { 53,0x00},
    { 54,0xAE},
    { 55,0x00},
    { 56,0x00},
    { 57,0x00},
    { 58,0x5B},
    { 59,0x00},
    {  0,0x1A},
    {  8,0x00},
    {  9,0xB7},
    { 10,0x98},
    { 11,0x00},
    { 12,0x7E},
    { 13,0x90},
    { 14,0xD0},
    { 15,0x00},
    { 16,0x7F},
    { 17,0xFF},
    { 18,0xFF},
    { 19,0x00},
    { 20,0x00},
    { 21,0x00},
    { 22,0x00},
    { 23,0x00},
    { 24,0x00},
    { 25,0x00},
    { 26,0x00},
    { 27,0x00},
    { 28,0xFF},
    { 29,0xFF},
    { 30,0xFF},
    { 31,0x00},
    { 32,0x80},
    { 33,0x00},
    { 34,0x00},
    { 35,0x00},
    { 36,0x7F},
    { 37,0xFF},
    { 38,0xFF},
    { 39,0x00},
    { 40,0x40},
    { 41,0x00},
    { 42,0x00},
    { 43,0x00},
    { 44,0x00},
    { 45,0x00},
    { 46,0x00},
    { 47,0x00},
    { 48,0xFF},
    { 49,0x9E},
    { 50,0x00},
    { 51,0x00},
    { 52,0xF7},
    { 53,0x10},
    { 54,0x00},
    { 55,0x00},
    { 56,0x26},
    { 57,0xF0},
    { 58,0x00},
    { 59,0x00},
    { 60,0x02},
    { 61,0x61},
    { 62,0x00},
    { 63,0x00},
    { 64,0x40},
    { 65,0x02},
    { 66,0x00},
    { 67,0x00},
    { 68,0xFF},
    { 69,0xFC},
    { 70,0x00},
    { 71,0x00},
    { 72,0xFF},
    { 73,0xFD},
    { 74,0x00},
    { 75,0x00},
    { 76,0xFF},
    { 77,0xE5},
    { 78,0x00},
    { 79,0x00},
    { 80,0xFF},
    { 81,0xA7},
    { 82,0x00},
    { 83,0x00},
    { 84,0xFF},
    { 85,0xC7},
    { 86,0x00},
    { 87,0x00},
    { 88,0xFF},
    { 89,0xCE},
    { 90,0x00},
    { 91,0x00},
    { 92,0xFF},
    { 93,0xFE},
    { 94,0x00},
    { 95,0x00},
    { 96,0xFE},
    { 97,0xF7},
    { 98,0x00},
    { 99,0x00},
    {100,0xFF},
    {101,0x46},
    {102,0x00},
    {103,0x00},
    {104,0xFF},
    {105,0x22},
    {106,0x00},
    {107,0x00},
    {108,0xFF},
    {109,0x0F},
    {110,0x00},
    {111,0x00},
    {112,0xFA},
    {113,0x8C},
    {114,0x00},
    {115,0x00},
    {116,0xF5},
    {117,0x08},
    {118,0x00},
    {119,0x00},
    {120,0xFD},
    {121,0x92},
    {122,0x00},
    {123,0x00},
    {124,0xF3},
    {125,0xA3},
    {126,0x00},
    {127,0x00},
    {  0,0x1B},
    {  8,0x03},
    {  9,0xB3},
    { 10,0x00},
    { 11,0x00},
    { 12,0x00},
    { 13,0x33},
    { 14,0x00},
    { 15,0x00},
    { 16,0x00},
    { 17,0x71},
    { 18,0x00},
    { 19,0x00},
    { 20,0x40},
    { 21,0x60},
    { 22,0x00},
    { 23,0x00},
    { 24,0x00},
    { 25,0xE2},
    { 26,0x00},
    { 27,0x00},
    { 28,0x00},
    { 29,0xC6},
    { 30,0x00},
    { 31,0x00},
    { 32,0x00},
    { 33,0x87},
    { 34,0x00},
    { 35,0x00},
    { 36,0x00},
    { 37,0x0F},
    { 38,0x00},
    { 39,0x00},
    { 40,0x00},
    { 41,0x0A},
    { 42,0x00},
    { 43,0x00},
    { 44,0x00},
    { 45,0x02},
    { 46,0x00},
    { 47,0x00},
    { 48,0x01},
    { 49,0x81},
    { 50,0x00},
    { 51,0x00},
    { 52,0x18},
    { 53,0x89},
    { 54,0x00},
    { 55,0x00},
    { 56,0x07},
    { 57,0xFB},
    { 58,0x00},
    { 59,0x00},
    { 60,0x03},
    { 61,0xBE},
    { 62,0x00},
    { 63,0x00},
    { 64,0x00},
    { 65,0x49},
    { 66,0x00},
    { 67,0x00},
    { 68,0xFF},
    { 69,0xF2},
    { 70,0x00},
    { 71,0x00},
    { 72,0xF9},
    { 73,0xBA},
    { 74,0x00},
    { 75,0x00},
    { 76,0xF9},
    { 77,0x00},
    { 78,0x00},
    { 79,0x00},
    { 80,0xFF},
    { 81,0x68},
    { 82,0x00},
    { 83,0x00},
    { 84,0xFE},
    { 85,0x2C},
    { 86,0x00},
    { 87,0x00},
    { 88,0xEB},
    { 89,0x8D},
    { 90,0x00},
    { 91,0x00},
    { 92,0x03},
    { 93,0x83},
    { 94,0x00},
    { 95,0x00},
    { 96,0x01},
    { 97,0xC3},
    { 98,0x00},
    { 99,0x00},
    {100,0x00},
    {101,0xD3},
    {102,0x00},
    {103,0x00},
    {104,0x00},
    {105,0x33},
    {106,0x00},
    {107,0x00},
    {108,0x00},
    {109,0x02},
    {110,0x00},
    {111,0x00},
    {112,0x32},
    {113,0x08},
    {114,0x00},
    {115,0x00},
    {116,0x0A},
    {117,0xFA},
    {118,0x00},
    {119,0x00},
    {120,0x54},
    {121,0x7B},
    {122,0x00},
    {123,0x00},
    {124,0xFF},
    {125,0x6B},
    {126,0x00},
    {127,0x00},
    {  0,0x1C},
    {  8,0xFF},
    {  9,0x03},
    { 10,0x00},
    { 11,0x00},
    { 12,0xFC},
    { 13,0xC6},
    { 14,0x00},
    { 15,0x00},
    { 16,0xF5},
    { 17,0x54},
    { 18,0x00},
    { 19,0x00},
    { 20,0xF9},
    { 21,0x64},
    { 22,0x00},
    { 23,0x00},
    { 24,0x39},
    { 25,0x80},
    { 26,0x00},
    { 27,0x00},
    { 28,0x03},
    { 29,0x1C},
    { 30,0x00},
    { 31,0x00},
    { 32,0x03},
    { 33,0x2F},
    { 34,0x00},
    { 35,0x00},
    { 36,0x00},
    { 37,0x67},
    { 38,0x00},
    { 39,0x00},
    { 40,0x0F},
    { 41,0x73},
    { 42,0x00},
    { 43,0x00},
    { 44,0x2C},
    { 45,0x2B},
    { 46,0x00},
    { 47,0x00},
    { 48,0x00},
    { 49,0x00},
    { 50,0x51},
    { 51,0x00},
    { 52,0x00},
    { 53,0x00},
    { 54,0xAE},
    { 55,0x00},
    { 56,0x00},
    { 57,0x00},
    { 58,0x5B},
    { 59,0x00},
    {  0,0x50},
    {  8,0x31},
    {  9,0x1B},
    { 10,0xFB},
    { 11,0x00},
    { 12,0x00},
    { 13,0x00},
    { 14,0x00},
    { 15,0x00},
    { 16,0x38},
    { 17,0x17},
    { 18,0xFB},
    { 19,0x00},
    { 20,0x88},
    { 21,0x17},
    { 22,0xFE},
    { 23,0x00},
    { 24,0x30},
    { 25,0x38},
    { 26,0x0C},
    { 27,0x00},
    { 28,0x38},
    { 29,0x34},
    { 30,0x07},
    { 31,0x00},
    { 32,0x38},
    { 33,0x34},
    { 34,0x03},
    { 35,0x00},
    { 36,0x38},
    { 37,0x30},
    { 38,0x08},
    { 39,0x00},
    { 40,0x38},
    { 41,0x30},
    { 42,0x02},
    { 43,0x00},
    { 44,0x38},
    { 45,0x2C},
    { 46,0x01},
    { 47,0x00},
    { 48,0x38},
    { 49,0x2C},
    { 50,0x09},
    { 51,0x00},
    { 52,0x38},
    { 53,0x28},
    { 54,0x0A},
    { 55,0x00},
    { 56,0xF0},
    { 57,0x28},
    { 58,0x00},
    { 59,0x00},
    { 60,0x30},
    { 61,0x28},
    { 62,0x59},
    { 63,0x00},
    { 64,0xF8},
    { 65,0x28},
    { 66,0x4F},
    { 67,0x00},
    { 68,0x20},
    { 69,0x00},
    { 70,0x2A},
    { 71,0x00},
    { 72,0x38},
    { 73,0x2C},
    { 74,0x50},
    { 75,0x00},
    { 76,0x38},
    { 77,0x2C},
    { 78,0x58},
    { 79,0x00},
    { 80,0x38},
    { 81,0x30},
    { 82,0x57},
    { 83,0x00},
    { 84,0x38},
    { 85,0x30},
    { 86,0x51},
    { 87,0x00},
    { 88,0x38},
    { 89,0x34},
    { 90,0x56},
    { 91,0x00},
    { 92,0x38},
    { 93,0x34},
    { 94,0x52},
    { 95,0x00},
    { 96,0x38},
    { 97,0x38},
    { 98,0x5B},
    { 99,0x00},
    {100,0x30},
    {101,0x3C},
    {102,0x29},
    {103,0x00},
    {104,0x38},
    {105,0x3C},
    {106,0x2A},
    {107,0x00},
    {108,0x20},
    {109,0x00},
    {110,0x79},
    {111,0x00},
    {112,0x38},
    {113,0x40},
    {114,0x0E},
    {115,0x00},
    {116,0x38},
    {117,0x40},
    {118,0x45},
    {119,0x00},
    {120,0x38},
    {121,0x44},
    {122,0x2C},
    {123,0x00},
    {124,0x38},
    {125,0x44},
    {126,0x27},
    {127,0x00},
    {  0,0x51},
    {  8,0x38},
    {  9,0x48},
    { 10,0x2E},
    { 11,0x00},
    { 12,0x38},
    { 13,0x48},
    { 14,0x25},
    { 15,0x00},
    { 16,0x38},
    { 17,0x4C},
    { 18,0x34},
    { 19,0x00},
    { 20,0x38},
    { 21,0x4C},
    { 22,0x1F},
    { 23,0x00},
    { 24,0x38},
    { 25,0x50},
    { 26,0x11},
    { 27,0x00},
    { 28,0x38},
    { 29,0x50},
    { 30,0x42},
    { 31,0x00},
    { 32,0x38},
    { 33,0x54},
    { 34,0x0F},
    { 35,0x00},
    { 36,0x38},
    { 37,0x54},
    { 38,0x44},
    { 39,0x00},
    { 40,0x38},
    { 41,0x58},
    { 42,0x35},
    { 43,0x00},
    { 44,0x38},
    { 45,0x58},
    { 46,0x1E},
    { 47,0x00},
    { 48,0x38},
    { 49,0x5C},
    { 50,0x30},
    { 51,0x00},
    { 52,0x38},
    { 53,0x5C},
    { 54,0x23},
    { 55,0x00},
    { 56,0x38},
    { 57,0x60},
    { 58,0x13},
    { 59,0x00},
    { 60,0x38},
    { 61,0x60},
    { 62,0x40},
    { 63,0x00},
    { 64,0x38},
    { 65,0x64},
    { 66,0x32},
    { 67,0x00},
    { 68,0x38},
    { 69,0x64},
    { 70,0x21},
    { 71,0x00},
    { 72,0x38},
    { 73,0x68},
    { 74,0x17},
    { 75,0x00},
    { 76,0x38},
    { 77,0x68},
    { 78,0x3C},
    { 79,0x00},
    { 80,0x38},
    { 81,0x6C},
    { 82,0x37},
    { 83,0x00},
    { 84,0x38},
    { 85,0x6C},
    { 86,0x1C},
    { 87,0x00},
    { 88,0x38},
    { 89,0x70},
    { 90,0x15},
    { 91,0x00},
    { 92,0x38},
    { 93,0x70},
    { 94,0x3E},
    { 95,0x00},
    { 96,0x38},
    { 97,0x74},
    { 98,0x19},
    { 99,0x00},
    {100,0x38},
    {101,0x74},
    {102,0x3A},
    {103,0x00},
    {104,0x38},
    {105,0x78},
    {106,0x16},
    {107,0x00},
    {108,0x38},
    {109,0x78},
    {110,0x3D},
    {111,0x00},
    {112,0x38},
    {113,0x7C},
    {114,0x2D},
    {115,0x00},
    {116,0x38},
    {117,0x7C},
    {118,0x26},
    {119,0x00},
    {120,0x38},
    {121,0x80},
    {122,0x12},
    {123,0x00},
    {124,0x38},
    {125,0x80},
    {126,0x41},
    {127,0x00},
    {  0,0x52},
    {  8,0x38},
    {  9,0x84},
    { 10,0x38},
    { 11,0x00},
    { 12,0x38},
    { 13,0x84},
    { 14,0x1B},
    { 15,0x00},
    { 16,0x38},
    { 17,0x88},
    { 18,0x31},
    { 19,0x00},
    { 20,0x38},
    { 21,0x88},
    { 22,0x22},
    { 23,0x00},
    { 24,0x38},
    { 25,0x8C},
    { 26,0x33},
    { 27,0x00},
    { 28,0x38},
    { 29,0x8C},
    { 30,0x20},
    { 31,0x00},
    { 32,0x38},
    { 33,0x90},
    { 34,0x2F},
    { 35,0x00},
    { 36,0x38},
    { 37,0x90},
    { 38,0x24},
    { 39,0x00},
    { 40,0x38},
    { 41,0x94},
    { 42,0x10},
    { 43,0x00},
    { 44,0x38},
    { 45,0x94},
    { 46,0x43},
    { 47,0x00},
    { 48,0x38},
    { 49,0x98},
    { 50,0x2B},
    { 51,0x00},
    { 52,0x38},
    { 53,0x98},
    { 54,0x28},
    { 55,0x00},
    { 56,0x38},
    { 57,0x9C},
    { 58,0x0D},
    { 59,0x00},
    { 60,0x38},
    { 61,0x9C},
    { 62,0x46},
    { 63,0x00},
    { 64,0x38},
    { 65,0xA0},
    { 66,0x14},
    { 67,0x00},
    { 68,0x38},
    { 69,0xA0},
    { 70,0x3F},
    { 71,0x00},
    { 72,0x38},
    { 73,0xA4},
    { 74,0x1A},
    { 75,0x00},
    { 76,0x38},
    { 77,0xA4},
    { 78,0x39},
    { 79,0x00},
    { 80,0x38},
    { 81,0xA8},
    { 82,0x18},
    { 83,0x00},
    { 84,0x38},
    { 85,0xA8},
    { 86,0x3B},
    { 87,0x00},
    { 88,0x38},
    { 89,0xAC},
    { 90,0x36},
    { 91,0x00},
    { 92,0x38},
    { 93,0xAC},
    { 94,0x1D},
    { 95,0x00},
    { 96,0x08},
    { 97,0x00},
    { 98,0x0A},
    { 99,0x00},
    {100,0x50},
    {101,0x04},
    {102,0x00},
    {103,0x00},
    {104,0x08},
    {105,0x04},
    {106,0x59},
    {107,0x00},
    {108,0x50},
    {109,0x00},
    {110,0x00},
    {111,0x00},
    {112,0x30},
    {113,0x0C},
    {114,0x47},
    {115,0x00},
    {116,0x38},
    {117,0x10},
    {118,0x49},
    {119,0x00},
    {120,0x98},
    {121,0x08},
    {122,0x46},
    {123,0x00},
    {124,0x60},
    {125,0x00},
    {126,0x49},
    {127,0x00},
    {  0,0x53},
    {  8,0x38},
    {  9,0x04},
    { 10,0x4B},
    { 11,0x00},
    { 12,0x28},
    { 13,0x00},
    { 14,0x48},
    { 15,0x00},
    { 16,0x68},
    { 17,0x00},
    { 18,0x48},
    { 19,0x00},
    { 20,0x00},
    { 21,0x00},
    { 22,0x00},
    { 23,0x00},
    { 24,0x18},
    { 25,0x08},
    { 26,0x00},
    { 27,0x00},
    { 28,0x28},
    { 29,0x00},
    { 30,0x4A},
    { 31,0x00},
    { 32,0x31},
    { 33,0x1F},
    { 34,0xFB},
    { 35,0x00},
    { 36,0x00},
    { 37,0x00},
    { 38,0x00},
    { 39,0x00},
    { 40,0x38},
    { 41,0x17},
    { 42,0xFB},
    { 43,0x00},
    { 44,0x88},
    { 45,0x17},
    { 46,0xFE},
    { 47,0x00},
    { 48,0x30},
    { 49,0x38},
    { 50,0x54},
    { 51,0x00},
    { 52,0x38},
    { 53,0x34},
    { 54,0x4F},
    { 55,0x00},
    { 56,0x38},
    { 57,0x34},
    { 58,0x58},
    { 59,0x00},
    { 60,0x38},
    { 61,0x30},
    { 62,0x50},
    { 63,0x00},
    { 64,0x38},
    { 65,0x30},
    { 66,0x57},
    { 67,0x00},
    { 68,0x38},
    { 69,0x2C},
    { 70,0x56},
    { 71,0x00},
    { 72,0x38},
    { 73,0x2C},
    { 74,0x51},
    { 75,0x00},
    { 76,0x38},
    { 77,0x28},
    { 78,0x52},
    { 79,0x00},
    { 80,0xF8},
    { 81,0x28},
    { 82,0x55},
    { 83,0x00},
    { 84,0x30},
    { 85,0x28},
    { 86,0x03},
    { 87,0x00},
    { 88,0xF0},
    { 89,0x28},
    { 90,0x06},
    { 91,0x00},
    { 92,0x20},
    { 93,0x00},
    { 94,0x5B},
    { 95,0x00},
    { 96,0x38},
    { 97,0x2C},
    { 98,0x07},
    { 99,0x00},
    {100,0x38},
    {101,0x2C},
    {102,0x02},
    {103,0x00},
    {104,0x38},
    {105,0x30},
    {106,0x01},
    {107,0x00},
    {108,0x38},
    {109,0x30},
    {110,0x08},
    {111,0x00},
    {112,0x38},
    {113,0x34},
    {114,0x00},
    {115,0x00},
    {116,0x38},
    {117,0x34},
    {118,0x09},
    {119,0x00},
    {120,0x38},
    {121,0x38},
    {122,0x05},
    {123,0x00},
    {124,0x30},
    {125,0x3C},
    {126,0x78},
    {127,0x00},
    {  0,0x54},
    {  8,0x38},
    {  9,0x3C},
    { 10,0x79},
    { 11,0x00},
    { 12,0x20},
    { 13,0x00},
    { 14,0x0C},
    { 15,0x00},
    { 16,0x38},
    { 17,0x40},
    { 18,0x5D},
    { 19,0x00},
    { 20,0x38},
    { 21,0x40},
    { 22,0x94},
    { 23,0x00},
    { 24,0x38},
    { 25,0x44},
    { 26,0x7B},
    { 27,0x00},
    { 28,0x38},
    { 29,0x44},
    { 30,0x76},
    { 31,0x00},
    { 32,0x38},
    { 33,0x48},
    { 34,0x7D},
    { 35,0x00},
    { 36,0x38},
    { 37,0x48},
    { 38,0x74},
    { 39,0x00},
    { 40,0x38},
    { 41,0x4C},
    { 42,0x83},
    { 43,0x00},
    { 44,0x38},
    { 45,0x4C},
    { 46,0x6E},
    { 47,0x00},
    { 48,0x38},
    { 49,0x50},
    { 50,0x60},
    { 51,0x00},
    { 52,0x38},
    { 53,0x50},
    { 54,0x91},
    { 55,0x00},
    { 56,0x38},
    { 57,0x54},
    { 58,0x5E},
    { 59,0x00},
    { 60,0x38},
    { 61,0x54},
    { 62,0x93},
    { 63,0x00},
    { 64,0x38},
    { 65,0x58},
    { 66,0x84},
    { 67,0x00},
    { 68,0x38},
    { 69,0x58},
    { 70,0x6D},
    { 71,0x00},
    { 72,0x38},
    { 73,0x5C},
    { 74,0x7F},
    { 75,0x00},
    { 76,0x38},
    { 77,0x5C},
    { 78,0x72},
    { 79,0x00},
    { 80,0x38},
    { 81,0x60},
    { 82,0x62},
    { 83,0x00},
    { 84,0x38},
    { 85,0x60},
    { 86,0x8F},
    { 87,0x00},
    { 88,0x38},
    { 89,0x64},
    { 90,0x81},
    { 91,0x00},
    { 92,0x38},
    { 93,0x64},
    { 94,0x70},
    { 95,0x00},
    { 96,0x38},
    { 97,0x68},
    { 98,0x66},
    { 99,0x00},
    {100,0x38},
    {101,0x68},
    {102,0x8B},
    {103,0x00},
    {104,0x38},
    {105,0x6C},
    {106,0x86},
    {107,0x00},
    {108,0x38},
    {109,0x6C},
    {110,0x6B},
    {111,0x00},
    {112,0x38},
    {113,0x70},
    {114,0x64},
    {115,0x00},
    {116,0x38},
    {117,0x70},
    {118,0x8D},
    {119,0x00},
    {120,0x38},
    {121,0x74},
    {122,0x68},
    {123,0x00},
    {124,0x38},
    {125,0x74},
    {126,0x89},
    {127,0x00},
    {  0,0x55},
    {  8,0x38},
    {  9,0x78},
    { 10,0x65},
    { 11,0x00},
    { 12,0x38},
    { 13,0x78},
    { 14,0x8C},
    { 15,0x00},
    { 16,0x38},
    { 17,0x7C},
    { 18,0x7C},
    { 19,0x00},
    { 20,0x38},
    { 21,0x7C},
    { 22,0x75},
    { 23,0x00},
    { 24,0x38},
    { 25,0x80},
    { 26,0x61},
    { 27,0x00},
    { 28,0x38},
    { 29,0x80},
    { 30,0x90},
    { 31,0x00},
    { 32,0x38},
    { 33,0x84},
    { 34,0x87},
    { 35,0x00},
    { 36,0x38},
    { 37,0x84},
    { 38,0x6A},
    { 39,0x00},
    { 40,0x38},
    { 41,0x88},
    { 42,0x80},
    { 43,0x00},
    { 44,0x38},
    { 45,0x88},
    { 46,0x71},
    { 47,0x00},
    { 48,0x38},
    { 49,0x8C},
    { 50,0x82},
    { 51,0x00},
    { 52,0x38},
    { 53,0x8C},
    { 54,0x6F},
    { 55,0x00},
    { 56,0x38},
    { 57,0x90},
    { 58,0x7E},
    { 59,0x00},
    { 60,0x38},
    { 61,0x90},
    { 62,0x73},
    { 63,0x00},
    { 64,0x38},
    { 65,0x94},
    { 66,0x5F},
    { 67,0x00},
    { 68,0x38},
    { 69,0x94},
    { 70,0x92},
    { 71,0x00},
    { 72,0x38},
    { 73,0x98},
    { 74,0x7A},
    { 75,0x00},
    { 76,0x38},
    { 77,0x98},
    { 78,0x77},
    { 79,0x00},
    { 80,0x38},
    { 81,0x9C},
    { 82,0x5C},
    { 83,0x00},
    { 84,0x38},
    { 85,0x9C},
    { 86,0x95},
    { 87,0x00},
    { 88,0x38},
    { 89,0xA0},
    { 90,0x63},
    { 91,0x00},
    { 92,0x38},
    { 93,0xA0},
    { 94,0x8E},
    { 95,0x00},
    { 96,0x38},
    { 97,0xA4},
    { 98,0x69},
    { 99,0x00},
    {100,0x38},
    {101,0xA4},
    {102,0x88},
    {103,0x00},
    {104,0x38},
    {105,0xA8},
    {106,0x67},
    {107,0x00},
    {108,0x38},
    {109,0xA8},
    {110,0x8A},
    {111,0x00},
    {112,0x38},
    {113,0xAC},
    {114,0x85},
    {115,0x00},
    {116,0x38},
    {117,0xAC},
    {118,0x6C},
    {119,0x00},
    {120,0x00},
    {121,0x00},
    {122,0x00},
    {123,0x00},
    {124,0x50},
    {125,0x0C},
    {126,0x00},
    {127,0x00},
    {  0,0x56},
    {  8,0x00},
    {  9,0x00},
    { 10,0x00},
    { 11,0x00},
    { 12,0x50},
    { 13,0x08},
    { 14,0x00},
    { 15,0x00},
    { 16,0x30},
    { 17,0x0C},
    { 18,0x96},
    { 19,0x00},
    { 20,0x38},
    { 21,0x10},
    { 22,0x98},
    { 23,0x00},
    { 24,0x98},
    { 25,0x08},
    { 26,0x95},
    { 27,0x00},
    { 28,0x60},
    { 29,0x00},
    { 30,0x98},
    { 31,0x00},
    { 32,0x38},
    { 33,0x04},
    { 34,0x9A},
    { 35,0x00},
    { 36,0x28},
    { 37,0x00},
    { 38,0x97},
    { 39,0x00},
    { 40,0x68},
    { 41,0x00},
    { 42,0x97},
    { 43,0x00},
    { 44,0x58},
    { 45,0x14},
    { 46,0x97},
    { 47,0x00},
    { 48,0x18},
    { 49,0x0C},
    { 50,0x00},
    { 51,0x00},
    { 52,0x28},
    { 53,0x00},
    { 54,0x99},
    { 55,0x00},
    { 56,0x58},
    { 57,0x10},
    { 58,0x48},
    { 59,0x00},
    { 60,0x00},
    { 61,0x00},
    { 62,0x00},
    { 63,0x00},
    { 64,0x20},
    { 65,0xFC},
    { 66,0x9C},
    { 67,0x00},
    { 68,0x20},
    { 69,0xFC},
    { 70,0x4D},
    { 71,0x00},
    { 72,0x31},
    { 73,0x23},
    { 74,0xFB},
    { 75,0x00},
    { 76,0x00},
    { 77,0x00},
    { 78,0x00},
    { 79,0x00},
    { 80,0x38},
    { 81,0x17},
    { 82,0xFB},
    { 83,0x00},
    { 84,0x88},
    { 85,0x17},
    { 86,0xFE},
    { 87,0x00},
    { 88,0x10},
    { 89,0x10},
    { 90,0x4E},
    { 91,0x00},
    { 92,0x10},
    { 93,0x14},
    { 94,0x9D},
    { 95,0x00},
    { 96,0x08},
    { 97,0x00},
    { 98,0x03},
    { 99,0x00},
    {100,0x08},
    {101,0x04},
    {102,0x52},
    {103,0x00},
    {104,0x00},
    {105,0x00},
    {106,0x00},
    {107,0x00},
    {108,0x88},
    {109,0x03},
    {110,0xFF},
    {111,0x00},
};
#define miniDSP_A_reg_values_COEFF_START   0
#define miniDSP_A_reg_values_COEFF_SIZE    590
#define miniDSP_A_reg_values_INST_START    590
#define miniDSP_A_reg_values_INST_SIZE     831

reg_value miniDSP_D_reg_values[] = {
    {  0,0x2C},
    {  8,0xFF},
    {  9,0xFF},
    { 10,0xFF},
    { 11,0x00},
    { 12,0x80},
    { 13,0x00},
    { 14,0x00},
    { 15,0x00},
    { 16,0x7F},
    { 17,0xF7},
    { 18,0x00},
    { 19,0x00},
    { 20,0x80},
    { 21,0x09},
    { 22,0x00},
    { 23,0x00},
    { 24,0x7F},
    { 25,0xEF},
    { 26,0x00},
    { 27,0x00},
    { 28,0x00},
    { 29,0x00},
    { 30,0x00},
    { 31,0x00},
    { 32,0x00},
    { 33,0x00},
    { 34,0x00},
    { 35,0x00},
    { 36,0x00},
    { 37,0x00},
    { 38,0x00},
    { 39,0x00},
    { 40,0x00},
    { 41,0x00},
    { 42,0x00},
    { 43,0x00},
    { 44,0x00},
    { 45,0x00},
    { 46,0x00},
    { 47,0x00},
    { 48,0x00},
    { 49,0x00},
    { 50,0x00},
    { 51,0x00},
    { 52,0x00},
    { 53,0x00},
    { 54,0x00},
    { 55,0x00},
    { 56,0x40},
    { 57,0x00},
    { 58,0x00},
    { 59,0x00},
    { 60,0x7F},
    { 61,0xFF},
    { 62,0xFF},
    { 63,0x00},
    { 64,0x00},
    { 65,0x00},
    { 66,0x00},
    { 67,0x00},
    { 68,0x40},
    { 69,0x00},
    { 70,0x00},
    { 71,0x00},
    { 72,0xFB},
    { 73,0x00},
    { 74,0x00},
    { 75,0x00},
    { 76,0x01},
    { 77,0x00},
    { 78,0x00},
    { 79,0x00},
    { 80,0x00},
    { 81,0x00},
    { 82,0x00},
    { 83,0x00},
    { 84,0x00},
    { 85,0x00},
    { 86,0x00},
    { 87,0x00},
    { 88,0x00},
    { 89,0x00},
    { 90,0x00},
    { 91,0x00},
    { 92,0x00},
    { 93,0x00},
    { 94,0x00},
    { 95,0x00},
    { 96,0x00},
    { 97,0x0A},
    { 98,0x3D},
    { 99,0x00},
    {100,0xFF},
    {101,0xF5},
    {102,0xC3},
    {103,0x00},
    {104,0x80},
    {105,0x00},
    {106,0x00},
    {107,0x00},
    {108,0xB8},
    {109,0x8C},
    {110,0x96},
    {111,0x00},
    {112,0x6B},
    {113,0x2D},
    {114,0x1E},
    {115,0x00},
    {116,0x5C},
    {117,0x46},
    {118,0x4B},
    {119,0x00},
    {120,0x15},
    {121,0x55},
    {122,0x55},
    {123,0x00},
    {124,0x40},
    {125,0x00},
    {126,0x00},
    {127,0x00},
    {  0,0x2D},
    {  8,0x00},
    {  9,0x00},
    { 10,0x00},
    { 11,0x00},
    { 12,0x00},
    { 13,0x00},
    { 14,0x00},
    { 15,0x00},
    { 16,0x00},
    { 17,0x00},
    { 18,0x00},
    { 19,0x00},
    { 20,0x00},
    { 21,0x00},
    { 22,0x00},
    { 23,0x00},
    { 24,0x00},
    { 25,0x00},
    { 26,0x00},
    { 27,0x00},
    { 28,0x00},
    { 29,0x00},
    { 30,0x00},
    { 31,0x00},
    { 32,0x80},
    { 33,0x00},
    { 34,0x00},
    { 35,0x00},
    { 36,0xE0},
    { 37,0x00},
    { 38,0x00},
    { 39,0x00},
    { 40,0x30},
    { 41,0x00},
    { 42,0x00},
    { 43,0x00},
    { 44,0x20},
    { 45,0x00},
    { 46,0x00},
    { 47,0x00},
    { 48,0x50},
    { 49,0x00},
    { 50,0x00},
    { 51,0x00},
    { 52,0x20},
    { 53,0x2B},
    { 54,0x6A},
    { 55,0x00},
    { 56,0xE0},
    { 57,0x0F},
    { 58,0xDC},
    { 59,0x00},
    { 60,0x1F},
    { 61,0xB7},
    { 62,0x75},
    { 63,0x00},
    { 64,0x1F},
    { 65,0xF0},
    { 66,0x24},
    { 67,0x00},
    { 68,0xE0},
    { 69,0x1D},
    { 70,0x21},
    { 71,0x00},
    { 72,0xE0},
    { 73,0x00},
    { 74,0x00},
    { 75,0x00},
    { 76,0x20},
    { 77,0x5A},
    { 78,0xD2},
    { 79,0x00},
    { 80,0xE0},
    { 81,0x24},
    { 82,0x27},
    { 83,0x00},
    { 84,0x1F},
    { 85,0x68},
    { 86,0x3F},
    { 87,0x00},
    { 88,0x1F},
    { 89,0xDB},
    { 90,0xD9},
    { 91,0x00},
    { 92,0xE0},
    { 93,0x3C},
    { 94,0xEF},
    { 95,0x00},
    { 96,0xE0},
    { 97,0x00},
    { 98,0x00},
    { 99,0x00},
    {100,0x20},
    {101,0xBD},
    {102,0x8A},
    {103,0x00},
    {104,0xE0},
    {105,0x58},
    {106,0x6F},
    {107,0x00},
    {108,0x1E},
    {109,0xC3},
    {110,0x4C},
    {111,0x00},
    {112,0x1F},
    {113,0xA7},
    {114,0x91},
    {115,0x00},
    {116,0xE0},
    {117,0x7F},
    {118,0x2A},
    {119,0x00},
    {120,0xE0},
    {121,0x00},
    {122,0x00},
    {123,0x00},
    {124,0x21},
    {125,0x89},
    {126,0xB7},
    {127,0x00},
    {  0,0x2E},
    {  8,0xE0},
    {  9,0xF0},
    { 10,0x05},
    { 11,0x00},
    { 12,0x1D},
    { 13,0x6E},
    { 14,0x24},
    { 15,0x00},
    { 16,0x1F},
    { 17,0x0F},
    { 18,0xFB},
    { 19,0x00},
    { 20,0xE1},
    { 21,0x08},
    { 22,0x25},
    { 23,0x00},
    { 24,0xE0},
    { 25,0x00},
    { 26,0x00},
    { 27,0x00},
    { 28,0x23},
    { 29,0x29},
    { 30,0xB4},
    { 31,0x00},
    { 32,0xE2},
    { 33,0xDC},
    { 34,0x70},
    { 35,0x00},
    { 36,0x1A},
    { 37,0xB7},
    { 38,0x11},
    { 39,0x00},
    { 40,0x1D},
    { 41,0x23},
    { 42,0x90},
    { 43,0x00},
    { 44,0xE2},
    { 45,0x1F},
    { 46,0x3B},
    { 47,0x00},
    { 48,0xE0},
    { 49,0x00},
    { 50,0x00},
    { 51,0x00},
    { 52,0x26},
    { 53,0x65},
    { 54,0x8A},
    { 55,0x00},
    { 56,0xE9},
    { 57,0x81},
    { 58,0xA5},
    { 59,0x00},
    { 60,0x15},
    { 61,0x4F},
    { 62,0xD6},
    { 63,0x00},
    { 64,0x16},
    { 65,0x7E},
    { 66,0x5B},
    { 67,0x00},
    { 68,0xE4},
    { 69,0x4A},
    { 70,0xA0},
    { 71,0x00},
    { 72,0xE0},
    { 73,0x00},
    { 74,0x00},
    { 75,0x00},
    { 76,0x2C},
    { 77,0x88},
    { 78,0xAC},
    { 79,0x00},
    { 80,0xFE},
    { 81,0x11},
    { 82,0xA9},
    { 83,0x00},
    { 84,0x0B},
    { 85,0x0E},
    { 86,0xA2},
    { 87,0x00},
    { 88,0x01},
    { 89,0xEE},
    { 90,0x57},
    { 91,0x00},
    { 92,0xE8},
    { 93,0x68},
    { 94,0xB2},
    { 95,0x00},
    { 96,0xE0},
    { 97,0x00},
    { 98,0x00},
    { 99,0x00},
    {100,0x00},
    {101,0x0D},
    {102,0x00},
    {103,0x00},
    {104,0x00},
    {105,0x1C},
    {106,0x00},
    {107,0x00},
    {108,0x00},
    {109,0x3E},
    {110,0x00},
    {111,0x00},
    {112,0x00},
    {113,0x78},
    {114,0x00},
    {115,0x00},
    {116,0x02},
    {117,0x4C},
    {118,0x00},
    {119,0x00},
    {120,0x00},
    {121,0xD5},
    {122,0x00},
    {123,0x00},
    {124,0x01},
    {125,0x65},
    {126,0x00},
    {127,0x00},
    {  0,0x2F},
    {  8,0x03},
    {  9,0xE9},
    { 10,0x00},
    { 11,0x00},
    { 12,0x07},
    { 13,0xCA},
    { 14,0x00},
    { 15,0x00},
    { 16,0xFF},
    { 17,0xEF},
    { 18,0x00},
    { 19,0x00},
    { 20,0xFE},
    { 21,0xEB},
    { 22,0x00},
    { 23,0x00},
    { 24,0xFF},
    { 25,0xA8},
    { 26,0x00},
    { 27,0x00},
    { 28,0xFD},
    { 29,0x08},
    { 30,0x00},
    { 31,0x00},
    { 32,0xFF},
    { 33,0x5E},
    { 34,0x00},
    { 35,0x00},
    { 36,0xFF},
    { 37,0xD5},
    { 38,0x00},
    { 39,0x00},
    { 40,0xFE},
    { 41,0x36},
    { 42,0x00},
    { 43,0x00},
    { 44,0xFA},
    { 45,0xAC},
    { 46,0x00},
    { 47,0x00},
    { 48,0xF2},
    { 49,0xA3},
    { 50,0x00},
    { 51,0x00},
    { 52,0x28},
    { 53,0xAB},
    { 54,0x00},
    { 55,0x00},
    { 56,0x3F},
    { 57,0xFF},
    { 58,0x00},
    { 59,0x00},
    { 60,0xFF},
    { 61,0x98},
    { 62,0x00},
    { 63,0x00},
    { 64,0xF6},
    { 65,0xF9},
    { 66,0x00},
    { 67,0x00},
    { 68,0x26},
    { 69,0xFB},
    { 70,0x00},
    { 71,0x00},
    { 72,0x02},
    { 73,0x72},
    { 74,0x00},
    { 75,0x00},
    { 76,0x40},
    { 77,0x02},
    { 78,0x00},
    { 79,0x00},
    { 80,0xFB},
    { 81,0xCB},
    { 82,0x00},
    { 83,0x00},
    { 84,0x20},
    { 85,0xA7},
    { 86,0x00},
    { 87,0x00},
    { 88,0xFF},
    { 89,0x6A},
    { 90,0x00},
    { 91,0x00},
    { 92,0x3A},
    { 93,0x0F},
    { 94,0x00},
    { 95,0x00},
    { 96,0x00},
    { 97,0x00},
    { 98,0x18},
    { 99,0x00},
    {100,0x00},
    {101,0x00},
    {102,0x09},
    {103,0x00},
    {104,0x00},
    {105,0x00},
    {106,0x05},
    {107,0x00},
    {108,0x00},
    {109,0x00},
    {110,0x10},
    {111,0x00},
    {112,0x00},
    {113,0x00},
    {114,0x34},
    {115,0x00},
    {116,0x00},
    {117,0x00},
    {118,0x17},
    {119,0x00},
    {  0,0x3E},
    {  8,0xFF},
    {  9,0xFF},
    { 10,0xFF},
    { 11,0x00},
    { 12,0x80},
    { 13,0x00},
    { 14,0x00},
    { 15,0x00},
    { 16,0x7F},
    { 17,0xF7},
    { 18,0x00},
    { 19,0x00},
    { 20,0x80},
    { 21,0x09},
    { 22,0x00},
    { 23,0x00},
    { 24,0x7F},
    { 25,0xEF},
    { 26,0x00},
    { 27,0x00},
    { 28,0x00},
    { 29,0x00},
    { 30,0x00},
    { 31,0x00},
    { 32,0x00},
    { 33,0x00},
    { 34,0x00},
    { 35,0x00},
    { 36,0x00},
    { 37,0x00},
    { 38,0x00},
    { 39,0x00},
    { 40,0x00},
    { 41,0x00},
    { 42,0x00},
    { 43,0x00},
    { 44,0x00},
    { 45,0x00},
    { 46,0x00},
    { 47,0x00},
    { 48,0x00},
    { 49,0x00},
    { 50,0x00},
    { 51,0x00},
    { 52,0x00},
    { 53,0x00},
    { 54,0x00},
    { 55,0x00},
    { 56,0x40},
    { 57,0x00},
    { 58,0x00},
    { 59,0x00},
    { 60,0x7F},
    { 61,0xFF},
    { 62,0xFF},
    { 63,0x00},
    { 64,0x00},
    { 65,0x00},
    { 66,0x00},
    { 67,0x00},
    { 68,0x40},
    { 69,0x00},
    { 70,0x00},
    { 71,0x00},
    { 72,0xFB},
    { 73,0x00},
    { 74,0x00},
    { 75,0x00},
    { 76,0x01},
    { 77,0x00},
    { 78,0x00},
    { 79,0x00},
    { 80,0x00},
    { 81,0x00},
    { 82,0x00},
    { 83,0x00},
    { 84,0x00},
    { 85,0x00},
    { 86,0x00},
    { 87,0x00},
    { 88,0x00},
    { 89,0x00},
    { 90,0x00},
    { 91,0x00},
    { 92,0x00},
    { 93,0x00},
    { 94,0x00},
    { 95,0x00},
    { 96,0x00},
    { 97,0x0A},
    { 98,0x3D},
    { 99,0x00},
    {100,0xFF},
    {101,0xF5},
    {102,0xC3},
    {103,0x00},
    {104,0x80},
    {105,0x00},
    {106,0x00},
    {107,0x00},
    {108,0xB8},
    {109,0x8C},
    {110,0x96},
    {111,0x00},
    {112,0x6B},
    {113,0x2D},
    {114,0x1E},
    {115,0x00},
    {116,0x5C},
    {117,0x46},
    {118,0x4B},
    {119,0x00},
    {120,0x15},
    {121,0x55},
    {122,0x55},
    {123,0x00},
    {124,0x40},
    {125,0x00},
    {126,0x00},
    {127,0x00},
    {  0,0x3F},
    {  8,0x00},
    {  9,0x00},
    { 10,0x00},
    { 11,0x00},
    { 12,0x00},
    { 13,0x00},
    { 14,0x00},
    { 15,0x00},
    { 16,0x00},
    { 17,0x00},
    { 18,0x00},
    { 19,0x00},
    { 20,0x00},
    { 21,0x00},
    { 22,0x00},
    { 23,0x00},
    { 24,0x00},
    { 25,0x00},
    { 26,0x00},
    { 27,0x00},
    { 28,0x00},
    { 29,0x00},
    { 30,0x00},
    { 31,0x00},
    { 32,0x80},
    { 33,0x00},
    { 34,0x00},
    { 35,0x00},
    { 36,0xE0},
    { 37,0x00},
    { 38,0x00},
    { 39,0x00},
    { 40,0x30},
    { 41,0x00},
    { 42,0x00},
    { 43,0x00},
    { 44,0x20},
    { 45,0x00},
    { 46,0x00},
    { 47,0x00},
    { 48,0x50},
    { 49,0x00},
    { 50,0x00},
    { 51,0x00},
    { 52,0x20},
    { 53,0x2B},
    { 54,0x6A},
    { 55,0x00},
    { 56,0xE0},
    { 57,0x0F},
    { 58,0xDC},
    { 59,0x00},
    { 60,0x1F},
    { 61,0xB7},
    { 62,0x75},
    { 63,0x00},
    { 64,0x1F},
    { 65,0xF0},
    { 66,0x24},
    { 67,0x00},
    { 68,0xE0},
    { 69,0x1D},
    { 70,0x21},
    { 71,0x00},
    { 72,0xE0},
    { 73,0x00},
    { 74,0x00},
    { 75,0x00},
    { 76,0x20},
    { 77,0x5A},
    { 78,0xD2},
    { 79,0x00},
    { 80,0xE0},
    { 81,0x24},
    { 82,0x27},
    { 83,0x00},
    { 84,0x1F},
    { 85,0x68},
    { 86,0x3F},
    { 87,0x00},
    { 88,0x1F},
    { 89,0xDB},
    { 90,0xD9},
    { 91,0x00},
    { 92,0xE0},
    { 93,0x3C},
    { 94,0xEF},
    { 95,0x00},
    { 96,0xE0},
    { 97,0x00},
    { 98,0x00},
    { 99,0x00},
    {100,0x20},
    {101,0xBD},
    {102,0x8A},
    {103,0x00},
    {104,0xE0},
    {105,0x58},
    {106,0x6F},
    {107,0x00},
    {108,0x1E},
    {109,0xC3},
    {110,0x4C},
    {111,0x00},
    {112,0x1F},
    {113,0xA7},
    {114,0x91},
    {115,0x00},
    {116,0xE0},
    {117,0x7F},
    {118,0x2A},
    {119,0x00},
    {120,0xE0},
    {121,0x00},
    {122,0x00},
    {123,0x00},
    {124,0x21},
    {125,0x89},
    {126,0xB7},
    {127,0x00},
    {  0,0x40},
    {  8,0xE0},
    {  9,0xF0},
    { 10,0x05},
    { 11,0x00},
    { 12,0x1D},
    { 13,0x6E},
    { 14,0x24},
    { 15,0x00},
    { 16,0x1F},
    { 17,0x0F},
    { 18,0xFB},
    { 19,0x00},
    { 20,0xE1},
    { 21,0x08},
    { 22,0x25},
    { 23,0x00},
    { 24,0xE0},
    { 25,0x00},
    { 26,0x00},
    { 27,0x00},
    { 28,0x23},
    { 29,0x29},
    { 30,0xB4},
    { 31,0x00},
    { 32,0xE2},
    { 33,0xDC},
    { 34,0x70},
    { 35,0x00},
    { 36,0x1A},
    { 37,0xB7},
    { 38,0x11},
    { 39,0x00},
    { 40,0x1D},
    { 41,0x23},
    { 42,0x90},
    { 43,0x00},
    { 44,0xE2},
    { 45,0x1F},
    { 46,0x3B},
    { 47,0x00},
    { 48,0xE0},
    { 49,0x00},
    { 50,0x00},
    { 51,0x00},
    { 52,0x26},
    { 53,0x65},
    { 54,0x8A},
    { 55,0x00},
    { 56,0xE9},
    { 57,0x81},
    { 58,0xA5},
    { 59,0x00},
    { 60,0x15},
    { 61,0x4F},
    { 62,0xD6},
    { 63,0x00},
    { 64,0x16},
    { 65,0x7E},
    { 66,0x5B},
    { 67,0x00},
    { 68,0xE4},
    { 69,0x4A},
    { 70,0xA0},
    { 71,0x00},
    { 72,0xE0},
    { 73,0x00},
    { 74,0x00},
    { 75,0x00},
    { 76,0x2C},
    { 77,0x88},
    { 78,0xAC},
    { 79,0x00},
    { 80,0xFE},
    { 81,0x11},
    { 82,0xA9},
    { 83,0x00},
    { 84,0x0B},
    { 85,0x0E},
    { 86,0xA2},
    { 87,0x00},
    { 88,0x01},
    { 89,0xEE},
    { 90,0x57},
    { 91,0x00},
    { 92,0xE8},
    { 93,0x68},
    { 94,0xB2},
    { 95,0x00},
    { 96,0xE0},
    { 97,0x00},
    { 98,0x00},
    { 99,0x00},
    {100,0x00},
    {101,0x0D},
    {102,0x00},
    {103,0x00},
    {104,0x00},
    {105,0x1C},
    {106,0x00},
    {107,0x00},
    {108,0x00},
    {109,0x3E},
    {110,0x00},
    {111,0x00},
    {112,0x00},
    {113,0x78},
    {114,0x00},
    {115,0x00},
    {116,0x02},
    {117,0x4C},
    {118,0x00},
    {119,0x00},
    {120,0x00},
    {121,0xD5},
    {122,0x00},
    {123,0x00},
    {124,0x01},
    {125,0x65},
    {126,0x00},
    {127,0x00},
    {  0,0x41},
    {  8,0x03},
    {  9,0xE9},
    { 10,0x00},
    { 11,0x00},
    { 12,0x07},
    { 13,0xCA},
    { 14,0x00},
    { 15,0x00},
    { 16,0xFF},
    { 17,0xEF},
    { 18,0x00},
    { 19,0x00},
    { 20,0xFE},
    { 21,0xEB},
    { 22,0x00},
    { 23,0x00},
    { 24,0xFF},
    { 25,0xA8},
    { 26,0x00},
    { 27,0x00},
    { 28,0xFD},
    { 29,0x08},
    { 30,0x00},
    { 31,0x00},
    { 32,0xFF},
    { 33,0x5E},
    { 34,0x00},
    { 35,0x00},
    { 36,0xFF},
    { 37,0xD5},
    { 38,0x00},
    { 39,0x00},
    { 40,0xFE},
    { 41,0x36},
    { 42,0x00},
    { 43,0x00},
    { 44,0xFA},
    { 45,0xAC},
    { 46,0x00},
    { 47,0x00},
    { 48,0xF2},
    { 49,0xA3},
    { 50,0x00},
    { 51,0x00},
    { 52,0x28},
    { 53,0xAB},
    { 54,0x00},
    { 55,0x00},
    { 56,0x3F},
    { 57,0xFF},
    { 58,0x00},
    { 59,0x00},
    { 60,0xFF},
    { 61,0x98},
    { 62,0x00},
    { 63,0x00},
    { 64,0xF6},
    { 65,0xF9},
    { 66,0x00},
    { 67,0x00},
    { 68,0x26},
    { 69,0xFB},
    { 70,0x00},
    { 71,0x00},
    { 72,0x02},
    { 73,0x72},
    { 74,0x00},
    { 75,0x00},
    { 76,0x40},
    { 77,0x02},
    { 78,0x00},
    { 79,0x00},
    { 80,0xFB},
    { 81,0xCB},
    { 82,0x00},
    { 83,0x00},
    { 84,0x20},
    { 85,0xA7},
    { 86,0x00},
    { 87,0x00},
    { 88,0xFF},
    { 89,0x6A},
    { 90,0x00},
    { 91,0x00},
    { 92,0x3A},
    { 93,0x0F},
    { 94,0x00},
    { 95,0x00},
    { 96,0x00},
    { 97,0x00},
    { 98,0x18},
    { 99,0x00},
    {100,0x00},
    {101,0x00},
    {102,0x09},
    {103,0x00},
    {104,0x00},
    {105,0x00},
    {106,0x05},
    {107,0x00},
    {108,0x00},
    {109,0x00},
    {110,0x10},
    {111,0x00},
    {112,0x00},
    {113,0x00},
    {114,0x34},
    {115,0x00},
    {116,0x00},
    {117,0x00},
    {118,0x17},
    {119,0x00},
    {  0,0x98},
    {  8,0x08},
    {  9,0x08},
    { 10,0x00},
    { 11,0x00},
    { 12,0x08},
    { 13,0x0C},
    { 14,0x01},
    { 15,0x00},
    { 16,0x30},
    { 17,0x0C},
    { 18,0x62},
    { 19,0x00},
    { 20,0x38},
    { 21,0x10},
    { 22,0x64},
    { 23,0x00},
    { 24,0x38},
    { 25,0x08},
    { 26,0x61},
    { 27,0x00},
    { 28,0x10},
    { 29,0x04},
    { 30,0xD9},
    { 31,0x00},
    { 32,0x10},
    { 33,0x00},
    { 34,0x98},
    { 35,0x00},
    { 36,0x28},
    { 37,0x00},
    { 38,0x63},
    { 39,0x00},
    { 40,0x31},
    { 41,0x4C},
    { 42,0x88},
    { 43,0x00},
    { 44,0x39},
    { 45,0x50},
    { 46,0x65},
    { 47,0x00},
    { 48,0xA1},
    { 49,0x4C},
    { 50,0x63},
    { 51,0x00},
    { 52,0x39},
    { 53,0x50},
    { 54,0x86},
    { 55,0x00},
    { 56,0x39},
    { 57,0x54},
    { 58,0x67},
    { 59,0x00},
    { 60,0x39},
    { 61,0x54},
    { 62,0x84},
    { 63,0x00},
    { 64,0x39},
    { 65,0x58},
    { 66,0x69},
    { 67,0x00},
    { 68,0x39},
    { 69,0x58},
    { 70,0x82},
    { 71,0x00},
    { 72,0x39},
    { 73,0x5C},
    { 74,0x6F},
    { 75,0x00},
    { 76,0x39},
    { 77,0x5C},
    { 78,0x7C},
    { 79,0x00},
    { 80,0x39},
    { 81,0x60},
    { 82,0x6B},
    { 83,0x00},
    { 84,0x39},
    { 85,0x60},
    { 86,0x80},
    { 87,0x00},
    { 88,0x39},
    { 89,0x64},
    { 90,0x6D},
    { 91,0x00},
    { 92,0x39},
    { 93,0x64},
    { 94,0x7E},
    { 95,0x00},
    { 96,0x39},
    { 97,0x68},
    { 98,0x71},
    { 99,0x00},
    {100,0x39},
    {101,0x68},
    {102,0x7A},
    {103,0x00},
    {104,0x39},
    {105,0x6C},
    {106,0x73},
    {107,0x00},
    {108,0x39},
    {109,0x6C},
    {110,0x78},
    {111,0x00},
    {112,0x39},
    {113,0x70},
    {114,0x64},
    {115,0x00},
    {116,0x39},
    {117,0x70},
    {118,0x87},
    {119,0x00},
    {120,0x39},
    {121,0x74},
    {122,0x6C},
    {123,0x00},
    {124,0x39},
    {125,0x74},
    {126,0x7F},
    {127,0x00},
    {  0,0x99},
    {  8,0x39},
    {  9,0x78},
    { 10,0x68},
    { 11,0x00},
    { 12,0x39},
    { 13,0x78},
    { 14,0x83},
    { 15,0x00},
    { 16,0x39},
    { 17,0x7C},
    { 18,0x70},
    { 19,0x00},
    { 20,0x39},
    { 21,0x7C},
    { 22,0x7B},
    { 23,0x00},
    { 24,0x39},
    { 25,0x80},
    { 26,0x6A},
    { 27,0x00},
    { 28,0x39},
    { 29,0x80},
    { 30,0x81},
    { 31,0x00},
    { 32,0x39},
    { 33,0x84},
    { 34,0x66},
    { 35,0x00},
    { 36,0x39},
    { 37,0x84},
    { 38,0x85},
    { 39,0x00},
    { 40,0x39},
    { 41,0x88},
    { 42,0x6E},
    { 43,0x00},
    { 44,0x39},
    { 45,0x88},
    { 46,0x7D},
    { 47,0x00},
    { 48,0x39},
    { 49,0x8C},
    { 50,0x72},
    { 51,0x00},
    { 52,0x39},
    { 53,0x8C},
    { 54,0x79},
    { 55,0x00},
    { 56,0x39},
    { 57,0x90},
    { 58,0x74},
    { 59,0x00},
    { 60,0x39},
    { 61,0x90},
    { 62,0x77},
    { 63,0x00},
    { 64,0x39},
    { 65,0x94},
    { 66,0x75},
    { 67,0x00},
    { 68,0x39},
    { 69,0x94},
    { 70,0x76},
    { 71,0x00},
    { 72,0x00},
    { 73,0x00},
    { 74,0x00},
    { 75,0x00},
    { 76,0x00},
    { 77,0x00},
    { 78,0x00},
    { 79,0x00},
    { 80,0x20},
    { 81,0x00},
    { 82,0x8D},
    { 83,0x00},
    { 84,0x30},
    { 85,0x74},
    { 86,0x3A},
    { 87,0x00},
    { 88,0x30},
    { 89,0x74},
    { 90,0x3B},
    { 91,0x00},
    { 92,0x30},
    { 93,0x74},
    { 94,0x3C},
    { 95,0x00},
    { 96,0x20},
    { 97,0x04},
    { 98,0x39},
    { 99,0x00},
    {100,0x20},
    {101,0x04},
    {102,0x3A},
    {103,0x00},
    {104,0x20},
    {105,0x04},
    {106,0x3B},
    {107,0x00},
    {108,0x30},
    {109,0x74},
    {110,0x3D},
    {111,0x00},
    {112,0x30},
    {113,0x74},
    {114,0x3E},
    {115,0x00},
    {116,0x00},
    {117,0x00},
    {118,0x00},
    {119,0x00},
    {120,0x20},
    {121,0x04},
    {122,0x3C},
    {123,0x00},
    {124,0x20},
    {125,0x04},
    {126,0x3D},
    {127,0x00},
    {  0,0x9A},
    {  8,0x30},
    {  9,0x74},
    { 10,0x3F},
    { 11,0x00},
    { 12,0x30},
    { 13,0x74},
    { 14,0x40},
    { 15,0x00},
    { 16,0x00},
    { 17,0x00},
    { 18,0x00},
    { 19,0x00},
    { 20,0x20},
    { 21,0x04},
    { 22,0x3E},
    { 23,0x00},
    { 24,0x20},
    { 25,0x04},
    { 26,0x3F},
    { 27,0x00},
    { 28,0x31},
    { 29,0xC3},
    { 30,0xFB},
    { 31,0x00},
    { 32,0x00},
    { 33,0x00},
    { 34,0x00},
    { 35,0x00},
    { 36,0x38},
    { 37,0x03},
    { 38,0xFB},
    { 39,0x00},
    { 40,0x88},
    { 41,0x17},
    { 42,0xFE},
    { 43,0x00},
    { 44,0x00},
    { 45,0x00},
    { 46,0x00},
    { 47,0x00},
    { 48,0x30},
    { 49,0x0C},
    { 50,0xA1},
    { 51,0x00},
    { 52,0x38},
    { 53,0x10},
    { 54,0xA5},
    { 55,0x00},
    { 56,0x38},
    { 57,0x08},
    { 58,0xA0},
    { 59,0x00},
    { 60,0x31},
    { 61,0x4C},
    { 62,0xC9},
    { 63,0x00},
    { 64,0x39},
    { 65,0x50},
    { 66,0xA6},
    { 67,0x00},
    { 68,0xA1},
    { 69,0x4C},
    { 70,0xA4},
    { 71,0x00},
    { 72,0x39},
    { 73,0x50},
    { 74,0xC7},
    { 75,0x00},
    { 76,0x39},
    { 77,0x54},
    { 78,0xA8},
    { 79,0x00},
    { 80,0x39},
    { 81,0x54},
    { 82,0xC5},
    { 83,0x00},
    { 84,0x10},
    { 85,0x04},
    { 86,0xD8},
    { 87,0x00},
    { 88,0x10},
    { 89,0x00},
    { 90,0x97},
    { 91,0x00},
    { 92,0x39},
    { 93,0x58},
    { 94,0xAA},
    { 95,0x00},
    { 96,0x39},
    { 97,0x58},
    { 98,0xC3},
    { 99,0x00},
    {100,0x39},
    {101,0x5C},
    {102,0xB0},
    {103,0x00},
    {104,0x39},
    {105,0x5C},
    {106,0xBD},
    {107,0x00},
    {108,0x39},
    {109,0x60},
    {110,0xAC},
    {111,0x00},
    {112,0x39},
    {113,0x60},
    {114,0xC1},
    {115,0x00},
    {116,0x39},
    {117,0x64},
    {118,0xAE},
    {119,0x00},
    {120,0x39},
    {121,0x64},
    {122,0xBF},
    {123,0x00},
    {124,0x39},
    {125,0x68},
    {126,0xB2},
    {127,0x00},
    {  0,0x9B},
    {  8,0x39},
    {  9,0x68},
    { 10,0xBB},
    { 11,0x00},
    { 12,0x39},
    { 13,0x6C},
    { 14,0xB4},
    { 15,0x00},
    { 16,0x39},
    { 17,0x6C},
    { 18,0xB9},
    { 19,0x00},
    { 20,0x39},
    { 21,0x70},
    { 22,0xA5},
    { 23,0x00},
    { 24,0x39},
    { 25,0x70},
    { 26,0xC8},
    { 27,0x00},
    { 28,0x39},
    { 29,0x74},
    { 30,0xAD},
    { 31,0x00},
    { 32,0x39},
    { 33,0x74},
    { 34,0xC0},
    { 35,0x00},
    { 36,0x39},
    { 37,0x78},
    { 38,0xA9},
    { 39,0x00},
    { 40,0x39},
    { 41,0x78},
    { 42,0xC4},
    { 43,0x00},
    { 44,0x39},
    { 45,0x7C},
    { 46,0xB1},
    { 47,0x00},
    { 48,0x39},
    { 49,0x7C},
    { 50,0xBC},
    { 51,0x00},
    { 52,0x39},
    { 53,0x80},
    { 54,0xAB},
    { 55,0x00},
    { 56,0x39},
    { 57,0x80},
    { 58,0xC2},
    { 59,0x00},
    { 60,0x39},
    { 61,0x84},
    { 62,0xA7},
    { 63,0x00},
    { 64,0x39},
    { 65,0x84},
    { 66,0xC6},
    { 67,0x00},
    { 68,0x39},
    { 69,0x88},
    { 70,0xAF},
    { 71,0x00},
    { 72,0x39},
    { 73,0x88},
    { 74,0xBE},
    { 75,0x00},
    { 76,0x39},
    { 77,0x8C},
    { 78,0xB3},
    { 79,0x00},
    { 80,0x39},
    { 81,0x8C},
    { 82,0xBA},
    { 83,0x00},
    { 84,0x39},
    { 85,0x90},
    { 86,0xB5},
    { 87,0x00},
    { 88,0x39},
    { 89,0x90},
    { 90,0xB8},
    { 91,0x00},
    { 92,0x39},
    { 93,0x94},
    { 94,0xB6},
    { 95,0x00},
    { 96,0x39},
    { 97,0x94},
    { 98,0xB7},
    { 99,0x00},
    {100,0x31},
    {101,0x9C},
    {102,0xCD},
    {103,0x00},
    {104,0x39},
    {105,0xA0},
    {106,0xCF},
    {107,0x00},
    {108,0x99},
    {109,0x9C},
    {110,0xCE},
    {111,0x00},
    {112,0x39},
    {113,0xA0},
    {114,0xCC},
    {115,0x00},
    {116,0x39},
    {117,0xA4},
    {118,0xCB},
    {119,0x00},
    {120,0x39},
    {121,0xA4},
    {122,0xD0},
    {123,0x00},
    {124,0x39},
    {125,0xA8},
    {126,0xCA},
    {127,0x00},
    {  0,0x9C},
    {  8,0x39},
    {  9,0xA8},
    { 10,0xD1},
    { 11,0x00},
    { 12,0x31},
    { 13,0xB4},
    { 14,0xD2},
    { 15,0x00},
    { 16,0x39},
    { 17,0xB4},
    { 18,0xD4},
    { 19,0x00},
    { 20,0x99},
    { 21,0xB0},
    { 22,0xD5},
    { 23,0x00},
    { 24,0x39},
    { 25,0xB0},
    { 26,0xD7},
    { 27,0x00},
    { 28,0x00},
    { 29,0x04},
    { 30,0x00},
    { 31,0x00},
    { 32,0x50},
    { 33,0x04},
    { 34,0x03},
    { 35,0x00},
    { 36,0x31},
    { 37,0x9C},
    { 38,0x8C},
    { 39,0x00},
    { 40,0x39},
    { 41,0x9C},
    { 42,0x8D},
    { 43,0x00},
    { 44,0x20},
    { 45,0x08},
    { 46,0xDE},
    { 47,0x00},
    { 48,0x39},
    { 49,0xA0},
    { 50,0x8E},
    { 51,0x00},
    { 52,0x39},
    { 53,0xA0},
    { 54,0x8B},
    { 55,0x00},
    { 56,0x39},
    { 57,0xA4},
    { 58,0x8A},
    { 59,0x00},
    { 60,0x39},
    { 61,0xA4},
    { 62,0x8F},
    { 63,0x00},
    { 64,0x39},
    { 65,0xA8},
    { 66,0x89},
    { 67,0x00},
    { 68,0x39},
    { 69,0xA8},
    { 70,0x90},
    { 71,0x00},
    { 72,0x31},
    { 73,0xB4},
    { 74,0x91},
    { 75,0x00},
    { 76,0x39},
    { 77,0xB4},
    { 78,0x93},
    { 79,0x00},
    { 80,0x99},
    { 81,0xB0},
    { 82,0x94},
    { 83,0x00},
    { 84,0x39},
    { 85,0xB0},
    { 86,0x96},
    { 87,0x00},
    { 88,0x00},
    { 89,0x00},
    { 90,0x00},
    { 91,0x00},
    { 92,0x50},
    { 93,0x00},
    { 94,0x03},
    { 95,0x00},
    { 96,0x00},
    { 97,0x00},
    { 98,0x00},
    { 99,0x00},
    {100,0x00},
    {101,0x00},
    {102,0x00},
    {103,0x00},
    {104,0x20},
    {105,0x08},
    {106,0x9D},
    {107,0x00},
    {108,0x30},
    {109,0x74},
    {110,0x42},
    {111,0x00},
    {112,0x30},
    {113,0x74},
    {114,0x43},
    {115,0x00},
    {116,0x30},
    {117,0x74},
    {118,0x44},
    {119,0x00},
    {120,0x20},
    {121,0x04},
    {122,0x41},
    {123,0x00},
    {124,0x20},
    {125,0x04},
    {126,0x42},
    {127,0x00},
    {  0,0x9D},
    {  8,0x20},
    {  9,0x04},
    { 10,0x43},
    { 11,0x00},
    { 12,0x30},
    { 13,0x74},
    { 14,0x45},
    { 15,0x00},
    { 16,0x30},
    { 17,0x74},
    { 18,0x46},
    { 19,0x00},
    { 20,0x30},
    { 21,0x74},
    { 22,0x47},
    { 23,0x00},
    { 24,0x20},
    { 25,0x04},
    { 26,0x44},
    { 27,0x00},
    { 28,0x20},
    { 29,0x04},
    { 30,0x45},
    { 31,0x00},
    { 32,0x20},
    { 33,0x04},
    { 34,0x46},
    { 35,0x00},
    { 36,0x30},
    { 37,0x74},
    { 38,0x48},
    { 39,0x00},
    { 40,0x30},
    { 41,0x74},
    { 42,0x49},
    { 43,0x00},
    { 44,0x30},
    { 45,0x74},
    { 46,0x4A},
    { 47,0x00},
    { 48,0x20},
    { 49,0x04},
    { 50,0x47},
    { 51,0x00},
    { 52,0x20},
    { 53,0x04},
    { 54,0x48},
    { 55,0x00},
    { 56,0x20},
    { 57,0x04},
    { 58,0x49},
    { 59,0x00},
    { 60,0x30},
    { 61,0x74},
    { 62,0x4B},
    { 63,0x00},
    { 64,0x30},
    { 65,0x74},
    { 66,0x4C},
    { 67,0x00},
    { 68,0x30},
    { 69,0x74},
    { 70,0x4D},
    { 71,0x00},
    { 72,0x20},
    { 73,0x04},
    { 74,0x4A},
    { 75,0x00},
    { 76,0x20},
    { 77,0x04},
    { 78,0x4B},
    { 79,0x00},
    { 80,0x20},
    { 81,0x04},
    { 82,0x4C},
    { 83,0x00},
    { 84,0x30},
    { 85,0x74},
    { 86,0x4E},
    { 87,0x00},
    { 88,0x30},
    { 89,0x74},
    { 90,0x4F},
    { 91,0x00},
    { 92,0x30},
    { 93,0x74},
    { 94,0x50},
    { 95,0x00},
    { 96,0x20},
    { 97,0x04},
    { 98,0x4D},
    { 99,0x00},
    {100,0x20},
    {101,0x04},
    {102,0x4E},
    {103,0x00},
    {104,0x20},
    {105,0x04},
    {106,0x4F},
    {107,0x00},
    {108,0x30},
    {109,0x74},
    {110,0x51},
    {111,0x00},
    {112,0x30},
    {113,0x74},
    {114,0x52},
    {115,0x00},
    {116,0x30},
    {117,0x74},
    {118,0x53},
    {119,0x00},
    {120,0x20},
    {121,0x04},
    {122,0x50},
    {123,0x00},
    {124,0x20},
    {125,0x04},
    {126,0x51},
    {127,0x00},
    {  0,0x9E},
    {  8,0x20},
    {  9,0x04},
    { 10,0x52},
    { 11,0x00},
    { 12,0x30},
    { 13,0x74},
    { 14,0x54},
    { 15,0x00},
    { 16,0x30},
    { 17,0x74},
    { 18,0x55},
    { 19,0x00},
    { 20,0x30},
    { 21,0x74},
    { 22,0x56},
    { 23,0x00},
    { 24,0x20},
    { 25,0x04},
    { 26,0x53},
    { 27,0x00},
    { 28,0x20},
    { 29,0x04},
    { 30,0x54},
    { 31,0x00},
    { 32,0x20},
    { 33,0x04},
    { 34,0x55},
    { 35,0x00},
    { 36,0x30},
    { 37,0x74},
    { 38,0x57},
    { 39,0x00},
    { 40,0x30},
    { 41,0x74},
    { 42,0x58},
    { 43,0x00},
    { 44,0x30},
    { 45,0x74},
    { 46,0x59},
    { 47,0x00},
    { 48,0x20},
    { 49,0x04},
    { 50,0x56},
    { 51,0x00},
    { 52,0x20},
    { 53,0x04},
    { 54,0x57},
    { 55,0x00},
    { 56,0x20},
    { 57,0x04},
    { 58,0x58},
    { 59,0x00},
    { 60,0x30},
    { 61,0x74},
    { 62,0x5A},
    { 63,0x00},
    { 64,0x30},
    { 65,0x74},
    { 66,0x5B},
    { 67,0x00},
    { 68,0x30},
    { 69,0x74},
    { 70,0x5C},
    { 71,0x00},
    { 72,0x20},
    { 73,0x04},
    { 74,0x59},
    { 75,0x00},
    { 76,0x20},
    { 77,0x04},
    { 78,0x5A},
    { 79,0x00},
    { 80,0x20},
    { 81,0x04},
    { 82,0x5B},
    { 83,0x00},
    { 84,0x30},
    { 85,0x74},
    { 86,0x5D},
    { 87,0x00},
    { 88,0x00},
    { 89,0x00},
    { 90,0x00},
    { 91,0x00},
    { 92,0x00},
    { 93,0x00},
    { 94,0x00},
    { 95,0x00},
    { 96,0x20},
    { 97,0x04},
    { 98,0x5C},
    { 99,0x00},
    {100,0x30},
    {101,0x3C},
    {102,0x34},
    {103,0x00},
    {104,0x80},
    {105,0x43},
    {106,0xFB},
    {107,0x00},
    {108,0x38},
    {109,0x47},
    {110,0xFB},
    {111,0x00},
    {112,0x30},
    {113,0x4B},
    {114,0xFB},
    {115,0x00},
    {116,0x88},
    {117,0x0C},
    {118,0x02},
    {119,0x00},
    {120,0x20},
    {121,0x04},
    {122,0x33},
    {123,0x00},
    {124,0x88},
    {125,0x00},
    {126,0x02},
    {127,0x00},
    {  0,0x9F},
    {  8,0x00},
    {  9,0x00},
    { 10,0x00},
    { 11,0x00},
    { 12,0x20},
    { 13,0x00},
    { 14,0x33},
    { 15,0x00},
    { 16,0x00},
    { 17,0x00},
    { 18,0x00},
    { 19,0x00},
    { 20,0x00},
    { 21,0x00},
    { 22,0x00},
    { 23,0x00},
    { 24,0x00},
    { 25,0x00},
    { 26,0x00},
    { 27,0x00},
    { 28,0x00},
    { 29,0x00},
    { 30,0x00},
    { 31,0x00},
    { 32,0x10},
    { 33,0x04},
    { 34,0xDE},
    { 35,0x00},
    { 36,0x10},
    { 37,0x00},
    { 38,0x9D},
    { 39,0x00},
    { 40,0x31},
    { 41,0xB8},
    { 42,0xD5},
    { 43,0x00},
    { 44,0x39},
    { 45,0xB8},
    { 46,0xD4},
    { 47,0x00},
    { 48,0x39},
    { 49,0xBC},
    { 50,0xD2},
    { 51,0x00},
    { 52,0x00},
    { 53,0x04},
    { 54,0x00},
    { 55,0x00},
    { 56,0x50},
    { 57,0x04},
    { 58,0x03},
    { 59,0x00},
    { 60,0x31},
    { 61,0xB8},
    { 62,0x94},
    { 63,0x00},
    { 64,0x39},
    { 65,0xB8},
    { 66,0x93},
    { 67,0x00},
    { 68,0x20},
    { 69,0x08},
    { 70,0xDD},
    { 71,0x00},
    { 72,0x39},
    { 73,0xBC},
    { 74,0x91},
    { 75,0x00},
    { 76,0x00},
    { 77,0x00},
    { 78,0x00},
    { 79,0x00},
    { 80,0x50},
    { 81,0x00},
    { 82,0x03},
    { 83,0x00},
    { 84,0x31},
    { 85,0xAC},
    { 86,0xCB},
    { 87,0x00},
    { 88,0x31},
    { 89,0xB0},
    { 90,0xD4},
    { 91,0x00},
    { 92,0x20},
    { 93,0x08},
    { 94,0x9C},
    { 95,0x00},
    { 96,0x99},
    { 97,0xB0},
    { 98,0xD6},
    { 99,0x00},
    {100,0x39},
    {101,0xB4},
    {102,0xD5},
    {103,0x00},
    {104,0x39},
    {105,0xB4},
    {106,0xD2},
    {107,0x00},
    {108,0x00},
    {109,0x04},
    {110,0x00},
    {111,0x00},
    {112,0x50},
    {113,0x04},
    {114,0x03},
    {115,0x00},
    {116,0x31},
    {117,0xAC},
    {118,0x8A},
    {119,0x00},
    {120,0x31},
    {121,0xB0},
    {122,0x93},
    {123,0x00},
    {124,0x20},
    {125,0x08},
    {126,0xDC},
    {127,0x00},
    {  0,0xA0},
    {  8,0x99},
    {  9,0xB0},
    { 10,0x95},
    { 11,0x00},
    { 12,0x39},
    { 13,0xB4},
    { 14,0x94},
    { 15,0x00},
    { 16,0x39},
    { 17,0xB4},
    { 18,0x91},
    { 19,0x00},
    { 20,0x00},
    { 21,0x00},
    { 22,0x00},
    { 23,0x00},
    { 24,0x50},
    { 25,0x00},
    { 26,0x03},
    { 27,0x00},
    { 28,0x31},
    { 29,0xB8},
    { 30,0xD6},
    { 31,0x00},
    { 32,0x39},
    { 33,0xB8},
    { 34,0xD2},
    { 35,0x00},
    { 36,0x20},
    { 37,0x08},
    { 38,0x9B},
    { 39,0x00},
    { 40,0x39},
    { 41,0xBC},
    { 42,0xD5},
    { 43,0x00},
    { 44,0x00},
    { 45,0x04},
    { 46,0x00},
    { 47,0x00},
    { 48,0x50},
    { 49,0x04},
    { 50,0x03},
    { 51,0x00},
    { 52,0x00},
    { 53,0x00},
    { 54,0x00},
    { 55,0x00},
    { 56,0x00},
    { 57,0x00},
    { 58,0x00},
    { 59,0x00},
    { 60,0x20},
    { 61,0x08},
    { 62,0xDB},
    { 63,0x00},
    { 64,0x30},
    { 65,0x63},
    { 66,0xFB},
    { 67,0x00},
    { 68,0x30},
    { 69,0x3C},
    { 70,0x34},
    { 71,0x00},
    { 72,0x10},
    { 73,0xEC},
    { 74,0x34},
    { 75,0x00},
    { 76,0x20},
    { 77,0x00},
    { 78,0x38},
    { 79,0x00},
    { 80,0x40},
    { 81,0x54},
    { 82,0x00},
    { 83,0x00},
    { 84,0x18},
    { 85,0xF0},
    { 86,0x00},
    { 87,0x00},
    { 88,0x90},
    { 89,0x7C},
    { 90,0x00},
    { 91,0x00},
    { 92,0x30},
    { 93,0x3C},
    { 94,0x39},
    { 95,0x00},
    { 96,0x90},
    { 97,0x78},
    { 98,0x00},
    { 99,0x00},
    {100,0x30},
    {101,0x17},
    {102,0xFB},
    {103,0x00},
    {104,0x90},
    {105,0xF8},
    {106,0x00},
    {107,0x00},
    {108,0x40},
    {109,0x50},
    {110,0x01},
    {111,0x00},
    {112,0x40},
    {113,0x4C},
    {114,0x02},
    {115,0x00},
    {116,0x90},
    {117,0xFC},
    {118,0x00},
    {119,0x00},
    {120,0x30},
    {121,0x5F},
    {122,0xFB},
    {123,0x00},
    {124,0x38},
    {125,0x53},
    {126,0xFB},
    {127,0x00},
    {  0,0xA1},
    {  8,0x80},
    {  9,0x4C},
    { 10,0x38},
    { 11,0x00},
    { 12,0x00},
    { 13,0x00},
    { 14,0x00},
    { 15,0x00},
    { 16,0xD8},
    { 17,0x5B},
    { 18,0xFB},
    { 19,0x00},
    { 20,0x88},
    { 21,0x0C},
    { 22,0x08},
    { 23,0x00},
    { 24,0x80},
    { 25,0x4C},
    { 26,0x38},
    { 27,0x00},
    { 28,0x30},
    { 29,0x4F},
    { 30,0xFB},
    { 31,0x00},
    { 32,0x20},
    { 33,0x08},
    { 34,0x02},
    { 35,0x00},
    { 36,0x88},
    { 37,0x10},
    { 38,0x08},
    { 39,0x00},
    { 40,0x20},
    { 41,0x08},
    { 42,0x02},
    { 43,0x00},
    { 44,0x00},
    { 45,0x00},
    { 46,0x00},
    { 47,0x00},
    { 48,0x00},
    { 49,0x00},
    { 50,0x00},
    { 51,0x00},
    { 52,0x88},
    { 53,0x00},
    { 54,0x08},
    { 55,0x00},
    { 56,0x20},
    { 57,0x08},
    { 58,0x02},
    { 59,0x00},
    { 60,0x00},
    { 61,0x00},
    { 62,0x00},
    { 63,0x00},
    { 64,0x00},
    { 65,0x00},
    { 66,0x00},
    { 67,0x00},
    { 68,0x00},
    { 69,0x00},
    { 70,0x00},
    { 71,0x00},
    { 72,0x30},
    { 73,0x3C},
    { 74,0x34},
    { 75,0x00},
    { 76,0x00},
    { 77,0x00},
    { 78,0x00},
    { 79,0x00},
    { 80,0x00},
    { 81,0x00},
    { 82,0x00},
    { 83,0x00},
    { 84,0x20},
    { 85,0x04},
    { 86,0x33},
    { 87,0x00},
    { 88,0x30},
    { 89,0x77},
    { 90,0xFB},
    { 91,0x00},
    { 92,0x38},
    { 93,0x70},
    { 94,0x02},
    { 95,0x00},
    { 96,0x00},
    { 97,0x00},
    { 98,0x00},
    { 99,0x00},
    {100,0x30},
    {101,0x67},
    {102,0xFB},
    {103,0x00},
    {104,0x40},
    {105,0x78},
    {106,0x02},
    {107,0x00},
    {108,0x48},
    {109,0x78},
    {110,0x00},
    {111,0x00},
    {112,0x38},
    {113,0x6B},
    {114,0xFB},
    {115,0x00},
    {116,0x00},
    {117,0x00},
    {118,0x00},
    {119,0x00},
    {120,0x48},
    {121,0x78},
    {122,0x00},
    {123,0x00},
    {124,0x38},
    {125,0x6F},
    {126,0xFB},
    {127,0x00},
    {  0,0xA2},
    {  8,0x00},
    {  9,0x00},
    { 10,0x00},
    { 11,0x00},
    { 12,0x48},
    { 13,0x78},
    { 14,0x00},
    { 15,0x00},
    { 16,0x38},
    { 17,0x93},
    { 18,0xFB},
    { 19,0x00},
    { 20,0x00},
    { 21,0x00},
    { 22,0x00},
    { 23,0x00},
    { 24,0x20},
    { 25,0x08},
    { 26,0x36},
    { 27,0x00},
    { 28,0x20},
    { 29,0x08},
    { 30,0x37},
    { 31,0x00},
    { 32,0x31},
    { 33,0xC7},
    { 34,0xFB},
    { 35,0x00},
    { 36,0x00},
    { 37,0x00},
    { 38,0x00},
    { 39,0x00},
    { 40,0x38},
    { 41,0x03},
    { 42,0xFB},
    { 43,0x00},
    { 44,0x88},
    { 45,0x17},
    { 46,0xFE},
    { 47,0x00},
    { 48,0x00},
    { 49,0x00},
    { 50,0x00},
    { 51,0x00},
    { 52,0x10},
    { 53,0x04},
    { 54,0xDD},
    { 55,0x00},
    { 56,0x10},
    { 57,0x00},
    { 58,0x9C},
    { 59,0x00},
    { 60,0x31},
    { 61,0xB8},
    { 62,0x95},
    { 63,0x00},
    { 64,0x39},
    { 65,0xB8},
    { 66,0x91},
    { 67,0x00},
    { 68,0x39},
    { 69,0xBC},
    { 70,0x94},
    { 71,0x00},
    { 72,0x00},
    { 73,0x00},
    { 74,0x00},
    { 75,0x00},
    { 76,0x50},
    { 77,0x00},
    { 78,0x03},
    { 79,0x00},
    { 80,0x31},
    { 81,0x98},
    { 82,0xB6},
    { 83,0x00},
    { 84,0x31},
    { 85,0x9C},
    { 86,0xD1},
    { 87,0x00},
    { 88,0x20},
    { 89,0x08},
    { 90,0x9A},
    { 91,0x00},
    { 92,0x99},
    { 93,0x9C},
    { 94,0xC9},
    { 95,0x00},
    { 96,0x39},
    { 97,0xA0},
    { 98,0xCA},
    { 99,0x00},
    {100,0x39},
    {101,0xA0},
    {102,0xD0},
    {103,0x00},
    {104,0x39},
    {105,0xA4},
    {106,0xCF},
    {107,0x00},
    {108,0x39},
    {109,0xA4},
    {110,0xCB},
    {111,0x00},
    {112,0x39},
    {113,0xA8},
    {114,0xCE},
    {115,0x00},
    {116,0x39},
    {117,0xA8},
    {118,0xCC},
    {119,0x00},
    {120,0x31},
    {121,0xB4},
    {122,0xD6},
    {123,0x00},
    {124,0x39},
    {125,0xB4},
    {126,0xD5},
    {127,0x00},
    {  0,0xA3},
    {  8,0x99},
    {  9,0xB0},
    { 10,0xD3},
    { 11,0x00},
    { 12,0x39},
    { 13,0xB0},
    { 14,0xD2},
    { 15,0x00},
    { 16,0x00},
    { 17,0x04},
    { 18,0x00},
    { 19,0x00},
    { 20,0x50},
    { 21,0x04},
    { 22,0x03},
    { 23,0x00},
    { 24,0x31},
    { 25,0x98},
    { 26,0x75},
    { 27,0x00},
    { 28,0x31},
    { 29,0x9C},
    { 30,0x90},
    { 31,0x00},
    { 32,0x20},
    { 33,0x08},
    { 34,0xDA},
    { 35,0x00},
    { 36,0x99},
    { 37,0x9C},
    { 38,0x88},
    { 39,0x00},
    { 40,0x39},
    { 41,0xA0},
    { 42,0x89},
    { 43,0x00},
    { 44,0x39},
    { 45,0xA0},
    { 46,0x8F},
    { 47,0x00},
    { 48,0x39},
    { 49,0xA4},
    { 50,0x8E},
    { 51,0x00},
    { 52,0x39},
    { 53,0xA4},
    { 54,0x8A},
    { 55,0x00},
    { 56,0x39},
    { 57,0xA8},
    { 58,0x8D},
    { 59,0x00},
    { 60,0x39},
    { 61,0xA8},
    { 62,0x8B},
    { 63,0x00},
    { 64,0x31},
    { 65,0xB4},
    { 66,0x95},
    { 67,0x00},
    { 68,0x39},
    { 69,0xB4},
    { 70,0x94},
    { 71,0x00},
    { 72,0x99},
    { 73,0xB0},
    { 74,0x92},
    { 75,0x00},
    { 76,0x39},
    { 77,0xB0},
    { 78,0x91},
    { 79,0x00},
    { 80,0x00},
    { 81,0x00},
    { 82,0x00},
    { 83,0x00},
    { 84,0x50},
    { 85,0x00},
    { 86,0x03},
    { 87,0x00},
    { 88,0x31},
    { 89,0xB8},
    { 90,0xD3},
    { 91,0x00},
    { 92,0x39},
    { 93,0xB8},
    { 94,0xD5},
    { 95,0x00},
    { 96,0x20},
    { 97,0x08},
    { 98,0x99},
    { 99,0x00},
    {100,0x39},
    {101,0xBC},
    {102,0xD6},
    {103,0x00},
    {104,0x00},
    {105,0x04},
    {106,0x00},
    {107,0x00},
    {108,0x50},
    {109,0x04},
    {110,0x03},
    {111,0x00},
    {112,0x00},
    {113,0x00},
    {114,0x00},
    {115,0x00},
    {116,0x00},
    {117,0x00},
    {118,0x00},
    {119,0x00},
    {120,0x20},
    {121,0x08},
    {122,0xD9},
    {123,0x00},
    {124,0x30},
    {125,0x98},
    {126,0x34},
    {127,0x00},
    {  0,0xA4},
    {  8,0x30},
    {  9,0x9C},
    { 10,0x34},
    { 11,0x00},
    { 12,0x18},
    { 13,0xEC},
    { 14,0x04},
    { 15,0x00},
    { 16,0x18},
    { 17,0xF0},
    { 18,0x03},
    { 19,0x00},
    { 20,0x90},
    { 21,0x78},
    { 22,0x00},
    { 23,0x00},
    { 24,0x30},
    { 25,0xA4},
    { 26,0x36},
    { 27,0x00},
    { 28,0x38},
    { 29,0xB8},
    { 30,0x37},
    { 31,0x00},
    { 32,0x30},
    { 33,0xAC},
    { 34,0x36},
    { 35,0x00},
    { 36,0x90},
    { 37,0x7C},
    { 38,0x00},
    { 39,0x00},
    { 40,0x20},
    { 41,0x00},
    { 42,0x41},
    { 43,0x00},
    { 44,0x90},
    { 45,0xFC},
    { 46,0x00},
    { 47,0x00},
    { 48,0x38},
    { 49,0xB4},
    { 50,0x37},
    { 51,0x00},
    { 52,0x30},
    { 53,0xB4},
    { 54,0x36},
    { 55,0x00},
    { 56,0x90},
    { 57,0x7C},
    { 58,0x00},
    { 59,0x00},
    { 60,0x20},
    { 61,0x00},
    { 62,0x42},
    { 63,0x00},
    { 64,0x90},
    { 65,0xFC},
    { 66,0x00},
    { 67,0x00},
    { 68,0x38},
    { 69,0xAC},
    { 70,0x37},
    { 71,0x00},
    { 72,0x30},
    { 73,0xB8},
    { 74,0x36},
    { 75,0x00},
    { 76,0x90},
    { 77,0x7C},
    { 78,0x00},
    { 79,0x00},
    { 80,0x20},
    { 81,0x00},
    { 82,0x44},
    { 83,0x00},
    { 84,0x90},
    { 85,0xFC},
    { 86,0x00},
    { 87,0x00},
    { 88,0x38},
    { 89,0xA4},
    { 90,0x37},
    { 91,0x00},
    { 92,0x90},
    { 93,0xF8},
    { 94,0x00},
    { 95,0x00},
    { 96,0x00},
    { 97,0x00},
    { 98,0x00},
    { 99,0x00},
    {100,0x40},
    {101,0x84},
    {102,0x00},
    {103,0x00},
    {104,0x30},
    {105,0x87},
    {106,0xFB},
    {107,0x00},
    {108,0xD8},
    {109,0xA3},
    {110,0xFB},
    {111,0x00},
    {112,0x00},
    {113,0x00},
    {114,0x00},
    {115,0x00},
    {116,0x48},
    {117,0x84},
    {118,0x02},
    {119,0x00},
    {120,0xD8},
    {121,0x37},
    {122,0xFB},
    {123,0x00},
    {124,0x40},
    {125,0x8C},
    {126,0x02},
    {127,0x00},
    {  0,0xA5},
    {  8,0x48},
    {  9,0x8C},
    { 10,0x01},
    { 11,0x00},
    { 12,0x00},
    { 13,0x00},
    { 14,0x00},
    { 15,0x00},
    { 16,0x48},
    { 17,0x84},
    { 18,0x01},
    { 19,0x00},
    { 20,0xD8},
    { 21,0x37},
    { 22,0xFB},
    { 23,0x00},
    { 24,0x40},
    { 25,0x8C},
    { 26,0x01},
    { 27,0x00},
    { 28,0x48},
    { 29,0x8C},
    { 30,0x01},
    { 31,0x00},
    { 32,0x00},
    { 33,0x00},
    { 34,0x00},
    { 35,0x00},
    { 36,0x48},
    { 37,0x84},
    { 38,0x01},
    { 39,0x00},
    { 40,0xD8},
    { 41,0x37},
    { 42,0xFB},
    { 43,0x00},
    { 44,0x40},
    { 45,0x8C},
    { 46,0x01},
    { 47,0x00},
    { 48,0x48},
    { 49,0x8C},
    { 50,0x01},
    { 51,0x00},
    { 52,0x00},
    { 53,0x00},
    { 54,0x00},
    { 55,0x00},
    { 56,0x90},
    { 57,0x7C},
    { 58,0x00},
    { 59,0x00},
    { 60,0x20},
    { 61,0x04},
    { 62,0x43},
    { 63,0x00},
    { 64,0x90},
    { 65,0xFC},
    { 66,0x00},
    { 67,0x00},
    { 68,0x11},
    { 69,0xF0},
    { 70,0x15},
    { 71,0x00},
    { 72,0x30},
    { 73,0x3C},
    { 74,0x02},
    { 75,0x00},
    { 76,0x30},
    { 77,0x3C},
    { 78,0x00},
    { 79,0x00},
    { 80,0x90},
    { 81,0x7C},
    { 82,0x00},
    { 83,0x00},
    { 84,0x20},
    { 85,0x04},
    { 86,0x39},
    { 87,0x00},
    { 88,0x90},
    { 89,0xFC},
    { 90,0x00},
    { 91,0x00},
    { 92,0x20},
    { 93,0x04},
    { 94,0x03},
    { 95,0x00},
    { 96,0x31},
    { 97,0xCB},
    { 98,0xFB},
    { 99,0x00},
    {100,0x00},
    {101,0x00},
    {102,0x00},
    {103,0x00},
    {104,0x38},
    {105,0x03},
    {106,0xFB},
    {107,0x00},
    {108,0x88},
    {109,0x17},
    {110,0xFE},
    {111,0x00},
    {112,0x10},
    {113,0x04},
    {114,0xDC},
    {115,0x00},
    {116,0x10},
    {117,0x00},
    {118,0x9B},
    {119,0x00},
    {120,0x31},
    {121,0xB8},
    {122,0x92},
    {123,0x00},
    {124,0x39},
    {125,0xB8},
    {126,0x94},
    {127,0x00},
    {  0,0xA6},
    {  8,0x39},
    {  9,0xBC},
    { 10,0x95},
    { 11,0x00},
    { 12,0x00},
    { 13,0x00},
    { 14,0x00},
    { 15,0x00},
    { 16,0x50},
    { 17,0x00},
    { 18,0x03},
    { 19,0x00},
    { 20,0x31},
    { 21,0xAC},
    { 22,0xCF},
    { 23,0x00},
    { 24,0x31},
    { 25,0xB0},
    { 26,0xD5},
    { 27,0x00},
    { 28,0x20},
    { 29,0x08},
    { 30,0x98},
    { 31,0x00},
    { 32,0x99},
    { 33,0xB0},
    { 34,0xD1},
    { 35,0x00},
    { 36,0x39},
    { 37,0xB4},
    { 38,0xD3},
    { 39,0x00},
    { 40,0x39},
    { 41,0xB4},
    { 42,0xD6},
    { 43,0x00},
    { 44,0x00},
    { 45,0x04},
    { 46,0x00},
    { 47,0x00},
    { 48,0x50},
    { 49,0x04},
    { 50,0x03},
    { 51,0x00},
    { 52,0x31},
    { 53,0xAC},
    { 54,0x8E},
    { 55,0x00},
    { 56,0x31},
    { 57,0xB0},
    { 58,0x94},
    { 59,0x00},
    { 60,0x20},
    { 61,0x08},
    { 62,0xD8},
    { 63,0x00},
    { 64,0x99},
    { 65,0xB0},
    { 66,0x90},
    { 67,0x00},
    { 68,0x39},
    { 69,0xB4},
    { 70,0x92},
    { 71,0x00},
    { 72,0x39},
    { 73,0xB4},
    { 74,0x95},
    { 75,0x00},
    { 76,0x00},
    { 77,0x00},
    { 78,0x00},
    { 79,0x00},
    { 80,0x50},
    { 81,0x00},
    { 82,0x03},
    { 83,0x00},
    { 84,0x31},
    { 85,0xB8},
    { 86,0xD1},
    { 87,0x00},
    { 88,0x39},
    { 89,0xB8},
    { 90,0xD6},
    { 91,0x00},
    { 92,0x20},
    { 93,0x08},
    { 94,0x97},
    { 95,0x00},
    { 96,0x39},
    { 97,0xBC},
    { 98,0xD3},
    { 99,0x00},
    {100,0x00},
    {101,0x04},
    {102,0x00},
    {103,0x00},
    {104,0x50},
    {105,0x04},
    {106,0x03},
    {107,0x00},
    {108,0x31},
    {109,0xB8},
    {110,0x90},
    {111,0x00},
    {112,0x39},
    {113,0xB8},
    {114,0x95},
    {115,0x00},
    {116,0x20},
    {117,0x08},
    {118,0xD7},
    {119,0x00},
    {120,0x39},
    {121,0xBC},
    {122,0x92},
    {123,0x00},
    {124,0x00},
    {125,0x00},
    {126,0x00},
    {127,0x00},
    {  0,0xA7},
    {  8,0x50},
    {  9,0x00},
    { 10,0x03},
    { 11,0x00},
    { 12,0x00},
    { 13,0x00},
    { 14,0x00},
    { 15,0x00},
    { 16,0x00},
    { 17,0x00},
    { 18,0x00},
    { 19,0x00},
    { 20,0x20},
    { 21,0x08},
    { 22,0x96},
    { 23,0x00},
    { 24,0x31},
    { 25,0xCF},
    { 26,0xFB},
    { 27,0x00},
    { 28,0x00},
    { 29,0x00},
    { 30,0x00},
    { 31,0x00},
    { 32,0x38},
    { 33,0x03},
    { 34,0xFB},
    { 35,0x00},
    { 36,0x88},
    { 37,0x17},
    { 38,0xFE},
    { 39,0x00},
    { 40,0x00},
    { 41,0x00},
    { 42,0x00},
    { 43,0x00},
    { 44,0x10},
    { 45,0x04},
    { 46,0xDB},
    { 47,0x00},
    { 48,0x10},
    { 49,0x00},
    { 50,0x9A},
    { 51,0x00},
    { 52,0x31},
    { 53,0xD3},
    { 54,0xFB},
    { 55,0x00},
    { 56,0x00},
    { 57,0x00},
    { 58,0x00},
    { 59,0x00},
    { 60,0x38},
    { 61,0x03},
    { 62,0xFB},
    { 63,0x00},
    { 64,0x88},
    { 65,0x17},
    { 66,0xFE},
    { 67,0x00},
    { 68,0x00},
    { 69,0x00},
    { 70,0x00},
    { 71,0x00},
    { 72,0x10},
    { 73,0x04},
    { 74,0xDA},
    { 75,0x00},
    { 76,0x10},
    { 77,0x00},
    { 78,0x99},
    { 79,0x00},
    { 80,0x30},
    { 81,0x3C},
    { 82,0x01},
    { 83,0x00},
    { 84,0x30},
    { 85,0x30},
    { 86,0x41},
    { 87,0x00},
    { 88,0x30},
    { 89,0x30},
    { 90,0x42},
    { 91,0x00},
    { 92,0x20},
    { 93,0x04},
    { 94,0x1B},
    { 95,0x00},
    { 96,0x40},
    { 97,0x7C},
    { 98,0x01},
    { 99,0x00},
    {100,0x40},
    {101,0x80},
    {102,0x01},
    {103,0x00},
    {104,0x30},
    {105,0x30},
    {106,0x43},
    {107,0x00},
    {108,0x30},
    {109,0x30},
    {110,0x44},
    {111,0x00},
    {112,0x30},
    {113,0x7C},
    {114,0x03},
    {115,0x00},
    {116,0x40},
    {117,0x84},
    {118,0x01},
    {119,0x00},
    {120,0x40},
    {121,0x88},
    {122,0x01},
    {123,0x00},
    {124,0xD8},
    {125,0xA8},
    {126,0x04},
    {127,0x00},
    {  0,0xA8},
    {  8,0x38},
    {  9,0x80},
    { 10,0x05},
    { 11,0x00},
    { 12,0xD8},
    { 13,0xB0},
    { 14,0x07},
    { 15,0x00},
    { 16,0x38},
    { 17,0x88},
    { 18,0x08},
    { 19,0x00},
    { 20,0x30},
    { 21,0x30},
    { 22,0x45},
    { 23,0x00},
    { 24,0x48},
    { 25,0x84},
    { 26,0x02},
    { 27,0x00},
    { 28,0x30},
    { 29,0x7C},
    { 30,0x1B},
    { 31,0x00},
    { 32,0x40},
    { 33,0x7C},
    { 34,0x01},
    { 35,0x00},
    { 36,0x20},
    { 37,0x00},
    { 38,0x06},
    { 39,0x00},
    { 40,0xD8},
    { 41,0xA8},
    { 42,0x1C},
    { 43,0x00},
    { 44,0x38},
    { 45,0x80},
    { 46,0x1D},
    { 47,0x00},
    { 48,0xD8},
    { 49,0xB0},
    { 50,0x1F},
    { 51,0x00},
    { 52,0x38},
    { 53,0x88},
    { 54,0x20},
    { 55,0x00},
    { 56,0x30},
    { 57,0x30},
    { 58,0x46},
    { 59,0x00},
    { 60,0x48},
    { 61,0x84},
    { 62,0x02},
    { 63,0x00},
    { 64,0x30},
    { 65,0x30},
    { 66,0x47},
    { 67,0x00},
    { 68,0x40},
    { 69,0x80},
    { 70,0x01},
    { 71,0x00},
    { 72,0x20},
    { 73,0x00},
    { 74,0x1E},
    { 75,0x00},
    { 76,0x40},
    { 77,0x84},
    { 78,0x01},
    { 79,0x00},
    { 80,0x30},
    { 81,0x30},
    { 82,0x48},
    { 83,0x00},
    { 84,0x30},
    { 85,0x80},
    { 86,0x08},
    { 87,0x00},
    { 88,0xD8},
    { 89,0xC0},
    { 90,0x07},
    { 91,0x00},
    { 92,0x40},
    { 93,0x88},
    { 94,0x01},
    { 95,0x00},
    { 96,0x38},
    { 97,0x7C},
    { 98,0x06},
    { 99,0x00},
    {100,0xD8},
    {101,0xC8},
    {102,0x0A},
    {103,0x00},
    {104,0x38},
    {105,0x88},
    {106,0x0B},
    {107,0x00},
    {108,0x30},
    {109,0x30},
    {110,0x49},
    {111,0x00},
    {112,0x48},
    {113,0x84},
    {114,0x02},
    {115,0x00},
    {116,0x30},
    {117,0x7C},
    {118,0x1E},
    {119,0x00},
    {120,0x40},
    {121,0x7C},
    {122,0x01},
    {123,0x00},
    {124,0x20},
    {125,0x00},
    {126,0x09},
    {127,0x00},
    {  0,0xA9},
    {  8,0xD8},
    {  9,0xC0},
    { 10,0x1F},
    { 11,0x00},
    { 12,0x38},
    { 13,0x80},
    { 14,0x20},
    { 15,0x00},
    { 16,0xD8},
    { 17,0xC8},
    { 18,0x22},
    { 19,0x00},
    { 20,0x38},
    { 21,0x88},
    { 22,0x23},
    { 23,0x00},
    { 24,0x30},
    { 25,0x30},
    { 26,0x4A},
    { 27,0x00},
    { 28,0x48},
    { 29,0x84},
    { 30,0x02},
    { 31,0x00},
    { 32,0x30},
    { 33,0x30},
    { 34,0x4B},
    { 35,0x00},
    { 36,0x40},
    { 37,0x80},
    { 38,0x01},
    { 39,0x00},
    { 40,0x20},
    { 41,0x00},
    { 42,0x21},
    { 43,0x00},
    { 44,0x40},
    { 45,0x84},
    { 46,0x01},
    { 47,0x00},
    { 48,0x30},
    { 49,0x30},
    { 50,0x4C},
    { 51,0x00},
    { 52,0x30},
    { 53,0x80},
    { 54,0x0B},
    { 55,0x00},
    { 56,0xD8},
    { 57,0xD8},
    { 58,0x0A},
    { 59,0x00},
    { 60,0x40},
    { 61,0x88},
    { 62,0x01},
    { 63,0x00},
    { 64,0x38},
    { 65,0x7C},
    { 66,0x09},
    { 67,0x00},
    { 68,0xD8},
    { 69,0xE0},
    { 70,0x0D},
    { 71,0x00},
    { 72,0x38},
    { 73,0x88},
    { 74,0x0E},
    { 75,0x00},
    { 76,0x30},
    { 77,0x30},
    { 78,0x4D},
    { 79,0x00},
    { 80,0x48},
    { 81,0x84},
    { 82,0x02},
    { 83,0x00},
    { 84,0x30},
    { 85,0x7C},
    { 86,0x21},
    { 87,0x00},
    { 88,0x40},
    { 89,0x7C},
    { 90,0x01},
    { 91,0x00},
    { 92,0x20},
    { 93,0x00},
    { 94,0x0C},
    { 95,0x00},
    { 96,0xD8},
    { 97,0xD8},
    { 98,0x22},
    { 99,0x00},
    {100,0x38},
    {101,0x80},
    {102,0x23},
    {103,0x00},
    {104,0xD8},
    {105,0xE0},
    {106,0x25},
    {107,0x00},
    {108,0x38},
    {109,0x88},
    {110,0x26},
    {111,0x00},
    {112,0x30},
    {113,0x30},
    {114,0x4E},
    {115,0x00},
    {116,0x48},
    {117,0x84},
    {118,0x02},
    {119,0x00},
    {120,0x30},
    {121,0x30},
    {122,0x4F},
    {123,0x00},
    {124,0x40},
    {125,0x80},
    {126,0x01},
    {127,0x00},
    {  0,0xAA},
    {  8,0x20},
    {  9,0x00},
    { 10,0x24},
    { 11,0x00},
    { 12,0x40},
    { 13,0x84},
    { 14,0x01},
    { 15,0x00},
    { 16,0x30},
    { 17,0x30},
    { 18,0x50},
    { 19,0x00},
    { 20,0x30},
    { 21,0x80},
    { 22,0x0E},
    { 23,0x00},
    { 24,0xD8},
    { 25,0xF0},
    { 26,0x0D},
    { 27,0x00},
    { 28,0x40},
    { 29,0x88},
    { 30,0x01},
    { 31,0x00},
    { 32,0x38},
    { 33,0x7C},
    { 34,0x0C},
    { 35,0x00},
    { 36,0xD8},
    { 37,0xF8},
    { 38,0x10},
    { 39,0x00},
    { 40,0x38},
    { 41,0x88},
    { 42,0x11},
    { 43,0x00},
    { 44,0x30},
    { 45,0x30},
    { 46,0x51},
    { 47,0x00},
    { 48,0x48},
    { 49,0x84},
    { 50,0x02},
    { 51,0x00},
    { 52,0x30},
    { 53,0x7C},
    { 54,0x24},
    { 55,0x00},
    { 56,0x40},
    { 57,0x7C},
    { 58,0x01},
    { 59,0x00},
    { 60,0x20},
    { 61,0x00},
    { 62,0x0F},
    { 63,0x00},
    { 64,0xD8},
    { 65,0xF0},
    { 66,0x25},
    { 67,0x00},
    { 68,0x38},
    { 69,0x80},
    { 70,0x26},
    { 71,0x00},
    { 72,0xD8},
    { 73,0xF8},
    { 74,0x28},
    { 75,0x00},
    { 76,0x38},
    { 77,0x88},
    { 78,0x29},
    { 79,0x00},
    { 80,0x30},
    { 81,0x30},
    { 82,0x52},
    { 83,0x00},
    { 84,0x48},
    { 85,0x84},
    { 86,0x02},
    { 87,0x00},
    { 88,0x30},
    { 89,0x30},
    { 90,0x53},
    { 91,0x00},
    { 92,0x40},
    { 93,0x80},
    { 94,0x01},
    { 95,0x00},
    { 96,0x20},
    { 97,0x00},
    { 98,0x27},
    { 99,0x00},
    {100,0x40},
    {101,0x84},
    {102,0x01},
    {103,0x00},
    {104,0x30},
    {105,0x30},
    {106,0x54},
    {107,0x00},
    {108,0x30},
    {109,0x80},
    {110,0x11},
    {111,0x00},
    {112,0xD9},
    {113,0x08},
    {114,0x10},
    {115,0x00},
    {116,0x40},
    {117,0x88},
    {118,0x01},
    {119,0x00},
    {120,0x38},
    {121,0x7C},
    {122,0x0F},
    {123,0x00},
    {124,0xD9},
    {125,0x10},
    {126,0x13},
    {127,0x00},
    {  0,0xAB},
    {  8,0x38},
    {  9,0x88},
    { 10,0x14},
    { 11,0x00},
    { 12,0x00},
    { 13,0x00},
    { 14,0x00},
    { 15,0x00},
    { 16,0x48},
    { 17,0x84},
    { 18,0x02},
    { 19,0x00},
    { 20,0x30},
    { 21,0x7C},
    { 22,0x27},
    { 23,0x00},
    { 24,0xD9},
    { 25,0x08},
    { 26,0x28},
    { 27,0x00},
    { 28,0x20},
    { 29,0x00},
    { 30,0x12},
    { 31,0x00},
    { 32,0x38},
    { 33,0x80},
    { 34,0x29},
    { 35,0x00},
    { 36,0xD9},
    { 37,0x10},
    { 38,0x2B},
    { 39,0x00},
    { 40,0x38},
    { 41,0x88},
    { 42,0x2C},
    { 43,0x00},
    { 44,0x00},
    { 45,0x00},
    { 46,0x00},
    { 47,0x00},
    { 48,0x48},
    { 49,0x84},
    { 50,0x02},
    { 51,0x00},
    { 52,0x00},
    { 53,0x00},
    { 54,0x00},
    { 55,0x00},
    { 56,0x00},
    { 57,0x00},
    { 58,0x00},
    { 59,0x00},
    { 60,0x20},
    { 61,0x00},
    { 62,0x2A},
    { 63,0x00},
    { 64,0x30},
    { 65,0x30},
    { 66,0x55},
    { 67,0x00},
    { 68,0x30},
    { 69,0x30},
    { 70,0x56},
    { 71,0x00},
    { 72,0x30},
    { 73,0x30},
    { 74,0x57},
    { 75,0x00},
    { 76,0x40},
    { 77,0x7C},
    { 78,0x01},
    { 79,0x00},
    { 80,0x40},
    { 81,0x80},
    { 82,0x01},
    { 83,0x00},
    { 84,0x40},
    { 85,0x84},
    { 86,0x01},
    { 87,0x00},
    { 88,0x30},
    { 89,0x30},
    { 90,0x58},
    { 91,0x00},
    { 92,0x30},
    { 93,0x7C},
    { 94,0x12},
    { 95,0x00},
    { 96,0xD9},
    { 97,0x20},
    { 98,0x13},
    { 99,0x00},
    {100,0x40},
    {101,0x88},
    {102,0x01},
    {103,0x00},
    {104,0x38},
    {105,0x80},
    {106,0x14},
    {107,0x00},
    {108,0xD9},
    {109,0x28},
    {110,0x16},
    {111,0x00},
    {112,0x38},
    {113,0x88},
    {114,0x17},
    {115,0x00},
    {116,0x30},
    {117,0x30},
    {118,0x59},
    {119,0x00},
    {120,0x48},
    {121,0x84},
    {122,0x02},
    {123,0x00},
    {124,0x30},
    {125,0x7C},
    {126,0x2A},
    {127,0x00},
    {  0,0xAC},
    {  8,0x40},
    {  9,0x7C},
    { 10,0x01},
    { 11,0x00},
    { 12,0x20},
    { 13,0x00},
    { 14,0x15},
    { 15,0x00},
    { 16,0xD9},
    { 17,0x20},
    { 18,0x2B},
    { 19,0x00},
    { 20,0x38},
    { 21,0x80},
    { 22,0x2C},
    { 23,0x00},
    { 24,0xD9},
    { 25,0x28},
    { 26,0x2E},
    { 27,0x00},
    { 28,0x38},
    { 29,0x88},
    { 30,0x2F},
    { 31,0x00},
    { 32,0x30},
    { 33,0x30},
    { 34,0x5A},
    { 35,0x00},
    { 36,0x48},
    { 37,0x84},
    { 38,0x02},
    { 39,0x00},
    { 40,0x30},
    { 41,0x30},
    { 42,0x5B},
    { 43,0x00},
    { 44,0x40},
    { 45,0x80},
    { 46,0x01},
    { 47,0x00},
    { 48,0x20},
    { 49,0x00},
    { 50,0x2D},
    { 51,0x00},
    { 52,0x40},
    { 53,0x84},
    { 54,0x01},
    { 55,0x00},
    { 56,0x30},
    { 57,0x30},
    { 58,0x5C},
    { 59,0x00},
    { 60,0x30},
    { 61,0x80},
    { 62,0x17},
    { 63,0x00},
    { 64,0xD9},
    { 65,0x38},
    { 66,0x16},
    { 67,0x00},
    { 68,0x40},
    { 69,0x88},
    { 70,0x01},
    { 71,0x00},
    { 72,0x38},
    { 73,0x7C},
    { 74,0x15},
    { 75,0x00},
    { 76,0xD9},
    { 77,0x40},
    { 78,0x19},
    { 79,0x00},
    { 80,0x38},
    { 81,0x88},
    { 82,0x1A},
    { 83,0x00},
    { 84,0x00},
    { 85,0x00},
    { 86,0x00},
    { 87,0x00},
    { 88,0x48},
    { 89,0x84},
    { 90,0x02},
    { 91,0x00},
    { 92,0x30},
    { 93,0x7C},
    { 94,0x2D},
    { 95,0x00},
    { 96,0xD9},
    { 97,0x38},
    { 98,0x2E},
    { 99,0x00},
    {100,0x20},
    {101,0x00},
    {102,0x18},
    {103,0x00},
    {104,0x38},
    {105,0x80},
    {106,0x2F},
    {107,0x00},
    {108,0xD9},
    {109,0x40},
    {110,0x31},
    {111,0x00},
    {112,0x38},
    {113,0x88},
    {114,0x32},
    {115,0x00},
    {116,0x30},
    {117,0x30},
    {118,0x5A},
    {119,0x00},
    {120,0x48},
    {121,0x84},
    {122,0x02},
    {123,0x00},
    {124,0x00},
    {125,0x00},
    {126,0x00},
    {127,0x00},
    {  0,0xAD},
    {  8,0x00},
    {  9,0x00},
    { 10,0x00},
    { 11,0x00},
    { 12,0x20},
    { 13,0x00},
    { 14,0x30},
    { 15,0x00},
    { 16,0x31},
    { 17,0xD7},
    { 18,0xFB},
    { 19,0x00},
    { 20,0x00},
    { 21,0x00},
    { 22,0x00},
    { 23,0x00},
    { 24,0x38},
    { 25,0x03},
    { 26,0xFB},
    { 27,0x00},
    { 28,0x88},
    { 29,0x17},
    { 30,0xFE},
    { 31,0x00},
    { 32,0x30},
    { 33,0x30},
    { 34,0x18},
    { 35,0x00},
    { 36,0x30},
    { 37,0x30},
    { 38,0x30},
    { 39,0x00},
    { 40,0x00},
    { 41,0x00},
    { 42,0x00},
    { 43,0x00},
    { 44,0x20},
    { 45,0x04},
    { 46,0x60},
    { 47,0x00},
    { 48,0x20},
    { 49,0x04},
    { 50,0x9F},
    { 51,0x00},
    { 52,0x10},
    { 53,0x04},
    { 54,0xD9},
    { 55,0x00},
    { 56,0x10},
    { 57,0x00},
    { 58,0x98},
    { 59,0x00},
    { 60,0x88},
    { 61,0x03},
    { 62,0xFF},
    { 63,0x00},
};
#define miniDSP_D_reg_values_COEFF_START   0
#define miniDSP_D_reg_values_COEFF_SIZE    952
#define miniDSP_D_reg_values_INST_START    952
#define miniDSP_D_reg_values_INST_SIZE     2598
