//========================
//       cc1101.c
//========================

#include <reg52.h>
#include <intrins.h>
#include "cc1101.h"

//***************๦ʲÿϸοDATACC1100Ӣĵе48-49ҳĲ******************
//INT8U xdata PaTabel[8] = {0x04 ,0x04 ,0x04 ,0x04 ,0x04 ,0x04 ,0x04 ,0x04};  //-30dBm   С
//INT8U xdata PaTabel[8] = {0x60 ,0x60 ,0x60 ,0x60 ,0x60 ,0x60 ,0x60 ,0x60};  //0dBm
INT8U xdata PaTabel[8] ={0xC0 ,0xC0 ,0xC0 ,0xC0 ,0xC0 ,0xC0 ,0xC0 ,0xC0};   //10dBm  //{0xFF,0xff,0xff,0xff,0xff,0xff,0xff,0xff,};
// INT8U xdata PaTabel[8] ={0x00 ,0x12 ,0x0e ,0x34 ,0x60 ,0xC5 ,0xC1 ,0xC0};  

/////////////////////////////////////////////////////////////////
const RF_SETTINGS rfSettings = 
{ 
    0x08,   // FSCTRL1   Frequency synthesizer control.
    0x00,   // FSCTRL0   Frequency synthesizer control.
    0x12,//0x10,   // FREQ2     Frequency control word, high byte.
    0x76,//0xA7,   // FREQ1     Frequency control word, middle byte.
    0x27,//0x62,   // FREQ0     Frequency control word, low byte.
    0x5b,//޸Ĳ0x5B,   // MDMCFG4   Modem configuration.
    0x93,//޸Ĳ0xF8,   // MDMCFG3   Modem configuration.
    0x83,//0x03,   // MDMCFG2   Modem configuration.
    0x22,   // MDMCFG1   Modem configuration.
    0xF8,   // MDMCFG0   Modem configuration.

    0x00,   // CHANNR    Channel number.
    0x47,   // DEVIATN   Modem deviation setting (when FSK modulation is enabled).
    0xB6,   // FREND1    Front end RX configuration.
    0x17,//0,   // FREND0    Front end RX configuration.    
    0x18,   // MCSM0     Main Radio Control State Machine configuration.
    0x1D,   // FOCCFG    Frequency Offset Compensation Configuration.
    0x1C,   // BSCFG     Bit synchronization Configuration.
    0xC7,   // AGCCTRL2  AGC control.
    0x00,   // AGCCTRL1  AGC control.
    0xB2,   // AGCCTRL0  AGC control.

    0xEA,   // FSCAL3    Frequency synthesizer calibration.
    0x2A,   // FSCAL2    Frequency synthesizer calibration.
    0x00,   // FSCAL1    Frequency synthesizer calibration.
    0x11,   // FSCAL0    Frequency synthesizer calibration.
    0x59,   // FSTEST    Frequency synthesizer calibration.
    0x81,   // TEST2     Various test settings.
    0x35,   // TEST1     Various test settings.
    0x09,   // TEST0     Various test settings.
    0x0B,   // IOCFG2    GDO2 output pin configuration.
    0x06,   // IOCFG0D   GDO0 output pin configuration. Refer to SmartRF?Studio User Manual for detailed pseudo register explanation.

    0x04,   // PKTCTRL1  Packet automation control.
    0x05,   // PKTCTRL0  Packet automation control.
    0x00,   // ADDR      Device address.
    0x20    // PKTLEN    Packet length.		 old  is  0x0c				,0x20
//	0x06,   //*0x0B IOCFG2    GDO2 output pin configuration.
//    0x2E,   //*0x2E IOCFG1    GDO1 output pin configuration.
//    0x2E,   //*0x0C IOCFG0   GDO0 output pin configuration. Refer to SmartRF?Studio User Manual for detailed pseudo register explanation.
//    0x07, 	// FIFOTHR  RX FIFO and TX FIFO thresholds
//	0xD3, 	// SYNC1  Sync word, high byte
//	0x91, 	// SYNC0  Sync word, low byte
//    0xFF,   // PKTLEN    Packet length.
//    0x04,   //*0x00 PKTCTRL1  Packet automation control.
//    0x45,   //*0x12 PKTCTRL0  Packet automation control.
//    0x00,   // ADDR      Device address.
//    0x00,   // CHANNR    Channel number.
//    0x06,   // 0x0C,   //*0x06 FSCTRL1   Frequency synthesizer control.
//    0x00,   // FSCTRL0   Frequency synthesizer control.
////#ifdef RF_429
////    0x10,   // FREQ2     Frequency control word, high byte.
////    0x80,   // FREQ1     Frequency control word, middle byte.
////    0x83,   // FREQ0     Frequency control word, low byte.
////#endif
////
////#ifdef RF_433
//    0x10,   // FREQ2     Frequency control word, high byte.
//    0xa7,   // FREQ1     Frequency control word, middle byte.
//    0x62,   // FREQ0     Frequency control word, low byte.
////#endif
////#ifdef RF_461
////    0x11,   // FREQ2     Frequency control word, high byte.
////    0xBB,   // FREQ1     Frequency control word, middle byte.
////    0x13,   // FREQ0     Frequency control word, low byte.
////#endif
//  
//    0xF5,   // MDMCFG4   Modem configuration.
//    0x83,   // MDMCFG3   Modem configuration.
//    0x03,   //*0x00 MDMCFG2   Modem configuration.
//    0x22,   // MDMCFG1   Modem configuration.
//    0xF8,   // MDMCFG0   Modem configuration.
//    0x15,   // DEVIATN   Modem deviation setting (when FSK modulation is enabled).
//	0x0E,   //*0x07 MCSM2     Main Radio Control State Machine configuration.
//	0x30,   // MCSM1     Main Radio Control State Machine configuration.
//    0x18,   // MCSM0     Main Radio Control State Machine configuration.
//    0x16,   // 0x15,   //*0x16 FOCCFG    Frequency Offset Compensation Configuration.
//    0x6C,   // BSCFG     Bit synchronization Configuration.
//    0x03,   // AGCCTRL2  AGC control.
//    0x40,   // AGCCTRL1  AGC control.
//    0x91,   // AGCCTRL0  AGC control.
//	0x87,   // WOREVT1  0x1E  //EVENT0ʱ
//	0x6B,   // WOREVT0  0x1F  //...
//	0xF8,   // WORCTRL  0x20  //رRCEVENT1ʱ
//    0x56,   // FREND1    Front end RX configuration.
//    0x10,   // FREND0    Front end RX configuration.
//    0xE9,   // 0xA9,   //*0xE9 FSCAL3    Frequency synthesizer calibration.
//    0x2A,   // 0x2A,   //*0x2A FSCAL2    Frequency synthesizer calibration.
//    0x00,   // 0x0D,   //*0x00 FSCAL1    Frequency synthesizer calibration.
//    0x1F,   // 0x11,   //*0x1F FSCAL0    Frequency synthesizer calibration.
//	//0x09,   // 0x11,   //*0x1F FSCAL0    Frequency synthesizer calibration.

};

//*****************************************************************************************
//delay(unsigned int s)
//룺ʱ
//
//ͨ͢ʱ,ڲ
//*****************************************************************************************		
void delay(unsigned int s)
{
	unsigned int i;
	for(i=0; i<s; i++);
	for(i=0; i<s; i++);
}


void halWait(INT16U timeout) {
    do {
        _nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_(); 
    } while (--timeout);
}


void SpiInit(void)
{
	CSN=0;
	SCK=0;
	CSN=1;
}

/*****************************************************************************************
//CpuInit()
//룺
//
//SPIʼ
/*****************************************************************************************/
void CpuInit(void)
{
	SpiInit();
	delay(5000);
}
	

//*****************************************************************************************
//SpisendByte(INT8U dat)
//룺͵
//
//SPIһֽ
//*****************************************************************************************
INT8U SpiTxRxByte(INT8U dat)
{
	INT8U i,temp;
	temp = 0;
	
	SCK = 0;
	for(i=0; i<8; i++)
	{
		if(dat & 0x80)
		{
			MOSI = 1;
		}
		else MOSI = 0;
		dat <<= 1;

		SCK = 1; 
		_nop_();
		_nop_();

		temp <<= 1;
		if(MISO)temp++; 
		SCK = 0;
		_nop_();
		_nop_();	
	}
	return temp;
}

//*****************************************************************************************
//void RESET_CC1100(void)
//룺
//
//λCC1100
//*****************************************************************************************
void RESET_CC1100(void) 
{
	CSN = 0; 
	while (MISO);
    SpiTxRxByte(CCxxx0_SRES); 		//д븴λ
	while (MISO); 
    CSN = 1; 
}

//*****************************************************************************************
//void POWER_UP_RESET_CC1100(void) 
//룺
//
//ϵ縴λCC1100
//*****************************************************************************************
void POWER_UP_RESET_CC1100(void) 
{
	CSN = 1; 
	halWait(1); 
	CSN = 0; 
	halWait(1); 
	CSN = 1; 
	halWait(41); 
	RESET_CC1100();   		//λCC1100
}

//*****************************************************************************************
//void halSpiWriteReg(INT8U addr, INT8U value)
//룺ַ
//
//SPIдĴ
//*****************************************************************************************
void halSpiWriteReg(INT8U addr, INT8U value) 
{
    CSN = 0;
    while (MISO);
    SpiTxRxByte(addr);		//дַ
    SpiTxRxByte(value);		//д
    CSN = 1;
}

//*****************************************************************************************
//void halSpiWriteBurstReg(INT8U addr, INT8U *buffer, INT8U count)
//룺ַд뻺д
//
//SPIдüĴ
//*****************************************************************************************
void halSpiWriteBurstReg(INT8U addr, INT8U *buffer, INT8U count) 
{
    INT8U i, temp;
	temp = addr | WRITE_BURST;
    CSN = 0;
    while (MISO);
    SpiTxRxByte(temp);
    for (i = 0; i < count; i++)
 	{
        SpiTxRxByte(buffer[i]);
    }
    CSN = 1;
}

//*****************************************************************************************
//void halSpiStrobe(INT8U strobe)
//룺
//
//SPIд
//*****************************************************************************************
void halSpiStrobe(INT8U strobe) 
{
    CSN = 0;
    while (MISO);
    SpiTxRxByte(strobe);		//д
    CSN = 1;
}





//*****************************************************************************************
//INT8U halSpiReadReg(INT8U addr)
//룺ַ
//üĴ
//SPIĴ
//*****************************************************************************************
INT8U halSpiReadReg(INT8U addr) 
{
	INT8U temp, value;
    temp = addr|READ_SINGLE;//Ĵ
	CSN = 0;
	while (MISO);
	SpiTxRxByte(temp);
	value = SpiTxRxByte(0);
	CSN = 1;
	return value;
}


//*****************************************************************************************
//void halSpiReadBurstReg(INT8U addr, INT8U *buffer, INT8U count)
//룺ַݺݴĻø
//
//SPIдüĴ
//*****************************************************************************************
void halSpiReadBurstReg(INT8U addr, INT8U *buffer, INT8U count) 
{
    INT8U i,temp;
	temp = addr | READ_BURST;		//дҪüĴַͶ
    CSN = 0;
    while (MISO);
	SpiTxRxByte(temp);   
    for (i = 0; i < count; i++) 
	{
        buffer[i] = SpiTxRxByte(0);
    }
    CSN = 1;
}


//*****************************************************************************************
//INT8U halSpiReadReg(INT8U addr)
//룺ַ
//״̬Ĵǰֵ
//SPI״̬Ĵ
//*****************************************************************************************
INT8U halSpiReadStatus(INT8U addr) 
{
    INT8U value,temp;
	temp = addr | READ_BURST;		//дҪ״̬Ĵĵַͬʱд
    CSN = 0;
    while (MISO);
    SpiTxRxByte(temp);
	value = SpiTxRxByte(0);
	CSN = 1;
	return value;
}
//*****************************************************************************************
//void halRfWriteRfSettings(RF_SETTINGS *pRfSettings)
//룺
//
//CC1100ļĴ
//*****************************************************************************************
void halRfWriteRfSettings(void) 
{

//	halSpiWriteReg(CCxxx0_FSCTRL0,  rfSettings.FSCTRL2);//Ѽӵ
    // Write register settings
    halSpiWriteReg(CCxxx0_FSCTRL1,  rfSettings.FSCTRL1);
    halSpiWriteReg(CCxxx0_FSCTRL0,  rfSettings.FSCTRL0);
    halSpiWriteReg(CCxxx0_FREQ2,    rfSettings.FREQ2);
    halSpiWriteReg(CCxxx0_FREQ1,    rfSettings.FREQ1);
    halSpiWriteReg(CCxxx0_FREQ0,    rfSettings.FREQ0);
    halSpiWriteReg(CCxxx0_MDMCFG4,  rfSettings.MDMCFG4);
    halSpiWriteReg(CCxxx0_MDMCFG3,  rfSettings.MDMCFG3);
    halSpiWriteReg(CCxxx0_MDMCFG2,  rfSettings.MDMCFG2);
    halSpiWriteReg(CCxxx0_MDMCFG1,  rfSettings.MDMCFG1);
    halSpiWriteReg(CCxxx0_MDMCFG0,  rfSettings.MDMCFG0);
    halSpiWriteReg(CCxxx0_CHANNR,   rfSettings.CHANNR);
    halSpiWriteReg(CCxxx0_DEVIATN,  rfSettings.DEVIATN);
    halSpiWriteReg(CCxxx0_FREND1,   rfSettings.FREND1);
    halSpiWriteReg(CCxxx0_FREND0,   rfSettings.FREND0); 
    halSpiWriteReg(CCxxx0_MCSM0 ,   rfSettings.MCSM0 );
    halSpiWriteReg(CCxxx0_FOCCFG,   rfSettings.FOCCFG);
    halSpiWriteReg(CCxxx0_BSCFG,    rfSettings.BSCFG);
    halSpiWriteReg(CCxxx0_AGCCTRL2, rfSettings.AGCCTRL2);
	halSpiWriteReg(CCxxx0_AGCCTRL1, rfSettings.AGCCTRL1);
    halSpiWriteReg(CCxxx0_AGCCTRL0, rfSettings.AGCCTRL0);
    halSpiWriteReg(CCxxx0_FSCAL3,   rfSettings.FSCAL3);
	halSpiWriteReg(CCxxx0_FSCAL2,   rfSettings.FSCAL2);
	halSpiWriteReg(CCxxx0_FSCAL1,   rfSettings.FSCAL1);
    halSpiWriteReg(CCxxx0_FSCAL0,   rfSettings.FSCAL0);
    halSpiWriteReg(CCxxx0_FSTEST,   rfSettings.FSTEST);
    halSpiWriteReg(CCxxx0_TEST2,    rfSettings.TEST2);
    halSpiWriteReg(CCxxx0_TEST1,    rfSettings.TEST1);
    halSpiWriteReg(CCxxx0_TEST0,    rfSettings.TEST0);
    halSpiWriteReg(CCxxx0_IOCFG2,   rfSettings.IOCFG2);
    halSpiWriteReg(CCxxx0_IOCFG0,   rfSettings.IOCFG0);    
    halSpiWriteReg(CCxxx0_PKTCTRL1, rfSettings.PKTCTRL1);
    halSpiWriteReg(CCxxx0_PKTCTRL0, rfSettings.PKTCTRL0);
    halSpiWriteReg(CCxxx0_ADDR,     rfSettings.ADDR);
    halSpiWriteReg(CCxxx0_PKTLEN,   rfSettings.PKTLEN);
}

//*****************************************************************************************
//void halRfSendPacket(INT8U *txBuffer, INT8U size)
//룺͵Ļݸ
//
//CC1100һ
//*****************************************************************************************

void halRfSendPacket(INT8U *txBuffer, INT8U size) 
{
	halSpiWriteReg(CCxxx0_TXFIFO, size);
    halSpiWriteBurstReg(CCxxx0_TXFIFO, txBuffer, size);	//дҪ͵

    halSpiStrobe(CCxxx0_STX);		//뷢ģʽ

    // Wait for GDO0 to be set -> sync transmitted
    while (!GDO0);
    // Wait for GDO0 to be cleared -> end of packet
    while (GDO0);
    delay(200);
	halSpiStrobe(CCxxx0_SFTX);
}


void setRxMode(void)
{
    halSpiStrobe(CCxxx0_SRX);		//״̬
}

/*
// Bit masks corresponding to STATE[2:0] in the status byte returned on MISO
#define CCxx00_STATE_BM                 0x70
#define CCxx00_FIFO_BYTES_AVAILABLE_BM  0x0F
#define CCxx00_STATE_TX_BM              0x20
#define CCxx00_STATE_TX_UNDERFLOW_BM    0x70
#define CCxx00_STATE_RX_BM              0x10
#define CCxx00_STATE_RX_OVERFLOW_BM     0x60
#define CCxx00_STATE_IDLE_BM            0x00

static INT8U RfGetRxStatus(void)
{
	INT8U temp, spiRxStatus1,spiRxStatus2;
	INT8U i=4;// ѭԴ
    temp = CCxxx0_SNOP|READ_SINGLE;//Ĵ
	CSN = 0;
	while (MISO);
	SpiTxRxByte(temp);
	spiRxStatus1 = SpiTxRxByte(0);
	do
	{
		SpiTxRxByte(temp);
		spiRxStatus2 = SpiTxRxByte(0);
		if(spiRxStatus1 == spiRxStatus2)
		{
			if( (spiRxStatus1 & CCxx00_STATE_BM) == CCxx00_STATE_RX_OVERFLOW_BM)
			{
               halSpiStrobe(CCxxx0_SFRX);
			   return 0;
			}
		    return 1;
		}
		 spiRxStatus1=spiRxStatus2;
	}
	while(i--);
	CSN = 1;
    return 0;	
}
 */
INT8U halRfReceivePacket(INT8U *rxBuffer, INT8U *length) 
{
    INT8U status[2];
    INT8U packetLength;
	INT8U i=(*length)*4;  // Ҫdataratelength		  old is *4

    halSpiStrobe(CCxxx0_SRX);		//״̬
	//delay(5);
    //while (!GDO1);
    //while (GDO1);
	delay(2);
	while (GDO0)
	{
		delay(2);
		--i;
		if(i<1)
		   return 0; 	    
	}	 
    if ((halSpiReadStatus(CCxxx0_RXBYTES) & BYTES_IN_RXFIFO)) //ӵֽΪ0
	{
        packetLength = halSpiReadReg(CCxxx0_RXFIFO);//һֽڣֽΪ֡ݳ
        if (packetLength <= *length) 		//ҪЧݳСڵڽյݰĳ
		{
            halSpiReadBurstReg(CCxxx0_RXFIFO, rxBuffer, packetLength); //нյ
            *length = packetLength;				//ѽݳȵ޸Ϊǰݵĳ
        
            // Read the 2 appended status bytes (status[0] = RSSI, status[1] = LQI)
            halSpiReadBurstReg(CCxxx0_RXFIFO, status, 2); 	//CRCУλ
			halSpiStrobe(CCxxx0_SFRX);		//ϴջ 
            return (status[1] & CRC_OK);			//Уɹؽճɹ
        }
		 else 
		{
            *length = packetLength;
            halSpiStrobe(CCxxx0_SFRX);		//ϴջ
            return 0;
        }
    } 
	else return 0;
}

//main()е CC1100շģú 
void Config_CC1101(void)
{
	CpuInit();		                      //CC1100ʼ
	POWER_UP_RESET_CC1100();              //ģϵ縴λ
	halRfWriteRfSettings();	              //ģ
	halSpiWriteBurstReg(CCxxx0_PATABLE,PaTabel,8);
	delay(6000);
}