//========================
//       cc1101.h
//========================

#ifndef __CC1101_H__
#define __CC1101_H__

#define	INT8U	unsigned char
#define	INT16U	unsigned int

#define WRITE_BURST     	0x40						//д
#define	READ_SINGLE     	0x80						//
#define READ_BURST      	0xC0						//
#define BYTES_IN_RXFIFO     0x7F  						//ջЧֽ
#define	CRC_OK              0x80 						//CRCУͨλ־

/*************************CC1101뵥Ƭ߷ʽ**************************/
sbit 	GDO0	            =P3^3;
sbit 	GDO2	            =P1^2;
sbit	MISO	            =P0^3;
sbit	MOSI	            =P1^6;
sbit	SCK		            =P1^5;
sbit	CSN		            =P0^2;

//*****************************************************************************************
void SpiInit(void);
void CpuInit(void);
void RESET_CC1100(void);
void POWER_UP_RESET_CC1100(void);
void halSpiWriteReg(INT8U addr, INT8U value);
void halSpiWriteBurstReg(INT8U addr, INT8U *buffer, INT8U count);
void halSpiStrobe(INT8U strobe);
INT8U halSpiReadReg(INT8U addr);
void halSpiReadBurstReg(INT8U addr, INT8U *buffer, INT8U count);
INT8U halSpiReadStatus(INT8U addr);
void halRfWriteRfSettings(void);
void halRfSendPacket(INT8U *txBuffer, INT8U size); 
INT8U halRfReceivePacket(INT8U *rxBuffer, INT8U *length);  
//*****************************************************************************************
// CC1100 STROBE, CONTROL AND STATUS REGSITER
#define CCxxx0_IOCFG2       0x00        // GDO2 output pin configuration
#define CCxxx0_IOCFG1       0x01        // GDO1 output pin configuration
#define CCxxx0_IOCFG0       0x02        // GDO0 output pin configuration
#define CCxxx0_FIFOTHR      0x03        // RX FIFO and TX FIFO thresholds
#define CCxxx0_SYNC1        0x04        // Sync word, high INT8U
#define CCxxx0_SYNC0        0x05        // Sync word, low INT8U
#define CCxxx0_PKTLEN       0x06        // Packet length
#define CCxxx0_PKTCTRL1     0x07        // Packet automation control
#define CCxxx0_PKTCTRL0     0x08        // Packet automation control
#define CCxxx0_ADDR         0x09        // Device address
#define CCxxx0_CHANNR       0x0A        // Channel number
#define CCxxx0_FSCTRL1      0x0B        // Frequency synthesizer control
#define CCxxx0_FSCTRL0      0x0C        // Frequency synthesizer control
#define CCxxx0_FREQ2        0x0D        // Frequency control word, high INT8U
#define CCxxx0_FREQ1        0x0E        // Frequency control word, middle INT8U
#define CCxxx0_FREQ0        0x0F        // Frequency control word, low INT8U
#define CCxxx0_MDMCFG4      0x10        // Modem configuration
#define CCxxx0_MDMCFG3      0x11        // Modem configuration
#define CCxxx0_MDMCFG2      0x12        // Modem configuration
#define CCxxx0_MDMCFG1      0x13        // Modem configuration
#define CCxxx0_MDMCFG0      0x14        // Modem configuration
#define CCxxx0_DEVIATN      0x15        // Modem deviation setting
#define CCxxx0_MCSM2        0x16        // Main Radio Control State Machine configuration
#define CCxxx0_MCSM1        0x17        // Main Radio Control State Machine configuration
#define CCxxx0_MCSM0        0x18        // Main Radio Control State Machine configuration
#define CCxxx0_FOCCFG       0x19        // Frequency Offset Compensation configuration
#define CCxxx0_BSCFG        0x1A        // Bit Synchronization configuration
#define CCxxx0_AGCCTRL2     0x1B        // AGC control
#define CCxxx0_AGCCTRL1     0x1C        // AGC control
#define CCxxx0_AGCCTRL0     0x1D        // AGC control
#define CCxxx0_WOREVT1      0x1E        // High INT8U Event 0 timeout
#define CCxxx0_WOREVT0      0x1F        // Low INT8U Event 0 timeout
#define CCxxx0_WORCTRL      0x20        // Wake On Radio control
#define CCxxx0_FREND1       0x21        // Front end RX configuration
#define CCxxx0_FREND0       0x27//2        // Front end TX configuration
#define CCxxx0_FSCAL3       0x23        // Frequency synthesizer calibration
#define CCxxx0_FSCAL2       0x24        // Frequency synthesizer calibration
#define CCxxx0_FSCAL1       0x25        // Frequency synthesizer calibration
#define CCxxx0_FSCAL0       0x26        // Frequency synthesizer calibration
#define CCxxx0_RCCTRL1      0x27        // RC oscillator configuration
#define CCxxx0_RCCTRL0      0x28        // RC oscillator configuration
#define CCxxx0_FSTEST       0x29        // Frequency synthesizer calibration control
#define CCxxx0_PTEST        0x2A        // Production test
#define CCxxx0_AGCTEST      0x2B        // AGC test
#define CCxxx0_TEST2        0x2C        // Various test settings
#define CCxxx0_TEST1        0x2D        // Various test settings
#define CCxxx0_TEST0        0x2E        // Various test settings

// Strobe commands
#define CCxxx0_SRES         0x30        // Reset chip.
#define CCxxx0_SFSTXON      0x31        // Enable and calibrate frequency synthesizer (if MCSM0.FS_AUTOCAL=1).
                                        // If in RX/TX: Go to a wait state where only the synthesizer is
                                        // running (for quick RX / TX turnaround).
#define CCxxx0_SXOFF        0x32        // Turn off crystal oscillator.
#define CCxxx0_SCAL         0x33        // Calibrate frequency synthesizer and turn it off
                                        // (enables quick start).
#define CCxxx0_SRX          0x34        // Enable RX. Perform calibration first if coming from IDLE and
                                        // MCSM0.FS_AUTOCAL=1.
#define CCxxx0_STX          0x35        // In IDLE state: Enable TX. Perform calibration first if
                                        // MCSM0.FS_AUTOCAL=1. If in RX state and CCA is enabled:
                                        // Only go to TX if channel is clear.
#define CCxxx0_SIDLE        0x36        // Exit RX / TX, turn off frequency synthesizer and exit
                                        // Wake-On-Radio mode if applicable.
#define CCxxx0_SAFC         0x37        // Perform AFC adjustment of the frequency synthesizer
#define CCxxx0_SWOR         0x38        // Start automatic RX polling sequence (Wake-on-Radio)
#define CCxxx0_SPWD         0x39        // Enter power down mode when CSn goes high.
#define CCxxx0_SFRX         0x3A        // Flush the RX FIFO buffer.
#define CCxxx0_SFTX         0x3B        // Flush the TX FIFO buffer.
#define CCxxx0_SWORRST      0x3C        // Reset real time clock.
#define CCxxx0_SNOP         0x3D        // No operation. May be used to pad strobe commands to two
                                        // INT8Us for simpler software.

#define CCxxx0_PARTNUM      0x30
#define CCxxx0_VERSION      0x31
#define CCxxx0_FREQEST      0x32
#define CCxxx0_LQI          0x33
#define CCxxx0_RSSI         0x34
#define CCxxx0_MARCSTATE    0x35
#define CCxxx0_WORTIME1     0x36
#define CCxxx0_WORTIME0     0x37
#define CCxxx0_PKTSTATUS    0x38
#define CCxxx0_VCO_VC_DAC   0x39
#define CCxxx0_TXBYTES      0x3A
#define CCxxx0_RXBYTES      0x3B

#define CCxxx0_PATABLE      0x3E
#define CCxxx0_TXFIFO       0x3F
#define CCxxx0_RXFIFO       0x3F

// RF_SETTINGS is a data structure which contains all relevant CCxxx0 registers
typedef struct S_RF_SETTINGS
{
	//INT8U FSCTRL2;		//Ѽӵ
    INT8U FSCTRL1;   // Frequency synthesizer control.
    INT8U FSCTRL0;   // Frequency synthesizer control.
    INT8U FREQ2;     // Frequency control word, high INT8U.
    INT8U FREQ1;     // Frequency control word, middle INT8U.
    INT8U FREQ0;     // Frequency control word, low INT8U.
    INT8U MDMCFG4;   // Modem configuration.
    INT8U MDMCFG3;   // Modem configuration.
    INT8U MDMCFG2;   // Modem configuration.
    INT8U MDMCFG1;   // Modem configuration.
    INT8U MDMCFG0;   // Modem configuration.
    INT8U CHANNR;    // Channel number.
    INT8U DEVIATN;   // Modem deviation setting (when FSK modulation is enabled).
    INT8U FREND1;    // Front end RX configuration.
    INT8U FREND0;    // Front end RX configuration.
    //INT8U MCSM1;     // Main Radio Control State Machine configuration.
    INT8U MCSM0;     // Main Radio Control State Machine configuration.
    INT8U FOCCFG;    // Frequency Offset Compensation Configuration.
    INT8U BSCFG;     // Bit synchronization Configuration.
    INT8U AGCCTRL2;  // AGC control.
	INT8U AGCCTRL1;  // AGC control.
    INT8U AGCCTRL0;  // AGC control.
    INT8U FSCAL3;    // Frequency synthesizer calibration.
    INT8U FSCAL2;    // Frequency synthesizer calibration.
	INT8U FSCAL1;    // Frequency synthesizer calibration.
    INT8U FSCAL0;    // Frequency synthesizer calibration.
    INT8U FSTEST;    // Frequency synthesizer calibration control
    INT8U TEST2;     // Various test settings.
    INT8U TEST1;     // Various test settings.
    INT8U TEST0;     // Various test settings.
    INT8U IOCFG2;    // GDO2 output pin configuration
    INT8U IOCFG0;    // GDO0 output pin configuration
    INT8U PKTCTRL1;  // Packet automation control.
    INT8U PKTCTRL0;  // Packet automation control.
    INT8U ADDR;      // Device address.
    INT8U PKTLEN;    // Packet length.
//    INT8U IOCFG2;    // GDO2 output pin configuration
//    INT8U IOCFG1;    // GDO1 output pin configuration
//    INT8U IOCFG0;    // GDO0 output pin configuration
//    INT8U FIFOTHR;	 // RX FIFO and TX FIFO thresholds
//	INT8U SYNC1;	 // Sync word, high byte
//	INT8U SYNC0;	 // Sync word, low byte
//    INT8U PKTLEN;    // Packet length.
//    INT8U PKTCTRL1;  // Packet automation control.
//    INT8U PKTCTRL0;  // Packet automation control.
//    INT8U ADDR;      // Device address.
//    INT8U CHANNR;    // Channel number.
//    INT8U FSCTRL1;   // Frequency synthesizer control.
//    INT8U FSCTRL0;   // Frequency synthesizer control.
//    INT8U FREQ2;     // Frequency control word, high INT8U.
//    INT8U FREQ1;     // Frequency control word, middle INT8U.
//    INT8U FREQ0;     // Frequency control word, low INT8U.
//    INT8U MDMCFG4;   // Modem configuration.
//    INT8U MDMCFG3;   // Modem configuration.
//    INT8U MDMCFG2;   // Modem configuration.
//    INT8U MDMCFG1;   // Modem configuration.
//    INT8U MDMCFG0;   // Modem configuration.
//    INT8U DEVIATN;   // Modem deviation setting (when FSK modulation is enabled).
//    INT8U MCSM2;     // Main Radio Control State Machine configuration.
//    INT8U MCSM1;     // Main Radio Control State Machine configuration.
//    INT8U MCSM0;     // Main Radio Control State Machine configuration.
//    INT8U FOCCFG;    // Frequency Offset Compensation Configuration.
//    INT8U BSCFG;     // Bit synchronization Configuration.
//    INT8U AGCCTRL2;  // AGC control.
//	INT8U AGCCTRL1;  // AGC control.
//    INT8U AGCCTRL0;  // AGC control.
//	INT8U WOREVT1;   // High byte event0 timeout
//	INT8U WOREVT0;	 // Low byte event0 timeout
//	INT8U WORCTRL;	 // Wake On Radio control
//    INT8U FREND1;    // Front end RX configuration.
//    INT8U FREND0;    // Front end RX configuration.
//    INT8U FSCAL3;    // Frequency synthesizer calibration.
//    INT8U FSCAL2;    // Frequency synthesizer calibration.
//	INT8U FSCAL1;    // Frequency synthesizer calibration.
//    INT8U FSCAL0;    // Frequency synthesizer calibration.
} RF_SETTINGS;



void delay(unsigned int s);

void halWait(INT16U timeout);
void SpiInit(void) ;
void CpuInit(void) ;
void RESET_CC1100(void) ;
void POWER_UP_RESET_CC1100(void) ;

INT8U SpiTxRxByte(INT8U dat);
void halSpiWriteReg(INT8U addr, INT8U value); 
void halSpiWriteBurstReg(INT8U addr, INT8U *buffer, INT8U count); 
void halSpiStrobe(INT8U strobe); 
INT8U halSpiReadReg(INT8U addr);
void halSpiReadBurstReg(INT8U addr, INT8U *buffer, INT8U count) ;
INT8U halSpiReadStatus(INT8U addr);
void halRfWriteRfSettings(void) ;
void halRfSendPacket(INT8U *txBuffer, INT8U size) ;
void setRxMode(void) ;
INT8U halRfReceivePacket(INT8U *rxBuffer, INT8U *length); 
void Config_CC1101(void);

/*=================================  ˴   =========================================*/
#endif