/*******************************************************************************************************
 *                                                                                                     *
 *        **********                                                                                   *
 *       ************                                                                                  *
 *      ***        ***                                                                                 *
 *      ***   +++   ***                                                                                *
 *      ***   + +   ***     This file contains all defines and function prototypes necessary to        *
 *      ***   +             run the WorWithAck example.                                                *
 *      ***   + +   ***                                                                                *
 *      ***   +++   ***     WorWithAck.h                                                               *
 *      ***        ***                                                                                 *
 *       ************                                                                                  *
 *        **********                                                                                   *
 *                                                                                                     *
 *******************************************************************************************************
 * Compiler:                Keil C51 V7.50                                                             *
 * Target platform:         Chipcon CCxxx0 (Silabs F320)                                               *
 * Author:                  ESY                                                                        *
 *******************************************************************************************************
 * Revision history:     See end of file                                                               *
 *******************************************************************************************************/
#include <Chipcon\srf04\regssrf04.h>
#include <Chipcon\srf04\halsrf04.h>
#include <Chipcon\srf04\ebsrf04.h>




//-------------------------------------------------------------------------------------------------------
// Defines

// Defines used as state values for state machine in main loop
#define SETUP       0
#define TX          1
#define RX          2

// Other defines
#define GDO2_PIN    P0_7         
//-------------------------------------------------------------------------------------------------------




//-------------------------------------------------------------------------------------------------------
// Global variables
extern BYTE xdata rxBuffer[];       // Buffer for RX FIFO

extern BYTE xdata asciiString[];    // Byte array used by the intToAscii(UINT32 value) function

extern UINT8 xdata joystickPosition;
extern UINT8 xdata prevJoystickPosition;
//------------------------------------------------------------------------------------------------------




//-------------------------------------------------------------------------------------------------------
// Function declarations
void intToAscii(UINT32 value);          // Converts an UINT32 value to char array, stored in asciiString[]
void showMenu(void);                    // Show the initial setup menu
void parseMenu(UINT8 joystickPosition); // Parses the input for menu navigation
void runTransmitter();
void runReceiver();
//-------------------------------------------------------------------------------------------------------




/******************************************************************************************************
 * Revision history:                                                                                  *
 *
 * $Log: WorWithAck.h,v $
 * Revision 1.1  2005/10/06 12:14:34  sna
 * Initial version in CVS.
 *
 *
 *
 ******************************************************************************************************/

