/*******************************************************************************************************
 *                                                                                                     *
 *        **********                                                                                   *
 *       ************                                                                                  *
 *      ***        ***                                                                                 *
 *      ***   +++   ***                                                                                *
 *      ***   + +   ***     This file is used by the bootloader_reservations.c and should only be      *
 *      ***   +             used when creating bootloader compliant applications.                      *
 *      ***   + +   ***                                                                                *
 *      ***   +++   ***     bootloader_reservations.h                                                  *
 *      ***        ***                                                                                 *
 *       ************                                                                                  *
 *        **********                                                                                   *
 *                                                                                                     *
 *******************************************************************************************************
 * Compiler:                Keil C51 V7.50                                                             *
 * Target platform:         Chipcon CCxxx0 (Silabs F320)                                               *
 * Author:                  JOL                                                                        *
 *******************************************************************************************************
 * Revision history:     See end of file                                                               *
 *******************************************************************************************************/
#ifndef BOOTLOADERRESERVATION_H
#define BOOTLOADERRESERVATION_H

#include <Chipcon\srf04\usb_structs.h>




//-------------------------------------------------------------------------------------------------------
// Memory shared between bootloader and applications

// Data variables (IDATA)
#define SETUP_HEADER_ADDR           0x08
#define SETUP_DATA_ADDR             (SETUP_HEADER_ADDR + sizeof(SETUP_HEADER))
#define USB_INFO_ADDR               (SETUP_DATA_ADDR + sizeof(SETUP_DATA))
#define BOOTLOADER_INFO_ADDR        (USB_INFO_ADDR + sizeof(USB_INFO))
#define SMART_VAR_ADDR              (BOOTLOADER_INFO_ADDR + sizeof(BOOTLOADER_INFO))
#define SMART_VAR_SIZE              (43 - SMART_VAR_ADDR)

// Program and descriptors (CODE)
#define FLASH_PAGE_SIZE 512
#define APP_RESET_ADDR              0x0800
#define APP_DESC_LOCATOR_STARTADDR  (APP_RESET_ADDR + 0x0043 + 3)
#define APP_DESC_LOCATOR_STOPADDR   (APP_DESC_LOCATOR_STARTADDR + sizeof(APP_DESC_LOCATOR))
#define LAST_FLASH_PAGE_STARTADDR   0x3C00
#define LAST_FLASH_PAGE_STOPADDR    0x3DFF
#define FLASH_LOCK_BYTE_ADDR        LAST_FLASH_PAGE_STARTADDR
//-------------------------------------------------------------------------------------------------------




//-------------------------------------------------------------------------------------------------------
// Bootloader data structures
extern SETUP_HEADER data setupHeader;
extern SETUP_DATA data setupData;
extern USB_INFO data usbInfo;
extern BOOTLOADER_INFO data blInfo;
//-------------------------------------------------------------------------------------------------------




#endif// BOOTLOADER_RESERVATIONS




/*******************************************************************************************************
 * Revision history:                                                                                   *
 *
 * $Log: bootloader_reservations.h,v $
 * Revision 1.2  2005/02/07 14:34:36  sna
 * Initial version in CVS.
 *
 *
 *******************************************************************************************************/