/*******************************************************************************************************
 *                                                                                                     *
 *        **********                                                                                   *
 *       ************                                                                                  *
 *      ***        ***                                                                                 *
 *      ***   +++   ***                                                                                *
 *      ***   + +   ***     This file is used by the bootloader_reservations.c and should only be      *
 *      ***   +             used when creating bootloader compliant applications.                      *
 *      ***   + +   ***                                                                                *
 *      ***   +++   ***     bootloader_structs.h                                                       *
 *      ***        ***                                                                                 *
 *       ************                                                                                  *
 *        **********                                                                                   *
 *                                                                                                     *
 *******************************************************************************************************
 * Compiler:                Keil C51 V7.50                                                             *
 * Target platform:         Chipcon CCxxx0 (Silabs F320)                                               *
 * Author:                  JOL                                                                        *
 *******************************************************************************************************
 * Revision history:        See end of file                                                            *
 ******************************************************************************************************/
#ifndef USBSHAREDDEFS_H
#define USBSHAREDDEFS_H

#include <Chipcon\srf04\common.h>




//------------------------------------------------------------------------------------------------------
// Define bmRequestType bitmaps
#define IN_DEVICE               0x00        // Request made to device, direction is IN 
#define OUT_DEVICE              0x80        // Request made to device, direction is OUT
#define IN_INTERFACE            0x01        // Request made to interface, direction is IN
#define OUT_INTERFACE           0x81        // Request made to interface, direction is OUT
#define IN_ENDPOINT             0x02        // Request made to endpoint, direction is IN
#define OUT_ENDPOINT            0x82        // Request made to endpoint, direction is OUT

// bmRequestType Masks
#define CMD_MASK_DIR            0x80     // Request direction bit mask
#define CMD_MASK_TYPE           0x60     // Request type bit mask
#define CMD_MASK_RECIP          0x1F     // Request recipient bit mask
#define CMD_MASK_COMMON         0xE0     // Common request mask

// bmRequestType Direction Field
#define CMD_DIR_IN              0x80     // IN Request
#define CMD_DIR_OUT             0x00     // OUT Request

// bmRequestType Type Field
#define CMD_TYPE_STD            0x00     // Standard Request
#define CMD_TYPE_CLASS          0x20     // Class Request
#define CMD_TYPE_VEND           0x40     // Vendor Request

// bmRequestType Recipient Field
#define CMD_RECIP_DEV           0x00     // Device Request
#define CMD_RECIP_IF            0x01     // Interface Request
#define CMD_RECIP_EP            0x02     // Endpoint Request
#define CMD_RECIP_OTHER         0x03     // Other Request

// bmRequestType Common Commands
#define CMD_STD_OUT             (CMD_TYPE_STD | CMD_DIR_OUT)
#define CMD_STD_IN              (CMD_TYPE_STD | CMD_DIR_IN)
#define CMD_VEND_OUT            (CMD_TYPE_VEND | CMD_DIR_OUT)
#define CMD_VEND_IN             (CMD_TYPE_VEND | CMD_DIR_IN)
#define CMD_CLASS_OUT           (CMD_TYPE_CLASS | CMD_DIR_OUT)
#define CMD_CLASS_IN            (CMD_TYPE_CLASS | CMD_DIR_IN)
//------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------
typedef struct {
    BYTE requestType;
    BYTE request;
    WORD value;
    WORD index;
    WORD length;
} SETUP_HEADER;
extern SETUP_HEADER data setupHeader;
//------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------
typedef struct {
    BYTE *pBuffer;
    UINT16 bytesLeft;
} SETUP_DATA;
extern SETUP_DATA data setupData;
//------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------
// Define device states
#define DEV_ATTACHED            0x00        // Device is in Attached State
#define DEV_POWERED             0x01        // Device is in Powered State
#define DEV_DEFAULT             0x02        // Device is in Default State
#define DEV_ADDRESS             0x03        // Device is in Addressed State
#define DEV_CONFIGURED          0x04        // Device is in Configured State
#define DEV_SUSPENDED           0x05        // Device is in Suspended State

// Define Endpoint States
#define EP_IDLE                 0x00     // The endpoint is idle, or a setup token has been received
#define EP_TX                   0x01     // Setup IN data is transmitted automatically by the ISR
#define EP_RX                   0x02     // Setup OUT data is received automatically by the ISR
#define EP_HALT                 0x03     // The endpoint is halted (returns stalls to the host)
#define EP_STALL                0x04     // Send procedural stall in the next status phase
#define EP_MANUAL_RX            0x05     // Used by applications to manual handle OUT data reception 
					// manually
#define EP_MANUAL_TX            0x06     // Used by applications to manual handle IN data 
					///transmission manually
//------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------
typedef struct {
    BYTE usbState;

    // Endpoint status:
    // 0: EP0
    // 1-3: EP1-EP3 OUT (addresses 0x01 to 0x03)
    // 4-6: EP1-EP3 IN  (addresses 0x81 to 0x83) 
    BYTE pEpStatus[7];
    BYTE usbCommonInt;
    BYTE usbOutInt; 
    BYTE usbInInt;
} USB_INFO;
extern USB_INFO data usbInfo;
//------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------
// Define Endpoint Packet Sizes
#define EP0_PACKET_SIZE         0x40
//------------------------------------------------------------------------------------------------------




//-------------------------------------------------------------------------------------------------------
// Standard Device Descriptor Type Defintion
typedef struct {
    BYTE bLength;                // Size of this descriptor [bytes]
    BYTE bDescriptorType;        // Descriptor Type = 1
    WORD bcdUSB;                 // USB spec release number in BCD (0110 for USB 1.1)
    BYTE bDeviceClass;           // Device class code
    BYTE bDeviceSubClass;        // Device subclass code	
    BYTE bDeviceProtocol;        // Device protocol code
    BYTE bMaxPacketSize0;        // Maximum packet size for EP0 
    WORD idVendor;               // Vendor ID 
    WORD idProduct;              // Product ID
    WORD bcdDevice;              // Device release number [BCD]
    BYTE iManufacturer;          // Index of string desc for manufacturer
    BYTE iProduct;               // Index of string desc for product
    BYTE iSerialNumber;          // Index of string desc for serial number
    BYTE bNumConfigurations;     // Number of possible Configurations
} USB_DEVICE_DESCRIPTOR;
extern USB_DEVICE_DESCRIPTOR code deviceDesc;
//-------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------
// Standard Configuration Descriptor Type Definition
typedef struct {
    BYTE bLength;                // Size of this Descriptor in Bytes
    BYTE bDescriptorType;        // Descriptor Type (=2)
    WORD wTotalLength;           // Total Length of Data for this Conf
    BYTE bNumInterfaces;         // No of Interfaces supported by this Conf
    BYTE bConfigurationValue;    // Designator Value for *this* Configuration
    BYTE iConfiguration;         // Index of String Desc for this Conf
    BYTE bmAttributes;           // Configuration Characteristics (see below)
    BYTE bMaxPower;              // Max. Power Consumption in this Conf (*2mA)
} USB_CONFIGURATION_DESCRIPTOR;     // End of Configuration Descriptor Type
extern USB_CONFIGURATION_DESCRIPTOR code configDesc;
//------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------
// Standard Interface Descriptor Type Definition
typedef struct {
    BYTE bLength;                // Size of this Descriptor in Bytes
    BYTE bDescriptorType;        // Descriptor Type (=4)
    BYTE bInterfaceNumber;       // Number of *this* Interface (0..)
    BYTE bAlternateSetting;      // Alternative for this Interface (if any)
    BYTE bNumEndpoints;          // No of EPs used by this IF (excl. EP0)
    BYTE bInterfaceClass;        // Interface Class Code
    BYTE bInterfaceSubClass;     // Interface Subclass Code
    BYTE bInterfaceProtocol;     // Interface Protocol Code
    BYTE iInterface;             // Index of String Desc for this Interface
} USB_INTERFACE_DESCRIPTOR;         // End of Interface Descriptor Type
extern USB_INTERFACE_DESCRIPTOR code interfaceDesc;
//------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------
// Standard Endpoint Descriptor Type Definition
typedef struct {
    BYTE bLength;                // Size of this Descriptor in Bytes
    BYTE bDescriptorType;        // Descriptor Type (=5)
    BYTE bEndpointAddress;       // Endpoint Address (Number + Direction)
    BYTE bmAttributes;           // Endpoint Attributes (Transfer Type)
    WORD wMaxPacketSize;	     // Max. Endpoint Packet Size
    BYTE bInterval;              // Polling Interval (Interrupt) ms
} USB_ENDPOINT_DESCRIPTOR;       // End of Endpoint Descriptor Type
extern USB_ENDPOINT_DESCRIPTOR code pEndpointDescs[];
//------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------
extern BYTE code string0Desc[];
extern BYTE code string1Desc[];
extern BYTE code string2Desc[];
//------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------
typedef struct {
    WORD chipType;
    BOOL appDescValid;
    BOOL appStarted;
} BOOTLOADER_INFO;
extern BOOTLOADER_INFO data blInfo;
//------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------
// Define value bitmaps for Standard Feature Selectors
#define DEVICE_REMOTE_WAKEUP    0x01        // Remote wakeup feature(not used)
#define ENDPOINT_HALT           0x00        // Endpoint_Halt feature selector
//------------------------------------------------------------------------------------------------------




/*******************************************************************************************************
 * Revision history:                                                                                   *
 *
 * $Log: usb_structs.h,v $
 * Revision 1.2  2005/02/07 14:35:08  sna
 * Initial version in CVS.
 *
 *
 *******************************************************************************************************/




#endif// USB_STRUCTS




