/******************************************************************************
    Filename: chip_detect.h	
    
    Description: header file for radio chip detection
*******************************************************************************/

#ifndef CHIP_DETECT_H
#define CHIP_DETECT_H

#ifdef __cplusplus
extern "C" {
#endif
/******************************************************************************
 * INCLUDES
 */

#include "hal_types.h"


/******************************************************************************
 * CONSTANTS
 */ 

/* Chip type constants */
#define CHIP_TYPE_CC1101                0x1101

#define CHIP_TYPE_CC110L                0x0110
#define CHIP_TYPE_CC113L                0x0113 
#define CHIP_TYPE_CC115L                0x0115
  
#define CHIP_TYPE_CC1101_CC1190         0x0190  // CC1101 + CC1190 = 0190
#define CHIP_TYPE_CC1120_CC1190         0x2090  // CC1120 + CC1190 = 2090
#define CHIP_TYPE_CC1120                0x1120
#define CHIP_TYPE_CC1121                0X1121
#define CHIP_TYPE_CC1125                0x1125
#define CHIP_TYPE_CC1175                0x1175
#define CHIP_TYPE_NONE                  0x0000

/* Manual chip select constants*/
#define CC1101_SELECTED                 0x1101
#define CC1120_SELECTED                 0x1120
#define CC1101_CC1190_SELECTED          0x0190
#define CC1120_CC1190_SELECTED          0x2090
/******************************************************************************
 * Prototypes
 */ 

typedef struct
{
	uint16 deviceName;
	uint16 id;
	uint8  ver;
	uint8  xoscFreq;
  
}radioChipType_t;


/******************************************************************************
 * PROTOTYPES
 */
 
/* Will populate the radioChipType struct when called */
uint8 trxDetectChipType(radioChipType_t *pRadioChipType);

#ifdef  __cplusplus
}
#endif
/******************************************************************************
  Copyright 2010 Texas Instruments Incorporated. All rights reserved.

  IMPORTANT: Your use of this Software is limited to those specific rights
  granted under the terms of a software license agreement between the user
  who downloaded the software, his/her employer (which must be your employer)
  and Texas Instruments Incorporated (the "License").  You may not use this
  Software unless you agree to abide by the terms of the License. The License
  limits your use, and you acknowledge, that the Software may not be modified,
  copied or distributed unless embedded on a Texas Instruments microcontroller
  or used solely and exclusively in conjunction with a Texas Instruments radio
  frequency transceiver, which is integrated into your product.  Other than for
  the foregoing purpose, you may not use, reproduce, copy, prepare derivative
  works of, modify, distribute, perform, display or sell this Software and/or
  its documentation for any purpose.

  YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
  PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
  INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE,
  NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
  TEXAS INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
  NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER
  LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
  INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE
  OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT
  OF SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
  (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.

  Should you have any questions regarding your right to use this Software,
  contact Texas Instruments Incorporated at www.TI.com.
*******************************************************************************/

#endif //CHIP_DETECT_H