/******************************************************************************
  Filename:      cc1190_per_test_api.h
  
  Description:   This header file declares api-like functions that the per test
                 will call if a CC1190 was selected.
  
******************************************************************************/

#ifndef CC1190_PER_TEST_API_H
#define CC1190_PER_TEST_API_H

#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************
 * INCLUDES
 */
#include "msp430.h"
#include "hal_types.h"
#include "hal_defs.h"
#include "per_test.h"
/******************************************************************************
 * CONSTANTS
 */
    
#define TRXEM_PORT_SEL         P3SEL
#define TRXEM_PORT_OUT         P3OUT
#define TRXEM_PORT_DIR         P3DIR
#define TRXEM_PORT_IN          P3IN
    
#define TRXEM_CC1190_PORT_SEL  P1SEL
#define TRXEM_CC1190_PORT_OUT  P1OUT
#define TRXEM_CC1190_PORT_DIR  P1DIR
#define TRXEM_CC1190_PORT_IN   P1IN
    
#define TRXEM_CC1190_PA        BIT4
#define TRXEM_CC1190_LNA       BIT4
#define TRXEM_CC1190_HGM       BIT5

    
/******************************************************************************
 * PROTOTYPES
 */
 
/* Functions that will be connected to the PER RF api*/
void perCC1101CC1190RegConfig(void);
void perCC1101CC1190SendPacket(uint8 *pData);
void perCC1101CC1190EnterRx(void);
void perCC1101CC1190EnterIdle(void);
void perCC1101CC1190EnterSleep(void);
void perCC1101CC1190RxTxISR(void);
void perCC1101CC1190SetOutputPower(uint8 index);
void perCC1101CC1190WriteTxFifo(uint8 *pData, uint8 len);

float perCC1101CC1190GetDataRate(uint8 index);
int8 perCC1101CC1190GetGuiTxPower(uint8 index);
int8 perCC1101CC1190Read8BitRssi(void);

#ifdef  __cplusplus
}
#endif 
/******************************************************************************
  Copyright 2010 Texas Instruments Incorporated. All rights reserved.

  IMPORTANT: Your use of this Software is limited to those specific rights
  granted under the terms of a software license agreement between the user
  who downloaded the software, his/her employer (which must be your employer)
  and Texas Instruments Incorporated (the "License").  You may not use this
  Software unless you agree to abide by the terms of the License. The License
  limits your use, and you acknowledge, that the Software may not be modified,
  copied or distributed unless embedded on a Texas Instruments microcontroller
  or used solely and exclusively in conjunction with a Texas Instruments radio
  frequency transceiver, which is integrated into your product.  Other than for
  the foregoing purpose, you may not use, reproduce, copy, prepare derivative
  works of, modify, distribute, perform, display or sell this Software and/or
  its documentation for any purpose.

  YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
  PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
  INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE,
  NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
  TEXAS INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
  NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER
  LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
  INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE
  OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT
  OF SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
  (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.

  Should you have any questions regarding your right to use this Software,
  contact Texas Instruments Incorporated at www.TI.com.
*******************************************************************************/

#endif