/******************************************************************************
  Filename:    sniff_mode_gui.c
  
  Description: Implementation of the menu system used in the sniff mode test.
  
  Notes: 
  
******************************************************************************/

/******************************************************************************
 * INCLUDES
 */

#include "hal_types.h"
#include "menu_system.h"
#include "menu_driver.h"
#include "sniff_mode.h"
#include "chip_detect.h"

/******************************************************************************
 * Local Functions
 */
/******************************************************************************
 * LOCAL VARIABLES AND CONSTANTS - needed for GUI information
 */

/******************************************************************************
 * MENUS
 */

menu_t sniffModeMainMenu;
menu_t sniffModeFrequencyMenu;


static const menuItem_t sniffModeMainMenuItems[] =
{
  {M_DISABLED,0,"    Select Device",0,0,0,0,0},
  {0x00,"1","Master",0,0,0,&sniffMasterStartApp,0},
  {0x00,"2","Slave ",0,0,0,&sniffSlaveStartApp ,0},
};

menu_t sniffModeMainMenu = 
{
  (menuItem_t*)sniffModeMainMenuItems,  /* pItems          */
  0,                                    /* pParentMenu     */
  0,                                    /* pMenuGraphics   */
  "RX Sniff Test",                      /* pTextHeader     */
  "2",                                  /* pTextMenuItems  */
  3,                                    /* nMenuItems      */
  1,                                    /* nCurrentItem    */
  -1,                                   /* nSelectedItem   */
  0,                                    /* nScreen         */
  0xE0                                  /* reservedAreas   */
};

static const menuItem_t sniffModeFrequencyMenuItems[] =
{
  {M_DISABLED,0,"  Select Frequency",0,0,0,0,0},
  {0x00,"1","169 MHz",0,&sniffModeMainMenu,0,&sniffModeFreqConfig,(void **)0},
  {0x00,"2","434 MHz",0,&sniffModeMainMenu,0,&sniffModeFreqConfig,(void **)1}, 
  {0x00,"3","868 MHz",0,&sniffModeMainMenu,0,&sniffModeFreqConfig,(void **)2},
  {0x00,"4","915 MHz",0,&sniffModeMainMenu,0,&sniffModeFreqConfig,(void **)3},
  {0x00,"5","955 MHz",0,&sniffModeMainMenu,0,&sniffModeFreqConfig,(void **)4}  
};
menu_t sniffModeFrequencyMenu =
{
  (menuItem_t*)sniffModeFrequencyMenuItems,     /* pItems         */
  0,                                            /* pParentMenu    */
  0,                                            /* pMenuGraphics  */
  0,                                            /* pTextHeader    */
  "5",                                          /* pTextMenuItems */
  6,                                            /* nMenuItems     */
  3,                                            /* nCurrentItem   */
  3,                                            /* nSelectedItem  */
  0,                                            /* nScreen        */
  0                                             /* reservedAreas  */
};

/******************************************************************************
 * Functions
 */
void drawInfo(void)
{
    menuClearReservedArea(&sniffModeMainMenu);
    halLcdSetHLine(0,0,LCD_COLS-1,LCD_ROWS-17);
    halLcdPrintString(0,"Carrier Sense Thrshld",1,6);
    halLcdPrintString(0,"set high for DEMO use",1,7);
    halLcdInvertPage(0,0,LCD_COLS-1,6);
    halLcdInvertPage(0,0,LCD_COLS-1,7);
    halLcdSendBuffer(0);
    
}

/******************************************************************************
  Copyright 2011 Texas Instruments Incorporated. All rights reserved.

  IMPORTANT: Your use of this Software is limited to those specific rights
  granted under the terms of a software license agreement between the user
  who downloaded the software, his/her employer (which must be your employer)
  and Texas Instruments Incorporated (the "License").  You may not use this
  Software unless you agree to abide by the terms of the License. The License
  limits your use, and you acknowledge, that the Software may not be modified,
  copied or distributed unless embedded on a Texas Instruments microcontroller
  or used solely and exclusively in conjunction with a Texas Instruments radio
  frequency transceiver, which is integrated into your product.  Other than for
  the foregoing purpose, you may not use, reproduce, copy, prepare derivative
  works of, modify, distribute, perform, display or sell this Software and/or
  its documentation for any purpose.

  YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
  PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
  INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE,
  NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
  TEXAS INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
  NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER
  LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
  INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE
  OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT
  OF SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
  (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.

  Should you have any questions regarding your right to use this Software,
  contact Texas Instruments Incorporated at www.TI.com.
*******************************************************************************/