/*****************************************************************************
    Filename: menu_driver.h

    Description: Header file for the menu driver. The menu driver is
                 the layer that is between the menu system and the LCD HAL.
                 DOGM128LCD: 
                 To avoid confusion the term page is used when talking about 
                 the physical section of the LCD called a page. That is, the 
                 LCD is divided into 8 pages with 8px of height each. The LCD 
                 is 128px wide wich then gives the resolution of 128x64px. 
                 The term screen is used when talking about what would seem to 
                 be one "page" in the menu system. For example, a picture
                 displaying the first 7 menuItems is one screen. The next 
                 screen contains the next 7 menuItems, and so on. 
                 Thus, one screen consists of 8 pages.

*****************************************************************************/

#ifndef menu_driver_h
#define menu_driver_h

#ifdef __cplusplus
extern "C" {
#endif
/*****************************************************************************
 * INCLUDES
 */
#include "menu_system.h"

/*****************************************************************************
 * MACROS
 */
#define MENU_ITEMS_PER_SCREEN 7    /* How many menu items fit on one screen */
#define MENU_MARGIN 2             /* How many pixels of margin on left/right*/

/*****************************************************************************
 * FUNCTION PROTOTYPES
 */
void menuDisplay(const menu_t *currentMenu);
uint8 menuGetScreen(const menu_t *pMenu, uint8 nItem);
void menuClearReservedArea(const menu_t *pMenu);

#ifdef  __cplusplus
}
#endif
/******************************************************************************
  Copyright 2010 Texas Instruments Incorporated. All rights reserved.

  IMPORTANT: Your use of this Software is limited to those specific rights
  granted under the terms of a software license agreement between the user
  who downloaded the software, his/her employer (which must be your employer)
  and Texas Instruments Incorporated (the "License").  You may not use this
  Software unless you agree to abide by the terms of the License. The License
  limits your use, and you acknowledge, that the Software may not be modified,
  copied or distributed unless embedded on a Texas Instruments microcontroller
  or used solely and exclusively in conjunction with a Texas Instruments radio
  frequency transceiver, which is integrated into your product.  Other than for
  the foregoing purpose, you may not use, reproduce, copy, prepare derivative
  works of, modify, distribute, perform, display or sell this Software and/or
  its documentation for any purpose.

  YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
  PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
  INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE,
  NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
  TEXAS INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
  NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER
  LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
  INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE
  OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT
  OF SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
  (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.

  Should you have any questions regarding your right to use this Software,
  contact Texas Instruments Incorporated at www.TI.com.
*******************************************************************************/

#endif //menu_driver_h