/*******************************************************************************
date   : 2010/08/20
writer on the way

Port   P0_2,P0_3,P0_4,P0_5  ĸ˿UART0
         P1_0P1_1           ˿LED1LED2
         P1_4,P1_5,P1_6,P1_7  ĸ˿SPIͨ

fuctionSPIͨģʽ
         úüĴֱ֮ӽ뷢ݵ״̬
*******************************************************************************/
/*-------------------------------------------------------------------------------- 
    Master                 Slave 
-------------          ------------- 
|           |          |           | 
|P1_4   SSN |--------->|SSN    P1_4| 
|           |          |           | 
|P1_5   SCK |--------->|SCK    P1_5| 
|           |          |           | 
|P1_6   MOSI|--------->|MOSI   P1_6| 
|           |          |           | 
|P1_7   MISO|<---------|MISO   P1_7| 
|           |          |           | 
-------------          ------------- 
--------------------------------------------------------------------------------*/
// Master Mode

#include <iocc2530.h>
#include "hal_cc8051.h"

#define LED1          P1_0
#define LED2          P1_1

#define LED_OFF 1
#define LED_ON  0


#define SSN       P1_4
/******************************************************************************
* @fn  init_port
*
* @brief
*     Initializes components IO port application example.
*
* Parameters:
*
* @param  void
*
* @return void
*
******************************************************************************/
void init_port(void)
{
   IO_FUNC_PORT_PIN(1, 0, IO_FUNC_GIO);    //P1_0ΪͨIO
   IO_DIR_PORT_PIN(1, 0, IO_OUT);          //Ϊ
    
   IO_FUNC_PORT_PIN(1, 1, IO_FUNC_GIO);    //P1_1ΪͨIO
   IO_DIR_PORT_PIN(1, 1, IO_OUT);          //Ϊ
   
   PERCFG |= 0x02;        // PERCFG.U1CFG = 1 
   P1SEL |= 0xE0;         // P1_7, P1_6, and P1_5 are peripherals 
   P1SEL &= ~0x10;        // P1_4 is GPIO (SSN) 
   P1DIR |= 0x10;         // SSN is set as output 
}
/******************************************************************************
* @fn  init_Baudrate
*
* @brief
*     Initializes components Baudrate application example.
*
* Parameters:
*
* @param  void
*
* @return void
*
******************************************************************************/
void init_Baudrate(void)
{
  // Set baud rate to max (system clock frequency / 8) 
  // Assuming a 26 MHz crystal (CC1110Fx/CC2510Fx), 
  // max baud rate = 26 MHz / 8 = 3.25 MHz.  
  U1BAUD = 0x00;   // BAUD_M = 0 
  U1GCR |= 0x11;   // BAUD_E = 17
}

/*******************************************************************************
* @fn          main
*
* @brief       
*
* @param       none
*
* @return      none
*******************************************************************************/

void main(void)
{
  halMcuInit();  // ѡ32MHzΪϵͳʱԴ(ʱԴ)//ʱԴ32MHZ
  init_port();      //ʼ˿
  init_Baudrate();  //ʼ
  
  
  // SPI Master Mode 
  U1CSR &= ~0xA0;   //ѡΪSPIΪMaster
  
  
  // Configure phase, polarity, and bit order 
  U1GCR &= ~0xC0;      // CPOL = CPHA = 0 
  U1GCR |= 0x20;       // ORDER = 1 
  
  
  LED1=0;
  
  unsigned char i;
  char txBufferMaster[]="on the way..";
  for(;;)
  {
    for (i = 0; i <= sizeof(txBufferMaster); i++) 
    { 
      SSN = LOW; 
      U1DBUF = txBufferMaster[i]; //Ҫ͵
      while (!U1TX_BYTE); 
      SSN = HIGH; 
      U1TX_BYTE = 0;
    }
    LED1=~LED1;
    halMcuWaitMs(300);
  }
}