/*******************************************************************************
date   : 2010/08/27
writer on the way..

Port   P0_2,P0_3,P0_4,P0_5    ĸ˿UART0
         P1_0P1_1            ˿LED1LED2
         P1_4,P1_5,P1_6,P1_7    ĸ˿SPIͨ
fuctionSPIͨ
         Ǵģʽϵ֮Ĵúֱ֮
         գȴݴͽ
*******************************************************************************/
/*-------------------------------------------------------------------------------- 
    Master                 Slave 
-------------          ------------- 
|           |          |           | 
|P1_4   SSN |--------->|SSN    P1_4| 
|           |          |           | 
|P1_5   SCK |--------->|SCK    P1_5| 
|           |          |           | 
|P1_6   MOSI|--------->|MOSI   P1_6| 
|           |          |           | 
|P1_7   MISO|<---------|MISO   P1_7| 
|           |          |           | 
-------------          ------------- 
--------------------------------------------------------------------------------*/
// Slave Mode

#include <iocc2530.h>
#include "hal_cc8051.h"

#define LED1          P1_0
#define LED2          P1_1

#define LED_OFF 1
#define LED_ON  0

#define SSN       P1_4
/******************************************************************************
* @fn  init_port
*
* @brief
*     Initializes components IO port application example.
*
* Parameters:
*
* @param  void
*
* @return void
*
******************************************************************************/
void init_port(void)
{
   IO_FUNC_PORT_PIN(1, 0, IO_FUNC_GIO);    //P1_0ΪͨIO
   IO_DIR_PORT_PIN(1, 0, IO_OUT);          //Ϊ
    
   IO_FUNC_PORT_PIN(1, 1, IO_FUNC_GIO);    //P1_1ΪͨIO
   IO_DIR_PORT_PIN(1, 1, IO_OUT);          //Ϊ
   
   PERCFG |= 0x02;        // PERCFG.U1CFG = 1 
   P1SEL |= 0xF0;         // P1_7, P1_6, P1_5, and P1_4 are peripherals
   
}

void init_Baudrate(void)
{
  // Set baud rate to max (system clock frequency / 8) 
  // a 32 MHz crystal, 
  // max baud rate = 32 MHz / 8 = 4 MHz.  
  U1BAUD = 0x00;   // BAUD_M = 0 
  U1GCR |= 0x11;   // BAUD_E = 17
}
/******************************************************************************
* @fn  initUART
*
* @brief
*      Initializes components for the UART application example.
*
* Parameters:
*
* @param  void
*
* @return void
*
******************************************************************************/
void initUART(void)
{
   // Setup for UART0
   IO_PER_LOC_UART0_AT_PORT0_PIN2345();//˿02345Ϊ
                   
   //Ĵ0Ϊ57600ûУλ8λݣ1λֹͣλ
   UART_SETUP(0, 57600, HIGH_STOP);    //ô
}
/*******************************************************************************
* @fn          main
*
* @brief       
*
* @param       none
*
* @return      none
*******************************************************************************/
void main(void)
{
  halMcuInit();// ѡ32MHzΪϵͳʱԴ(ʱԴ)//ʱԴ32MHZ
  init_port();      //ʼ˿
  init_Baudrate();  //ʼ
  initUART();       //ʼUART
  
  // SPI Slave Mode 
  U1CSR &= ~0x80; 
  U1CSR |= 0x20;
  
  // Configure phase, polarity, and bit order 
  U1GCR &= ~0xC0;   // CPOL = CPHA = 0 
  U1GCR |= 0x20;    // ORDER = 1 
  
  
  LED1=LED_ON;      //ʾ״̬ 
  
  
  char rxBufferSlave[13]; 
  unsigned char i;
  for (i = 0; i <= sizeof(rxBufferSlave); i++)  
  { 
    while (!U1RX_BYTE); 
    U1RX_BYTE = 0; 
    rxBufferSlave[i] = U1DBUF;
    LED1=~LED1;
  }
  
   
  LED1=LED_OFF;     //ʾѾ꣬ڴʾ
  
  
  for(i=0;i<sizeof(rxBufferSlave)+1;i++)
  {
    U0DBUF = rxBufferSlave[i];
    while(UTX0IF == 0);    //ȴ
    UTX0IF = 0;
  }
  while(1);
  
}