
#include <stdint.h>
#include <math.h>
#include "Bitmap.h"

#define PI 3.141592653

//  a b ֵ
#define SWAP(x,y) x^=y; y^=x; x^=y;

/***********************************************************************************************************************

 *        : bitmap_SetPoint

 *          : bitmap      ͼָ

 *                x           x

 *                y		      y


 *                color        :ɫ

 *          : 

 *          : ڻͼĻͼһ
 *  ֻ֧1,2λɫͼÿصռ1-2bitbitɫҪ
 *  ޸ıʵ
 *************************************************************************************************************************/

const uint8_t two_color_shift_mask[5]={6,4,2,0,0};
const uint8_t one_color_shift_mask[9]={7,6,5,4,3,2,1,0,0};

int32_t bitmap_SetPoint(void *bitmap,int32_t x,int32_t y,int32_t color)
{
	BITMAP *pMap;
	uint32_t x_offset,x_shift;
	uint8_t *pBuf;

	pMap = (BITMAP *)bitmap;
	if((x<0)||(y<0))
		return -1;
	if((x>=pMap->width)||(y>=pMap->height))
		return -1;

	pBuf = (uint8_t *)pMap->pDraw_board;

	if(pMap->color_bit==1){ //ɫ1bit
		x_offset = x>>3;
		if(x_offset==0)
			x_shift  = one_color_shift_mask[x];
		else
			x_shift  = one_color_shift_mask[(x-(x_offset<<3))];
		pBuf += (y*pMap->line_len)+x_offset;
		*pBuf &= ~(1<<x_shift);
		*pBuf |= (color&1)<<x_shift;	
	}
	else if(pMap->color_bit==2){ //˫ɫ2bit
		x_offset = x>>2;
		if(x_offset==0)
			x_shift  = two_color_shift_mask[x];
		else
			x_shift  = two_color_shift_mask[(x-(x_offset<<2))];
		pBuf += (y*pMap->line_len)+x_offset;
		*pBuf &= ~(3<<x_shift);
		*pBuf |= (color&3)<<x_shift;
	}

	return 1;
}

/***********************************************************************************************************************

 *        : draw_SetPoint

 *          : draw      ͼָ

 *                x           x

 *                y		      y


 *                color        :ɫ

 *          : 

 *          : Դ滭һ
 *  ֻ֧1-2λɫͼÿصռ1-2bitbitɫҪ
 *  ޸ıʵ,ҵͬҲҪ޸
 *************************************************************************************************************************/

int32_t draw_SetPoint(void *draw,
		int32_t x,
		int32_t y,
		int32_t color
		)
{
	int32_t y_offset,y_shift;
	uint16_t *pr;
	BITMAP *pDraw;

	pDraw = (BITMAP *)draw;

	if((x<0)||(y<0))
		return(-1);	

	if((x>=pDraw->width)||(y>=pDraw->height))
		return (-1);

	if(pDraw->color_bit==1){  //ɫ1bit
		y_offset = y%16;
		y_shift  = (y>>4);
		color = (uint16_t)((color&0x00000001)<<y_shift);
		pr = (uint16_t *)pDraw->pDraw_board;
		pr +=(y_offset*pDraw->width) + x;
		*pr &= (uint16_t)(~(1<<y_shift));
		*pr |= color;
	}
	else if(pDraw->color_bit==2){  //˫ɫ2bit
		y_offset = y%16;
		y_shift  = ((y>>4)<<1);
		color = (uint16_t)((color&0x00000003)<<y_shift);
		pr = (uint16_t *)pDraw->pDraw_board;
		pr +=(y_offset*pDraw->width) + x;
		*pr &= (uint16_t)(~(3<<y_shift));
		*pr |= color;
	}

	return 1;
}
/***********************************************************************************************************************

 *        : bitmap_shift

 *          : bitmap      ͼָ

 *                mode        : ƶģʽ1=ƣ2=ƣ3=ƣ4=

 *                count       : ƶĵ

 *          : 

 *          : ѻͼƶ
 ҲҪλͼзʽ޸
 *************************************************************************************************************************/

int32_t bitmap_shift(void *bitmap,uint32_t mode,uint32_t count)
{
	uint32_t x_loop,y_loop,count_loop;
	uint8_t *dest,*src,*end_addr;
	uint32_t va;
	BITMAP *draw;

	draw = (BITMAP *)bitmap;
	if((bitmap==(void *)0)||(draw->color_bit>8))
		return -1;

	if(mode==1){		//
		va = 8-draw->color_bit;
		for(count_loop=0; count_loop<count; count_loop++){
			for(y_loop=0; y_loop<draw->height; y_loop++){
				end_addr = (uint8_t *)draw->pDraw_board+(y_loop*draw->line_len);
				dest = (uint8_t *)draw->pDraw_board+((y_loop+1)*draw->line_len);
				dest-=1;
				src = dest-1;
				while(src>=end_addr){
					*dest>>=draw->color_bit;
					*dest |= *src<<va;
					dest--;
					src--;
				}
			}	
		}
		return 1;
	}
	else if(mode==2){		//
		va = 8-draw->color_bit;
		for(count_loop=0; count_loop<count; count_loop++){
			for(y_loop=0; y_loop<draw->height; y_loop++){
				dest = (uint8_t *)draw->pDraw_board+(y_loop*draw->line_len);
				src  = (uint8_t *)(dest+1);
				end_addr = (uint8_t *)(dest+draw->line_len);
				while(src<end_addr){
					*dest<<=draw->color_bit;
					*dest |= *src>>va;
					dest++;
					src++;
				}
			}	
		}
		return 1;
	}
	else if(mode==3){		//
		for(count_loop=0; count_loop<count; count_loop++){
			for(y_loop=(draw->height-1); y_loop>0; y_loop--){
				dest = (uint8_t *)draw->pDraw_board+(y_loop*draw->line_len);
				src = (uint8_t *)draw->pDraw_board+((y_loop-1)*draw->line_len);
				for(x_loop=0;x_loop<draw->line_len; x_loop++){
					*dest = *src;
					*src = 0;
					dest++;
					src++;
				}
			}	
		}
		return 1;
	}
	else if(mode==4){		//
		for(count_loop=0; count_loop<count; count_loop++){
			for(y_loop=0; y_loop<(draw->height-1); y_loop++){
				dest = (uint8_t *)draw->pDraw_board+(y_loop*draw->line_len);
				src = (uint8_t *)draw->pDraw_board+((y_loop+1)*draw->line_len);
				for(x_loop=0;x_loop<draw->line_len; x_loop++){
					*dest = *src;
					*src = 0;
					dest++;
					src++;
				}
			}	
		}
		return 1;
	}
	return -1;
}

/***********************************************************************************************************************

 *        : bitmap_shiftA

 *          : bitmap      ͼָ
 
 *                x           : ʼx,8ı
               
 *                y           : ʼy
                 
 *                w           : ,8ı
 
 *                h           : ߶

 *                mode        : ƶģʽ1=ƣ2=ƣ3=ƣ4=

 *                count       : ƶĵ

 *          : 

 *          : ѻͼx,y,w,h޶ƶ
				  ҲҪλͼзʽ޸
 *************************************************************************************************************************/

int32_t bitmap_shiftA(void *bitmap,
		              uint32_t x,
					  uint32_t y,
		              uint32_t w,
					  uint32_t h,
					  uint32_t mode,
					  uint32_t count)
{
	uint32_t x_loop,y_loop,count_loop;
	uint8_t *dest,*src,*end_addr,x_shift_mask;
	uint32_t va;
	BITMAP *draw;

	draw = (BITMAP *)bitmap;
	if((bitmap==(void *)0)||(draw->color_bit>8))
		return -1;

	switch(draw->color_bit)
	{
	case 1:
		x_shift_mask = 3;
		break;
	case 2:
		x_shift_mask = 2;
		break;
	case 4:
		x_shift_mask = 1;
		break;
	case 8:
		x_shift_mask = 0;
		break;
	default:
		return -1;
		break;
	}

	if(mode==1){		//
		va = 8-draw->color_bit;
		for(count_loop=0; count_loop<count; count_loop++){
			for(y_loop=y; y_loop<(h+y); y_loop++){
				end_addr = (uint8_t *)draw->pDraw_board+(y_loop*draw->line_len);
				end_addr+=(x>>x_shift_mask);
				dest = (uint8_t *)(end_addr+(w>>x_shift_mask));
				src = (uint8_t *)(dest-1);
				while(src>=end_addr){
					*dest>>=draw->color_bit;
					*dest |= *src<<va;
					dest--;
					src--;
				}
			}	
		}
		return 1;
	}
	else if(mode==2){		//
		va = 8-draw->color_bit;
		for(count_loop=0; count_loop<count; count_loop++){
			for(y_loop=y; y_loop<(h+y); y_loop++){
				dest = (uint8_t *)draw->pDraw_board+(y_loop*draw->line_len);
				dest += x>>x_shift_mask;
				end_addr = dest+(w>>x_shift_mask);
				src  = (uint8_t *)(dest+1);
				while(src<=end_addr){
					*dest<<=draw->color_bit;
					*dest |= *src>>va;
					dest++;
					src++;
				}
			}	
		}
		return 1;
	}
	else if(mode==3){		//
		for(count_loop=0; count_loop<count; count_loop++){
			for(y_loop=((y+h)-1); y_loop>y; y_loop--){
				dest = (uint8_t *)draw->pDraw_board+(y_loop*draw->line_len);
				src = (uint8_t *)draw->pDraw_board+((y_loop-1)*draw->line_len);
				dest += x>>x_shift_mask;
				src  += x>>x_shift_mask;
				for(x_loop=0;x_loop<(w>>x_shift_mask); x_loop++){
					*dest = *src;
					*src = 0;
					dest++;
					src++;
				}
			}	
		}
		return 1;
	}
	else if(mode==4){		//
		for(count_loop=0; count_loop<count; count_loop++){
			for(y_loop=y; y_loop<((y+h)-1); y_loop++){
				dest = (uint8_t *)draw->pDraw_board+(y_loop*draw->line_len);
				src = (uint8_t *)draw->pDraw_board+((y_loop+1)*draw->line_len);
				dest += x>>x_shift_mask;
				src  += x>>x_shift_mask;
				for(x_loop=0;x_loop<(w>>x_shift_mask); x_loop++){
					*dest = *src;
					*src = 0;
					dest++;
					src++;
				}
			}	
		}
		return 1;
	}
	return -1;
}

int32_t bitmap_copy(void *pDest,      //ָĿ豸
		int32_t xDest,    //ָĿ豸X
		int32_t yDest,    //ָĿ豸Y int32_t width,    //Ŀ
		int32_t width,    //Ŀ
		int32_t height,   //ĸ߶
		void *pSrc,       //ָԴ豸
		int32_t xSrc,     //ָԴ豸X
		int32_t ySrc,     //ָԴ豸Y
		int32_t rop       //ָ
		)
{
	BITMAP *dest,*src;
	uint8_t *psrc_temp;
	uint8_t color;
	uint16_t *pdest_temp;
	uint32_t i,x,x_offset,x_shift,y_offset,y_shift;

	if((pDest==(void *)0)||(pSrc==(void *)0)){ 
		return -1;
	}

	dest = (BITMAP *)pDest;
	src  = (BITMAP *)pSrc;

	if(((xDest+width)>dest->width)||((yDest+height)>dest->height)){
		return -1;
	}
	if(((xSrc+width)>src->width)||((ySrc+height)>src->height)){
		return -1;
	}
	if(dest->color_bit!=src->color_bit)
		return -1;

	if(dest->color_bit==1){
		for(i=0;i<height;i++){
			psrc_temp = (uint8_t *)src->pDraw_board;
			psrc_temp +=((ySrc+i)*src->line_len)+(xSrc>>3);

			y_offset = (yDest+i)%16;
			y_shift  = (yDest+i)>>4;
			pdest_temp = (uint16_t *)dest->pDraw_board;
			pdest_temp +=(y_offset*dest->width)+xDest;

			for(x=0;x<width;x++){
				x_offset = x>>3;
				if(x_offset==0)
					x_shift  = one_color_shift_mask[x];
				else
					x_shift  = one_color_shift_mask[(x-(x_offset<<3))];
				color = (*(psrc_temp+x_offset))>>x_shift;
				*pdest_temp &= (uint16_t)(~(1<<y_shift));
				*pdest_temp |= ((color&1)<<y_shift);	
				pdest_temp++;
			}
		}
	}
	else if(dest->color_bit==2){
		for(i=0;i<height;i++){
			psrc_temp = (uint8_t *)src->pDraw_board;
			psrc_temp +=((ySrc+i)*src->line_len)+(xSrc>>2);

			y_offset = (yDest+i)%16;
			y_shift  = (((yDest+i)>>4)<<1);
			pdest_temp = (uint16_t *)dest->pDraw_board;
			pdest_temp +=(y_offset*dest->width)+xDest;

			for(x=0;x<width;x++){
				x_offset = x>>2;
				if(x_offset==0)
					x_shift  = two_color_shift_mask[x];
				else
					x_shift  = two_color_shift_mask[(x-(x_offset<<2))];
				color = (*(psrc_temp+x_offset))>>x_shift;
				*pdest_temp &= (uint16_t)(~(3<<y_shift));
				*pdest_temp |= ((color&3)<<y_shift);	
				pdest_temp++;
			}
		}
	}
	return 1;
}

/***********************************************************************************************************************

 *        : bitmap_circle

 *          : xc      ԲX

 *                yc      ԲY

 *                r		 Բ뾶

 *                isfill		 ǷԲ >0

 *                color        :ɫ

 *          : 

 *          : Bresenham 㷨Բ

 *************************************************************************************************************************/

void bitmap_circle(void *bitmap,int32_t xc,int32_t yc,int32_t r,int32_t isfill,int32_t color)
{
	// (xc, yc) ΪԲģr Ϊ뾶
	// fill ΪǷ
	// c Ϊɫֵ

	// ԲͼƬɼ⣬ֱ˳

	if(xc + r < 0 || yc + r < 0 )
		return;

	int32_t x = 0, y = r, yi, d;

	d = 3 - 2 * r;

	if (isfill>0)
	{
		// 䣨ʵԲ
		while (x <= y)
		{
			for (yi = x; yi <= y; yi ++)
			{
				bitmap_SetPoint(bitmap,xc + x, yc + yi, color);
				bitmap_SetPoint(bitmap,xc - x, yc + yi, color);
				bitmap_SetPoint(bitmap,xc + x, yc - yi, color);
				bitmap_SetPoint(bitmap,xc - x, yc - yi, color);
				bitmap_SetPoint(bitmap,xc + yi, yc + x, color);
				bitmap_SetPoint(bitmap,xc - yi, yc + x, color);
				bitmap_SetPoint(bitmap,xc + yi, yc - x, color);
				bitmap_SetPoint(bitmap,xc - yi, yc - x, color);
			}


			if (d < 0)
			{
				d = d + 4 * x + 6;
			}
			else
			{
				d = d + 4 * (x - y) + 10;
				y --;
			}
			x++;
		}
	}
	else
	{
		// 䣨Բ
		while (x <= y)
		{
			//_bitmap_circle_8(xc, yc, x, y, c);
			bitmap_SetPoint(bitmap,xc + x, yc + y, color);
			bitmap_SetPoint(bitmap,xc - x, yc + y, color);
			bitmap_SetPoint(bitmap,xc + x, yc - y, color);
			bitmap_SetPoint(bitmap,xc - x, yc - y, color);
			bitmap_SetPoint(bitmap,xc + y, yc + x, color);
			bitmap_SetPoint(bitmap,xc - y, yc + x, color);
			bitmap_SetPoint(bitmap,xc + y, yc - x, color);
			bitmap_SetPoint(bitmap,xc - y, yc - x, color);

			if (d < 0)
			{
				d = d + 4 * x + 6;
			}
			else
			{
				d = d + 4 * (x - y) + 10;
				y --;
			}
			x ++;
		}
	}
}


/***********************************************************************************************************************

 *        : bitmap_line

 *          : x1      ߿ʼX

 *                y1      ߿ʼY

 *                x2		 ߽X

 *                y2		 ߽Y

 *                color        :ɫ

 *          : 

 *          : Bresenham 㷨

 *************************************************************************************************************************/

void bitmap_line(void *bitmap,int32_t x1,int32_t y1,int32_t x2,int32_t y2,int32_t color)
{
	//  c Ϊɫֵ

	int32_t dx,dy,yy = 0;


	if((x2-x1)>=0)
		dx = x2-x1;
	else
		dx = -(x2-x1);

	if((y2-y1)>=0)
		dy = y2-y1;
	else
		dy = -(y2-y1);

	if (dx < dy)
	{
		yy = 1;
		SWAP(x1, y1);
		SWAP(x2, y2);
		SWAP(dx, dy);
	}

	int ix = (x2 - x1) > 0 ? 1 : -1,
		iy = (y2 - y1) > 0 ? 1 : -1,
		cx = x1,
		cy = y1,
		n2dy = dy * 2,
		n2dydx = (dy - dx) * 2,
		d = dy * 2 - dx;

	if (yy)   // ֱ x ļнǴ 45 
	{
		while (cx != x2)
		{
			if (d < 0)
			{
				d += n2dy;
			}
			else
			{
				cy += iy;
				d += n2dydx;
			}
			bitmap_SetPoint(bitmap,cy, cx, color);
			cx += ix;
		}
	}
	else     // ֱ x ļнС 45 
	{
		while (cx != x2)
		{
			if (d < 0)
			{
				d += n2dy;
			}
			else
			{
				cy += iy;
				d += n2dydx;
			}
			bitmap_SetPoint(bitmap,cx, cy, color);
			cx += ix;
		}
	}
}
/***********************************************************************************************************************

 *        : bitmap_CircleRectangle

 *          : x0      X

 *                y0      Y

 *                width  

 *                height    ߶

 *                r       :Բǰ뾶

 *                isfill       :Ƿ

 *                   color        :ɫ

 *          : 

 *          : ԲǾ

 *************************************************************************************************************************/



void bitmap_CircleRectangle(void *bitmap,int32_t x0,int32_t y0,int32_t width,
		int32_t height,int32_t r,int32_t isfill,int32_t color)

{

	int32_t a,b,di;

	int32_t QUA_Second_y0,QUA_Third_y0;

	int32_t QUA_Third_x0,QUA_Four_x0;

	int32_t x_loop,y_loop;


	x0 = x0+r;

	y0 = y0+r;

	width = width-2*r;

	height = height-2*r;

	a=0;

	b=r;

	di=3-2*r;

	while(a<=b)

	{

		//һ

		bitmap_SetPoint(bitmap,x0-a,y0-b,color);             //2

		bitmap_SetPoint(bitmap,x0-b,y0-a,color);             //3



		//ڶ

		QUA_Second_y0 = y0+height;

		bitmap_SetPoint(bitmap,x0-a,QUA_Second_y0+b,color);             //1

		bitmap_SetPoint(bitmap,x0-b,QUA_Second_y0+a,color);             //7



		//

		QUA_Third_y0 = y0+height;

		QUA_Third_x0 = x0+width;

		bitmap_SetPoint(bitmap,QUA_Third_x0+a,QUA_Third_y0+b,color);             //6

		bitmap_SetPoint(bitmap,QUA_Third_x0+b,QUA_Third_y0+a,color);             //4



		//

		QUA_Four_x0 = x0+width;

		bitmap_SetPoint(bitmap,QUA_Four_x0+a,y0-b,color);             //5

		bitmap_SetPoint(bitmap,QUA_Four_x0+b,y0-a,color);             //0

		if(isfill>0)
		{
			bitmap_line(bitmap,x0-a,y0-b,(QUA_Four_x0+a),y0-b,color);    //-(x0-a)

			bitmap_line(bitmap,x0-b,y0-a,(QUA_Four_x0+b),y0-a,color);     //-(x0-b)

			bitmap_line(bitmap,x0-a,QUA_Second_y0+b,(QUA_Third_x0+a),QUA_Second_y0+b,color);

			bitmap_line(bitmap,x0-b,QUA_Second_y0+a,(QUA_Four_x0+b),QUA_Second_y0+a,color);
		}


		a++;

		if(di<0) di +=4*a+6;

		else

		{

			di+=10+4*(a-b);

			b--;

		}

	}

	bitmap_line(bitmap,x0-r,y0,x0-r,y0+height,color);//(6,10,77,Vertical);

	bitmap_line(bitmap,x0+r+width,y0,x0+r+width,y0+height,color);//(192,10,77,Vertical);

	bitmap_line(bitmap,x0,y0-r,x0+width,y0-r,color);//(6,10,186,Horizontal);

	bitmap_line(bitmap,x0,y0+height+r,x0+width,y0+height+r,color);//(6,87,186,Horizontal);

	if(isfill>0)
	{
		for(y_loop=y0; y_loop<=y0+height; y_loop++)
		{
			for(x_loop=x0-r; x_loop<=x0+r+width; x_loop++)
			{
				bitmap_SetPoint(bitmap,x_loop,y_loop,color);
			}
		}
	}

}
/***********************************************************************************************************************

 *        : bitmap_Rectangle

 *          : x0      X

 *                y0      Y

 *                width  

 *                height    ߶

 *                isfill       :Ƿ

 *                   color        :ɫ

 *          : 

 *          : 

 *************************************************************************************************************************/



void bitmap_Rectangle(void *bitmap,int32_t x0,int32_t y0,int32_t width,
		int32_t height,int32_t isfill,int32_t color)

{

	int32_t x_loop,y_loop;
	if(width>0)
		width-=1;
	if(height>0)
		height-=1;

	bitmap_line(bitmap,x0,y0,x0,y0+height,color);//(6,10,77,Vertical);

	bitmap_line(bitmap,x0+width,y0,x0+width,y0+height,color);//(192,10,77,Vertical);

	bitmap_line(bitmap,x0,y0,x0+width,y0,color);//(6,10,186,Horizontal);

	bitmap_line(bitmap,x0,y0+height,x0+width+1,y0+height,color);//(6,87,186,Horizontal);

	if(isfill>0)
	{
		for(y_loop=y0; y_loop<=y0+height; y_loop++)
		{
			for(x_loop=x0; x_loop<=x0+width; x_loop++)
			{
				bitmap_SetPoint(bitmap,x_loop,y_loop,color);
			}
		}
	}

}
/***********************************************************************************************************************

 *        : bitmap_FillRect

 *          : x0      X

 *                y0      Y

 *                width   

 *                height    ߶


 *                   color        :ɫ

 *          : 

 *          : 

 *************************************************************************************************************************/

void bitmap_FillRect(void *bitmap,int32_t x0,int32_t y0,int32_t width,
		int32_t height,int32_t color)
{
	int32_t x_loop,y_loop;
	for(y_loop=y0; y_loop<y0+height; y_loop++)
	{
		for(x_loop=x0; x_loop<x0+width; x_loop++)
		{
			bitmap_SetPoint(bitmap,x_loop,y_loop,color);
		}
	}
}

#if CIRCLE_CLOCK_EN>0
/***********************************************************************************************************************

 *        : bitmap_clock

 *          : bitmap      ͼ豸

 *                clk      ʱӲ



 *          : 

 *          : ʾһԲεģʱ

 *************************************************************************************************************************/


void bitmap_clock(void *bitmap,CIRCLE_CLOCK *clk)
{
	int32_t xc, yc;
	int32_t i;
	float f_temp;

	if((clk->hour>=24)||(clk->minute>=60)||(clk->second>=60))
		return;

	bitmap_circle(bitmap,clk->x, clk->y, clk->r, 1, 0);	//   ʱֱڵķΧ

	bitmap_circle(bitmap,clk->x, clk->y, clk->r, 0, clk->color_cir);	// ʱӵ⾶
	bitmap_circle(bitmap,clk->x, clk->y, clk->mid_r, 0, clk->color_cir);	// middle
	bitmap_circle(bitmap,clk->x, clk->y, clk->core_r, 1, clk->color_cir);	// ʱӵıԲ

	for (i = 0; i < 60; i++)
	{
		xc = clk->x + (int32_t)(clk->kd * sin(PI * 2 * i/60));
		yc = clk->y + (int32_t)(clk->kd * cos(PI * 2 * i/60));
		if (i % 15 == 0)
			bitmap_Rectangle(bitmap,xc-(clk->k_r>>1),yc-(clk->k_r>>1),clk->k_r,clk->k_r,0,clk->color_15);    //һӿ̶
		else if (i % 5 == 0)
			bitmap_circle(bitmap,xc, yc, (clk->k_r>>1), 1, clk->color_5);         //5ӿ̶
		else
			bitmap_SetPoint(bitmap,xc, yc, clk->color_1);             //1ӿ̶
	}

	//
	f_temp = clk->second * 2 * PI / 60;
	xc = (int32_t)(clk->sec_len * sin(f_temp));
	yc = (int32_t)(clk->sec_len * cos(f_temp));
	bitmap_line(bitmap,clk->x + xc, clk->y - yc, clk->x - (xc>>2) , clk->y + (yc>>2), clk->color_second);

	//
	f_temp = clk->minute * 2 * PI / 60+(f_temp/60);
	xc = (int32_t)(clk->min_len * sin(f_temp));
	yc = (int32_t)(clk->min_len * cos(f_temp));
	bitmap_line(bitmap,clk->x + xc, clk->y - yc, clk->x - (xc>>2), clk->y + (yc>>2), clk->color_minute);

	//ʱ
	if(clk->hour>12)
		f_temp = (clk->hour-12) * 2 * PI / 12+(f_temp/12);
	else
		f_temp = clk->hour * 2 * PI / 12+(f_temp/12);
	xc = (int32_t)(clk->hour_len * sin(f_temp));
	yc = (int32_t)(clk->hour_len * cos(f_temp));
	bitmap_line(bitmap,clk->x + xc, clk->y - yc, clk->x - (xc>>2), clk->y + (yc>>2), clk->color_hour);

}
#endif

/***********************************************************************************************************************

 *        : bitmap_Text

 *          : bitmap      ͼ豸

 *                x      ֵĿʼX

 *                y         :ֵĿʼY

 *                str       ĵ

 *                rotation ת˳ʱת0,90180270

 *                font_ctrl 16bitСַָ8bit͵8bit
							  bit0-bit7߶ȣbit8-bit15

 *                color     ɫ

 *          : 

 *          : ʾһ,֧Ժֿ⣬ߵĵΪֽڵλbit7
 ұߵĵΪbit0,Ȳִ֧32bit

 *************************************************************************************************************************/

void bitmap_Text(void *bitmap,int32_t x,int32_t y,const uint8_t *str,
		uint32_t rotation,uint32_t font_ctrl,int32_t color)
{
	uint32_t cx,cy,shift,reg,line_byte,i,rotation_offset;
	int32_t width,height,loop;
	uint8_t bit_shift;

	width  = font_ctrl&0xff;        //
	height = (font_ctrl>>8)&0xff;   //߶

	if(width>32)
		return;

	line_byte = width/8;
	bit_shift = width%8;
	if(bit_shift>0){
		line_byte+=1;
		bit_shift = 8-bit_shift;
	}

	/*תʱҪĳȣԱתܾ*/
	if((height-width)>=0){
		rotation_offset = height-width;
	}
	else{
		rotation_offset = -(height-width);
	}
	rotation_offset>>=1;

	if(rotation==0)          //岻ת
	{
		cx = x;
		cy = y;

		for(loop=0; loop< height; loop++)
		{
			reg = 0;
			for(i=0; i<line_byte; i++)
			{
				reg <<=8;
				reg |= *str++;
			}
			reg>>=bit_shift;
			shift=(1<<(width-1));
			while(shift)
			{
				if(shift&reg)
					bitmap_SetPoint(bitmap,cx,cy,color);
				cx++;
				shift>>=1;
			}
			cx=x;
			cy++;
		}
	}
	else if(rotation==90)   //˳ʱת90
	{
		cx = x+height;
		cy = y+rotation_offset;
		for(loop=0; loop<height; loop++)
		{
			reg = 0;
			for(i=0; i<line_byte; i++)
			{
				reg <<=8;
				reg |= *str++;
			}
			reg>>=bit_shift;
			shift=(1<<(width-1));
			while(shift)
			{
				if(shift&reg)
					bitmap_SetPoint(bitmap,cx,cy,color);
				cy++;
				shift>>=1;
			}
			cx--;
			cy = y+rotation_offset;
		}
	}
	else if(rotation==180)   //˳ʱת180
	{
		cx = x+width;
		cy = y+(height-1);
		for(loop=0; loop<height; loop++)
		{
			reg = 0;
			for(i=0; i<line_byte; i++)
			{
				reg <<=8;
				reg |= *str++;
			}
			reg>>=bit_shift;
			shift=(1<<(width-1));
			while(shift)
			{
				if(shift&reg)
					bitmap_SetPoint(bitmap,cx,cy,color);
				cx--;
				shift>>=1;
			}
			cx = x+width;
			cy --;
		}
	}
	else if(rotation==270)   //ת270
	{
		cx = x;
		cy = (y+(height-1))-rotation_offset;
		for(loop=0; loop< height; loop++)
		{
			reg = 0;
			for(i=0; i<line_byte; i++)
			{
				reg <<=8;
				reg |= *str++;
			}
			reg>>=bit_shift;
			shift=(1<<(width-1));
			while(shift)
			{
				if(shift&reg)
					bitmap_SetPoint(bitmap,cx,cy,color);
				cy--;
				shift>>=1;
			}
			cx++;
			cy = (y+(height-1))-rotation_offset;
		}
	}

}



/***********************************************************************************************************************

 *        : draw_circle

 *          : xc      ԲX

 *                yc      ԲY

 *                r		 Բ뾶

 *                isfill		 ǷԲ >0

 *                color        :ɫ

 *          : 

 *          : Bresenham 㷨Բ

 *************************************************************************************************************************/

void draw_circle(void *draw,int32_t xc,int32_t yc,int32_t r,int32_t isfill,int32_t color)
{
	// (xc, yc) ΪԲģr Ϊ뾶
	// fill ΪǷ
	// c Ϊɫֵ

	// ԲͼƬɼ⣬ֱ˳

	if(xc + r < 0 || yc + r < 0 )
		return;

	int32_t x = 0, y = r, yi, d;

	d = 3 - 2 * r;

	if (isfill>0)
	{
		// 䣨ʵԲ
		while (x <= y)
		{
			for (yi = x; yi <= y; yi ++)
			{
				draw_SetPoint(draw,xc + x, yc + yi, color);
				draw_SetPoint(draw,xc - x, yc + yi, color);
				draw_SetPoint(draw,xc + x, yc - yi, color);
				draw_SetPoint(draw,xc - x, yc - yi, color);
				draw_SetPoint(draw,xc + yi, yc + x, color);
				draw_SetPoint(draw,xc - yi, yc + x, color);
				draw_SetPoint(draw,xc + yi, yc - x, color);
				draw_SetPoint(draw,xc - yi, yc - x, color);
			}


			if (d < 0)
			{
				d = d + 4 * x + 6;
			}
			else
			{
				d = d + 4 * (x - y) + 10;
				y --;
			}
			x++;
		}
	}
	else
	{
		// 䣨Բ
		while (x <= y)
		{
			//_draw_circle_8(xc, yc, x, y, c);
			draw_SetPoint(draw,xc + x, yc + y, color);
			draw_SetPoint(draw,xc - x, yc + y, color);
			draw_SetPoint(draw,xc + x, yc - y, color);
			draw_SetPoint(draw,xc - x, yc - y, color);
			draw_SetPoint(draw,xc + y, yc + x, color);
			draw_SetPoint(draw,xc - y, yc + x, color);
			draw_SetPoint(draw,xc + y, yc - x, color);
			draw_SetPoint(draw,xc - y, yc - x, color);

			if (d < 0)
			{
				d = d + 4 * x + 6;
			}
			else
			{
				d = d + 4 * (x - y) + 10;
				y --;
			}
			x ++;
		}
	}
}


/***********************************************************************************************************************

 *        : draw_line

 *          : x1      ߿ʼX

 *                y1      ߿ʼY

 *                x2		 ߽X

 *                y2		 ߽Y

 *                color        :ɫ

 *          : 

 *          : Bresenham 㷨

 *************************************************************************************************************************/




void draw_line(void *draw,int32_t x1,int32_t y1,int32_t x2,int32_t y2,int32_t color)
{
	//  c Ϊɫֵ

	int32_t dx,dy,yy = 0;


	if((x2-x1)>=0)
		dx = x2-x1;
	else
		dx = -(x2-x1);

	if((y2-y1)>=0)
		dy = y2-y1;
	else
		dy = -(y2-y1);

	if (dx < dy)
	{
		yy = 1;
		SWAP(x1, y1);
		SWAP(x2, y2);
		SWAP(dx, dy);
	}

	int ix = (x2 - x1) > 0 ? 1 : -1,
		iy = (y2 - y1) > 0 ? 1 : -1,
		cx = x1,
		cy = y1,
		n2dy = dy * 2,
		n2dydx = (dy - dx) * 2,
		d = dy * 2 - dx;

	if (yy)   // ֱ x ļнǴ 45 
	{
		while (cx != x2)
		{
			if (d < 0)
			{
				d += n2dy;
			}
			else
			{
				cy += iy;
				d += n2dydx;
			}
			draw_SetPoint(draw,cy, cx, color);
			cx += ix;
		}
	}
	else     // ֱ x ļнС 45 
	{
		while (cx != x2)
		{
			if (d < 0)
			{
				d += n2dy;
			}
			else
			{
				cy += iy;
				d += n2dydx;
			}
			draw_SetPoint(draw,cx, cy, color);
			cx += ix;
		}
	}
}
/***********************************************************************************************************************

 *        : draw_CircleRectangle

 *          : x0      X

 *                y0      Y

 *                width  

 *                height    ߶

 *                r       :Բǰ뾶

 *                isfill       :Ƿ

 *                   color        :ɫ

 *          : 

 *          : ԲǾ

 *************************************************************************************************************************/



void draw_CircleRectangle(void *draw,int32_t x0,int32_t y0,int32_t width,
		int32_t height,int32_t r,int32_t isfill,int32_t color)

{

	int32_t a,b,di;

	int32_t QUA_Second_y0,QUA_Third_y0;

	int32_t QUA_Third_x0,QUA_Four_x0;

	int32_t x_loop,y_loop;


	x0 = x0+r;

	y0 = y0+r;

	width = width-2*r;

	height = height-2*r;

	a=0;

	b=r;

	di=3-2*r;

	while(a<=b)

	{

		//һ

		draw_SetPoint(draw,x0-a,y0-b,color);             //2

		draw_SetPoint(draw,x0-b,y0-a,color);             //3



		//ڶ

		QUA_Second_y0 = y0+height;

		draw_SetPoint(draw,x0-a,QUA_Second_y0+b,color);             //1

		draw_SetPoint(draw,x0-b,QUA_Second_y0+a,color);             //7



		//

		QUA_Third_y0 = y0+height;

		QUA_Third_x0 = x0+width;

		draw_SetPoint(draw,QUA_Third_x0+a,QUA_Third_y0+b,color);             //6

		draw_SetPoint(draw,QUA_Third_x0+b,QUA_Third_y0+a,color);             //4



		//

		QUA_Four_x0 = x0+width;

		draw_SetPoint(draw,QUA_Four_x0+a,y0-b,color);             //5

		draw_SetPoint(draw,QUA_Four_x0+b,y0-a,color);             //0

		if(isfill>0)
		{
			draw_line(draw,x0-a,y0-b,(QUA_Four_x0+a),y0-b,color);    //-(x0-a)

			draw_line(draw,x0-b,y0-a,(QUA_Four_x0+b),y0-a,color);     //-(x0-b)

			draw_line(draw,x0-a,QUA_Second_y0+b,(QUA_Third_x0+a),QUA_Second_y0+b,color);

			draw_line(draw,x0-b,QUA_Second_y0+a,(QUA_Four_x0+b),QUA_Second_y0+a,color);
		}


		a++;

		if(di<0) di +=4*a+6;

		else

		{

			di+=10+4*(a-b);

			b--;

		}

	}

	draw_line(draw,x0-r,y0,x0-r,y0+height,color);//(6,10,77,Vertical);

	draw_line(draw,x0+r+width,y0,x0+r+width,y0+height,color);//(192,10,77,Vertical);

	draw_line(draw,x0,y0-r,x0+width,y0-r,color);//(6,10,186,Horizontal);

	draw_line(draw,x0,y0+height+r,x0+width,y0+height+r,color);//(6,87,186,Horizontal);

	if(isfill>0)
	{
		for(y_loop=y0; y_loop<=y0+height; y_loop++)
		{
			for(x_loop=x0-r; x_loop<=x0+r+width; x_loop++)
			{
				draw_SetPoint(draw,x_loop,y_loop,color);
			}
		}
	}

}
/***********************************************************************************************************************

 *        : draw_Rectangle

 *          : x0      X

 *                y0      Y

 *                width  

 *                height    ߶

 *                isfill       :Ƿ

 *                   color        :ɫ

 *          : 

 *          : 

 *************************************************************************************************************************/



void draw_Rectangle(void *draw,int32_t x0,int32_t y0,int32_t width,
		int32_t height,int32_t isfill,int32_t color)

{

	int32_t x_loop,y_loop;
	if(width>0)
		width-=1;
	if(height>0)
		height-=1;

	draw_line(draw,x0,y0,x0,y0+height,color);//(6,10,77,Vertical);

	draw_line(draw,x0+width,y0,x0+width,y0+height,color);//(192,10,77,Vertical);

	draw_line(draw,x0,y0,x0+width,y0,color);//(6,10,186,Horizontal);

	draw_line(draw,x0,y0+height,x0+width+1,y0+height,color);//(6,87,186,Horizontal);

	if(isfill>0)
	{
		for(y_loop=y0; y_loop<=y0+height; y_loop++)
		{
			for(x_loop=x0; x_loop<=x0+width; x_loop++)
			{
				draw_SetPoint(draw,x_loop,y_loop,color);
			}
		}
	}

}
/***********************************************************************************************************************

 *        : draw_FillRect

 *          : x0      X

 *                y0      Y

 *                width  

 *                height    ߶


 *                   color        :ɫ

 *          : 

 *          : 

 *************************************************************************************************************************/

void draw_FillRect(void *draw,int32_t x0,int32_t y0,int32_t width,
		int32_t height,int32_t color)
{
	int32_t x_loop,y_loop;
	for(y_loop=y0; y_loop<y0+height; y_loop++)
	{
		for(x_loop=x0; x_loop<x0+width; x_loop++)
		{
			draw_SetPoint(draw,x_loop,y_loop,color);
		}
	}
}

#if CIRCLE_CLOCK_EN>0
/***********************************************************************************************************************

 *        : draw_clock

 *          : draw      ͼ豸

 *                clk      ʱӲ



 *          : 

 *          : ʾһԲεģʱ

 *************************************************************************************************************************/


void draw_clock(void *draw,CIRCLE_CLOCK *clk)
{
	int32_t xc, yc;
	int32_t i;
	float f_temp;

	if((clk->hour>=24)||(clk->minute>=60)||(clk->second>=60))
		return;

	draw_circle(draw,clk->x, clk->y, clk->r, 1, 0);	//   ʱֱڵķΧ

	draw_circle(draw,clk->x, clk->y, clk->r, 0, clk->color_cir);	// ʱӵ⾶
	draw_circle(draw,clk->x, clk->y, clk->mid_r, 0, clk->color_cir);	// middle
	draw_circle(draw,clk->x, clk->y, clk->core_r, 1, clk->color_cir);	// ʱӵıԲ

	for (i = 0; i < 60; i++)
	{
		xc = clk->x + (int32_t)(clk->kd * sin(PI * 2 * i/60));
		yc = clk->y + (int32_t)(clk->kd * cos(PI * 2 * i/60));
		if (i % 15 == 0)
			draw_Rectangle(draw,xc-(clk->k_r>>1),yc-(clk->k_r>>1),clk->k_r,clk->k_r,0,clk->color_15);    //һӿ̶
		else if (i % 5 == 0)
			draw_circle(draw,xc, yc, (clk->k_r>>1), 1, clk->color_5);         //5ӿ̶
		else
			draw_SetPoint(draw,xc, yc, clk->color_1);             //1ӿ̶
	}

	//
	f_temp = clk->second * 2 * PI / 60;
	xc = (int32_t)(clk->sec_len * sin(f_temp));
	yc = (int32_t)(clk->sec_len * cos(f_temp));
	draw_line(draw,clk->x + xc, clk->y - yc, clk->x - (xc>>2) , clk->y + (yc>>2), clk->color_second);

	//
	f_temp = clk->minute * 2 * PI / 60+(f_temp/60);
	xc = (int32_t)(clk->min_len * sin(f_temp));
	yc = (int32_t)(clk->min_len * cos(f_temp));
	draw_line(draw,clk->x + xc, clk->y - yc, clk->x - (xc>>2), clk->y + (yc>>2), clk->color_minute);

	//ʱ
	if(clk->hour>12)
		f_temp = (clk->hour-12) * 2 * PI / 12+(f_temp/12);
	else
		f_temp = clk->hour * 2 * PI / 12+(f_temp/12);
	xc = (int32_t)(clk->hour_len * sin(f_temp));
	yc = (int32_t)(clk->hour_len * cos(f_temp));
	draw_line(draw,clk->x + xc, clk->y - yc, clk->x - (xc>>2), clk->y + (yc>>2), clk->color_hour);

}
#endif

/***********************************************************************************************************************

 *        : draw_Text

 *          : draw      ͼ豸

 *                x      ֵĿʼX

 *                y         :ֵĿʼY

 *                str       ĵ

 *                rotation ת˳ʱת0,90180270

 *                font_ctrl 16bitСַָ8bit͵8bit
 bit0-bit7߶ȣbit8-bit15

 *                color     ɫ

 *          : 

 *          : ʾһ,֧Ժֿ⣬ߵĵΪֽڵλbit7
 ұߵĵΪbit0,Ȳִ֧32bit

 ʹ72ֽڱ
 *************************************************************************************************************************/


void draw_Text(void *draw,int32_t x,int32_t y,const uint8_t *str,
		uint32_t rotation,uint32_t font_ctrl,int32_t color)
{
	uint32_t cx,cy,shift,reg,line_byte,i,rotation_offset;
	int32_t width,height,loop;
	uint8_t bit_shift;

	width  = font_ctrl&0xff;        //
	height = (font_ctrl>>8)&0xff;   //߶

	if(width>32)
		return;

	line_byte = width/8;
	bit_shift = width%8;
	if(bit_shift>0){
		line_byte+=1;
		bit_shift = 8-bit_shift;
	}

	/*תʱҪĳȣԱתܾ*/
	if((height-width)>=0){
		rotation_offset = height-width;
	}
	else{
		rotation_offset = -(height-width);
	}
	rotation_offset>>=1;

	if(rotation==0)          //岻ת
	{
		cx = x;
		cy = y;

		for(loop=0; loop< height; loop++)
		{
			reg = 0;
			for(i=0; i<line_byte; i++)
			{
				reg <<=8;
				reg |= *str++;
			}
			reg>>=bit_shift;
			shift=(1<<(width-1));
			while(shift)
			{
				if(shift&reg)
					draw_SetPoint(draw,cx,cy,color);
				cx++;
				shift>>=1;
			}
			cx=x;
			cy++;
		}
	}
	else if(rotation==90)   //˳ʱת90
	{
		cx = x+height;
		cy = y+rotation_offset;
		for(loop=0; loop<height; loop++)
		{
			reg = 0;
			for(i=0; i<line_byte; i++)
			{
				reg <<=8;
				reg |= *str++;
			}
			reg>>=bit_shift;
			shift=(1<<(width-1));
			while(shift)
			{
				if(shift&reg)
					draw_SetPoint(draw,cx,cy,color);
				cy++;
				shift>>=1;
			}
			cx--;
			cy = y+rotation_offset;
		}
	}
	else if(rotation==180)   //˳ʱת180
	{
		cx = x+width;
		cy = y+(height-1);
		for(loop=0; loop<height; loop++)
		{
			reg = 0;
			for(i=0; i<line_byte; i++)
			{
				reg <<=8;
				reg |= *str++;
			}
			reg>>=bit_shift;
			shift=(1<<(width-1));
			while(shift)
			{
				if(shift&reg)
					draw_SetPoint(draw,cx,cy,color);
				cx--;
				shift>>=1;
			}
			cx = x+width;
			cy --;
		}
	}
	else if(rotation==270)   //ת270
	{
		cx = x;
		cy = (y+(height-1))-rotation_offset;
		for(loop=0; loop< height; loop++)
		{
			reg = 0;
			for(i=0; i<line_byte; i++)
			{
				reg <<=8;
				reg |= *str++;
			}
			reg>>=bit_shift;
			shift=(1<<(width-1));
			while(shift)
			{
				if(shift&reg)
					draw_SetPoint(draw,cx,cy,color);
				cy--;
				shift>>=1;
			}
			cx++;
			cy = (y+(height-1))-rotation_offset;
		}
	}

}



