#ifndef BITMAP_H
#define BITMAP_H

#ifdef __cplusplus
extern "C" {
#endif


#define CIRCLE_CLOCK_EN 0

#define FONT_WIDTH_SHIFT 0
#define FONT_HEIGHT_SHIFT 8

#define DEF_RED       1		//
#define DEF_BLUE      2		//
#define DEF_GREEN     2		//
#define DEF_BLACK     0		//
#define DEF_ORANGE    3		//

typedef struct
{
    int32_t width;      //
    int32_t height;     //߶
	int32_t color_bit;  //ɫbit
	int32_t line_len;   //ÿһеֽڳȣǷ㺯
	int32_t buf_size;   //ռõֽ
	void *pOriginal;    //ͼ建ָ룬Ϊmallocָ벻һ
						//ĳֳȶ룬Ϊ˶룬malloc
						//ԭʼָ룬pDraw_boardǾָ룬free
						//ͷŵʱpOriginalָ
	void *pDraw_board;  //ͼ建ָ
} BITMAP,*PBITMAP; 


#if CIRCLE_CLOCK_EN>0
// ģʱʾݽṹ
typedef struct
{
    int32_t x;      //ʱx
    int32_t y;      //ʱy
    int32_t r;      //ʱӰ뾶
    int32_t mid_r;  //ʱԲ뾶
    int32_t core_r; //ʱӵıԲ뾶
    int32_t k_r;      //̶ȱʶ
    int32_t kd;        //̶ȱʶ뾶

    int32_t hour;   //Сʱ
    int32_t minute; //
    int32_t second; //

    int32_t sec_len;        //볤
    int32_t min_len;        //볤
    int32_t hour_len;       //ʱ볤

    int32_t color_hour;     //ʱɫ
    int32_t color_minute;   //ɫ
    int32_t color_second;   //ɫ

    int32_t color_cir;      //ʱɫ
    int32_t color_15;       //һӿ̶ɫ
    int32_t color_5;        //5ӿ̶ɫ
    int32_t color_1;        //1ӿ̶ɫ
} CIRCLE_CLOCK;
#endif

void bitmap_circle(void *bitmap,int32_t xc,int32_t yc,int32_t r,int32_t isfill,int32_t color);

void bitmap_line(void *bitmap,int32_t x1,int32_t y1,int32_t x2,int32_t y2,int32_t color);

void bitmap_CircleRectangle(void *bitmap,int32_t x0,int32_t y0,int32_t width,
		int32_t height,int32_t r,int32_t isfill,int32_t color);

void bitmap_Rectangle(void *bitmap,int32_t x0,int32_t y0,int32_t width,
		int32_t height,int32_t isfill,int32_t color);

void bitmap_FillRect(void *bitmap,int32_t x0,int32_t y0,int32_t width,
		int32_t height,int32_t color);

void bitmap_clock(void *bitmap,CIRCLE_CLOCK *clk);

void bitmap_Text(void *bitmap,int32_t x,int32_t y,const uint8_t *str,
		uint32_t rotation,uint32_t font_ctrl,int32_t color);

int32_t bitmap_shift(void *bitmap,uint32_t mode,uint32_t count);

int32_t bitmap_shiftA(void *bitmap,
		              uint32_t x,
					  uint32_t y,
		              uint32_t w,
					  uint32_t h,
					  uint32_t mode,
					  uint32_t count);
/* 
 * ͼ¼Ҫû廷Ҫֲ޸
 * bitmap_SetPoint
 * draw_SetPoint
 * bitmap_copy 
 *
 *bitmap_SetPointλͼ滭ͼΪͬɫbitȲ
 *ڴ沼Щͬ޸ģdraw_SetPointʼĺǶ
 *ʾ滭ͼͼʾ,ҲҪԴɫbit
 *Ⱥڴ沼ַʽ޸ģbitmap_copy ǰbitmapʼĺͼ
 *ʾʾ
 *
 */

int32_t bitmap_copy(void *pDest,      //ָĿ豸
		int32_t xDest,    //ָĿ豸X
		int32_t yDest,    //ָĿ豸Y
		int32_t width,    //Ŀ
		int32_t height,   //ĸ߶
		void *pSrc,       //ָԴ豸
		int32_t xSrc,     //ָԴ豸X
		int32_t ySrc,     //ָԴ豸Y
		int32_t rop       //ָ
		);

extern int32_t draw_SetPoint(void *draw,int32_t x,int32_t y,int32_t color);

void draw_circle(void *draw,int32_t xc,int32_t yc,int32_t r,int32_t isfill,int32_t color);

void draw_line(void *draw,int32_t x1,int32_t y1,int32_t x2,int32_t y2,int32_t color);

void draw_CircleRectangle(void *draw,int32_t x0,int32_t y0,int32_t width,
						int32_t height,int32_t r,int32_t isfill,int32_t color);

void draw_Rectangle(void *draw,int32_t x0,int32_t y0,int32_t width,
					int32_t height,int32_t isfill,int32_t color);

void draw_FillRect(void *draw,int32_t x0,int32_t y0,int32_t width,
					int32_t height,int32_t color);

void draw_Text(void *draw,int32_t x,int32_t y,const uint8_t *str,
               uint32_t rotation,uint32_t font_ctrl,int32_t color);

#if CIRCLE_CLOCK_EN>0
void draw_clock(void *draw,CIRCLE_CLOCK *clk);
#endif

#ifdef __cplusplus
}
#endif

#endif

