#define PPP_FRAME_H
#include "comdef.h"
#include "CRC_ITU.h"
#include "PPPFrame.h"

#define PPP_RX_BUF_LEN  150  //PPP֡ĳ

static uint8_t Password = 0;
static uint8_t PppRxFlag = 0;
static uint32_t PppRxCount = 0;
static uint8_t PppRxBuffer[PPP_RX_BUF_LEN];

void SetPassword(uint8_t inpassword)
{
	Password = inpassword;
}
/****************************************************************************
* ƣppp_SendFrame
* ܣҪ͵ݰʽд뵽ͻ
* ڲSendByte ͺָ
*           indat    Ҫָ
*           len      ΪҪݵֽ
*           
* ڲ
****************************************************************************/	
void ppp_SendFrame(uint8_t *indata,void (*SendByte)(uint8_t x),uint16_t len)
{
     uint16_t temp_crc,loop;
     uint8_t temp;
     temp_crc = CreateCRC(indata,len);         /*PPP֡CRCȷ͵8bit,ٷ8bit*/

	 if(Password>0){
	 	 for(loop=0;loop<len;loop++){
			indata[loop]^=Password;
		 }
		 temp_crc^=((Password<<8)|Password);
	 }
	 	 
     (*SendByte)(FRAME_FLAG);                 /*Ϳʼ־ַ*/       
     while(len--){
         if((*indata==FRAME_FLAG)||(*indata==ESC)||(*indata<0x20)){
             (*SendByte)(ESC);
             (*SendByte)(*indata^(1<<5));
         }
         else{
             (*SendByte)(*indata);
         }
         indata++;
     }
     temp = (uint8_t)temp_crc&0x00ff;            /*CRC Low 8bit*/
     if((temp==FRAME_FLAG)||(temp==ESC)||(temp<0x20)){
         (*SendByte)(ESC);
         (*SendByte)(temp^(1<<5)); 
     }
     else{
         (*SendByte)(temp);
     }
     
     temp = (uint8_t)(temp_crc>>8);             /*CRC High 8bit*/
     if((temp==FRAME_FLAG)||(temp==ESC)||(temp<0x20)){
         (*SendByte)(ESC);
         (*SendByte)(temp^(1<<5)); 
     }
     else{
         (*SendByte)(temp);
     }
     (*SendByte)(FRAME_FLAG);                 /*ͽ־ַ*/
}

/****************************************************************************
* ƣppp_CreatFrame
* ܣҪ͵ݰʽд뵽ͻ
* ڲoutdata ѾPPP frameָ
*           indat   Ҫָ
*           len     ΪҪݵֽ
*           
* ڲɵPPP frameֽ
****************************************************************************/	
uint16_t ppp_CreatFrame(uint8_t *indata,uint8_t *outdata,uint16_t len)
{
     uint16_t temp_crc,loop;
     uint8_t temp;
     
     temp_crc = 0;
     temp_crc = CreateCRC(indata,len);   /*PPP֡CRCȷ͵8bit,ٷ8bit*/
	 if(Password>0){
		for(loop=0;loop<len;loop++){
			indata[loop]^=Password;
		}
		temp_crc^=((Password<<8)|Password);
	 }
	 loop=0;
     outdata[loop++] = FRAME_FLAG;      /*Ϳʼ־ַ*/       
     while(len--){
         if((*indata==FRAME_FLAG)||(*indata==ESC)||(*indata<0x20)){
		 	 
             outdata[loop++] = ESC;
		     outdata[loop++] = *indata^(1<<5);	
         }
         else{
		 	 outdata[loop++] = *indata;
         }
         indata++;
     }
     temp = (uint8_t)temp_crc&0x00ff;            /*CRC Low 8bit*/
     if((temp==FRAME_FLAG)||(temp==ESC)||(temp<0x20)){
	 	    outdata[loop++] = ESC;
		 	outdata[loop++] = temp^(1<<5);
     }
     else{
	 	   	outdata[loop++] = temp;
     }
     
     temp = (uint8_t)(temp_crc>>8);             /*CRC High 8bit*/
     if((temp==FRAME_FLAG)||(temp==ESC)||(temp<0x20)){
         outdata[loop++] = ESC;
		 outdata[loop++] = temp^(1<<5);
     }
     else{
         outdata[loop++] = temp;
     }
     outdata[loop++] = FRAME_FLAG;            /*ͽ־ַ*/
     return(loop);
}

/****************************************************************************
* ƣppp_ReduceFrame
* ܣPPP֡PPP frameݻԭԭʼ
* ڲindata  յ
* ڲ: err     >0ֽ  -1֡  -2CRC  -3ûн
*           
* :   ʱؽָ
****************************************************************************/	
uint8_t *ppp_ReduceFrame(uint8_t indata,int16_t *err)
{
	uint8_t esc;
	uint8_t *ptr;
	uint16_t loop,i;
	
	
	if(indata==FRAME_FLAG){
		if(PppRxCount>0){
			ptr = &PppRxBuffer[0];
			i=0;
			esc  = 0;
			/* תַָ */
			for(loop=0;loop<PppRxCount;loop++){  
				if(PppRxBuffer[loop]==ESC){
					if(esc==ESC){
						PppRxCount = 0;
						PppRxFlag  = 0;
						*err = -1;
						return(0);
					}
					else
						esc=ESC;
				}
				else{
					if(esc==ESC){
						ptr[i++] = PppRxBuffer[loop]^(1<<5);
						esc = 0;
					}
					else{
						ptr[i++] = PppRxBuffer[loop];
					}
				}
			}
			PppRxCount = 0;
			PppRxFlag  = 0;
			if(Password>0){
				for(loop=0;loop<i;loop++){
					ptr[loop]^=Password;
				}
			}
			if(CheckCRC(PppRxBuffer,i)){
				*err = i-2;           //ȥ2ֽڵCRC
				return(&PppRxBuffer[0]);
			}
			*err = -2;
			return(0);
		}
		else{
			PppRxCount = 0;
			PppRxFlag  = 1;
		}
	}
	else if(PppRxFlag==1){
		if(PppRxCount<(PPP_RX_BUF_LEN-1)){
			PppRxBuffer[PppRxCount++] = indata;
			if(PppRxCount==2){
				if(indata!=END_TYPE){
					PppRxCount = 0;
					PppRxFlag  = 0;
				}
			}
		}
		else{
			PppRxCount = 0;
			PppRxFlag  = 0;
		}
	}
	*err = -3;
	return(0);
}

