#define RING_BUFFER_H
#include "stdint.h"
#include "RingBuffer.h"

static uint32_t w_flag=0;
/****************************************************************************
* ƣbyteRingBufInit
* ܣֽͻλʼ
* ڲpBrb   λݽṹָ
*           pBuf   ڴݵĻָ
*           len    λĴС
*           
* ڲ
****************************************************************************/	

void byteRingBufInit(BYTE_RING_BUFFER *pBrb,uint8_t *pBuf,uint32_t len)
{
	pBrb->count = 0;
	pBrb->buf_len = len;
	pBrb->read  = pBuf;
	pBrb->write = pBuf;
	pBrb->buffer = pBuf;
}

/****************************************************************************
* ƣbyteRingWrite
* ܣֽͻλд
* ڲpBrb   λݽṹָ
*           pInput Ҫдָ
*           len    Ҫдĳ
*           
* ڲʵд볤
****************************************************************************/	

uint32_t byteRingWrite(BYTE_RING_BUFFER *pBrb,uint8_t *pInput,uint32_t len)
{
	uint32_t r_len=0;
	if((pBrb->buf_len-pBrb->count)>=len){
		r_len = len;
		pBrb->count+=len;
		while(len){
			*pBrb->write++ = *pInput++;
			if(pBrb->write==(pBrb->buffer+pBrb->buf_len)){
				pBrb->write = pBrb->buffer;
			}
			len--;
		}
	}
	else{
		w_flag++;
	}
	return r_len;
}

/****************************************************************************
* ƣbyteRingRead
* ܣֽͻλ
* ڲpBrb   λݽṹָ
*           pOut   Ҫݻָ
*           len    Ҫĳ
*           
* ڲʵʶ
****************************************************************************/

uint32_t byteRingRead(BYTE_RING_BUFFER *pBrb,uint8_t *pOut,uint32_t len)
{
	uint32_t r_len=0;
	if(pBrb->count>0){
		if(len>=pBrb->count)
			len = pBrb->count;
		r_len = len;
		pBrb->count-=len;
		while(len){
			*pOut++ = *pBrb->read++;
			if(pBrb->read==(pBrb->buffer+pBrb->buf_len)){
				pBrb->read = pBrb->buffer;
			}
			len--;
		}
	}
	return r_len;
}

/****************************************************************************
* ƣbyteRingGetCount
* ܣֽͻλĴ洢
* ڲpBrb   λݽṹָ
*          
*           
*           
* ڲ洢
****************************************************************************/

uint32_t byteRingGetCount(BYTE_RING_BUFFER *pBrb)
{
    return pBrb->count;
}
