/**************************************************************************************

W25Q16BV 16 Mbit(2M x 8) Flash洢
(20110520)
ڴ˳:
˳ΪûʹøFLASHṩһܺ,ûɸԼҪʹЩ 
Read_Status_Register	ȡ״̬Ĵ
EWSR					ʹд״̬Ĵ
WRSR					д״̬Ĵ
WREN					дʹ
WRDI					дֹ
EBSY					ʹMISO ΪAAIģʽRY/BY#
DBSY					ֹMISORY/BY#
HighSpeed_Read			ȡһֽ(50MhzʱƵ)byte
HighSpeed_Read_Cont		ȡ(50 MHzʱƵ)
Byte_Program			дһֽ
Auto_Add_IncA			ʼAuto Address Increment(AAI)
Auto_Add_IncB			AAIʼAuto_Address_Increment(AAI)
Chip_Erase				оƬ
Block_Erase_32K			һ32 KByte
Block_Erase_64K			һ64 KByte
Wait_Busy				ȴ(״̬ĴBUSYλΪ0)
Wait_Busy_AAI			AAIģʽµȴ
WREN_Check				WELǷλ
WREN_AAI_Check			WELAAIģʽλλ
**************************************************************************************/
#define  W25Q16BV_H

#include "comdef.h"
#include "W25Q16BV.h"

/************************************************************************/
/* : WRSR														*/
/* : ״̬Ĵд2ֽ,W25Q16BV2ֽ״̬Ĵ  		*/
/* :	 i													    	*/
/* :	 Nothing													*/
/************************************************************************/
void WRSR(uint16_t i)
{
	(*SPI_CS_ON)();			 /* ʹ豸 */
	(*SPI_Write)(0x01,8); /* д״̬Ĵ */
	(*SPI_Write)(i,16); /* ıĴBPxBPL (ֻ2,3,4,5,7λԸд)*/
	(*SPI_CS_OFF)();			 /* ֹ豸 */
}

/************************************************************************/
/* : WREN														*/
/* : дʹܣͬʹд״̬Ĵ						*/
/* :		None													*/
/* :		Nothing													*/
/************************************************************************/
void WREN(void)
{
	(*SPI_CS_ON)();			
	(*SPI_Write)(0x06,8);		/* WREN */
	(*SPI_CS_OFF)();		
}

/************************************************************************/
/* : WRDI															*/
/* : дֹ															*/
/* :		None													*/
/* :		Nothing													*/
/************************************************************************/
void WRDI(void)
{
	(*SPI_CS_ON)();			
	(*SPI_Write)(0x04,8);		/* WRDI*/
	(*SPI_CS_OFF)();		
}

/************************************************************************/
/* : Read_Status_Register			                */
/* : ȡ״̬Ĵ,״̬Ĵֵ			*/
/* :		None						*/
/* :		byte						*/
/************************************************************************/
uint8_t Read_Status_Register(uint8_t status)
{
	uint8_t i = 0;
	(*SPI_CS_ON)();    		    /* ʹ豸 */
	if(status==1)
		(*SPI_Write)(0x05,8);		/* Ͷ״̬Ĵ1 */
	else
		(*SPI_Write)(0x35,8);		/* Ͷ״̬Ĵ2 */
	i = (*SPI_Read)(8);		    /* ȡ״̬Ĵ */
	(*SPI_CS_OFF)();			/* ֹ豸 */
	return i;
}


/************************************************************************/
/* : Wait_Busy														*/
/* : ȴоƬ(ִByte-Program, Sector-Erase, Block-Erase		*/
/*		 Chip-Erase)												*/
/* : None															*/
/* : Nothing														*/
/************************************************************************/
void Wait_Busy(void)
{
	while ((Read_Status_Register(1))&0x01 == 0x01);/* waste time until not busy */
}


/************************************************************************/
/* : WREN_Check														*/
/* : дǰWELλǷΪ1										*/
/* :		None													*/
/* :		Nothing													*/
/************************************************************************/
void WREN_Check(void)
{
	uint8_t i;
	i = Read_Status_Register(1);	/* ȡ״̬register */
	if ((i&0x02) != 0x02)		/* WELλλ */
	{
		WREN();
			//δ1Ӧ,дʹò
	}
}

/************************************************************************/
/* : HighSpeed_Read													*/	
/* : ٶȡһֽ  												*/
/* : Dst(Ŀַ 000000H - 1FFFFFH)								*/
/* : byte															*/
/************************************************************************/
uint8_t HighSpeed_Read(uint32_t Dst) 
{
	uint8_t i = 0;	
	(*SPI_CS_ON)();			/*  ʹоƬ  */
	(*SPI_Write)(0x0B,8); /* ָ */
	(*SPI_Write)(((Dst & 0xFFFFFF) >> 16),8);/* 3ֽڵĵַ*/
	(*SPI_Write)(((Dst & 0xFFFF) >> 8),8);
	(*SPI_Write)((Dst & 0xFF),8);
	(*SPI_Write)(0xFF,8);/*ֽ*/
	i = (*SPI_Read)(8);
	(*SPI_CS_OFF)();	/* ֹоƬ */
	return i;/* ضȡһֽ */
}

/************************************************************************/
/* :  HighSpeed_Read_Cont											*/
/* :  ٶȡоƬַ,ɶȡ128ֽ					*/
/* :  Dst:(Ŀַ 000000H - 1FFFFFH)								*/
/*        no_bytes:	ȡֽ	(128ֽ)							*/
/*        upper_128[]: ȡݴŵַָ                             */
/* :  Nothing														*/
/************************************************************************/
void HighSpeed_Read_Cont(uint32_t Dst, uint32_t no_bytes,uint8_t *upper_128)
{
	uint32_t i = 0;
	(*SPI_CS_ON)();			/*  ʹоƬ  */
	(*SPI_Write)(0x0B,8); /* ָ */
	(*SPI_Write)(((Dst & 0xFFFFFF) >> 16),8);/* 3ֽڵĵַ*/
	(*SPI_Write)(((Dst & 0xFFFF) >> 8),8);
	(*SPI_Write)((Dst & 0xFF),8);
	(*SPI_Write)(0xFF,8);/*ֽ*/
	for (i = 0; i < no_bytes; i++) /* ȡno_bytesֽ*/
	{
		upper_128[i] = (*SPI_Read)(8);	/*ݴ 80H - FFH */
	}
	(*SPI_CS_OFF)(); /* ֹоƬ*/
}

/************************************************************************/
/* : Byte_Program													*/
/* : дһֽ,дĵַ뱻δ					*/				
/* :																*/
/*		Dst:		(Ŀַ 000000H - 1FFFFFH)						*/
/*		i:														*/
/* :																*/
/*		Nothing															*/
/************************************************************************/
void Byte_Program(uint32_t Dst, uint8_t i)
{
	WREN();
	(*SPI_CS_ON)();			/* оƬʹ */
	(*SPI_Write)(0x02,8); 	/* дָ */
	(*SPI_Write)(((Dst & 0xFFFFFF) >> 16),8);/* 3ֽڵַ */
	(*SPI_Write)(((Dst & 0xFFFF) >> 8),8);
	(*SPI_Write)(Dst & 0xFF,8);
	(*SPI_Write)(i,8);	/*Ҫд*/
	(*SPI_CS_OFF)();
	Wait_Busy();			
}
/************************************************************************/
/* : Auto_Program												*/
/* : дNֽ,żֽ					*/
/*       AAIģʽWRDIAAIִָܱ,ΪSOΪRY/BY#״̬*/
/* :																*/
/*		Dst:	  (Ŀַ 000000H - 1FFFFFH)		        */
/*		no_byte   Ҫдֽ				        */
/*              input     Ҫ̵ݻָ                         */
/* :							       */
/*		Nothing						       */
/************************************************************************/
void Auto_Program(uint32_t Dst,uint32_t no_byte,uint8_t *input)
{
	uint32_t loop;
	WREN();
	(*SPI_CS_ON)();			/* оƬʹ */
	(*SPI_Write)(0x02,8); 	/* дָ */
	(*SPI_Write)(((Dst & 0xFFFFFF) >> 16),8);/* 3ֽڵַ */
	(*SPI_Write)(((Dst & 0xFFFF) >> 8),8);
	(*SPI_Write)(Dst & 0xFF,8);


	for(loop=0;loop<no_byte;loop++){
		(*SPI_Write)(*(input+loop),8);
	}
	(*SPI_CS_OFF)();
    Wait_Busy();
}
/************************************************************************/
/* : Chip_Erase														*/
/* : оƬ													*/
/* : None													        */
/* : Nothing													    */
/************************************************************************/
void Chip_Erase(void)
{						
	WREN();
	(*SPI_CS_ON)();			/* оƬʹ */		
	(*SPI_Write)(0x60,8);			/*  Chip Erase (60h or C7h) */
	(*SPI_CS_OFF)();
	Wait_Busy();
}
/************************************************************************/
/* : Block_Erase_4K												*/
/* : Block Erases 4 KByte											*/
/* :		Dst:		Ŀַ000000H - 1FFFFFH					*/
/* :		Nothing													*/
/************************************************************************/
void Block_Erase_4K(uint32_t Dst)
{
	WREN_Check();
	(*SPI_CS_ON)();			
	(*SPI_Write)(0x20,8);			        /* 4KByte Block Erase  */
	(*SPI_Write)(((Dst & 0xFFFFFF) >> 16),8); 	/* 3 bytesַ 	*/
	(*SPI_Write)(((Dst & 0xFFFF) >> 8),8);
	(*SPI_Write)(Dst & 0xFF,8);
	(*SPI_CS_OFF)();
	Wait_Busy();		
}
/************************************************************************/
/* : Block_Erase_32K												*/
/* : Block Erases 32 KByte of the Chip.								*/
/* :		Dst:		Ŀַ 000000H - 1FFFFFH					*/
/* :		Nothing													*/
/************************************************************************/
void Block_Erase_32K(uint32_t Dst)
{
	WREN_Check();
	(*SPI_CS_ON)();			
	(*SPI_Write)(0x52,8);			        /* 32KByte Block Erase  */
	(*SPI_Write)(((Dst & 0xFFFFFF) >> 16),8); 	/* 3 bytesַ 	*/
	(*SPI_Write)(((Dst & 0xFFFF) >> 8),8);
	(*SPI_Write)(Dst & 0xFF,8);
	(*SPI_CS_OFF)();
	Wait_Busy();		
}

/************************************************************************/
/* : Block_Erase_64K												*/
/* : Block Erases 64 KByte											*/
/* :		Dst:		Ŀַ000000H - 1FFFFFH					*/
/* :		Nothing													*/
/************************************************************************/
void Block_Erase_64K(uint32_t Dst)
{
	WREN_Check();
	(*SPI_CS_ON)();			
	(*SPI_Write)(0xD8,8);			        /* 64KByte Block Erase  */
	(*SPI_Write)(((Dst & 0xFFFFFF) >> 16),8); 	/* 3 bytesַ 	*/
	(*SPI_Write)(((Dst & 0xFFFF) >> 8),8);
	(*SPI_Write)(Dst & 0xFF,8);
	(*SPI_CS_OFF)();
	Wait_Busy();		
}
/************************************************************************/
/* : Read_JEDEC_ID											    	*/
/* : оƬ	JEDEC ID								        		*/
/* :		Nothing                               					*/
/* :		JEDEC ID												*/
/************************************************************************/
uint32_t Read_JEDEC_ID(void)
{
	uint32_t temp;
	temp = 0;
	(*SPI_CS_ON)();		
	(*SPI_Write)(0x9F,8);		         /* send JEDEC ID command (9Fh) */
   	temp = (temp | (*SPI_Read)(8)) << 8; /* receive byte */
	temp = (temp | (*SPI_Read)(8)) << 8;	
	temp = (temp | (*SPI_Read)(8)); 
	(*SPI_CS_OFF)();
	return(temp);		
}


