#include "ioCC1110.h"
#include "comdef.h"
#include "disp_drv.h"
#include "funt.h"

#define LED_R  0
#define LED_G  5
#define LED_STB P0_6
#define LED_SCK P0_7
#define LED_EN  P1_0
#define DISP_BUF_HIGH 16
#define DISP_BUF_LEN  48

__code const uint8_t abcd_mask[16]={0,0x10,0x08,0x18,0x04,0x14,0x0c,0x1c,
                              0x02,0x12,0x0a,0x1a,0x06,0x16,0x0E,0x1E};


static uint8_t abcd_reg=0;
static  uint8_t disp_buf[DISP_BUF_HIGH][DISP_BUF_LEN];

 

__data uint8_t send_bit_reg;

void led_scan(void *arg)
{
  uint8_t i,s_len;
  
  uint8_t *c_pr;
  arg = arg;
  
  s_len = sys_cfg.len;
  LED_STB = 0;
  c_pr = &disp_buf[abcd_reg][0];
  
  ENTER_CRITICAL; //رж
  for(i=0;i<s_len;i++){
    send_bit_reg = *c_pr++;
    __asm("MOV A,send_bit_reg");
    LED_SCK=0;
    __asm("RLC A");
    __asm("MOV P0.5,C");
    __asm("RLC A");
    __asm("MOV P0.0,C");
    LED_SCK=1;
    
    LED_SCK=0;
    __asm("RLC A");
    __asm("MOV P0.5,C");
    __asm("RLC A");
    __asm("MOV P0.0,C");
    LED_SCK=1;
    
    LED_SCK=0;
    __asm("RLC A");
    __asm("MOV P0.5,C");
    __asm("RLC A");
    __asm("MOV P0.0,C");
    LED_SCK=1;
    
    LED_SCK=0;
    __asm("RLC A");
    __asm("MOV P0.5,C");
    __asm("RLC A");
    __asm("MOV P0.0,C");
    LED_SCK=1;
  }
  
  P0&=~((1<<1)|(1<<2)|(1<<3)|(1<<4));  //set ABCD
  P0|=abcd_mask[abcd_reg++];
  if(abcd_reg>0x0F)
    abcd_reg=0;
  
  LED_STB = 1;
  EXIT_CRITICAL; //ж
}
