#include "ioCC1110.h"
#include "comdef.h"
#include "W25Q16BV.h"
#include "CRC_ITU.h"

#define FUNT_H
#include "funt.h"

#define SPI_BAUD_M 60
#define SPI_BAUD_E 17

#define U0CSR_MODE   DEF_B(7)
#define U0CSR_SLAVE  DEF_B(5)
#define U0GCR_BAUD_E 0x1F
#define U0GCR_CPOL   DEF_B(7)
#define U0GCR_CPHA   DEF_B(6)
#define U0GCR_ORDER  DEF_B(5)
#define U0CSR_TX_BYTE DEF_B(1)

#define SPI_CS P1_2 

#define ISN15x16_Address    0x0002C9D0
#define ISN24x24_Address    0x00068190
#define ISN32x32_Address    0x000EDF00
#define ASCII8x16_Address   0x001DD780
#define ASCII12x24_Address   0x001DFF00 
#define ASCII16x32_Address   0x001E5A50

#define SYS_SET_SAVE_ADDR 0x1F3000
#define DATA_CONFIG_ADDR  0x1F4000
#define SPACE_SAVE_ADDR   0x1F5000

__code const uint8_t chardot[224] = {
/*0    */
0x00,0x1C,0x36,0x63,0x63,0x63,0x63,0x6B,
0x6B,0x63,0x63,0x63,0x63,0x36,0x1C,0x00,

/*1    */
0x00,0x0C,0x1C,0x3C,0x0C,0x0C,0x0C,0x0C,
0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x7F,0x00,

/*2    */
0x00,0x3E,0x7F,0x63,0x03,0x06,0x0C,0x18,
0x30,0x60,0x60,0x60,0x60,0x7F,0x3F,0x00,

/*3    */
0x00,0x3E,0x63,0x03,0x03,0x03,0x03,0x3F,
0x3F,0x03,0x03,0x03,0x03,0x63,0x3E,0x00,

/*4    */
0x00,0x63,0x63,0x63,0x63,0x63,0x63,0x7F,
0x3F,0x03,0x03,0x03,0x03,0x03,0x03,0x00,

/*5    */
0x00,0x7F,0x60,0x60,0x60,0x60,0x60,0x7E,
0x03,0x03,0x03,0x03,0x03,0x63,0x3E,0x00,

/*6    */
0x00,0x3E,0x63,0x60,0x60,0x60,0x60,0x7E,
0x63,0x63,0x63,0x63,0x63,0x63,0x3E,0x00,

/*7    */
0x00,0x7E,0x7F,0x03,0x03,0x03,0x07,0x0E,
0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x00,

/*8    */
0x00,0x1C,0x36,0x63,0x63,0x63,0x63,0x7F,
0x7F,0x63,0x63,0x63,0x63,0x36,0x1C,0x00,

/*9    */
0x00,0x3E,0x63,0x63,0x63,0x63,0x63,0x3F,
0x03,0x03,0x03,0x03,0x03,0x63,0x3E,0x00

};

__code const uint8_t ABCD[]={
/*A    */
0x00,0x1C,0x36,0x63,0x63,0x63,0x63,0x7F,
0x7F,0x63,0x63,0x63,0x63,0x63,0x63,0x00,

/*B    */
0x00,0x7E,0x63,0x63,0x63,0x63,0x63,0x7E,
0x7E,0x63,0x63,0x63,0x63,0x63,0x7E,0x00,

/*C    */
0x00,0x3E,0x63,0x60,0x60,0x60,0x60,0x60,
0x60,0x60,0x60,0x60,0x60,0x63,0x3E,0x00,

/*D    */
0x00,0x7E,0x63,0x63,0x63,0x63,0x63,0x63,
0x63,0x63,0x63,0x63,0x63,0x63,0x7E,0x00,

/*E    */
0x00,0x3F,0x7F,0x60,0x60,0x60,0x60,0x7F,
0x7F,0x60,0x60,0x60,0x60,0x7F,0x3F,0x00,

/*F    */
0x00,0x3F,0x7F,0x60,0x60,0x60,0x60,0x7F,
0x7F,0x60,0x60,0x60,0x60,0x60,0x60,0x00,

/*G    */
0x00,0x3E,0x63,0x60,0x60,0x60,0x60,0x66,
0x6F,0x63,0x63,0x63,0x63,0x63,0x3E,0x00,

/*H    */
0x00,0x63,0x63,0x63,0x63,0x63,0x63,0x7F,
0x7F,0x63,0x63,0x63,0x63,0x63,0x63,0x00,

/*I    */
0x00,0x7E,0x18,0x18,0x18,0x18,0x18,0x18,
0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x00,

/*J    */
0x00,0x7E,0x03,0x03,0x03,0x03,0x03,0x03,
0x03,0x03,0x03,0x03,0x03,0x63,0x3E,0x00,

/*K    */
0x00,0x61,0x63,0x66,0x6C,0x78,0x70,0x60,
0x60,0x70,0x78,0x6C,0x66,0x63,0x61,0x00,

/*L    */
0x00,0x60,0x60,0x60,0x60,0x60,0x60,0x60,
0x60,0x60,0x60,0x60,0x61,0x63,0x7F,0x00,

/*M    */
0x00,0x63,0x63,0x77,0x7F,0x7F,0x6B,0x6B,
0x63,0x63,0x63,0x63,0x63,0x63,0x63,0x00,

/*N    */
0x00,0x63,0x63,0x63,0x63,0x63,0x73,0x7B,
0x6F,0x67,0x63,0x63,0x63,0x63,0x63,0x00,

/*O    */
0x00,0x1C,0x36,0x63,0x63,0x63,0x63,0x63,
0x63,0x63,0x63,0x63,0x63,0x36,0x1C,0x00,

/*P    */
0x00,0x3E,0x63,0x63,0x63,0x63,0x63,0x7E,
0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x00,

/*Q    */
0x00,0x1C,0x36,0x63,0x63,0x63,0x63,0x63,
0x63,0x63,0x63,0x6B,0x67,0x36,0x1D,0x00,

/*R    */
0x00,0x3E,0x63,0x63,0x63,0x63,0x63,0x7E,
0x70,0x70,0x78,0x6C,0x66,0x63,0x61,0x00,

/*S    */
0x00,0x3E,0x63,0x60,0x60,0x60,0x60,0x3E,
0x03,0x03,0x03,0x03,0x03,0x63,0x3E,0x00,

/*T    */
0x00,0x7E,0x7E,0x5A,0x18,0x18,0x18,0x18,
0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,

/*U    */
0x00,0x63,0x63,0x63,0x63,0x63,0x63,0x63,
0x63,0x63,0x63,0x63,0x63,0x77,0x3E,0x00,

/*V    */
0x00,0x63,0x63,0x63,0x63,0x63,0x63,0x63,
0x63,0x63,0x63,0x77,0x36,0x1C,0x08,0x00,

/*W    */
0x00,0x63,0x63,0x63,0x63,0x63,0x63,0x63,
0x6B,0x6B,0x7F,0x7F,0x77,0x63,0x63,0x00,

/*X    */
0x00,0x41,0x63,0x36,0x1C,0x1C,0x1C,0x1C,
0x1C,0x1C,0x1C,0x1C,0x36,0x63,0x41,0x00,

/*Y    */
0x00,0x63,0x63,0x63,0x63,0x77,0x3E,0x1C,
0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x00,

/*Z    */
0x00,0x7F,0x7F,0x03,0x03,0x03,0x06,0x0C,
0x18,0x30,0x60,0x60,0x60,0x7F,0x7F,0x00

};

__code const uint8_t ascii1[] = {
    0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x7e,0x81, 0xa5,0x81,0x81,0xbd, 0x99,0x81,0x81,0x7e, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x7e,0xff, 0xdb,0xff,0xff,0xc3, 0xe7,0xff,0xff,0x7e, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x6c,0xfe,0xfe,0xfe, 0xfe,0x7c,0x38,0x10, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x10,0x38,0x7c,0xfe, 0x7c,0x38,0x10,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x18, 0x3c,0x3c,0xe7,0xe7, 0xe7,0x18,0x18,0x3c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x18, 0x3c,0x7e,0xff,0xff, 0x7e,0x18,0x18,0x3c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x00,0x18,0x3c, 0x3c,0x18,0x00,0x00, 0x00,0x00,0x00,0x00,
    0xff,0xff,0xff,0xff, 0xff,0xff,0xe7,0xc3, 0xc3,0xe7,0xff,0xff, 0xff,0xff,0xff,0xff,
    0x00,0x00,0x00,0x00, 0x00,0x3c,0x66,0x42, 0x42,0x66,0x3c,0x00, 0x00,0x00,0x00,0x00,
    0xff,0xff,0xff,0xff, 0xff,0xc3,0x99,0xbd, 0xbd,0x99,0xc3,0xff, 0xff,0xff,0xff,0xff,
    0x00,0x00,0x1e,0x0e, 0x1a,0x32,0x78,0xcc, 0xcc,0xcc,0xcc,0x78, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x3c,0x66, 0x66,0x66,0x66,0x3c, 0x18,0x7e,0x18,0x18, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x3f,0x33, 0x3f,0x30,0x30,0x30, 0x30,0x70,0xf0,0xe0, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x7f,0x63, 0x7f,0x63,0x63,0x63, 0x63,0x67,0xe7,0xe6, 0xc0,0x00,0x00,0x00,
    0x00,0x00,0x00,0x18, 0x18,0xdb,0x3c,0xe7, 0x3c,0xdb,0x18,0x18, 0x00,0x00,0x00,0x00,
    0x00,0x80,0xc0,0xe0, 0xf0,0xf8,0xfe,0xf8, 0xf0,0xe0,0xc0,0x80, 0x00,0x00,0x00,0x00,
    0x00,0x02,0x06,0x0e, 0x1e,0x3e,0xfe,0x3e, 0x1e,0x0e,0x06,0x02, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x18,0x3c, 0x7e,0x18,0x18,0x18, 0x7e,0x3c,0x18,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x66,0x66, 0x66,0x66,0x66,0x66, 0x66,0x00,0x66,0x66, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x7f,0xdb, 0xdb,0xdb,0x7b,0x1b, 0x1b,0x1b,0x1b,0x1b, 0x00,0x00,0x00,0x00,
    0x00,0x7c,0xc6,0x60, 0x38,0x6c,0xc6,0xc6, 0x6c,0x38,0x0c,0xc6, 0x7c,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0xfe,0xfe,0xfe,0xfe, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x18,0x3c, 0x7e,0x18,0x18,0x18, 0x7e,0x3c,0x18,0x7e, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x18,0x3c, 0x7e,0x18,0x18,0x18, 0x18,0x18,0x18,0x18, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x18,0x18, 0x18,0x18,0x18,0x18, 0x18,0x7e,0x3c,0x18, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x18,0x0c,0xfe, 0x0c,0x18,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x30,0x60,0xfe, 0x60,0x30,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x00,0xc0,0xc0, 0xc0,0xfe,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x28,0x6c,0xfe, 0x6c,0x28,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x10,0x38,0x38,0x7c, 0x7c,0xfe,0xfe,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0xfe,0xfe,0x7c,0x7c, 0x38,0x38,0x10,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x18,0x3c, 0x3c,0x3c,0x18,0x18, 0x18,0x00,0x18,0x18, 0x00,0x00,0x00,0x00,
    0x00,0x66,0x66,0x66, 0x24,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x6c, 0x6c,0xfe,0x6c,0x6c, 0x6c,0xfe,0x6c,0x6c, 0x00,0x00,0x00,0x00,
    0x18,0x18,0x7c,0xc6, 0xc2,0xc0,0x7c,0x06, 0x06,0x86,0xc6,0x7c, 0x18,0x18,0x00,0x00,
    0x00,0x00,0x00,0x00, 0xc2,0xc6,0x0c,0x18, 0x30,0x60,0xc6,0x86, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x38,0x6c, 0x6c,0x38,0x76,0xdc, 0xcc,0xcc,0xcc,0x76, 0x00,0x00,0x00,0x00,
    0x00,0x30,0x30,0x30, 0x60,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x0c,0x18, 0x30,0x30,0x30,0x30, 0x30,0x30,0x18,0x0c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x30,0x18, 0x0c,0x0c,0x0c,0x0c, 0x0c,0x0c,0x18,0x30, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x66,0x3c,0xff, 0x3c,0x66,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x18,0x18,0x7e, 0x18,0x18,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x18,0x18,0x18, 0x30,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0xfe, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x18,0x18, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x02,0x06,0x0c,0x18, 0x30,0x60,0xc0,0x80, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x38,0x6c, 0xc6,0xc6,0xd6,0xd6, 0xc6,0xc6,0x6c,0x38, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x18,0x38, 0x78,0x18,0x18,0x18, 0x18,0x18,0x18,0x7e, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x7c,0xc6, 0x06,0x0c,0x18,0x30, 0x60,0xc0,0xc6,0xfe, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x7c,0xc6, 0x06,0x06,0x3c,0x06, 0x06,0x06,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x0c,0x1c, 0x3c,0x6c,0xcc,0xfe, 0x0c,0x0c,0x0c,0x1e, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xfe,0xc0, 0xc0,0xc0,0xfc,0x06, 0x06,0x06,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x38,0x60, 0xc0,0xc0,0xfc,0xc6, 0xc6,0xc6,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xfe,0xc6, 0x06,0x06,0x0c,0x18, 0x30,0x30,0x30,0x30, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x7c,0xc6, 0xc6,0xc6,0x7c,0xc6, 0xc6,0xc6,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x7c,0xc6, 0xc6,0xc6,0x7e,0x06, 0x06,0x06,0x0c,0x78, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x18,0x18,0x00,0x00, 0x00,0x18,0x18,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x18,0x18,0x00,0x00, 0x00,0x18,0x18,0x30, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x06, 0x0c,0x18,0x30,0x60, 0x30,0x18,0x0c,0x06, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x7e,0x00,0x00, 0x7e,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x60, 0x30,0x18,0x0c,0x06, 0x0c,0x18,0x30,0x60, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x7c,0xc6, 0xc6,0x0c,0x18,0x18, 0x18,0x00,0x18,0x18, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x7c, 0xc6,0xc6,0xde,0xde, 0xde,0xdc,0xc0,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x10,0x38, 0x6c,0xc6,0xc6,0xfe, 0xc6,0xc6,0xc6,0xc6, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xfc,0x66, 0x66,0x66,0x7c,0x66, 0x66,0x66,0x66,0xfc, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x3c,0x66, 0xc2,0xc0,0xc0,0xc0, 0xc0,0xc2,0x66,0x3c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xf8,0x6c, 0x66,0x66,0x66,0x66, 0x66,0x66,0x6c,0xf8, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xfe,0x66, 0x62,0x68,0x78,0x68, 0x60,0x62,0x66,0xfe, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xfe,0x66, 0x62,0x68,0x78,0x68, 0x60,0x60,0x60,0xf0, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x3c,0x66, 0xc2,0xc0,0xc0,0xde, 0xc6,0xc6,0x66,0x3a, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xc6,0xc6, 0xc6,0xc6,0xfe,0xc6, 0xc6,0xc6,0xc6,0xc6, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x3c,0x18, 0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x3c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x1e,0x0c, 0x0c,0x0c,0x0c,0x0c, 0xcc,0xcc,0xcc,0x78, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xe6,0x66, 0x66,0x6c,0x78,0x78, 0x6c,0x66,0x66,0xe6, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xf0,0x60, 0x60,0x60,0x60,0x60, 0x60,0x62,0x66,0xfe, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xc6,0xee, 0xfe,0xfe,0xd6,0xc6, 0xc6,0xc6,0xc6,0xc6, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xc6,0xe6, 0xf6,0xfe,0xde,0xce, 0xc6,0xc6,0xc6,0xc6, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x7c,0xc6, 0xc6,0xc6,0xc6,0xc6, 0xc6,0xc6,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xfc,0x66, 0x66,0x66,0x7c,0x60, 0x60,0x60,0x60,0xf0, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x7c,0xc6, 0xc6,0xc6,0xc6,0xc6, 0xc6,0xd6,0xde,0x7c, 0x0c,0x0e,0x00,0x00,
    0x00,0x00,0xfc,0x66, 0x66,0x66,0x7c,0x6c, 0x66,0x66,0x66,0xe6, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x7c,0xc6, 0xc6,0x60,0x38,0x0c, 0x06,0xc6,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x7e,0x7e, 0x5a,0x18,0x18,0x18, 0x18,0x18,0x18,0x3c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xc6,0xc6, 0xc6,0xc6,0xc6,0xc6, 0xc6,0xc6,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xc6,0xc6, 0xc6,0xc6,0xc6,0xc6, 0xc6,0x6c,0x38,0x10, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xc6,0xc6, 0xc6,0xc6,0xd6,0xd6, 0xd6,0xfe,0xee,0x6c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xc6,0xc6, 0x6c,0x7c,0x38,0x38, 0x7c,0x6c,0xc6,0xc6, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x66,0x66, 0x66,0x66,0x3c,0x18, 0x18,0x18,0x18,0x3c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xfe,0xc6, 0x86,0x0c,0x18,0x30, 0x60,0xc2,0xc6,0xfe, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x3c,0x30, 0x30,0x30,0x30,0x30, 0x30,0x30,0x30,0x3c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x80, 0xc0,0xe0,0x70,0x38, 0x1c,0x0e,0x06,0x02, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x3c,0x0c, 0x0c,0x0c,0x0c,0x0c, 0x0c,0x0c,0x0c,0x3c, 0x00,0x00,0x00,0x00,
    0x10,0x38,0x6c,0xc6, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0xff,0x00,0x00,
    0x30,0x30,0x18,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x78,0x0c,0x7c, 0xcc,0xcc,0xcc,0x76, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xe0,0x60, 0x60,0x78,0x6c,0x66, 0x66,0x66,0x66,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x7c,0xc6,0xc0, 0xc0,0xc0,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x1c,0x0c, 0x0c,0x3c,0x6c,0xcc, 0xcc,0xcc,0xcc,0x76, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x7c,0xc6,0xfe, 0xc0,0xc0,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x38,0x6c, 0x64,0x60,0xf0,0x60, 0x60,0x60,0x60,0xf0, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x76,0xcc,0xcc, 0xcc,0xcc,0xcc,0x7c, 0x0c,0xcc,0x78,0x00,
    0x00,0x00,0xe0,0x60, 0x60,0x6c,0x76,0x66, 0x66,0x66,0x66,0xe6, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x18,0x18, 0x00,0x38,0x18,0x18, 0x18,0x18,0x18,0x3c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x06,0x06, 0x00,0x0e,0x06,0x06, 0x06,0x06,0x06,0x06, 0x66,0x66,0x3c,0x00,
    0x00,0x00,0xe0,0x60, 0x60,0x66,0x6c,0x78, 0x78,0x6c,0x66,0xe6, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x38,0x18, 0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x3c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0xec,0xfe,0xd6, 0xd6,0xd6,0xd6,0xc6, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0xdc,0x66,0x66, 0x66,0x66,0x66,0x66, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x7c,0xc6,0xc6, 0xc6,0xc6,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0xdc,0x66,0x66, 0x66,0x66,0x66,0x7c, 0x60,0x60,0xf0,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x76,0xcc,0xcc, 0xcc,0xcc,0xcc,0x7c, 0x0c,0x0c,0x1e,0x00,
    0x00,0x00,0x00,0x00, 0x00,0xdc,0x76,0x66, 0x60,0x60,0x60,0xf0, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x7c,0xc6,0x60, 0x38,0x0c,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x10,0x30, 0x30,0xfc,0x30,0x30, 0x30,0x30,0x36,0x1c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0xcc,0xcc,0xcc, 0xcc,0xcc,0xcc,0x76, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x66,0x66,0x66, 0x66,0x66,0x3c,0x18, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0xc6,0xc6,0xd6, 0xd6,0xd6,0xfe,0x6c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0xc6,0x6c,0x38, 0x38,0x38,0x6c,0xc6, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0xc6,0xc6,0xc6, 0xc6,0xc6,0xc6,0x7e, 0x06,0x0c,0xf8,0x00,
    0x00,0x00,0x00,0x00, 0x00,0xfe,0xcc,0x18, 0x30,0x60,0xc6,0xfe, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x0e,0x18, 0x18,0x18,0x70,0x18, 0x18,0x18,0x18,0x0e, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x18,0x18, 0x18,0x18,0x00,0x18, 0x18,0x18,0x18,0x18, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x70,0x18, 0x18,0x18,0x0e,0x18, 0x18,0x18,0x18,0x70, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x76,0xdc, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x10,0x38,0x6c,0xc6, 0xc6,0xc6,0xfe,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x3c,0x66, 0xc2,0xc0,0xc0,0xc0, 0xc2,0x66,0x3c,0x0c, 0x06,0x7c,0x00,0x00,
    0x00,0x00,0xcc,0x00, 0x00,0xcc,0xcc,0xcc, 0xcc,0xcc,0xcc,0x76, 0x00,0x00,0x00,0x00,
    0x00,0x0c,0x18,0x30, 0x00,0x7c,0xc6,0xfe, 0xc0,0xc0,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x10,0x38,0x6c, 0x00,0x78,0x0c,0x7c, 0xcc,0xcc,0xcc,0x76, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xcc,0x00, 0x00,0x78,0x0c,0x7c, 0xcc,0xcc,0xcc,0x76, 0x00,0x00,0x00,0x00,
    0x00,0x60,0x30,0x18, 0x00,0x78,0x0c,0x7c, 0xcc,0xcc,0xcc,0x76, 0x00,0x00,0x00,0x00,
    0x00,0x38,0x6c,0x38, 0x00,0x78,0x0c,0x7c, 0xcc,0xcc,0xcc,0x76, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x3c,0x66,0x60,0x60, 0x66,0x3c,0x0c,0x06, 0x3c,0x00,0x00,0x00,
    0x00,0x10,0x38,0x6c, 0x00,0x7c,0xc6,0xfe, 0xc0,0xc0,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xc6,0x00, 0x00,0x7c,0xc6,0xfe, 0xc0,0xc0,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x60,0x30,0x18, 0x00,0x7c,0xc6,0xfe, 0xc0,0xc0,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x66,0x00, 0x00,0x38,0x18,0x18, 0x18,0x18,0x18,0x3c, 0x00,0x00,0x00,0x00,
    0x00,0x18,0x3c,0x66, 0x00,0x38,0x18,0x18, 0x18,0x18,0x18,0x3c, 0x00,0x00,0x00,0x00,
    0x00,0x60,0x30,0x18, 0x00,0x38,0x18,0x18, 0x18,0x18,0x18,0x3c, 0x00,0x00,0x00,0x00,
    0x00,0xc6,0x00,0x10, 0x38,0x6c,0xc6,0xc6, 0xfe,0xc6,0xc6,0xc6, 0x00,0x00,0x00,0x00,
    0x38,0x6c,0x38,0x00, 0x38,0x6c,0xc6,0xc6, 0xfe,0xc6,0xc6,0xc6, 0x00,0x00,0x00,0x00,
    0x18,0x30,0x60,0x00, 0xfe,0x66,0x60,0x7c, 0x60,0x60,0x66,0xfe, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0xcc,0x76,0x36, 0x7e,0xd8,0xd8,0x6e, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x3e,0x6c, 0xcc,0xcc,0xfe,0xcc, 0xcc,0xcc,0xcc,0xce, 0x00,0x00,0x00,0x00,
    0x00,0x10,0x38,0x6c, 0x00,0x7c,0xc6,0xc6, 0xc6,0xc6,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xc6,0x00, 0x00,0x7c,0xc6,0xc6, 0xc6,0xc6,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x60,0x30,0x18, 0x00,0x7c,0xc6,0xc6, 0xc6,0xc6,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x30,0x78,0xcc, 0x00,0xcc,0xcc,0xcc, 0xcc,0xcc,0xcc,0x76, 0x00,0x00,0x00,0x00,
    0x00,0x60,0x30,0x18, 0x00,0xcc,0xcc,0xcc, 0xcc,0xcc,0xcc,0x76, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xc6,0x00, 0x00,0xc6,0xc6,0xc6, 0xc6,0xc6,0xc6,0x7e, 0x06,0x0c,0x78,0x00,
    0x00,0xc6,0x00,0x7c, 0xc6,0xc6,0xc6,0xc6, 0xc6,0xc6,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0xc6,0x00,0xc6, 0xc6,0xc6,0xc6,0xc6, 0xc6,0xc6,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x18,0x18,0x3c, 0x66,0x60,0x60,0x60, 0x66,0x3c,0x18,0x18, 0x00,0x00,0x00,0x00,
    0x00,0x38,0x6c,0x64, 0x60,0xf0,0x60,0x60, 0x60,0x60,0xe6,0xfc, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x66,0x66, 0x3c,0x18,0x7e,0x18, 0x7e,0x18,0x18,0x18, 0x00,0x00,0x00,0x00,
    0x00,0xf8,0xcc,0xcc, 0xf8,0xc4,0xcc,0xde, 0xcc,0xcc,0xcc,0xc6, 0x00,0x00,0x00,0x00,
    0x00,0x0e,0x1b,0x18, 0x18,0x18,0x7e,0x18, 0x18,0x18,0x18,0x18, 0xd8,0x70,0x00,0x00,
    0x00,0x18,0x30,0x60, 0x00,0x78,0x0c,0x7c, 0xcc,0xcc,0xcc,0x76, 0x00,0x00,0x00,0x00,
    0x00,0x0c,0x18,0x30, 0x00,0x38,0x18,0x18, 0x18,0x18,0x18,0x3c, 0x00,0x00,0x00,0x00,
    0x00,0x18,0x30,0x60, 0x00,0x7c,0xc6,0xc6, 0xc6,0xc6,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x18,0x30,0x60, 0x00,0xcc,0xcc,0xcc, 0xcc,0xcc,0xcc,0x76, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x76,0xdc, 0x00,0xdc,0x66,0x66, 0x66,0x66,0x66,0x66, 0x00,0x00,0x00,0x00,
    0x76,0xdc,0x00,0xc6, 0xe6,0xf6,0xfe,0xde, 0xce,0xc6,0xc6,0xc6, 0x00,0x00,0x00,0x00,
    0x00,0x3c,0x6c,0x6c, 0x3e,0x00,0x7e,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x38,0x6c,0x6c, 0x38,0x00,0x7c,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x30,0x30, 0x00,0x30,0x30,0x60, 0xc0,0xc6,0xc6,0x7c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x00,0xfe,0xc0, 0xc0,0xc0,0xc0,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x00,0xfe,0x06, 0x06,0x06,0x06,0x00, 0x00,0x00,0x00,0x00,
    0x00,0xc0,0xc0,0xc2, 0xc6,0xcc,0x18,0x30, 0x60,0xdc,0x86,0x0c, 0x18,0x3e,0x00,0x00,
    0x00,0xc0,0xc0,0xc2, 0xc6,0xcc,0x18,0x30, 0x66,0xce,0x9e,0x3e, 0x06,0x06,0x00,0x00,
    0x00,0x00,0x18,0x18, 0x00,0x18,0x18,0x18, 0x3c,0x3c,0x3c,0x18, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x36,0x6c,0xd8, 0x6c,0x36,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0xd8,0x6c,0x36, 0x6c,0xd8,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x11,0x44,0x11,0x44, 0x11,0x44,0x11,0x44, 0x11,0x44,0x11,0x44, 0x11,0x44,0x11,0x44,
    0x55,0xaa,0x55,0xaa, 0x55,0xaa,0x55,0xaa, 0x55,0xaa,0x55,0xaa, 0x55,0xaa,0x55,0xaa,
    0xdd,0x77,0xdd,0x77, 0xdd,0x77,0xdd,0x77, 0xdd,0x77,0xdd,0x77, 0xdd,0x77,0xdd,0x77,
    0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0xf8, 0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18, 0x18,0xf8,0x18,0xf8, 0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x18,
    0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0xf6, 0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0x36,
    0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0xfe, 0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0x36,
    0x00,0x00,0x00,0x00, 0x00,0xf8,0x18,0xf8, 0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x18,
    0x36,0x36,0x36,0x36, 0x36,0xf6,0x06,0xf6, 0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0x36,
    0x00,0x00,0x00,0x00, 0x00,0xfe,0x06,0xf6, 0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36, 0x36,0xf6,0x06,0xfe, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0xfe, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x18,0x18,0x18,0x18, 0x18,0xf8,0x18,0xf8, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0xf8, 0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x1f, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0xff, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0xff, 0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x1f, 0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x18,
    0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0xff, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0xff, 0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18, 0x18,0x1f,0x18,0x1f, 0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x18,
    0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0x37, 0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36, 0x36,0x37,0x30,0x3f, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x3f,0x30,0x37, 0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36, 0x36,0xf7,0x00,0xff, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0xff,0x00,0xf7, 0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36, 0x36,0x37,0x30,0x37, 0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0x36,
    0x00,0x00,0x00,0x00, 0x00,0xff,0x00,0xff, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x36,0x36,0x36,0x36, 0x36,0xf7,0x00,0xf7, 0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0x36,
    0x18,0x18,0x18,0x18, 0x18,0xff,0x00,0xff, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0xff, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0xff,0x00,0xff, 0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x18,
    0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0xff, 0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0x3f, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x18,0x18,0x18,0x18, 0x18,0x1f,0x18,0x1f, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x1f,0x18,0x1f, 0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x18,
    0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x3f, 0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0xff, 0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0x36,
    0x18,0x18,0x18,0x18, 0x18,0xff,0x18,0xff, 0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0xf8, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x1f, 0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x18,
    0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff,
    0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0xff, 0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff,
    0xf0,0xf0,0xf0,0xf0, 0xf0,0xf0,0xf0,0xf0, 0xf0,0xf0,0xf0,0xf0, 0xf0,0xf0,0xf0,0xf0,
    0x0f,0x0f,0x0f,0x0f, 0x0f,0x0f,0x0f,0x0f, 0x0f,0x0f,0x0f,0x0f, 0x0f,0x0f,0x0f,0x0f,
    0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x76,0xdc,0xd8, 0xd8,0xd8,0xdc,0x76, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x78,0xcc, 0xcc,0xcc,0xd8,0xcc, 0xc6,0xc6,0xc6,0xcc, 0x00,0x00,0x00,0x00,
    0x00,0x00,0xfe,0xc6, 0xc6,0xc0,0xc0,0xc0, 0xc0,0xc0,0xc0,0xc0, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0xfe,0x6c,0x6c,0x6c, 0x6c,0x6c,0x6c,0x6c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0xfe, 0xc6,0x60,0x30,0x18, 0x30,0x60,0xc6,0xfe, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x7e,0xd8,0xd8, 0xd8,0xd8,0xd8,0x70, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x66,0x66,0x66,0x66, 0x66,0x7c,0x60,0x60, 0xc0,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x76,0xdc,0x18,0x18, 0x18,0x18,0x18,0x18, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x7e, 0x18,0x3c,0x66,0x66, 0x66,0x3c,0x18,0x7e, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x38, 0x6c,0xc6,0xc6,0xfe, 0xc6,0xc6,0x6c,0x38, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x38,0x6c, 0xc6,0xc6,0xc6,0x6c, 0x6c,0x6c,0x6c,0xee, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x1e,0x30, 0x18,0x0c,0x3e,0x66, 0x66,0x66,0x66,0x3c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x7e,0xdb,0xdb, 0xdb,0x7e,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x03, 0x06,0x7e,0xdb,0xdb, 0xf3,0x7e,0x60,0xc0, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x1c,0x30, 0x60,0x60,0x7c,0x60, 0x60,0x60,0x30,0x1c, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x7c, 0xc6,0xc6,0xc6,0xc6, 0xc6,0xc6,0xc6,0xc6, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0xfe,0x00,0x00,0xfe, 0x00,0x00,0xfe,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x18,0x18,0x7e,0x18, 0x18,0x00,0x00,0xff, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x30, 0x18,0x0c,0x06,0x0c, 0x18,0x30,0x00,0x7e, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x0c, 0x18,0x30,0x60,0x30, 0x18,0x0c,0x00,0x7e, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x0e,0x1b, 0x1b,0x18,0x18,0x18, 0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x18, 0xd8,0xd8,0xd8,0x70, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x18,0x18,0x00,0x7e, 0x00,0x18,0x18,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x76,0xdc,0x00, 0x76,0xdc,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x38,0x6c,0x6c, 0x38,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x18, 0x18,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x18,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x0f,0x0c,0x0c, 0x0c,0x0c,0x0c,0xec, 0x6c,0x6c,0x3c,0x1c, 0x00,0x00,0x00,0x00,
    0x00,0xd8,0x6c,0x6c, 0x6c,0x6c,0x6c,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x70,0xd8,0x30, 0x60,0xc8,0xf8,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x7c,0x7c,0x7c,0x7c, 0x7c,0x7c,0x7c,0x00, 0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00
};

void spi_on(void)
{
  SPI_CS = 0;
}

void spi_off(void)
{
  SPI_CS = 1;
}


uint8_t spi_read(uint8_t cdata)
{
  uint8_t i;
  
  cdata=cdata;
  
  // Write dummy byte to USART0 buffer (transmit data)
  U0DBUF = 0xFF;
  
  // Check if byte is transmitted (and a byte is recieved)
  while(!(U0CSR & U0CSR_TX_BYTE)) 
  { __asm("NOP");}
  
  // Clear transmit byte status
  U0CSR &= ~U0CSR_TX_BYTE;
  
  // Write received byte to buffer
  i = U0DBUF;
  
  return i;
}

void spi_write(uint8_t cdata,uint8_t l)
{
  //uint8_t i;
  l=l;
  
  // Write dummy byte to USART0 buffer (transmit data)
  U0DBUF = cdata;
  
  // Check if byte is transmitted (and a byte is recieved)
  while(!(U0CSR & U0CSR_TX_BYTE)) 
  { __asm("NOP");}
  
  // Clear transmit byte status
  U0CSR &= ~U0CSR_TX_BYTE;
  
  // Write received byte to buffer
 // i = U0DBUF;
  
 }

void init_spi(void)
{
  // Set USART to SPI mode and Master mode
    U0CSR &= ~(U0CSR_MODE | U0CSR_SLAVE);

    // Set:
    // - mantissa value
    // - exponent value
    // - clock phase to be centered on first edge of SCK period
    // - negative clock polarity (SCK low when idle)
    // - bit order for transfers to LSB first | U0GCR_ORDER
    U0BAUD =  SPI_BAUD_M;
    U0GCR = (U0GCR & ~(U0GCR_BAUD_E | U0GCR_CPOL | U0GCR_CPHA ))
        | SPI_BAUD_E|U0GCR_ORDER;
    
    SPI_CS_ON = spi_on;
    SPI_CS_OFF = spi_off;
    SPI_Write  = spi_write;
    SPI_Read = spi_read;
}

uint8_t ReadASCIILib(uint8_t *out_pr,uint8_t ascii,uint8_t LibType)
{
  uint8_t loop,DataLen;
  uint32_t BaseAdd,Address;
  
  DataLen = 0;
  if(LibType==16){
#if 0
    if((ascii>='0')&&(ascii<='9')){
      Address = ascii*0x10;
      for(loop=0;loop<16;loop++){
        out_pr[loop] = ascii1[Address+loop]; 
      }
    }
    else if((ascii>='A')&&(ascii<='Z')){
      Address = (ascii-'A')*0x10;
      for(loop=0;loop<16;loop++){
        out_pr[loop] = ABCD[Address+loop]; 
      }
    }
    else{
      Address = ascii*0x10;
      for(loop=0;loop<16;loop++)
      {
        out_pr[loop] = ascii1[Address+loop]; 
      }
    }
#endif
    Address = ascii*0x10;
    for(loop=0;loop<16;loop++){
      out_pr[loop] = ascii1[Address+loop]; 
    }
    return(16);
  }
  switch(LibType)
  {
  case 24:
    BaseAdd = ASCII12x24_Address;
    DataLen = 48;
    break;
  case 32:
    BaseAdd = ASCII16x32_Address;
    DataLen = 64;
    break;
  }
  if((DataLen>0)&&(ascii>=0x20)&&(ascii<=0x7E)){
    Address = (ascii-0x20)*DataLen+BaseAdd;
    HighSpeed_Read_Cont(Address,DataLen,out_pr);
    return(DataLen);
  }
  return(0);
}

uint8_t ReadISNLib(uint8_t *out_pr,uint8_t msb,uint8_t lsb,uint8_t LibType)
{
  uint8_t DataLen;
  uint32_t BaseAdd,Address;
  DataLen = 0;
  switch(LibType)
  {
  case 16:
    BaseAdd = ISN15x16_Address;
    DataLen = 32;
    break;
  case 24:
    BaseAdd = ISN24x24_Address;
    DataLen = 72;
    break;
  case 32:
    BaseAdd = ISN32x32_Address;
    DataLen = 128;
    break;
  }
  if(DataLen>0){
    if(msb >=0xA1 && msb <= 0xAB && msb >=0xA1)
      Address =((msb - 0xA1) * 94 + (lsb - 0xA1))*DataLen + BaseAdd;
    else if(msb >=0xB0 && msb <= 0xF7 && lsb >=0xA1)
      Address =((msb - 0xB0) * 94 + (lsb - 0xA1)+846)*DataLen+ BaseAdd;
    HighSpeed_Read_Cont(Address,DataLen,out_pr);
  }
  return(DataLen);
}

void eeprom_file_write(uint32_t addr,uint8_t *pu8,uint32_t len)
{
  uint32_t i;
  uint8_t *u8Pr;
  uint16_t crc;
  
  i = len;
  Block_Erase_4K(addr);
  Byte_Program(addr++,(uint8_t)(i&0x000000FF));
  Byte_Program(addr++,(uint8_t)((i>>8)&0x000000FF));
  Byte_Program(addr++,(uint8_t)((i>>16)&0x000000FF));
  Byte_Program(addr++,(uint8_t)((i>>24)&0x000000FF));
  
  crc = CreateCRC(pu8,len);
  
  Byte_Program(addr++,(uint8_t)(crc&0x00ff));
  Byte_Program(addr++,(uint8_t)(crc>>8));
  
  u8Pr = pu8;
  if(len<=250){
    Auto_Program(addr,len,u8Pr);
    len=0;
  }
  else{
    Auto_Program(addr,250,u8Pr);
    u8Pr+=250;
    len-=250;
    addr+=250;
    do{
      if(len>=256){
        Auto_Program(addr,256,u8Pr);
        u8Pr+=256;
        len-=256;
        addr+=256;
      }
      else{
        Auto_Program(addr,len,u8Pr);
        len = 0;
      }
    } while(len);
  }
}

uint32_t eeprom_file_read(uint32_t addr,uint8_t *pOut,uint32_t len)
{
  uint32_t i;
  uint16_t crc;
  i = HighSpeed_Read(addr+3);
  i<<=8;
  i |= HighSpeed_Read(addr+2);
  i<<=8;
  i |= HighSpeed_Read(addr+1);
  i<<=8;
  i |= HighSpeed_Read(addr);
  addr+=4;
 
  crc = HighSpeed_Read(addr++);
  crc |= HighSpeed_Read(addr++)<<8;
  
  if(i>len){
    return 0;
  }
  HighSpeed_Read_Cont(addr,i,pOut);
  if(CreateCRC(pOut,i)==crc)
    return(i);
  else
    return 0;
}

uint8_t KeyStartFlag,KeyOk,KeyTempValue;

void  KeyScan(void *arg)
{
    uint8_t temp;
    arg = arg;

    temp = P2_0;
    temp<<=1;
    temp|= P2_3;
    temp<<=1;
    temp|= P2_4;
    temp^=0x07;
    temp &=0x07;

    if(temp!=0){
      if(KeyStartFlag==1){
        if(temp==KeyTempValue){
          KeyStartFlag = 2;
          KeyOk = KeyTempValue;
          return;   
        }
        KeyStartFlag = 0;
        KeyTempValue = 0;
        return;
      }
      else if(KeyStartFlag==0){
        KeyTempValue = temp;
        KeyStartFlag = 1;
      }
    }
    else{
        KeyStartFlag = 0;
        KeyTempValue = 0;
    }
    return;
}

uint8_t key_read(void)
{
  uint8_t i;
  if(KeyOk>0){
    i=KeyOk;
    KeyOk = 0;
    return i;
  }
  return 0;
}

void DmaT(void)
{
  
}

void init_funt(void)
{
  KeyStartFlag = 0;
  KeyOk = 0;
  KeyTempValue = 0;
}
