#include "ioCC1110.h"
#include "comdef.h"
#include "tmr.h"
#include "disp_drv.h"
#include "funt.h"
#include "W25Q16BV.h"
#include "radio.h"

/* register SLEEP - bit definitions */
#define XOSC_STB      DEF_B(6)
// SLEEP (0xBE) - Sleep Mode Control
#define SLEEP_USB_EN                      0x80
#define SLEEP_XOSC_S                      0x40
#define SLEEP_HFRC_S                      0x20
#define SLEEP_RST                         0x18
#define SLEEP_RST0                        0x08
#define SLEEP_RST1                        0x10
#define SLEEP_OSC_PD                      0x04
#define SLEEP_MODE                        0x03
#define SLEEP_MODE1                       0x02
#define SLEEP_MODE0                       0x01

#define SLEEP_RST_POR_BOD                 (0x00 << 3)
#define SLEEP_RST_EXT                     (0x01 << 3)
#define SLEEP_RST_WDT                     (0x02 << 3)

#define SLEEP_MODE_PM0                    (0x00)
#define SLEEP_MODE_PM1                    (0x01)
#define SLEEP_MODE_PM2                    (0x02)
#define SLEEP_MODE_PM3                    (0x03)

// CLKCON (0xC6) - Clock Control
#define CLKCON_OSC32                      0x80  // bit mask, for the slow 32k clock oscillator
#define CLKCON_OSC                        0x40  // bit mask, for the system clock oscillator
#define CLKCON_TICKSPD                    0x38  // bit mask, for timer ticks output setting
#define CLKCON_TICKSPD0                   0x08  // bit mask, for timer ticks output setting
#define CLKCON_TICKSPD1                   0x10  // bit mask, for timer ticks output setting
#define CLKCON_TICKSPD2                   0x20  // bit mask, for timer ticks output setting
#define CLKCON_CLKSPD                     0x07  // bit mask, for the clock speed
#define CLKCON_CLKSPD0                    0x01  // bit mask, for the clock speed
#define CLKCON_CLKSPD1                    0x02  // bit mask, for the clock speed
#define CLKCON_CLKSPD2                    0x04  // bit mask, for the clock speed

#define TICKSPD_DIV_1                     (0x00 << 3)
#define TICKSPD_DIV_2                     (0x01 << 3)
#define TICKSPD_DIV_4                     (0x02 << 3)
#define TICKSPD_DIV_8                     (0x03 << 3)
#define TICKSPD_DIV_16                    (0x04 << 3)
#define TICKSPD_DIV_32                    (0x05 << 3)
#define TICKSPD_DIV_64                    (0x06 << 3)
#define TICKSPD_DIV_128                   (0x07 << 3)

#define CLKSPD_DIV_1                      (0x00)
#define CLKSPD_DIV_2                      (0x01)
#define CLKSPD_DIV_4                      (0x02)
#define CLKSPD_DIV_8                      (0x03)
#define CLKSPD_DIV_16                     (0x04)
#define CLKSPD_DIV_32                     (0x05)
#define CLKSPD_DIV_64                     (0x06)
#define CLKSPD_DIV_128                    (0x07)

#define OSC_PD        DEF_B(2)

/* register CLKCON - bit definitions */
#define OSC           DEF_B(6)
#define PERCFG_U0CFG  DEF_B(0)

void init_ocs(void)
{
/* ------------------------------------------------------------------
   *    Switch to high speed crystal oscillator.
   *   ------------------------------------------
   */

  SLEEP &= ~SLEEP_OSC_PD;
  while( !(SLEEP & SLEEP_XOSC_S) );

  /* switch from RC oscillator to high speed crystal oscillator */
  CLKCON = (CLKCON & ~(CLKCON_CLKSPD | CLKCON_OSC)) | CLKSPD_DIV_1|TICKSPD_DIV_2;
  
  while (CLKCON & CLKCON_OSC);
  /* power down the oscillator not selected, i.e. the RC oscillator */
  SLEEP |= SLEEP_OSC_PD;
  
}

void init_io(void)
{
    P0DIR = 0xFF;
    P1DIR = 0x1F;
    PERCFG = PERCFG_U0CFG;
    P0SEL = 0;
    P1SEL = (BIT_03|BIT_04|BIT_05);
    P2SEL = 0x40;
    P1|=0x07;
    
}

void init_t1(void)
{
   /***************************************************************************
    * Setup interrupt
    */

    // Clear Timer 1 channel 1 and overflow interrupt flag
    // CPU interrupt flag (IRCON) for Timer 1 is cleared automatically by hardware.
    T1CTL =0x02;
    // Set individual interrupt enable bit in the peripherals SFR
    OVFIM = 0;                   // Enable overflow interrupt
    T1CCTL0 =0x54;      
    T1CCTL1 = 0;
    T1CCTL2 = 0;      
      
    T1CNTL = 0;
    T1CNTH = 0;
    
    //0x2E2A=900us 0x32C8=1ms
    T1CC0L = 0x2A;//0xc8;
    T1CC0H = 0x2E;//0x32;
  
    // Enable Timer 1 interrupts by setting [IEN1.T1IE=1]
    T1IE = 1;
}



#pragma vector = T1_VECTOR
__interrupt void timer1_ISR(void)
{
   T1CTL &=0x0F;
   T1CNTL = 0;
   T1CNTH = 0;
   TmrTask();
}

void led_test(void * arg)
{
    arg = arg;
    P1_1^=1;
}

uint32_t k;
uint8_t arg[20]={55,0xaa,77,88,99,11,22,33,44,55,66};
void main(void)
{
    uint8_t i;
    init_io();    //ʼI/O
    init_ocs();   //ʼʱ
    init_spi();   //ʼSPI

    TmrInit();    //ʼʱ
    init_t1();    //ʼʱ
    
    
    TmrCfgFnct(0,F_MODE,KeyScan,(void *)0);
    TmrSetTick(0,50);
    TmrStart(0);
    
    TmrCfgFnct(1,F_MODE,led_scan,(void *)0);
    TmrSetTick(1,1);
    TmrStart(1);

    EA = 1;
    radio_init(6<<1);
    radio_rxOn();
  //  radio_pn9();
    while(1){
        i = key_read();
        if(i>0){
          radio_send(arg,19);
        }
        rf_isr_handler();
      
        i = radio_read(arg,19);
        if(i>0){
            radio_send(arg,i);
        }
      
    }
}
