
#include "comdef.h"

#define  TMR_MAX_TMR          4  

#define  TMR_USE_SEM           0  

#ifdef  TMR_GLOBALS  
#define TMR_EXT  
#else  
#define TMR_EXT  extern  
#endif  

/* 
 ********************************************************************************************************* 
 *                                             DATA TYPES 
 ********************************************************************************************************* 
 */  

typedef struct tmr {                             /* TIMER DATA STRUCTURE                               */  
    uint8_t     TmrEn;                             /* Flag indicating whether timer is enabled           */  
    uint8_t     Mode;
    uint16_t    TmrCtr;                            /* Current value of timer (counting down)             */  
    uint16_t    TmrInit;                           /* Initial value of timer (i.e. when timer is set)    */  
    void        (*TmrFnct)(void *);                  /* Function to execute when timer times out           */  
    void        *TmrFnctArg;                        /* Arguments supplied to user defined function        */  
} TMR;  

enum{TMR_RUN=1,TMR_STOP};  /*TMR_RUN ʱ,TMR_STOPֹͣ*/
enum{S_MODE,F_MODE};       /*S_MODEģʽF_MODEģʽ*/

/* 
 ********************************************************************************************************* 
 *                                          GLOBAL VARIABLES 
 ********************************************************************************************************* 
 */  

TMR_EXT  TMR       TmrTbl[TMR_MAX_TMR];          /* Table of timers managed by this module             */  

/* 
 ********************************************************************************************************* 
 *                                          FUNCTION PROTOTYPES 
 ********************************************************************************************************* 
 */  

void    TmrCfgFnct(uint8_t n, uint8_t mode, void (*fnct)(void *), void *arg);  
uint16_t  TmrChk(uint8_t n);  
void    TmrInit(void);  
void    TmrReset(uint8_t n);  
void    TmrSetTick (uint8_t n, uint16_t tick); 
void    TmrStart(uint8_t n);  
void    TmrStop(uint8_t n);  
void    TmrTask (void); 

