/* TPIC83R00 Program Bank 0 */

#include "TPIC83R00.H"          /* Register Definitions */
#include "tpic83r00_vars.h"     /* Variable Definitions */
#include "tpic83r00_ee0.h"      /* EEPROGRAM BANK 0 Definition */


/*******************************************************************************/
/* Name:           eepromProgBank0Byte                                         */
/* Purpose:        Initializes Ports                                           */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     None                                                        */
/*******************************************************************************/
void  eepromProgBank0Byte ( unsigned char byteLoc, unsigned char byteVal )
{
  unsigned char eeData;

  if  ( (EE_STATUS&0x10) != 0x10 )
  {
    eeData = EEPROM_BANK0[byteLoc]; // This operation will cause Bank 0 contents to be transfered into Cache

    EEPROM_BANK0[byteLoc] =  byteVal; // Update value

    EE_CTRL = 0x01; // Program 
  }
}

/*******************************************************************************/
/* Name:           eepromReadBank0Byte                                         */
/* Purpose:        Initializes Ports                                           */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     None                                                        */
/*******************************************************************************/
unsigned char  eepromReadBank0Byte ( unsigned char byteLoc )
{
  unsigned char retVal = 0x00;

  if  ( (EE_STATUS&0x10) != 0x10 )	 //Make sure EEPROM Bank 0 is not being programmed
  {
    retVal = EEPROM_BANK0[byteLoc];
  }

  return retVal;
}

/*******************************************************************************/
/* Name:           eepromReadBank0                                             */
/* Purpose:        Initializes Ports                                           */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     None                                                        */
/*******************************************************************************/
unsigned char  eepromReadBank1Byte ( unsigned char byteLoc )
{
  unsigned char retVal = 0x00;

  if  ( (EE_STATUS&0x10) != 0x10 )	 //Make sure EEPROM Bank 0 is not being programmed
  {
    retVal = EEPROM_BANK1[byteLoc];
  }

  return retVal;
}
