/* TPIC83R00 variable Definitions C function */
                
#include "TPIC83R00.H"           /* Register Definitions */
#include "tpic83r00_vars.h"      /* Variable Definitions */
#include "tpic83r00_ee0.h"       /* EEPROGRAM BANK 0 Definition */

/*******************************************************************************/
/* Name:           portInit                                                    */
/* Purpose:        Initializes Ports                                           */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     None                                                        */
/*******************************************************************************/
void portInit (void)
{
  GPIO1 = 1;
  gpio1 = 1;

  GPIO2 = 1;
  gpio2 = 1;

  GPIO3 = 1;
  gpio3 = 1;

  GPIO4 = 1;
  gpio4 = 1;

  GPIO5 = 1;
  gpio5 = 1;

  P0 = 0x00; // Digital Interface Lockout Disabled

}

/*******************************************************************************/
/* Name:           esfrInit                                                    */
/* Purpose:        Initializes ESFRs                                           */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     None                                                        */
/*******************************************************************************/
void esfrInit (void)
{
  unsigned short ocTime;

  //////////////////////////////////////////////////////////////////////////////
  // AFE Setup
  // Capacitive Sensor Settings Register
  CAPSEN = 0xCB; // Resistive Bridge
	
  // Sensor Control
  SENCTRL = 0x42; 

  // Sensor 1 Gain Register
  SEN1GAIN = 0x40; //0b1110 0000;  /* Stage 1 Gain = 51V/V. Stage 2 Gain = 5.86V/V) */
  //SEN2GAIN = 0xEB; /* Stage 1 Gain = 51V/V. Stage 2 Gain = 1.5V/V) */

  // Sensor 1 Offset Register
  SEN1OFF1 = 0x00;
  SEN1OFF2 = 0xA0;

  //GPIO_STRG = 0x00;

  // Decimator Filter Setup
  //DECCTRL = 0x32; // DAC2 is enabled, AFE is enabled, DEC 2 OSR is 8  
  //////////////////////////////////////////////////////////////////////////////

  //////////////////////////////////////////////////////////////////////////////
  // Free Running Timer
  _10_20_MHZ = 1; /* Use 10MHz Clock for Free Running Timer */
  //////////////////////////////////////////////////////////////////////////////

  //////////////////////////////////////////////////////////////////////////////
  // Output Compare 1
  OC1_LVL = 1; /* Clear OC1 level bit */
  oc1 = 1; /* OC1 will be 1 on Match */

  IC_OC_TIM_LAT = 1;
  ocTime = (unsigned short)((((unsigned short)(FRTMSB))<<8) + ((unsigned short)FRTLSB));
  ocTime += (unsigned short)50000; /* 5ms */
  
  OC1MSB = (unsigned char)((ocTime>>8)&0x00FF);
  OC1LSB = (unsigned char)(ocTime&0x00FF);
  
  IC_OC_GPIO |= 0x04; /* Configure GPIO3 as OC1 */
  //////////////////////////////////////////////////////////////////////////////

  //////////////////////////////////////////////////////////////////////////////
  // Input Capture 1
  IC1_EDGE = 1; // Capture Rising Edge

  IC_OC_GPIO |= 0x01; /* Configure GPIO1 as IC1 */
  //////////////////////////////////////////////////////////////////////////////

  //////////////////////////////////////////////////////////////////////////////
  // Software Watchdog Enable
  EN_CTRL = 0x01; //Enable Software Watchdog

  //////////////////////////////////////////////////////////////////////////////

}

/*******************************************************************************/
/* Name:           interruptInit                                               */
/* Purpose:        Initializes Interrupts                                      */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     None                                                        */
/*******************************************************************************/
void interruptInit (void)
{

   PT0 = 1; /* Interrupt priority for Timer 0 is higher */

   EI5 = 1; /* Enable OWI Activation Interrupt */

   EI6 = 1; /* Enable COMBUFF Interrupt */

   EI7 = 1; /* Enable IC1 Interrupt */

   EI8 = 0; /* Disable IC2 Interrupt */

   EI9 = 1; /* OC1 Interrupt Enable */

   EI10 = 1; /* Disable OC2 Interrupt Enable */

   EI11 = 1; /* Decimator 1 Interrupt Enable */

   EI12 = 1; /* Decimator 2 Interrupt Enable */

   EA = 1; /* Enable All Interrupts */

}

/*******************************************************************************/
/* Name:           timerInit                                                   */
/* Purpose:        Initializes timer                                           */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     None                                                        */
/*******************************************************************************/
void timerInit (void)
{

  /*********************************************************/
  /* Timer 0 is Free Running Timer                         */
  /* Configure Timer 0                                     */
  /*   - M0    = 1                                         */
  /*   - M1    = 0   M0 and M1 result in 16-bit timer mode */
  /*   - C/NT  = 0   Internal Clock                        */
  /*   - Gate  = 0   Not gated                             */
  TMOD = TMOD | 0x01;
  
  /* sampling time 2560 us */
  TL0 = 0xFF;
  TH0 = 0xCD;

  ET0 = 1;     /* Enable Timer 0 Overflow Interrupt */
  
  TR0 = 1;     /* Start timer */ 
 
  /***************************************************************/
  /* Timer 1 is used for serial communication baud rate          */
  /* Configure Timer 1                                           */
  /*   - M0    = 0                                               */
  /*   - M1    = 1   M0 and M1 result in 8-bit auto reload mode  */
  /*   - C/T   = 0   Interval Timing                             */
  /*   - Gate  = 0   Not gated                                   */
  TMOD = TMOD | 0x20;
  
  TH1 = TH1_38400_BPS;

  TR1 = 1;
   
}

/*******************************************************************************/
/* Name:           serialInit                                                  */
/* Purpose:        Initializes serial communication                            */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     None                                                        */
/*******************************************************************************/
void serialInit (void)
{

  SM0 = 0;
  SM1 = 1; /* Serial Mode is 8-bit UART with baud rate set by Timer 1 */
  SM2 = 0; /* Multiprocessor communication is not enabled */ 
  TB8 = 0; /* 9th bit is 0 */
  REN = 1; /* Enable Receiver */

  PCON = PCON | 0x80;  /* Set PCON.7 to enable double baud rate - see timerInit funciton */

  //ES = 1;

}


/*******************************************************************************/
/* Name:           appInit                                                     */
/* Purpose:        Initializes SFRs, RAM                                       */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     None                                                        */
/*******************************************************************************/
void appInit (void)
{
  unsigned char i;  
  RAM_UPPER_VARIABLES[0] = eepromReadBank0Byte(0); // EEPROM_BANK0[0]; // Copy EEPROM to RAM
  RAM_LOWER_VARIABLES[0] = eepromReadBank1Byte(0); // EEPROM_BANK1[0]; // Copy EEPROM to RAM

  timeMark = 0x01;
  for(i=0;i<10;i++)
  {
    RAM_UPPER_VARIABLES[i] = i;
  }
  timeMark = 0x00;

  serialReady = (unsigned char)2;

  senChan = 0;
  sampleCnt = 0;

  swWDService = 1;
  SW_WATCHDOG = 0;

  eepromBank0 = 0;

  //
}

