/* TPIC83R00 variable Definitions C function */
                
#include "TPIC83R00.H"          /* Register Definitions */
#include "tpic83r00_vars.h"     /* Variable Definitions */
#include "tpic83r00_ee0.h"      /* EEPROGRAM BANK 0 Definition */
unsigned char LSB1;
unsigned char MSB1;
unsigned char LSB2;
unsigned char MSB2;
unsigned char xl;
unsigned char ym;
 
/*******************************************************************************/
/* Name:           external0_ISR                                               */
/* Purpose:        Timer 0 Interrupt Service Routine                           */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     user Timer 0                                                */
/*******************************************************************************/
void external0_ISR (void) interrupt 0 using 1  
{

}

/*******************************************************************************/
/* Name:           timer0_ISR                                                  */
/* Purpose:        Timer 0 Interrupt Service Routine                           */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     user Timer 0                                                */
/*******************************************************************************/
void timer0_ISR (void) interrupt 1 using 2  
{

  /* sampling time 2560 us */
  TR0 = 0;	// Stop Timer 

  TL0 = 0xFF;
  TH0 = 0xCD;

  /* 1. Set GPIO pin to appropriate state */
  if ( gpio2 == 0 )
  {
    gpio2 = 1;
	GPIO2 = 1;
  }
  else
  {
    gpio2 = 0;
	GPIO2 = 0;
  }

  // This section of code increments the output of DAC2 from 0 to 4095 and repeats    

  DAC2MSB = MSB2;
  DAC2LSB = LSB2;
 
  if(LSB2<255)
  {
  	LSB2++;
  }
	 else
	 {
	 LSB2=0;
	 
		 if(MSB2<15)
		 {
		 MSB2++;
		 }
			 else
			 { 
			 MSB2=0;  
			 }
	  }


  // This section of code takes the signed 16 bit ADC Output and   
  
  xl = ADCLSB;		 //[ nibble 1 | nibble 0]
  xl >> 4;			 //[ 0 0 0 0  | nibble 1]

  ym = ADCMSB;		  //[ nibble 3 | nibble 2]
  ym << 4;			  //[ nibble 2 | 0 0 0 0 ]	
  xl = xl | ym;		  //[ nibble 2 | nibble 1]

  ym = ADCMSB;		 //[ nibble 3 | nibble 2]
  ym >> 4;		  	 //[ 0 0 0 0  | nibble 3]
  					 /*  ym = [ 0 0 0 0  | nibble 3] 
					     xl = [ nibble 2 | nibble 1]
						Dropped the least significan nibble 
						xl and ym are now a 12 signed number padded with 4 zeroes */
  ym = ym ^ 0x08;    // Toggle the most significant bit of lower nibble of ym

  DAC1MSB = ym;
  DAC1LSB = xl;

  // Service Watchdog

  if ( swWDService == 1 )
  {
    SW_WATCHDOG ^= 1;
  }


  TR0 = 1;	 // Start Timer

}

/*******************************************************************************/
/* Name:           timer1_ISR                                                  */
/* Purpose:        Timer 1 Interrupt Service Routine                           */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     user Timer 0                                                */
/*******************************************************************************/
void timer1_ISR (void) interrupt 2 using 2  
{

  //TR0 = 0; /* Stop timer 0 */


  //TR0 = 1; /* Start timer 1 */

}


/*******************************************************************************/
/* Name:           serial_ISR                                                  */
/* Purpose:        Serial Interrupt Service Routine                            */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     user Timer 0                                                */
/*******************************************************************************/
void serial_ISR (void) interrupt 4 	using 3
{
  if (TI)
  { /* Transmit Interrupt */
    TI = 0;      /* Clear Transmit Flag      */

    serialReady++;
    switch (serialReady)
    {
      case 1: // Transfer lower byte of filtered value
        SBUF = padcValueLSB; //(unsigned char)padcValue.u8[1]; /* LSB */
      break;

      //case 2: // comma
      //  SBUF = 0x2C; // Write to the serial bus
      //break;

      //case 3: // Transfer upper byte of adc value
      //  SBUF = (unsigned char)((heightS>>8)&0xFF); // Write to the serial bus
      //break;

      //case 4:// Transfer lower byte of adc value
      //  SBUF = (unsigned char)(heightS&0xFF); // Write to the serial bus
      //break;

      case 2: // CR
        SBUF = 0x0D; // Write to the serial bus
      break;

      default:
      break;
    }
  }

  if (RI)
  {

  }

  ES = 1;      /* Enable Serial Interrupt */
                                  
}

/*******************************************************************************/
/* Name:           owiActivation_ISR                                           */
/* Purpose:        OWI Activation Interrupt Service Routine                    */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     user Timer 0                                                */
/*******************************************************************************/
void owiActivation_ISR (void) interrupt 5 	using 3
{

  //GPIO2 = 1;  /* Turn ON GPIO 2 */

  DI_CTRL = 0x06;  // Switch to OWI	 and Enable OWI Transciever

  //GPIO2 = 0;  /* Turn OFF GPIO 2 */
                       
}

/*******************************************************************************/
/* Name:           commBuffer_ISR                                              */
/* Purpose:        COMM BUFFER Interrupt Service Routine                       */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     user Timer 0                                                */
/*******************************************************************************/
void commBuff_ISR (void) interrupt 6 	using 3
{
  unsigned char commData;

  //GPIO3 = 1;  /* Turn ON GPIO 3 */

  commData = COMBUF; //Read Data from COMBUF

  switch (commData)
  {
    case (0x01): // Enable Low Power Mode
	  //COMBUF = 0x00; // Write 0x00 for interrupt ack
	  DECCTRL &= 0xCF; // Set DAC2_EN = 0, Set AFE_EN = 0
	break;

    case (0x02): // Diable Low Power Mode
	  //COMBUF = 0x00; // Write 0x00 for interrupt ack
      DECCTRL |= 0x30; // Set DAC2_EN = 1, Set AFE_EN = 1	  
	break;

    case (0x03): // Disable SW Watchdog Trigger
	  //COMBUF = 0x00; // Write 0x00 for interrupt ack
	  swWDService = 0; // Disable servicing of SW Watchdog
	break;


    case (0x04): // Program EEPROM Bank 0
	  //COMBUF = 0x00; // Write 0x00 for interrupt ack
	  eepromBank0++;
	  eepromProgBank0Byte(eepromBank0&0x0F, eepromBank0);
	break;

    case (0x05): // Enable Digital Interface Lockout
      P0 = 0xAA;
	break;

    case (0x06): // Disable Digital Interface Lockout
      P0 = 0x00;
	break;


    case (0xFF):
	  //COMBUF = 0x00;   // Write 0x00 for interrupt ack
	  DI_CTRL = 0x00;  // Disable OWI Transceiver and Switch to SPI
	break;

    case (0x55):
	  COMBUF = 0xAA; // Transmit 0xAA to Master
	break;

    case (0x50): // Read Comm Buf Only
	break;

    default:
	break;
  }

  //GPIO3 = 0;  /* Turn OFF GPIO 3 */
                       
}

/*******************************************************************************/
/* Name:           ic1_ISR                                                     */
/* Purpose:        INPUT CAPTURE 1 Interrupt Service Routine                     */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     user Timer 0                                                */
/*******************************************************************************/
void ic1_ISR (void) interrupt 7 	using 3
{

  unsigned short icTime;

  IC_OC_TIM_LAT  = 1; /* Grab FRT value */
  icTime = (unsigned short)((((unsigned short)(FRTMSB))<<8) + ((unsigned short)FRTLSB));

  switch(ic1)
  {
    case 0: 
      ic1 = 1; /* Set IC1 to 1 */
	break;

    case 1:
      ic1 = 0; /* Set IC1 to 0 */
	break;

	default:

	break;
  }
                       
}

/*******************************************************************************/
/* Name:           ic2_ISR                                                     */
/* Purpose:        INPUT CAPTURE 2 Interrupt Service Routine                     */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     user Timer 0                                                */
/*******************************************************************************/
void ic2_ISR (void) interrupt 8 	using 3
{


                       
}

/*******************************************************************************/
/* Name:           oc1_ISR                                                     */
/* Purpose:        OUTPUT COMPARE 1 Interrupt Service Routine                  */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     user Timer 0                                                */
/*******************************************************************************/
void oc1_ISR (void) interrupt 9 	using 3
{

  unsigned short ocTime;

  switch(oc1)
  {
    case 0: 
      OC1_LVL = 1;  
      oc1 = 1; /* OC1 will be 1 on Match */
	break;

    case 1: 
      OC1_LVL = 0;    
      oc1 = 0; /* OC1 will be 0 on Match */
	break;

	default:

	break;
  }

  IC_OC_TIM_LAT = 1; // Grab FRT value
  ocTime = (unsigned short)((((unsigned short)(FRTMSB))<<8) + ((unsigned short)FRTLSB));
  ocTime += (unsigned short)50000; /* 5ms */
 
  OC1MSB = (unsigned char)((ocTime>>8)&0x00FF);
  OC1LSB = (unsigned char)(ocTime&0x00FF);
  
                       
}

/*******************************************************************************/
/* Name:           oc2_ISR                                                     */
/* Purpose:        OUTPUT COMPARE 2 Interrupt Service Routine                  */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     user Timer 0                                                */
/*******************************************************************************/
void oc2_ISR (void) interrupt 10 	using 3
{
                       
}

/*******************************************************************************/
/* Name:           decimator1_ISR                                              */
/* Purpose:        DECIMATOR 1 Interrupt Service Routine                       */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     user Timer 0                                                */
/*******************************************************************************/
void decimator1_ISR (void) interrupt 11 	using 3
{
      //GPIO4 = 1;  /* Turn ON GPIO 4 */
      LD_DEC = 0x04;	// Stage 1 Decimator of ADC
	  padcValue.u8[0] = ADCMSB;
	  padcValue.u8[1] = ADCLSB;
      //GPIO4 = 0;  /* Turn OFF GPIO 4 */   
	  
	  /* 1. Toggle GPIO1 when this interrupt is called */
	  if ( gpio1 == 0 )
	  {
	    gpio1 = 1;
		GPIO1 = 1;
	  }
	  else
	  {
	    gpio1 = 0;
		GPIO1 = 0;
	  }
	                    
}

/*******************************************************************************/
/* Name:           decimator2_ISR                                              */
/* Purpose:        DECIMATOR 1 Interrupt Service Routine                       */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     user Timer 0                                                */
/*******************************************************************************/
void decimator2_ISR (void) interrupt 12 	using 2
{
      //GPIO5 = 1;  /* Turn ON GPIO 5 */

      LD_DEC = 0x02;	// Stage 2 Decimator of ADC
	  padcValue.u8[0] = ADCMSB;
	  padcValue.u8[1] = ADCLSB;
	  //place function here
      //GPIO5 = 0;  /* Turn OFF GPIO 5 */

}

