#ifndef _TPIC83R00_VARS_H
#define _TPIC83R00_VARS_H



/*****************************************************************************/
/* NOTES:                                                                    */
/* Timer 0 High is used to generate PWM                                      */
/* Timer 1 is used by Serial Port Interrupt. Serial Port is used to trasnmit */
/*  distance data to hyperterminal.                                          */
/*****************************************************************************/

/* defines */
/* Baud Rate Calculation:                                      */
/*   Assume PCON.7 = 1                                         */        
/*   TH1 = 256 - ((Timer_clk / 32/2/Baud/2)                    */
/*   For a baud of 2400,                                       */ 
/*     TH1 = 256 -  2*(5000000 / 32 / 2 / 1200 )               */
#define TH1_4800_BPS  (191)
#define TH1_38400_BPS (248)

/* GPIOs Pins */
#define GPIO1 P20
#define GPIO2 P21
#define GPIO3 P22
#define GPIO4 P23
#define GPIO5 P32

/* SW Watchdog Pin */
#define SW_WATCHDOG P24

/* EEPROM */
extern unsigned char xdata EEPROM_BANK0[];
extern unsigned char xdata EEPROM_BANK1[];
extern unsigned char xdata EEPROM_BANK2[];
extern unsigned char xdata EEPROM_BANK3[];
extern unsigned char xdata EEPROM_BANK4[];
extern unsigned char xdata EEPROM_BANK5[];

/* Internal RAM */
extern volatile unsigned char idata RAM_UPPER_VARIABLES[10];
extern volatile unsigned char idata RAM_LOWER_VARIABLES[10];
extern volatile unsigned char timeMark;
extern volatile unsigned char serialReady;

extern volatile unsigned char gpio1;
extern volatile unsigned char gpio2;
extern volatile unsigned char gpio3;
extern volatile unsigned char gpio4;
extern volatile unsigned char gpio5;


extern volatile unsigned char oc1;

extern volatile unsigned char ic1;

extern volatile unsigned char senChan;
extern volatile unsigned char sampleCnt;

extern volatile unsigned char swWDCnt;
extern volatile unsigned char swWDService;
extern volatile unsigned char swWDPinState;

extern volatile unsigned char eepromBank0;

extern union
{
  short s16;       /* Pressure ADC Value    */
  unsigned char u8[2];
} padcValue;

extern unsigned char padcValueLSB;

extern union
{
  short s16;
  unsigned char u8[2];
} tadcValue; /* Temperature ADC Value */


extern unsigned short linearizedValue; /* Linearized value */
extern unsigned short tcValue;         /* TC value */

extern unsigned short shortN0;  /* Linearization coeff N0 */
extern unsigned short shortN1;	/* Linearization coeff N1 */
extern unsigned short shortN2;	/* Linearization coeff N2 */

               
/* functions */
void portInit (void);
void esfrInit (void);
void interruptInit (void);
void timerInit (void);
void serialInit (void);
void appInit (void);

#endif
