/*--------------------------------------------------------------------------*/
/* TPIC83R00.H                                                                   */
/*--------------------------------------------------------------------------*/

#ifndef __TPIC83R00_H__
#define __TPIC83R00_H__

/*  SFR Registers  */
sfr P0   = 0x80;
sfr SP   = 0x81;
sfr DPL  = 0x82;
sfr DPH  = 0x83;
sfr PCON = 0x87;
sfr TCON = 0x88;
sfr TMOD = 0x89;
sfr TL0  = 0x8A;
sfr TL1  = 0x8B;
sfr TH0  = 0x8C;
sfr TH1  = 0x8D;
sfr P1   = 0x90;
sfr SCON = 0x98;
sfr SBUF = 0x99;
sfr P2   = 0xA0;
sfr IE   = 0xA8;
sfr P3   = 0xB0;
sfr IP   = 0xB8;
sfr PSW  = 0xD0;
sfr ACC  = 0xE0;
sfr IE1  = 0xE8;
sfr B    = 0xF0;
sfr IP1  = 0xF8;

/* ESFR Registers */
sfr PSMON1        = 0x91;
sfr PSMON2        = 0x92;
sfr AFEDIAG       = 0x93;
sfr CLKDIAG       = 0x94;
sfr SEN1GAIN      = 0xA1;
sfr SEN2GAIN      = 0xA2;
sfr SEN1OFF1      = 0xA3;
sfr SEN1OFF2      = 0xA4;
sfr SEN2OFF1      = 0xA5;
sfr SEN2OFF2      = 0xA6;
sfr CAPSEN        = 0xA7;
sfr SENCTRL       = 0xA9;
sfr GPIO_STRG     = 0xAA;
sfr CTOV_CLK_CNT  = 0xAB;
sfr ADCMSB        = 0xB1;
sfr ADCLSB        = 0xB2;
sfr LD_DEC        = 0xB3;
sfr DAC1MSB       = 0xB7;
sfr DAC1LSB       = 0xB9;
sfr DAC2MSB       = 0xBA;
sfr DAC2LSB       = 0xBB;
sfr DECCTRL       = 0xBC;
sfr IC_OC_CTRL    = 0xC0;
sfr IC1MSB        = 0xC1;
sfr IC1LSB        = 0xC2;
sfr IC2MSB        = 0xC3;
sfr IC2LSB        = 0xC4;
sfr OC1MSB        = 0xC5;
sfr OC1LSB        = 0xC6;
sfr IC_OC_GPIO    = 0xC7;
sfr OC2MSB        = 0xC9;
sfr OC2LSB        = 0xCA;
sfr FRTMSB        = 0xCB;
sfr FRTLSB        = 0xCC;
sfr COMBUF        = 0xD3;
sfr DI_CTRL       = 0xD4;
sfr EN_CTRL       = 0xD5;
sfr EN_CTRL2      = 0xD6;
sfr RAM_MBIST_ST  = 0xD7;
sfr EE_STATUS     = 0xE1;
sfr EE_CTRL       = 0xE2;

/*  BIT Registers  */
/* P0   */
sbit P07  = P0^7;
sbit P06  = P0^6;
sbit P05  = P0^5;
sbit P04  = P0^4;
sbit P03  = P0^3;
sbit P02  = P0^2;
sbit P01  = P0^1;
sbit P00  = P0^0;

/*  P1  */
sbit P17 = P1^7;
sbit P16 = P1^6;
sbit P15 = P1^5;
sbit P14 = P1^4;
sbit P13 = P1^3;
sbit P12 = P1^2;
sbit P11 = P1^1;
sbit P10 = P1^0;

/*  P2  */
sbit P27  = P2^7;
sbit P26  = P2^6;
sbit P25  = P2^5;
sbit P24  = P2^4;
sbit P23  = P2^3;
sbit P22  = P2^2;
sbit P21  = P2^1;
sbit P20  = P2^0;

/*  P3  */
sbit P37  = P3^7;
sbit P36  = P3^6;
sbit P35  = P3^5;
sbit P34  = P3^4;
sbit P33  = P3^3;
sbit P32  = P3^2;
sbit P31  = P3^1;
sbit P30  = P3^0;

/*  TCON  */
sbit TF1  = TCON^7;
sbit TR1  = TCON^6;
sbit TF0  = TCON^5;
sbit TR0  = TCON^4;
sbit TCON_IE1  = TCON^3;
sbit IT1  = TCON^2;
sbit IE0  = TCON^1;
sbit IT0  = TCON^0;

/*  SCON  */
sbit SM0  = SCON^7; // alternatively "FE"
sbit FE   = SCON^7;
sbit SM1  = SCON^6;
sbit SM2  = SCON^5;
sbit REN  = SCON^4;
sbit TB8  = SCON^3;
sbit RB8  = SCON^2;
sbit TI   = SCON^1;
sbit RI   = SCON^0;

/*  IE   */
sbit EA   = IE^7;
sbit EI5  = IE^5;
sbit ES   = IE^4;
sbit ET1  = IE^3;
sbit EX1  = IE^2;
sbit ET0  = IE^1;
sbit EX0  = IE^0;

/*  IE1   */
sbit EI13 = IE1^7;
sbit EI12 = IE1^6;
sbit EI11 = IE1^5;
sbit EI10 = IE1^4;
sbit EI9  = IE1^3;
sbit EI8  = IE1^2;
sbit EI7  = IE1^1;
sbit EI6  = IE1^0;

/*  IP   */ 
sbit PI5  = IP^5;
sbit PS   = IP^4;
sbit PT1  = IP^3;
sbit PX1  = IP^2;
sbit PT0  = IP^1;
sbit PX0  = IP^0;

/*  IP1   */ 
sbit PI13 = IP1^7;
sbit PI12 = IP1^6;
sbit PI11 = IP1^5;
sbit PI10 = IP1^4;
sbit PI9  = IP1^3;
sbit PI8  = IP1^2;
sbit PI7  = IP1^1;
sbit PI6  = IP1^0;

/*  PSW   */
sbit CY   = PSW^7;
sbit AC   = PSW^6;
sbit F0   = PSW^5;
sbit RS1  = PSW^4;
sbit RS0  = PSW^3;
sbit OV   = PSW^2;
sbit F1   = PSW^1;
sbit P    = PSW^0;

/*  ACC   */
sbit ACC7 = ACC^7;
sbit ACC6 = ACC^6;
sbit ACC5 = ACC^5;
sbit ACC4 = ACC^4;
sbit ACC3 = ACC^3;
sbit ACC2 = ACC^2;
sbit ACC1 = ACC^1;
sbit ACC0 = ACC^0;

/*  B   */
sbit B7 = B^7;
sbit B6 = B^6;
sbit B5 = B^5;
sbit B4 = B^4;
sbit B3 = B^3;
sbit B2 = B^2;
sbit B1 = B^1;
sbit B0 = B^0;

/* P0   */
sbit AD7  = P0^7;
sbit AD6  = P0^6;
sbit AD5  = P0^5;
sbit AD4  = P0^4;
sbit AD3  = P0^3;
sbit AD2  = P0^2;
sbit AD1  = P0^1;
sbit AD0  = P0^0;

/*  P1  */
sbit CEX4 = P1^7;
sbit CEX3 = P1^6;
sbit CEX2 = P1^5;
sbit CEX1 = P1^4;
sbit CEX0 = P1^3;
sbit ECI  = P1^2;
sbit T2EX = P1^1;
sbit T2   = P1^0;

/*  P2  */
sbit AD15  = P2^7;
sbit AD14  = P2^6;
sbit AD13  = P2^5;
sbit AD12  = P2^4;
sbit AD11  = P2^3;
sbit AD10  = P2^2;
sbit AD9   = P2^1;
sbit AD8   = P2^0;

/*  P3  */
sbit RD   = P3^7;
sbit WR   = P3^6;
sbit T1   = P3^5;
sbit T0   = P3^4;
sbit INT1 = P3^3;
sbit INT0 = P3^2;
sbit TXD  = P3^1;
sbit RXD  = P3^0;

/*  IC_OC_CTRL  */
sbit IC_OC_TIM_LAT   = IC_OC_CTRL^5;
sbit OC2_LVL         = IC_OC_CTRL^4;
sbit OC1_LVL         = IC_OC_CTRL^3;
sbit IC2_EDGE        = IC_OC_CTRL^2;
sbit IC1_EDGE        = IC_OC_CTRL^1;
sbit _10_20_MHZ      = IC_OC_CTRL^0;






#endif
