/* TPIC83R00 OTP */

#include "TPIC83R00.H"          /* Register Definitions */
#include "tpic83r00_vars.h"     /* Variable Definitions */
#include "tpic83r00_otp.h"      /* OTP Definition */

/*******************************************************************************/
/* Name:           otpCheckSum                                                 */
/* Purpose:        Computes OTP Checksum                                       */
/* Inputs:         None                                                        */
/* Return:         None                                                        */
/* Precaution:     None                                                        */
/*******************************************************************************/
void  otpChecksum ( void )
{
  volatile unsigned char code *instructionAddress;
  volatile unsigned char checkSum;

  instructionAddress = 0x0000;
  checkSum = 0;

  while ( instructionAddress < 0x2000 ) //8K Memory
  {
     checkSum += *instructionAddress;   // Read Contents of OTP pointed to by instrunctionAddress	and update checksum
     instructionAddress++;   		    // Go to Next Address
  }
}

