/* TPIC83R00 variable Definitions C function */
                
#include "TPIC83R00.H"          /* Register Definitions */
#include "tpic83r00_vars.h"     /* Variable Definitions */

/* EEPROM Data */
unsigned char xdata EEPROM_BANK0[16] _at_ 0x0000;
unsigned char xdata EEPROM_BANK1[16] _at_ 0x0010;
unsigned char xdata EEPROM_BANK2[16] _at_ 0x0020;
unsigned char xdata EEPROM_BANK3[16] _at_ 0x0030;
unsigned char xdata EEPROM_BANK4[16] _at_ 0x0040;
unsigned char xdata EEPROM_BANK5[9]  _at_ 0x0050;

volatile unsigned char idata RAM_UPPER_VARIABLES[10] _at_ 0x80;
volatile unsigned char idata RAM_LOWER_VARIABLES[10] _at_ 0xA0;
volatile unsigned char timeMark;
volatile unsigned char serialReady;

volatile unsigned char gpio1;
volatile unsigned char gpio2;
volatile unsigned char gpio3;
volatile unsigned char gpio4;
volatile unsigned char gpio5;


volatile unsigned char oc1;

volatile unsigned char ic1;

volatile unsigned char senChan;
volatile unsigned char sampleCnt;

volatile unsigned char swWDCnt;
volatile unsigned char swWDService;
volatile unsigned char swWDPinState;

volatile unsigned char eepromBank0;

union
{
  short s16;       /* Pressure ADC Value    */
  unsigned char u8[2];  // Big-Endian --> MSB is stored in lowest memory address
} padcValue;

unsigned char padcValueLSB;

union
{
  short s16;
  unsigned char u8[2];
} tadcValue; /* Temperature ADC Value */



unsigned short linearizedValue; /* Low pass filtered value */
unsigned short tcValue;         /* TC value */

unsigned short shortN0;  /* Linearization coeff N0 */
unsigned short shortN1;	/* Linearization coeff N1 */
unsigned short shortN2;	/* Linearization coeff N2 */

//unsigned char const code CheckSum = 0x00; //?co?tpic83r00_vars (0x1FFF)

