#include<msp430.h>
#include"HAL_Dogs102x6.h"

char CharCode[10]={"0123456789"};
volatile unsigned int OneSecondFlag=0;	//ʱ1S־
volatile unsigned int HInputWorkFlag=0;//ƵźŹ״̬־   0һ
volatile unsigned long int HInputOverflowTime=0;//Ƶźż
volatile unsigned int HROverflowTime=0;//Ƶ׼źż
volatile unsigned long int HInputNum=0;	//Ƶźżֵ
volatile unsigned long int HReferenceNum=0;//Ƶ׼źżֵ
volatile unsigned int IsHighFrequenceFlag=1;//жǷΪƵ־λ
volatile unsigned int HighFrequenceWaitFlag=1;//Ƶȴ־λ

void UCSSet1();//ACLKã32.768KHZ
void UCSSet2();//MCLK,SMCLKã4MHZ
void IOInit();//IOųʼ
void TAInit1();//ƵԤʱ
void HFMeasure();//Ƶĺ
void Display1();//Ƶʾ
void ParameterInit();//ʼ
void DelayMs(unsigned int i);

void main(void)
{
	WDTCTL=WDTPW+WDTHOLD;//رտŹ

	P1DIR|=BIT5+BIT1+BIT2+BIT3+BIT4;
	UCSSet1();
	UCSSet2();
	IOInit();
	Dogs102x6_init();//Һʼ
	Dogs102x6_backlightInit();//ȳʼ
	Dogs102x6_setBacklight(11);
	Dogs102x6_setContrast(11);
	Dogs102x6_clearScreen();//

	while(1)
	{
		ParameterInit();
		TAInit1();
		__enable_interrupt();//ж
		HFMeasure();
		__disable_interrupt();
		if(IsHighFrequenceFlag==1)
		Display1();
		/**/
		//P1OUT^=BIT1;
	}
}

/*ӿ*/
void IOInit()
{
	/*P2.0*/
	//P2DIR&=~BIT0;
	//P2IN&=~BIT0;
	//P2IES&=~BIT0;	//ش
	//P2OUT&=~BIT0;
	//P2REN|=BIT0;	//
	P2SEL|=BIT0;	//ΪTA1Ĳ1

	/*P1.0жϴ*/
	//P1DIR&=~BIT0;	//P1.0趨Ϊ뷽
	//P1IN&=~BIT0;	//ʼΪ0
	//P1IES&=~BIT0;	//ش
	//P1OUT&=~BIT0;
	//P1REN|=BIT0;	//
	P1SEL|=BIT0;//P1.0TA0CLK

}
/*ʱ*/

void UCSSet1()
{
	  //P1DIR |= BIT0;                            // ACLK
	  //P1SEL |= BIT0;

	  P5SEL |= BIT4+BIT5;                       // ѡ XT1

	  UCSCTL6 &= ~(XT1OFF);                     // XT1
	  UCSCTL6 |= XCAP_3;                        // XT1
	  UCSCTL3 = 0;                              // FLL Reference Clock = XT1

	  do
	  {
	    UCSCTL7 &= ~(XT2OFFG + XT1LFOFFG + DCOFFG);// XT2,XT1,DCO־

	    SFRIFG1 &= ~OFIFG;
	  }while (SFRIFG1&OFIFG);

	  UCSCTL6 &= ~(XT1DRIVE_3);                 // Xtal is now stable, reduce drive strength
	  UCSCTL4 = SELA_0;
}

void UCSSet2()
{
	  P2DIR |= BIT2;                            // SMCLK
	  P2SEL |= BIT2;
	  P7DIR |= BIT7;                            // MCLK
	  P7SEL |= BIT7;

	  P5SEL |= BIT2+BIT3;                       // ѡXT2

	  UCSCTL6 &= ~XT2OFF;                       // XT2
	  UCSCTL3 |= SELREF_2;                      // FLL׼ѡ
	  UCSCTL4 |= SELA_2;                        // ACLK=REFO,SMCLK=DCO,MCLK=DCO
	  do										//ֱȶ
	  {
	    UCSCTL7 &= ~(XT2OFFG + XT1LFOFFG + DCOFFG);
	                                            // XT2,XT1,DCO־
	    SFRIFG1 &= ~OFIFG;
	  }while (SFRIFG1&OFIFG);
	  UCSCTL6 &= ~XT2DRIVE0;                    // 
	  UCSCTL4 |= SELS_5 + SELM_5;               // SMCLK=MCLK=XT2
	}

void TAInit1()			//ƵԤʱ
{
	/*TB0趨1S*/
	TB0CTL|=MC_0;		//رնʱ
	TB0CTL|=TBCLR;		//TA2
	TB0CCR0=32767;	//ȽģʽԱֵ
	TB0CCTL0|=CCIE;		//CCROȽжʹ
	TB0CTL|=TBSSEL_1+ID_0;//ѡACLKʱ32.768KHZ1Ƶ,رTA2IFGж
	TB0EX0=TBIDEX_0;//1Ƶ

	/*TA0趨źż*/
	TA0CTL|=MC_0;		//رնʱ
	TA0CTL|=TACLR;		//TA0
	TA0CCR0=100;	//ȽģʽԱֵ
	TA0CCTL0|=CCIE;		//CCROȽжʹ
	TA0CTL|=TASSEL_0+ID_1;//ѡTA0CLKźţ2Ƶ,رTA0IFGж
	TA0EX0=TAIDEX_4;//5ƵܹΪ10Ƶ

	/*TA1׼źż*/
	TA1CTL|=MC_0;		//رնʱ
	TA1CTL|=TACLR;		//TA1
	TA1CTL|=TASSEL_2+ID_0+TAIE;//ѡSMCLK4MHZ1Ƶ,TA1IFGж
	TA1EX0=TAIDEX_0;//1Ƶ

}

/*TA2-CCR0жϷ*/
#pragma vector=TIMER0_B0_VECTOR		//CCR0жϱ־
__interrupt void TA2Interrupt0()
{
	OneSecondFlag=1;	//1S־λλ
	TB0CTL=MC_0;        //رնʱ2
	TB0CTL&=~TBIE;
	/**/
	P1OUT^=BIT2;
	if(HInputOverflowTime==0)//Ϊ0ʾʵźΪƵ
	{
		TA0CTL|=MC_0;	//TA0ֱӹر
		TA0CTL&=~TAIE;
		IsHighFrequenceFlag=0;//жΪƵ
		HighFrequenceWaitFlag=0;//Ƶȴ
		/**/
		P1OUT^=BIT3;
	}
}

/*TA0-CCR0жϷ*/
#pragma vector=TIMER0_A0_VECTOR		//CCR0жϱ־
__interrupt void TA0Interrupt0()
{
	//__enable_interrupt();
	if(OneSecondFlag==0)	//ʾ1SĴբ
	{
		if(HInputWorkFlag==0)	//źŵһբص
		{
			TA0CCR0=10000;	//ȽģʽԱֵ
			TA1CTL|=MC_2;	//׼źſʼͬʱģʽ
			HInputWorkFlag=1;	//բ
		}
		else	//ڴźբ
		{
			HInputOverflowTime++;
			P1OUT^=BIT4;
		}
	}
	if(OneSecondFlag==1)	//ʾ1SĴբѾر
	{
		TA0CTL|=MC_0;	//رմźż
		TA0CTL&=~TAIE;
		HInputOverflowTime++;
		TA1CTL&=~TAIE;
		TA1CTL|=MC_0;	//رձ׼źż
		HReferenceNum=TA1R;//ʱ¼׼źżֵ
		HighFrequenceWaitFlag=0;//Ƶȴ
		P1OUT^=BIT5;
	}
}

/*TA1IFGжϷ*/
#pragma vector=TIMER1_A1_VECTOR
__interrupt void TA1Interrupt1()
{
	switch(__even_in_range(TA0IV,14))
	{
		case 14:HROverflowTime++;break;
		default:break;
	}
}

/*Ƶ*/
void HFMeasure()
{
	OneSecondFlag=0;	//ʱ1S־
	TB0CTL|=MC_1;//ʱ2ģʽ
	TA0CTL|=MC_1;//ʱ0ģʽ
	DelayMs(1500);
	//while(HighFrequenceWaitFlag);//Ƶȴ
	//P1DIR|=BIT3;
	//P1OUT|=BIT3;
	TB0CTL|=MC_0;		//رնʱTB
	TA0CTL|=MC_0;		//رնʱ
	TA1CTL|=MC_0;		//رնʱ
	HInputNum=100*HInputOverflowTime;
	DelayMs(1);
	//HReferenceNum++;
	HReferenceNum+=HROverflowTime*65537;
	DelayMs(2);
}

/*msʱ*/
void DelayMs(unsigned int i)
{
	int j;
	for(j=0;j<i;j++)
	__delay_cycles(4000);

}

/*ʼ*/
void ParameterInit()
{
	 HInputWorkFlag=0;//ƵźŹ״̬־ 0һ
	 HInputOverflowTime=0;//Ƶźż
	 HROverflowTime=0;//Ƶ׼źż
	 HInputNum=0;	//Ƶźżֵ
	 HReferenceNum=0;//Ƶ׼źżֵ
	 IsHighFrequenceFlag=1;//жǷΪƵ־λ
	 HighFrequenceWaitFlag=1;//Ƶȴ־λ

}
/*ƵʾƵʺ*/
void Display1()
{
	char LEDBuffer1[17];  //ʾַ
	unsigned long int temp1;//м仺
	unsigned int IntegerBuffer1=0;//
	unsigned int DecimalBuffer1=0;//С
	if(HReferenceNum==0)
		HReferenceNum=1;
	temp1=HInputNum*4000;
	DelayMs(2);
		IntegerBuffer1=(temp1/HReferenceNum);
		DelayMs(5);
		DecimalBuffer1=((temp1%HReferenceNum)*1000)/HReferenceNum;
		DelayMs(2);
		LEDBuffer1[0]=CharCode[IntegerBuffer1/10000];
		IntegerBuffer1=IntegerBuffer1%10000;
		DelayMs(2);
		LEDBuffer1[1]=CharCode[IntegerBuffer1/1000];
		IntegerBuffer1=IntegerBuffer1%1000;
		DelayMs(2);
		LEDBuffer1[2]=CharCode[IntegerBuffer1/100];
		IntegerBuffer1=IntegerBuffer1%100;
		DelayMs(2);
		LEDBuffer1[3]=CharCode[IntegerBuffer1/10];
		IntegerBuffer1=IntegerBuffer1%10;
		DelayMs(2);
		LEDBuffer1[4]=CharCode[IntegerBuffer1];
		DelayMs(2);
		LEDBuffer1[5]='.';
		DelayMs(2);
		LEDBuffer1[6]=CharCode[DecimalBuffer1/1000];
		DecimalBuffer1=DecimalBuffer1%1000;
		DelayMs(2);
		LEDBuffer1[7]=CharCode[DecimalBuffer1/100];
		DecimalBuffer1=DecimalBuffer1%100;
		DelayMs(2);
		LEDBuffer1[8]=CharCode[DecimalBuffer1/10];
		DecimalBuffer1=DecimalBuffer1%10;
		DelayMs(2);
		LEDBuffer1[9]=CharCode[DecimalBuffer1];
		DelayMs(2);
		LEDBuffer1[10]='K';
		LEDBuffer1[11]='H';
		LEDBuffer1[12]='Z';
		LEDBuffer1[13]=' ';
		LEDBuffer1[14]=' ';
		LEDBuffer1[15]=' ';
		LEDBuffer1[16]='\0';
		Dogs102x6_clearScreen();//
		Dogs102x6_stringDraw(3, 0, &LEDBuffer1[0], 0);//10У20У&Ϊȡ׵ַ0ʾ׵׺
		Dogs102x6_clearRow(4);//4ʾ
		DelayMs(50);
	}

