/*******************************************************************************
 *
 *  MassStorage.c - Uses the USB MSC stack
 *
 *  Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************/

/***************************************************************************//**
 * @file       MassStorage.c
 * @addtogroup MassStorage
 * @{
 ******************************************************************************/
#include <stdint.h>
#include <string.h>
#include "msp430.h"
#include "HAL_PMM.h"
#include "HAL_UCS.h"
#include "HAL_Board.h"
#include "HAL_Buttons.h"
#include "HAL_Dogs102x6.h"
#include "mmc.h"
#include "diskio.h" // Low level disk interface module from the FatFs package
#include "device.h"
#include "types.h"  // Basic Type declarations
#include "descriptors.h"
#include "usb.h"    // USB-specific functions
#include "UsbMscScsi.h"
#include "USB_MSC_API\UsbMsc.h"
#include "USB_MSC_API\UsbMscStateMachine.h"
#include "UsbMscUser.h"
#include "HAL_FLASH.h"
#include "MassStorageCommon.h"



// This image has been created by ImageDog using 'usb_stick_outline.png'
static const uint8_t usbDrive[] =
{
    0x5e,           // Image width in pixels
    0x07,           // Image height in rows (1 row = 8 pixels)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x03, 0x02, 0x06, 0x04,
    0x0c, 0x09, 0x19, 0x11, 0x31, 0x21, 0x61, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x60, 0x20, 0x30,
    0x10, 0x18, 0x08, 0x0c, 0x04, 0x06, 0x02, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x03, 0x02, 0x06, 0x04, 0x0c, 0x08, 0x18,
    0x11, 0x33, 0x23, 0x67, 0x47, 0xc7, 0x87, 0x86, 0x10, 0x18, 0x30, 0x70, 0xe8, 0xec, 0xd4, 0xde,
    0x8a, 0x8d, 0xc5, 0xce, 0xff, 0xbd, 0x79, 0x38, 0x18, 0x18, 0x18, 0x1c, 0x14, 0x1e, 0x0b, 0x0c,
    0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xc0, 0x60, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x03, 0x02, 0x06, 0x04, 0x0c, 0x0c, 0x08, 0x18, 0x10, 0x31,
    0x21, 0x61, 0x40, 0xc0, 0x80, 0x8c, 0x0c, 0x18, 0x1c, 0x34, 0x3e, 0x0e, 0x07, 0x07, 0xe3, 0xf1,
    0xf1, 0x38, 0x38, 0x38, 0x28, 0x28, 0x38, 0x38, 0x71, 0x71, 0x71, 0x70, 0x71, 0x71, 0x39, 0x3f,
    0x9d, 0x8f, 0xc0, 0x40, 0xe0, 0xb8, 0x58, 0x78, 0x30, 0x71, 0x61, 0xe3, 0xc2, 0x86, 0x04, 0x0c,
    0x08, 0x19, 0x11, 0x33, 0x22, 0x44, 0xcc, 0x98, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x1f, 0x33, 0x73, 0x5b,
    0xc9, 0x8c, 0x84, 0x06, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x60, 0x60, 0xc0, 0xe0, 0xa0, 0xf0,
    0x50, 0x68, 0x2c, 0x14, 0x1e, 0x0a, 0x0f, 0x05, 0x07, 0x03, 0x03, 0x83, 0x81, 0xc3, 0xc3, 0xe3,
    0xff, 0x6f, 0x36, 0x1c, 0x00, 0x00, 0x80, 0xc0, 0xc0, 0xc1, 0xc3, 0xc2, 0xc6, 0x84, 0x8c, 0x08,
    0x18, 0x11, 0x31, 0x23, 0x62, 0x44, 0x8c, 0x88, 0x18, 0x10, 0x30, 0x20, 0x60, 0xc0, 0x80, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x06, 0x04, 0x0c, 0x0c,
    0x08, 0x18, 0x10, 0x3c, 0x3e, 0x7e, 0x5e, 0xce, 0xb6, 0xb0, 0x10, 0x00, 0x00, 0x00, 0x80, 0x81,
    0xc1, 0x41, 0x60, 0x30, 0x90, 0x98, 0xc8, 0x4c, 0x64, 0x27, 0x13, 0x19, 0x08, 0x0c, 0x06, 0x03,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x81, 0x81, 0x83, 0x86, 0x84, 0x8c, 0x08, 0x18,
    0x11, 0x31, 0x23, 0x62, 0x46, 0xc4, 0x8c, 0x08, 0x18, 0x30, 0x20, 0x60, 0x40, 0xc0, 0x80, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xbe, 0xa6, 0xdb, 0x69, 0x75, 0x36, 0x12, 0x19,
    0x0d, 0x04, 0x06, 0x03, 0x01, 0x01, 0x00, 0x00, 0x41, 0xe1, 0xf3, 0xf2, 0xf6, 0x64, 0xac, 0x88,
    0x98, 0x30, 0x30, 0x61, 0x41, 0xc3, 0x83, 0x87, 0x8d, 0xfc, 0x10, 0x18, 0x08, 0xff, 0x98, 0x10,
    0x31, 0x21, 0x63, 0x46, 0xc4, 0x8c, 0x88, 0x18, 0x10, 0x30, 0x20, 0x60, 0x40, 0x80, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0xc0, 0x60, 0x60, 0xb0, 0x98,
    0x58, 0x6c, 0x26, 0xd6, 0xff, 0xfe, 0x86, 0x04, 0x0c, 0x08, 0x18, 0x10, 0x30, 0x20, 0x60, 0x40,
    0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00
};

void msc_Init(void);
void msc_Loop(void);

uint8_t bDetectCard = 0x00;

/***************************************************************************//**
 * @brief  Uses USB MSC stack to make MSP430 appear as a "drive" to the host PC
 * @param  none
 * @return none
 ******************************************************************************/

void MassStorage(void)
{
    buttonsPressed = 0;
    Dogs102x6_clearScreen();
    Dogs102x6_stringDraw(0, 0, "USB Mass Storage", DOGS102x6_DRAW_NORMAL);
    Dogs102x6_imageDraw(usbDrive, 1, 0);

    SFRIE1 &= ~OFIE;
    disk_initialize(0);                   // Initialize Disk Drive #0

    SFRIE1 |= OFIE;

    ClockUSB();

    USB_init();                           // Initialize the USB module

    // Enable all USB events
    USB_setEnabledEvents(kUSB_allUsbEvents);

    // Clal Initialization Function
    msc_Init();

    // If USB is already connected when the program starts up, then there won't be a
    // USB_handleVbusOnEvent().
    // So we need to check for it, and manually connect if the host is already present.
    if (USB_connectionInfo() & kUSB_vbusPresent)
    {
        if (USB_enable() == kUSB_succeed)
        {
            USB_reset();
            USB_connect();
        }
    }

    while (!(buttonsPressed & BUTTON_S2))
    {
        switch (USB_connectionState())
        {
            case ST_USB_DISCONNECTED:
                __bis_SR_register(LPM3_bits + GIE);    // Enter LPM3 until VBUS-on event
                _NOP();
                break;

            case ST_USB_CONNECTED_NO_ENUM:
                break;

            case ST_ENUM_ACTIVE:

                msc_Loop();
                break;

            case ST_ENUM_SUSPENDED:
                Board_ledOff(LED1);
                __bis_SR_register(LPM3_bits + GIE);    // Enter LPM3, until a resume or VBUS-off
                                                       // event
                break;

            case ST_ENUM_IN_PROGRESS:
                break;

            case ST_ERROR:
                break;
            default:;
        }
    }

    buttonsPressed = 0;
    Board_ledOff(LED_ALL);
    USB_disable();
    SFRIE1 &= ~OFIE;
    Init_FLL_Settle(25000, 762);          // Return to normal clock settings
    SFRIE1 |= OFIE;
    Dogs102x6_clearScreen();
}

/***************************************************************************//**
 * @}
 ******************************************************************************/
