/*
 * Bluetooth.c
 *
 *  Created on: 2013/12/30
 *      Author: seagbri
 */
#include "driverlib.h"
#include <msp430.h>
#include <FRM_sys.h>
#include <FRM_frm.h>
#include <SYS_msgID.h>
#include <Bluetooth.h>
#include <BtDrvD.h>
#include <BtDrvM.h>
#include <HostIF.h>



void BLUE_Start(void);
void BLUE_ConfigStart(void);
void BLUE_Stop(void);
void BLUE_PowerTimeout(void);
void BLUE_sendmessage(UINT16 bto, UINT16 mid, UINT16 cmd);
void BLUE_ConfigCommand(FRM_MSG *msg);
void BLUE_DataComplete(FRM_MSG *msg);
static void BLUE_RtsTimeout(void);
static void BLUE_DrvRcv_Command(FRM_MSG *msg);
static void BLUE_DrvRcv_Spp(FRM_MSG *msg);
static void BLUE_DrvRcv_Comm(FRM_MSG *msg);

/*
* *************************************************************************
* MODULE    :BLUE_root
* ABSTRACT  :root
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void BLUE_root(FRM_MSG *msg)
{
	switch(msg->id){
				//Jn
		case	MSGID_BLUETOOTH_START:
				BLUE_Start();
				break;
				//ݒJn
		case	MSGID_BLUETOOTH_CONFIGSTART:
				BLUE_ConfigStart();
				//POWERN҂^CAEg
		case	MSGID_BLUETOOTH_POWERTIMEOUT:
				BLUE_PowerTimeout();
				break;
				//RTS҂^CAEg
		case	MSGID_BLUETOOTH_RTSTIMEOUT:
				BLUE_RtsTimeout();
				break;
				//~
		case	MSGID_BLUETOOTH_STOP:
				BLUE_Stop();
				break;
				//f[^擾
		case	MSGID_BLUETOOTH_DATAGETCOMPLETE:
				BLUE_DataComplete(msg);
				break;
				//Config command
		case	MSGID_BLUETOOTH_CONFIGCOMMAND:
				BLUE_ConfigCommand(msg);
				break;
				//BTW[牞
		case	MSGID_BLUETOOTH_DRVRCV_COMM:
				BLUE_DrvRcv_Command(msg);
				break;
				//BTW[SPPf[^
		case	MSGID_BLUETOOTH_DRVRCV_SPP:
				BLUE_DrvRcv_Spp(msg);
				break;
				//HostR}h
		case	MSGID_BLUETOOTH_HOSTCMD:
				BLUE_DrvRcv_Comm(msg);
				break;
		default:
			break;
	}
}

/*
* *************************************************************************
* MODULE    :BLUE_Initial
* ABSTRACT  :
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void BLUE_Initial(void)
{
	/* Power */
	BtDrvM_Power_initialize();
}

/*
* *************************************************************************
* MODULE    :BLUE_Start
* ABSTRACT  :Jn
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void BLUE_Start(void)
{
	/* dJn */
	BtDrvM_Power_Start();
}


/*
* *************************************************************************
* MODULE    :BLUE_ConfigStart
* ABSTRACT  :Jn
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void BLUE_ConfigStart(void)
{
	/* dJn */
	BtDrvM_Power_ConfigStart();
}

/*
* *************************************************************************
* MODULE    :BLUE_PowerTimeout
* ABSTRACT  :^CIEg
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void BLUE_PowerTimeout(void)
{
	/* dJn(Time out) */
	BtDrvM_Power_Timeout();
}

/*
* *************************************************************************
* MODULE    :BLUE_RtsTimeout
* ABSTRACT  :^CIEg
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void BLUE_RtsTimeout(void)
{
	/* RTS҂(Time out) */
}


/*
* *************************************************************************
* MODULE    :BLUE_ConfigCommand
* ABSTRACT  :Config command
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void BLUE_ConfigCommand(FRM_MSG *msg)
{
	//BluetoothW[֑M

}

/*
* *************************************************************************
* MODULE    :BLUE_DataComplete
* ABSTRACT  :f[^擾
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void BLUE_DataComplete(FRM_MSG *msg)
{
	uint8_t	power;

	/* BluetoothdԂ擾 */
	power = BtDrvM_get_PowerSts();
	if((power == DBTC_POWSTS_POWERON)||					/* Auto mode on */
			(power == DBTC_POWSTS_POWERONCOMMAND))		/* Command mode on */
	{

	}
}

/*
* *************************************************************************
* MODULE    :BLUE_Stop
* ABSTRACT  :~
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
void BLUE_Stop(void)
{
	/* d~ */
	BtDrvM_Power_Stop();
}
/*
* *************************************************************************
* MODULE    :BLUE_DrvRcv_Command
* ABSTRACT  :Get response from driver
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void BLUE_DrvRcv_Command(FRM_MSG *msg)
{
	/* Command */
	BtDrvM_Comm_RcvResponse(msg);
}

/*
* *************************************************************************
* MODULE    :BLUE_DrvRcv_Spp
* ABSTRACT  :Get data from driver
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void BLUE_DrvRcv_Spp(FRM_MSG *msg)
{
	/* SPPM */
	BtDrvM_Spp_RcvData(msg);
}

/*
* *************************************************************************
* MODULE    :BLUE_DrvRcv_Comm
* ABSTRACT  :Get data from driver
* FUNCTION  :
* ARGUMENT  :
* NOTE      :
* RETURN    :
* CREATE    : 2013/12/16 Seagbri/
* UPDATE    :
* **************************************************************************
*/
static void BLUE_DrvRcv_Comm(FRM_MSG *msg)
{
	/* Host M */
	if(msg->cmd == HOSTIF_DATFRM_KIND_BLUETOOTH)
	{
		/* BTW[֓]*/
		BtDrvD_Com_Commsend((uint8_t*)msg->ptr, msg->size);
	}
}
